/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.hpav.pav;

import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import sanproject.client.hpav.pav.RJPavDataSupplier;

public class RJPavCuComboBox
extends JComboBox {
    private RJPavDataSupplier supplier = null;
    private boolean enableEvent = true;

    public RJPavCuComboBox(RJPavDataSupplier rJPavDataSupplier) {
        this.supplier = rJPavDataSupplier;
        this.setModel(new ComboModel(rJPavDataSupplier));
    }

    public void setItems(int[] nArray, int n) {
        this.enableEvent = false;
        ((ComboModel)this.getModel()).setItems(nArray);
        this.enableEvent = true;
        if (nArray != null && nArray.length > 0) {
            Arrays.sort(nArray);
            this.setEnabled(true);
            this.setSelectedValue(new Integer(n));
        } else {
            this.setEnabled(false);
            this.setSelectedItem(null);
        }
    }

    public Integer getSelectedValue() {
        ComboModel comboModel = (ComboModel)this.getModel();
        Integer n = comboModel.getSelectedElement(this.getSelectedIndex());
        return n;
    }

    protected void selectedItemChanged() {
        if (this.enableEvent) {
            super.selectedItemChanged();
        }
    }

    public void setSelectedValue(Integer n) {
        ComboModel comboModel = (ComboModel)this.getModel();
        comboModel.setSelectedValue(n);
    }

    private class ComboModel
    extends DefaultComboBoxModel {
        private RJPavDataSupplier supplier = null;
        private int[] cu = null;
        private String[] cus = null;

        public ComboModel(RJPavDataSupplier rJPavDataSupplier) {
            this.supplier = rJPavDataSupplier;
        }

        public int getSize() {
            int n = 0;
            if (this.cu != null) {
                n = this.cu.length;
            }
            return n;
        }

        public Object getElementAt(int n) {
            String string = this.cus[n];
            return string;
        }

        public void setItems(int[] nArray) {
            this.cu = nArray;
            if (nArray == null) {
                this.cus = null;
            } else {
                this.cus = new String[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    this.cus[i] = this.toHexString(nArray[i], 2);
                }
            }
        }

        public Integer getSelectedElement(int n) {
            Integer n2 = null;
            if (n >= 0) {
                n2 = new Integer(this.cu[n]);
            }
            return n2;
        }

        private String toHexString(int n, int n2) {
            String string = "0000000" + Integer.toHexString(n).toUpperCase();
            return string.substring(string.length() - n2);
        }

        public void setSelectedValue(Integer n) {
            this.setSelectedItem(this.toHexString(n, 2));
        }
    }
}

