/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ldevguard.gui.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import sanproject.client.com.RJComSpringUtilities;
import sanproject.client.ldevguard.gui.logging.Logger;
import sanproject.client.ldevguard.gui.main.LDEVGuardDataControlWrapper;
import sanproject.client.openldevguard.color.ColorManager;
import sanproject.client.openldevguard.com.KeyEventReceiver;
import sanproject.client.openldevguard.com.KeyEventTransferable;
import sanproject.client.openldevguard.font.FontManager;
import sanproject.client.openldevguard.gui.ComponentFactory;
import sanproject.client.openldevguard.gui.ComponentUtilities;
import sanproject.client.openldevguard.gui.main.ShortcutKey;
import sanproject.client.openldevguard.gui.main.ShortcutKeySupport;
import sanproject.client.openldevguard.gui.main.StandardComponentFactory;
import sanproject.client.openldevguard.text.NumberStringDocument;

class VTOCEditDialogPanel
extends JPanel
implements KeyEventReceiver,
ShortcutKeySupport {
    private static final String MODULE_NAME = "VTOCEdit";
    public static final int ILLEGAL_VALUE = -1;
    public static final PanelState APPLIED = new PanelState();
    public static final PanelState CANCELED = new PanelState();
    public static final FieldKind BEGIN_CYLINDER = new FieldKind();
    public static final FieldKind BEGIN_HEADER = new FieldKind();
    public static final FieldKind END_CYLINDER = new FieldKind();
    public static final FieldKind END_HEADER = new FieldKind();
    public static final FieldKind MAXIMUM_CYLINDER = new FieldKind();
    public static final FieldKind MAXIMUM_HEADER = new FieldKind();
    private LDEVGuardDataControlWrapper mdcwWrapper;
    private Set msetShortcutKeys;
    private PanelState panelState = CANCELED;
    private JTextField beginCylinder;
    private JTextField beginHeader;
    private JTextField endCylinder;
    private JTextField endHeader;
    private JLabel maximumCylinder;
    private JLabel maximumHeader;
    private JButton okButton;
    private JButton cancelButton;
    static /* synthetic */ Class class$java$awt$Container;

    public VTOCEditDialogPanel(LDEVGuardDataControlWrapper lDEVGuardDataControlWrapper) {
        this.mdcwWrapper = lDEVGuardDataControlWrapper;
        this.msetShortcutKeys = new HashSet();
        this.beginCylinder = null;
        this.beginHeader = null;
        this.endCylinder = null;
        this.endHeader = null;
        this.maximumCylinder = null;
        this.maximumHeader = null;
        this.okButton = null;
        this.cancelButton = null;
        this.initializePanel();
        this.buildPanelLayout();
        this.doChangeField();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyEventReceived(KeyEventTransferable keyEventTransferable, KeyEvent keyEvent) {
        Set set;
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        String string = KeyEvent.getKeyText(n);
        String string2 = KeyEvent.getKeyModifiersText(n2);
        Logger.put(Level.FINEST, MODULE_NAME, "    keyEventReceived()    [" + string2 + " + " + string + "]");
        Object object = this.msetShortcutKeys;
        synchronized (object) {
            set = Collections.synchronizedSet(this.msetShortcutKeys);
        }
        object = set.iterator();
        while (object.hasNext() && !keyEvent.isConsumed()) {
            ShortcutKey shortcutKey = (ShortcutKey)object.next();
            shortcutKey.keyEventHappened(this, keyEvent);
        }
    }

    public Set getShortcutKeys() {
        HashSet hashSet = new HashSet(this.msetShortcutKeys);
        return hashSet;
    }

    public void addShortcutKey(ShortcutKey shortcutKey) {
        Logger.put(Level.FINEST, MODULE_NAME, "add shortcut key. [" + shortcutKey + "]");
        this.msetShortcutKeys.add(shortcutKey);
    }

    public void removeShortcutKey(ShortcutKey shortcutKey) {
        Logger.put(Level.FINEST, MODULE_NAME, "remove shortcut key. [" + shortcutKey + "]");
        this.msetShortcutKeys.remove(shortcutKey);
    }

    public int getValue(FieldKind fieldKind) {
        int n;
        String string = BEGIN_CYLINDER.equals(fieldKind) ? this.beginCylinder.getText() : (BEGIN_HEADER.equals(fieldKind) ? this.beginHeader.getText() : (END_CYLINDER.equals(fieldKind) ? this.endCylinder.getText() : (END_HEADER.equals(fieldKind) ? this.endHeader.getText() : (MAXIMUM_CYLINDER.equals(fieldKind) ? this.maximumCylinder.getText() : (MAXIMUM_HEADER.equals(fieldKind) ? this.maximumHeader.getText() : null)))));
        try {
            n = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            n = -1;
        }
        return n;
    }

    public void setValue(FieldKind fieldKind, int n) {
        if (BEGIN_CYLINDER.equals(fieldKind)) {
            throw new UnsupportedOperationException();
        }
        if (BEGIN_HEADER.equals(fieldKind)) {
            throw new UnsupportedOperationException();
        }
        if (END_CYLINDER.equals(fieldKind)) {
            String string = String.valueOf(n);
            this.endCylinder.setText(string);
        } else if (END_HEADER.equals(fieldKind)) {
            String string = String.valueOf(n);
            this.endHeader.setText(string);
        } else if (MAXIMUM_CYLINDER.equals(fieldKind)) {
            String string = String.valueOf(n);
            this.maximumCylinder.setText(string);
            this.revalidateParentContainer(this.maximumCylinder);
        } else if (MAXIMUM_HEADER.equals(fieldKind)) {
            String string = String.valueOf(n);
            this.maximumHeader.setText(string);
            this.revalidateParentContainer(this.maximumHeader);
        } else {
            throw new UnsupportedOperationException("unknown field.");
        }
    }

    public PanelState getPanelState() {
        PanelState panelState = this.panelState;
        return panelState;
    }

    private void setPanelState(PanelState panelState) {
        this.panelState = panelState;
    }

    private void addComponent(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        if (component instanceof KeyEventTransferable) {
            KeyEventTransferable keyEventTransferable = (KeyEventTransferable)((Object)component);
            keyEventTransferable.addKeyEventReceiver(this);
        }
    }

    private void removeComponent(ContainerEvent containerEvent) {
        Object object;
        Component component = containerEvent.getChild();
        if (component instanceof KeyEventTransferable) {
            object = (KeyEventTransferable)((Object)component);
            object.removeKeyEventReceiver(this);
        }
        if (component instanceof Container) {
            object = (Container)component;
            ((Container)object).removeAll();
        }
    }

    private void initializePanel() {
        ContainerListener containerListener = new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                VTOCEditDialogPanel.this.addComponent(containerEvent);
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                VTOCEditDialogPanel.this.removeComponent(containerEvent);
            }
        };
        this.addContainerListener(containerListener);
        int n = Math.max(9, 2) + 2;
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                VTOCEditDialogPanel.this.doChangeField();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                VTOCEditDialogPanel.this.doChangeField();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                VTOCEditDialogPanel.this.doChangeField();
            }
        };
        Border border = BorderFactory.createEmptyBorder();
        ComponentFactory componentFactory = StandardComponentFactory.getComponentFactory();
        ColorManager colorManager = ColorManager.getInstance();
        FontManager fontManager = FontManager.getInstance();
        Color color = colorManager.getDefaultCharacterColor();
        Color color2 = colorManager.getSelectedLineForeground();
        Color color3 = colorManager.getSelectedLineBackground();
        Font font = fontManager.getNormalFont();
        Object object = new NumberStringDocument(9);
        object.addDocumentListener(documentListener);
        this.beginCylinder = componentFactory.createTextField();
        this.beginCylinder.setDocument((Document)object);
        this.beginCylinder.setColumns(n);
        this.beginCylinder.setHorizontalAlignment(0);
        this.beginCylinder.setForeground(color);
        this.beginCylinder.setFont(font);
        this.beginCylinder.setSelectedTextColor(color2);
        this.beginCylinder.setSelectionColor(color3);
        Object object2 = fontManager.getViewLabelFont();
        this.beginCylinder.setOpaque(false);
        this.beginCylinder.setBorder(border);
        this.beginCylinder.setEditable(false);
        this.beginCylinder.setFont((Font)object2);
        this.beginCylinder.setEnabled(false);
        this.beginCylinder.setDisabledTextColor(color);
        object = new NumberStringDocument(2);
        object.addDocumentListener(documentListener);
        this.beginHeader = componentFactory.createTextField();
        this.beginHeader.setDocument((Document)object);
        this.beginHeader.setColumns(n);
        this.beginHeader.setHorizontalAlignment(0);
        this.beginHeader.setForeground(color);
        this.beginHeader.setFont(font);
        this.beginHeader.setSelectedTextColor(color2);
        this.beginHeader.setSelectionColor(color3);
        object2 = fontManager.getViewLabelFont();
        this.beginHeader.setOpaque(false);
        this.beginHeader.setBorder(border);
        this.beginHeader.setEditable(false);
        this.beginHeader.setFont((Font)object2);
        this.beginHeader.setEnabled(false);
        this.beginHeader.setDisabledTextColor(color);
        object = new NumberStringDocument(9);
        object.addDocumentListener(documentListener);
        this.endCylinder = componentFactory.createTextField();
        this.endCylinder.setDocument((Document)object);
        this.endCylinder.setColumns(n);
        this.endCylinder.setHorizontalAlignment(0);
        this.endCylinder.setForeground(color);
        this.endCylinder.setFont(font);
        this.endCylinder.setSelectedTextColor(color2);
        this.endCylinder.setSelectionColor(color3);
        object = new NumberStringDocument(2);
        object.addDocumentListener(documentListener);
        this.endHeader = componentFactory.createTextField();
        this.endHeader.setDocument((Document)object);
        this.endHeader.setColumns(n);
        this.endHeader.setHorizontalAlignment(0);
        this.endHeader.setForeground(color);
        this.endHeader.setFont(font);
        this.endHeader.setSelectedTextColor(color2);
        this.endHeader.setSelectionColor(color3);
        object = String.valueOf(999999999);
        this.maximumCylinder = componentFactory.createLabel();
        this.maximumCylinder.setText((String)object);
        object = String.valueOf(14);
        this.maximumHeader = componentFactory.createLabel();
        this.maximumHeader.setText((String)object);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VTOCEditDialogPanel.this.doApply();
            }
        };
        object2 = "COMMON/OK";
        String string = this.mdcwWrapper.getGuidanceString((String)object2);
        Color color4 = this.mdcwWrapper.getGuidanceColor((String)object2);
        this.okButton = componentFactory.createButton();
        this.okButton.setText(string);
        this.okButton.setForeground(color4);
        this.okButton.addActionListener((ActionListener)object);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VTOCEditDialogPanel.this.doCancel();
            }
        };
        object2 = "COMMON/Cancel";
        string = this.mdcwWrapper.getGuidanceString((String)object2);
        color4 = this.mdcwWrapper.getGuidanceColor((String)object2);
        this.cancelButton = componentFactory.createButton();
        this.cancelButton.setText(string);
        this.cancelButton.setForeground(color4);
        this.cancelButton.addActionListener((ActionListener)object);
        object = String.valueOf(0);
        this.beginCylinder.setText((String)object);
        object = String.valueOf(1);
        this.beginHeader.setText((String)object);
    }

    private void buildPanelLayout() {
        ComponentFactory componentFactory = StandardComponentFactory.getComponentFactory();
        ColorManager colorManager = ColorManager.getInstance();
        Object object = "LDEV Guard/STRING_DPT_INPUTVTOC";
        Object object2 = this.mdcwWrapper.getGuidanceString((String)object);
        JPanel jPanel = ComponentUtilities.buildTitlePanel(componentFactory, (String)object2);
        Object object3 = "LDEV Guard/STRING_TTL_VTOCBEGIN";
        Object object4 = this.mdcwWrapper.getGuidanceString((String)object3);
        Serializable serializable = ComponentUtilities.buildListTitleComponent(componentFactory, (String)object4);
        Object object5 = componentFactory.createLabel(" : ");
        Object object6 = new SpringLayout();
        Object object7 = componentFactory.createPanel();
        ((Container)object7).setLayout((LayoutManager)object6);
        ((JComponent)object7).setOpaque(false);
        ((Container)object7).add(this.beginCylinder);
        ((Container)object7).add((Component)object5);
        ((Container)object7).add(this.beginHeader);
        RJComSpringUtilities.makeCompactGrid((Container)object7, 1, 3, 0, 0, 4, 4);
        object5 = Box.createHorizontalGlue();
        object6 = new BorderLayout(4, 4);
        object4 = componentFactory.createPanel();
        ((Container)object4).setLayout((LayoutManager)object6);
        ((JComponent)object4).setOpaque(false);
        ((Container)object4).add((Component)object7, "West");
        ((Container)object4).add((Component)object5, "Center");
        object3 = ComponentUtilities.buildListValueComponent(componentFactory, (JComponent)object4);
        object7 = "LDEV Guard/STRING_TTL_VTOCEND";
        object5 = this.mdcwWrapper.getGuidanceString((String)object7);
        object4 = ComponentUtilities.buildListTitleComponent(componentFactory, (String)object5);
        JComponent jComponent = componentFactory.createLabel(" : ");
        Object object8 = new SpringLayout();
        object6 = componentFactory.createPanel();
        ((Container)object6).setLayout((LayoutManager)object8);
        ((JComponent)object6).setOpaque(false);
        ((Container)object6).add(this.endCylinder);
        ((Container)object6).add(jComponent);
        ((Container)object6).add(this.endHeader);
        RJComSpringUtilities.makeCompactGrid((Container)object6, 1, 3, 0, 0, 4, 4);
        object8 = componentFactory.createLabel("[ Max    ");
        JLabel jLabel = componentFactory.createLabel(" ]");
        JLabel jLabel2 = componentFactory.createLabel(" : ");
        Component component = Box.createHorizontalStrut(9);
        SpringLayout springLayout = new SpringLayout();
        jComponent = componentFactory.createPanel();
        jComponent.setLayout(springLayout);
        jComponent.setOpaque(false);
        jComponent.add(component);
        jComponent.add((Component)object8);
        jComponent.add(this.maximumCylinder);
        jComponent.add(jLabel2);
        jComponent.add(this.maximumHeader);
        jComponent.add(jLabel);
        RJComSpringUtilities.makeCompactGrid(jComponent, 1, 6, 0, 0, 4, 4);
        object8 = new BorderLayout(4, 4);
        object5 = componentFactory.createPanel();
        ((Container)object5).setLayout((LayoutManager)object8);
        ((JComponent)object5).setOpaque(false);
        ((Container)object5).add((Component)object6, "West");
        ((Container)object5).add((Component)jComponent, "Center");
        object7 = ComponentUtilities.buildListValueComponent(componentFactory, (JComponent)object5);
        object5 = new SpringLayout();
        object2 = componentFactory.createPanel();
        ((Container)object2).setLayout((LayoutManager)object5);
        ((JComponent)object2).setOpaque(false);
        ((Container)object2).add((Component)serializable);
        ((Container)object2).add((Component)object3);
        ((Container)object2).add((Component)object4);
        ((Container)object2).add((Component)object7);
        RJComSpringUtilities.makeCompactGrid((Container)object2, 2, 2, 0, 0, 4, 4);
        serializable = new BorderLayout(4, 4);
        object = componentFactory.createPanel();
        ((Container)object).setLayout((LayoutManager)((Object)serializable));
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)object2, "North");
        object3 = new GridLayout(1, 0, 4, 4);
        serializable = componentFactory.createPanel();
        ((Container)serializable).setLayout((LayoutManager)object3);
        ((JComponent)serializable).setOpaque(false);
        ((Container)serializable).add(this.okButton);
        ((Container)serializable).add(this.cancelButton);
        ComponentUtilities.decorateInputAreaMarginBorder((JComponent)serializable);
        object3 = new BorderLayout(4, 4);
        object2 = componentFactory.createPanel();
        ((Container)object2).setLayout((LayoutManager)object3);
        ((JComponent)object2).setOpaque(false);
        ((Container)object2).add((Component)serializable, "East");
        serializable = colorManager.getPanelBackground();
        object3 = new BorderLayout(4, 4);
        this.setLayout((LayoutManager)object3);
        this.setOpaque(true);
        this.setBackground((Color)serializable);
        this.add((Component)jPanel, "North");
        this.add((Component)object, "Center");
        this.add((Component)object2, "South");
        ComponentUtilities.decoratePanelAreaMarginBorder(this);
    }

    private boolean hasInputError() {
        boolean bl = !this.checkField(null);
        return bl;
    }

    private boolean checkField(FieldKind fieldKind) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        int n5 = this.getValue(MAXIMUM_CYLINDER);
        int n6 = this.getValue(MAXIMUM_HEADER);
        if ((fieldKind != null && !MAXIMUM_CYLINDER.equals(fieldKind) || 0 <= n5) && (fieldKind != null && !MAXIMUM_HEADER.equals(fieldKind) || 1 <= n6 && 14 >= n6) && (fieldKind != null && !BEGIN_CYLINDER.equals(fieldKind) || 0 <= (n4 = this.getValue(BEGIN_CYLINDER))) && (fieldKind != null && !BEGIN_HEADER.equals(fieldKind) || 1 <= (n4 = this.getValue(BEGIN_HEADER)) && n6 >= n4) && (fieldKind != null && !END_CYLINDER.equals(fieldKind) || (n4 = this.getValue(BEGIN_CYLINDER)) <= (n3 = this.getValue(END_CYLINDER)) && n5 >= n3) && (fieldKind != null && !END_HEADER.equals(fieldKind) || (n2 = (n4 = this.getValue(BEGIN_CYLINDER)) == (n3 = this.getValue(END_CYLINDER)) ? this.getValue(BEGIN_HEADER) : 0) <= (n = this.getValue(END_HEADER)) && n6 >= n) && (n5 != (n4 = this.getValue(END_CYLINDER)) || n6 >= (n3 = this.getValue(END_HEADER)))) {
            bl = true;
        }
        return bl;
    }

    private void doChangeField() {
        boolean bl = this.checkField(null);
        this.okButton.setEnabled(bl);
    }

    private void doApply() {
        if (!this.hasInputError()) {
            this.setPanelState(APPLIED);
            this.closeContentWindow();
        }
    }

    private void doCancel() {
        this.closeContentWindow();
    }

    private void closeContentWindow() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.dispose();
        }
    }

    private void revalidateParentContainer(Component component) {
        Container container;
        if (component != null && (container = SwingUtilities.getAncestorOfClass(class$java$awt$Container == null ? (class$java$awt$Container = VTOCEditDialogPanel.class$("java.awt.Container")) : class$java$awt$Container, component)) != null) {
            container.invalidate();
            container.doLayout();
            container.validate();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class PanelState {
        private PanelState() {
        }
    }

    public static final class FieldKind {
        private FieldKind() {
        }
    }
}

