/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.com;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Timer;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComUty;
import sanproject.client.data.RJDataChange;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataException;
import sanproject.client.data.RJDataMsg;
import sanproject.client.monitor.com.RJHihDataSupplierH;
import sanproject.client.monitor.com.RJHihDef;
import sanproject.client.monitor.com.RJHihIconTableP;
import sanproject.client.monitor.com.RJHihPortInfo;
import sanproject.client.monitor.com.RJHihSuperException;
import sanproject.client.monitor.com.RJHihWWNInfo;
import sanproject.common.Robj_interface_RJiCHAInfoDetail;
import sanproject.common.Robj_interface_RJiHostGroup;
import sanproject.common.Robj_interface_RJiHostGroupInfoDetail;
import sanproject.common.Robj_interface_RJiLUPathIndex;
import sanproject.common.Robj_interface_RJiPortAttributeInfoDetail;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.common.Robj_interface_RJiPortInfoDetail;
import sanproject.common.Robj_interface_RJiWWN;
import sanproject.serverux.arg.monitor.ArgAllPPCGroupWWNInfo;
import sanproject.serverux.arg.monitor.ArgAllPortWWNInfo;
import sanproject.serverux.arg.monitor.ArgNonPortSetPPCExistenceInfo;
import sanproject.serverux.arg.monitor.ArgWWNAbility;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.MonitorElementInfo;
import sanproject.serverux.data.MonitorInfoArray;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.data.PPCAllPPCGroupWWNInfo;
import sanproject.serverux.data.PPCAllPortWWNInfo;
import sanproject.serverux.data.PPCGroupWWNInfo;
import sanproject.serverux.data.PPCNonPortSetPPCExistenceInfo;
import sanproject.serverux.data.PPCPortWWNInfo;
import sanproject.serverux.data.PPCWWNAbility;
import sanproject.serverux.dataimpl.LUNSgetWWNList;
import sanproject.serverux.dataimpl.RJiCHAInfoDetail;
import sanproject.serverux.dataimpl.RJiPortIndex;
import sanproject.serverux.dataimpl.RJiWWN;

public abstract class RJHihDataSupplierP
extends RJHihDataSupplierH {
    public boolean m_RealTimeMode = false;
    protected Robj_interface_RJiPortAttributeInfoDetail[] portAttrInfo = null;
    protected Robj_interface_RJiPortInfoDetail[] portInfoDetail = null;
    protected RJHihPortInfo[] allPortInfo = null;
    protected Robj_interface_RJiHostGroupInfoDetail[] hgInfoDetail = null;
    protected MonitorInfoArray allPortWWNInfo = null;
    protected ArrayList errorWWNList = null;
    protected PPCAllPPCGroupWWNInfo[] ppcAllPpcGroupWwnInfos = null;
    protected LUNSgetWWNList[] dkcAllWWNInfos = null;
    LUNSgetWWNList[] dkcAllWWNList = null;
    private WWNComparetor wwnComparetor = new WWNComparetor();
    private PortComparetor portComparetor = new PortComparetor();
    static final long lDefSpan = 5400000L;
    private RJComUty ComUty = new RJComUty();
    public Timer timer;
    public Timer Porttimer;
    private boolean bRealTimeError = false;
    public boolean bPPCDlgShowAtOnce = false;
    private int portCount = 0;
    private boolean ppcEditing = false;
    private HashMap wwnCache = new HashMap();
    private Date wwnStart = null;
    private Date wwnEnd = null;

    public RJHihDataSupplierP() {
        this(null);
    }

    public RJHihDataSupplierP(RJDataControl rJDataControl) {
        super(rJDataControl);
        RJHihIconTableP.setDataControl(rJDataControl);
    }

    public void terminate() {
        RJHihIconTableP.terminate();
        super.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Robj_interface_RJiPortAttributeInfoDetail[] getPortAttributeInfoDetail() {
        if (this.portAttrInfo == null) {
            try {
                this.stayController = true;
                this.portAttrInfo = this.controlPortPart.getPortAttributeInfoDetail();
                this.portAttrInfo = (Robj_interface_RJiPortAttributeInfoDetail[])this.portAttrInfo.clone();
                Arrays.sort(this.portAttrInfo);
            }
            catch (RJDataException rJDataException) {
                this.showErrorMessage(rJDataException.getErrPart(), rJDataException.getErrCode());
            }
            finally {
                this.stayController = false;
            }
        }
        return this.portAttrInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Robj_interface_RJiPortInfoDetail[] getPortInfoDetail() {
        if (this.portInfoDetail == null) {
            try {
                this.stayController = true;
                this.portInfoDetail = this.controlPortPart.getPortInfoDetail();
                this.portInfoDetail = (Robj_interface_RJiPortInfoDetail[])this.portInfoDetail.clone();
                Arrays.sort(this.portInfoDetail);
            }
            catch (RJDataException rJDataException) {
                this.showErrorMessage(rJDataException.getErrPart(), rJDataException.getErrCode());
            }
            finally {
                this.stayController = false;
            }
        }
        return this.portInfoDetail;
    }

    public boolean isPort() {
        return this.isPort(11);
    }

    public boolean isPort(int n) {
        RJHihPortInfo[] rJHihPortInfoArray;
        boolean bl = false;
        if ((n & 1) != 0 && (rJHihPortInfoArray = this.getPortInfo(1)) != null && rJHihPortInfoArray.length > 0) {
            bl = true;
        }
        if ((n & 2) != 0 && (rJHihPortInfoArray = this.getPortInfo(2)) != null && rJHihPortInfoArray.length > 0) {
            bl = true;
        }
        if ((n & 4) != 0 && (rJHihPortInfoArray = this.getPortInfo(4)) != null && rJHihPortInfoArray.length > 0) {
            bl = true;
        }
        if ((n & 8) != 0 && (rJHihPortInfoArray = this.getPortInfo(8, false)) != null && rJHihPortInfoArray.length > 0) {
            bl = true;
        }
        if ((n & 0x10) != 0 && (rJHihPortInfoArray = this.getPortInfo(16)) != null && rJHihPortInfoArray.length > 0) {
            bl = true;
        }
        if ((n & 0x20) != 0 && (rJHihPortInfoArray = this.getPortInfo(32)) != null && rJHihPortInfoArray.length > 0) {
            bl = true;
        }
        if ((n & 0x40) != 0 && (rJHihPortInfoArray = this.getPortInfo(64)) != null && rJHihPortInfoArray.length > 0) {
            bl = true;
        }
        return bl;
    }

    public RJHihPortInfo getPortInfo(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex) {
        Object object = null;
        Object[] objectArray = this.getPortInfo(127, false);
        Arrays.sort(objectArray);
        int n = Arrays.binarySearch(objectArray, robj_interface_RJiPortIndex, this.portComparetor);
        if (n >= 0) {
            object = objectArray[n];
        }
        return object;
    }

    public RJHihPortInfo[] getPortInfo(int n) {
        return this.getPortInfo(n, true);
    }

    public RJHihPortInfo[] getPortInfo(int n, boolean bl) {
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = (n & 8) != 0;
        boolean bl4 = (n & 2) != 0;
        boolean bl5 = (n & 4) != 0;
        boolean bl6 = (n & 0x10) != 0;
        boolean bl7 = (n & 0x20) != 0;
        boolean bl8 = (n & 0x40) != 0;
        this.putLog("[PPC_Data]", "getPortInfo", "--- Function Start ---");
        RJHihPortInfo[] rJHihPortInfoArray = this.getPortInfo();
        ArrayList<RJHihPortInfo> arrayList = new ArrayList<RJHihPortInfo>();
        for (int i = 0; i < rJHihPortInfoArray.length; ++i) {
            short s = rJHihPortInfoArray[i].getSPort();
            byte by = rJHihPortInfoArray[i].getByPortKind();
            this.putLog("[PPC_Data]", "getPortInfo", "port:" + s);
            this.putLog("[PPC_Data]", "getPortInfo", "portKind:" + by);
            if (!(bl2 && by == 3 || bl3 && by == 4 && (this.isAdministrator() || bl) || bl5 && by == -1 || bl6 && by == 9 || bl7 && by == 9 || bl8 && by == 3) && (!bl4 || by != 5 && by != 6)) continue;
            Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail = rJHihPortInfoArray[i].getDetail();
            this.putLog("[PPC_Data]", "getPortInfo", "detail.getByPortKindNo():" + robj_interface_RJiPortInfoDetail.getByPortKindNo());
            if (!(robj_interface_RJiPortInfoDetail.getByPortKindNo() == 2 || robj_interface_RJiPortInfoDetail.getByPortKindNo() == 6 || robj_interface_RJiPortInfoDetail.getByPortKindNo() == 5 && bl7 || robj_interface_RJiPortInfoDetail.getByPortKindNo() == 7 && bl8) && (robj_interface_RJiPortInfoDetail.getByPortKindNo() != 3 || !bl5)) continue;
            arrayList.add(rJHihPortInfoArray[i]);
        }
        RJHihPortInfo[] rJHihPortInfoArray2 = arrayList.toArray(new RJHihPortInfo[0]);
        return rJHihPortInfoArray2;
    }

    private RJHihPortInfo[] getPortInfo() {
        if (this.allPortInfo == null) {
            ArrayList<RJHihPortInfo> arrayList = new ArrayList<RJHihPortInfo>();
            Robj_interface_RJiPortInfoDetail[] robj_interface_RJiPortInfoDetailArray = this.getPortInfoDetail();
            for (int i = 0; i < robj_interface_RJiPortInfoDetailArray.length; ++i) {
                short s = robj_interface_RJiPortInfoDetailArray[i].getSPort();
                Robj_interface_RJiPortAttributeInfoDetail robj_interface_RJiPortAttributeInfoDetail = this.getPortAttributeInfoDetail((Robj_interface_RJiPortIndex)robj_interface_RJiPortInfoDetailArray[i]);
                int n = 0;
                if (robj_interface_RJiPortAttributeInfoDetail != null) {
                    n = robj_interface_RJiPortAttributeInfoDetail.getByPortKind();
                } else if (robj_interface_RJiPortInfoDetailArray[i].getByPortKindNo() == 3) {
                    n = -1;
                }
                RJHihPortInfo rJHihPortInfo = new RJHihPortInfo(s, (byte)n);
                rJHihPortInfo.setDetail(robj_interface_RJiPortInfoDetailArray[i]);
                rJHihPortInfo.setCHAInfo(this.getCHAInfoDetail(s));
                rJHihPortInfo.setPortStr(this.getPortStr(rJHihPortInfo));
                rJHihPortInfo.setSecuritySW(robj_interface_RJiPortInfoDetailArray[i].isBPortSecuritySwitch());
                rJHihPortInfo.setPortSpeed(this.getPCBSpeedMode(rJHihPortInfo));
                rJHihPortInfo.setMixMode(this.isPortMixMode(rJHihPortInfo));
                arrayList.add(rJHihPortInfo);
            }
            this.allPortInfo = arrayList.toArray(new RJHihPortInfo[0]);
            Arrays.sort(this.allPortInfo);
        }
        return this.allPortInfo;
    }

    private boolean isPortMixMode(RJHihPortInfo rJHihPortInfo) {
        byte by = 0;
        byte by2 = 0;
        boolean bl = false;
        by = rJHihPortInfo.getByPortKind();
        Object[] objectArray = this.getPortAttributeInfoDetail();
        if (rJHihPortInfo != null && objectArray != null && rJHihPortInfo.isHighSpeedPort() && (by == 5 || by == 6)) {
            by2 = by == 5 ? (byte)6 : 5;
            int n = rJHihPortInfo.getSPort() % 2 == 0 ? 1 : -1;
            RJiPortIndex rJiPortIndex = new RJiPortIndex();
            rJiPortIndex.setSPort((short)(rJHihPortInfo.getSPort() + n));
            int n2 = Arrays.binarySearch(objectArray, rJiPortIndex);
            if (n2 >= 0 && objectArray[n2].getByPortKind() == by2) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isChaMixMode(int n) {
        boolean bl = false;
        RJHihPortInfo[] rJHihPortInfoArray = this.getPortInfo(2);
        for (int i = 0; i < rJHihPortInfoArray.length; ++i) {
            short s = rJHihPortInfoArray[i].getCHAInfo().getSCHANumber();
            if (n != s || !rJHihPortInfoArray[i].isMixmode()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isChaHighSpeedMode(int n) {
        boolean bl = false;
        RJHihPortInfo[] rJHihPortInfoArray = this.getPortInfo(11);
        for (int i = 0; i < rJHihPortInfoArray.length; ++i) {
            short s = rJHihPortInfoArray[i].getCHAInfo().getSCHANumber();
            if (n != s || !rJHihPortInfoArray[i].isHighSpeedPort()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean getPCBSpeedMode(RJHihPortInfo rJHihPortInfo) {
        boolean bl = false;
        byte by = rJHihPortInfo.getCHAInfo().getByCHAPackageType();
        switch (by) {
            case 102: 
            case 105: {
                byte[] byArray = rJHihPortInfo.getCHAInfo().getByCHAModeBit();
                int n = -128;
                int n2 = rJHihPortInfo.getSPort() % 8 / 4;
                if ((byArray[0] & (n >>>= n2)) == 0) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private Robj_interface_RJiPortInfoDetail getPortInfoDetail(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex) {
        Object object = null;
        Object[] objectArray = this.getPortInfoDetail();
        int n = Arrays.binarySearch(objectArray, robj_interface_RJiPortIndex);
        if (n >= 0) {
            object = objectArray[n];
        }
        return object;
    }

    private Robj_interface_RJiPortAttributeInfoDetail getPortAttributeInfoDetail(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex) {
        Object object = null;
        Object[] objectArray = this.getPortAttributeInfoDetail();
        int n = Arrays.binarySearch(objectArray, robj_interface_RJiPortIndex);
        if (n >= 0) {
            object = objectArray[n];
        }
        return object;
    }

    private Robj_interface_RJiCHAInfoDetail getCHAInfoDetailX(int n) {
        Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail = null;
        Robj_interface_RJiCHAInfoDetail[] robj_interface_RJiCHAInfoDetailArray = this.getCHAInfoDetail();
        RJDataChange rJDataChange = this.controller.getChangeTbl();
        String[] stringArray = rJDataChange.getPortIDtoCHA(n);
        RJiCHAInfoDetail rJiCHAInfoDetail = new RJiCHAInfoDetail();
        RJHihDataSupplierH.CHAComparetor cHAComparetor = new RJHihDataSupplierH.CHAComparetor();
        for (int i = 0; i < stringArray.length; ++i) {
            rJiCHAInfoDetail.strCHADisplayName = stringArray[i];
            int n2 = Arrays.binarySearch(robj_interface_RJiCHAInfoDetailArray, rJiCHAInfoDetail, cHAComparetor);
            if (n2 < 0) continue;
            robj_interface_RJiCHAInfoDetail = robj_interface_RJiCHAInfoDetailArray[n2];
            break;
        }
        return robj_interface_RJiCHAInfoDetail;
    }

    private Robj_interface_RJiCHAInfoDetail getCHAInfoDetail(int n) {
        Robj_interface_RJiCHAInfoDetail robj_interface_RJiCHAInfoDetail = null;
        Robj_interface_RJiCHAInfoDetail[] robj_interface_RJiCHAInfoDetailArray = (Robj_interface_RJiCHAInfoDetail[])this.getCHAInfoDetail().clone();
        RJHihDataSupplierH.CHAComparetor cHAComparetor = new RJHihDataSupplierH.CHAComparetor();
        Arrays.sort(robj_interface_RJiCHAInfoDetailArray, cHAComparetor);
        RJDataChange rJDataChange = this.controller.getChangeTbl();
        String[] stringArray = rJDataChange.getPortIDtoCHA(n);
        RJiCHAInfoDetail rJiCHAInfoDetail = new RJiCHAInfoDetail();
        for (int i = 0; i < stringArray.length; ++i) {
            rJiCHAInfoDetail.strCHADisplayName = stringArray[i];
            int n2 = Arrays.binarySearch(robj_interface_RJiCHAInfoDetailArray, rJiCHAInfoDetail, cHAComparetor);
            if (n2 < 0) continue;
            robj_interface_RJiCHAInfoDetail = robj_interface_RJiCHAInfoDetailArray[n2];
            break;
        }
        return robj_interface_RJiCHAInfoDetail;
    }

    private Robj_interface_RJiHostGroupInfoDetail[] getHostGroupInfoDetail() {
        RJHihPortInfo[] rJHihPortInfoArray = this.getPortInfo(27, false);
        RJiPortIndex[] rJiPortIndexArray = new RJiPortIndex[rJHihPortInfoArray.length];
        for (int i = 0; i < rJHihPortInfoArray.length; ++i) {
            rJiPortIndexArray[i] = new RJiPortIndex();
            rJiPortIndexArray[i].setSPort(rJHihPortInfoArray[i].getSPort());
        }
        if (this.hgInfoDetail == null && rJHihPortInfoArray.length > 0) {
            this.hgInfoDetail = this.getHostGroupInfoDetail((Robj_interface_RJiPortIndex[])rJiPortIndexArray);
        }
        return this.hgInfoDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Robj_interface_RJiHostGroupInfoDetail[] getHostGroupInfoDetail(Robj_interface_RJiPortIndex[] robj_interface_RJiPortIndexArray) {
        Robj_interface_RJiHostGroupInfoDetail[] robj_interface_RJiHostGroupInfoDetailArray = null;
        try {
            this.stayController = true;
            robj_interface_RJiHostGroupInfoDetailArray = this.controlPortPart.getHostGroupInfoDetail(robj_interface_RJiPortIndexArray);
        }
        catch (RJDataException rJDataException) {
            this.showErrorMessage(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        finally {
            this.stayController = false;
        }
        return robj_interface_RJiHostGroupInfoDetailArray;
    }

    public Robj_interface_RJiHostGroupInfoDetail getHostGroupInfoDetail(int n) {
        Robj_interface_RJiHostGroupInfoDetail robj_interface_RJiHostGroupInfoDetail = null;
        Robj_interface_RJiHostGroupInfoDetail[] robj_interface_RJiHostGroupInfoDetailArray = this.getHostGroupInfoDetail();
        for (int i = 0; i < robj_interface_RJiHostGroupInfoDetailArray.length; ++i) {
            if (n != robj_interface_RJiHostGroupInfoDetailArray[i].getSPort()) continue;
            robj_interface_RJiHostGroupInfoDetail = robj_interface_RJiHostGroupInfoDetailArray[i];
            break;
        }
        return robj_interface_RJiHostGroupInfoDetail;
    }

    public RJHihWWNInfo[] getPPCWWNInfo(int n, int n2) {
        Object[] objectArray = this.getPPCWWNInfo(n);
        RJHihWWNInfo[] rJHihWWNInfoArray = this.getAllDKCWWN(n);
        ArrayList<RJHihWWNInfo> arrayList = new ArrayList<RJHihWWNInfo>(Arrays.asList(objectArray));
        for (int i = 0; i < rJHihWWNInfoArray.length; ++i) {
            int n3 = Arrays.binarySearch(objectArray, rJHihWWNInfoArray[i]);
            if (n3 >= 0) continue;
            arrayList.add(rJHihWWNInfoArray[i]);
        }
        Object[] objectArray2 = arrayList.toArray(new RJHihWWNInfo[0]);
        Arrays.sort(objectArray2);
        return objectArray2;
    }

    public RJHihWWNInfo[] getWWNInfo(int n, int n2) {
        Object[] objectArray = null;
        ArrayList<RJHihWWNInfo> arrayList = new ArrayList<RJHihWWNInfo>();
        Robj_interface_RJiHostGroupInfoDetail robj_interface_RJiHostGroupInfoDetail = this.getHostGroupInfoDetail(n);
        if (robj_interface_RJiHostGroupInfoDetail != null) {
            Robj_interface_RJiHostGroup[] robj_interface_RJiHostGroupArray = robj_interface_RJiHostGroupInfoDetail.getObjHostGroup();
            for (int i = 0; i < robj_interface_RJiHostGroupArray.length; ++i) {
                short s = robj_interface_RJiHostGroupArray[i].getSHostgroupID();
                if (n2 != s) continue;
                Robj_interface_RJiWWN[] robj_interface_RJiWWNArray = robj_interface_RJiHostGroupArray[i].getObjWWN();
                for (int j = 0; j < robj_interface_RJiWWNArray.length; ++j) {
                    RJHihWWNInfo rJHihWWNInfo = new RJHihWWNInfo(robj_interface_RJiWWNArray[j]);
                    RJHihWWNInfo rJHihWWNInfo2 = this.getPPCWWNInfo(n, rJHihWWNInfo);
                    if (rJHihWWNInfo2 != null) {
                        rJHihWWNInfo.setPPCInfo(rJHihWWNInfo2.getPPCInfo());
                    }
                    rJHihWWNInfo.setError(this.isErrorWWN(rJHihWWNInfo));
                    arrayList.add(rJHihWWNInfo);
                }
                break;
            }
        }
        objectArray = arrayList.toArray(new RJHihWWNInfo[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public RJHihWWNInfo[] getPPCWWNInfo(int n) {
        Object[] objectArray = this.getWWNInfo(n);
        RJHihWWNInfo[] rJHihWWNInfoArray = this.getPPCPortWWNInfo(n);
        ArrayList<RJHihWWNInfo> arrayList = new ArrayList<RJHihWWNInfo>(Arrays.asList(objectArray));
        for (int i = 0; i < rJHihWWNInfoArray.length; ++i) {
            int n2 = Arrays.binarySearch(objectArray, rJHihWWNInfoArray[i]);
            if (n2 >= 0) continue;
            arrayList.add(rJHihWWNInfoArray[i]);
        }
        Object[] objectArray2 = arrayList.toArray(new RJHihWWNInfo[0]);
        Arrays.sort(objectArray2);
        return objectArray2;
    }

    public RJHihWWNInfo[] getPPCPortWWNInfo(int n) {
        Object[] objectArray = null;
        ArrayList<RJHihWWNInfo> arrayList = new ArrayList<RJHihWWNInfo>();
        PPCAllPortWWNInfo pPCAllPortWWNInfo = this.getPortPPCWWNInfo(n);
        if (pPCAllPortWWNInfo != null) {
            for (int i = 0; i < pPCAllPortWWNInfo.getElments().length; ++i) {
                PPCPortWWNInfo pPCPortWWNInfo = pPCAllPortWWNInfo.getElment(i);
                RJHihWWNInfo rJHihWWNInfo = new RJHihWWNInfo(pPCPortWWNInfo);
                rJHihWWNInfo.setError(this.isErrorWWN(rJHihWWNInfo));
                arrayList.add(rJHihWWNInfo);
            }
        }
        objectArray = arrayList.toArray(new RJHihWWNInfo[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private RJHihWWNInfo[] getWWNInfo(int n) {
        Object[] objectArray = null;
        ArrayList<RJHihWWNInfo> arrayList = new ArrayList<RJHihWWNInfo>();
        Robj_interface_RJiHostGroupInfoDetail robj_interface_RJiHostGroupInfoDetail = this.getHostGroupInfoDetail(n);
        Robj_interface_RJiHostGroup[] robj_interface_RJiHostGroupArray = robj_interface_RJiHostGroupInfoDetail.getObjHostGroup();
        for (int i = 0; i < robj_interface_RJiHostGroupArray.length; ++i) {
            short s = robj_interface_RJiHostGroupArray[i].getSHostgroupID();
            Robj_interface_RJiWWN[] robj_interface_RJiWWNArray = robj_interface_RJiHostGroupArray[i].getObjWWN();
            for (int j = 0; j < robj_interface_RJiWWNArray.length; ++j) {
                RJHihWWNInfo rJHihWWNInfo = new RJHihWWNInfo(robj_interface_RJiWWNArray[j]);
                RJHihWWNInfo rJHihWWNInfo2 = this.getPPCWWNInfo(n, rJHihWWNInfo);
                if (rJHihWWNInfo2 != null) {
                    rJHihWWNInfo.setPPCInfo(rJHihWWNInfo2.getPPCInfo());
                }
                rJHihWWNInfo.setError(this.isErrorWWN(rJHihWWNInfo));
                arrayList.add(rJHihWWNInfo);
            }
        }
        objectArray = arrayList.toArray(new RJHihWWNInfo[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private MonitorInfoArray getPortPPCWWNInfo() {
        if (this.allPortWWNInfo == null) {
            ArgAllPortWWNInfo argAllPortWWNInfo = new ArgAllPortWWNInfo();
            this.allPortWWNInfo = (MonitorInfoArray)this.getMonitorInfo((MonArg)argAllPortWWNInfo);
        }
        return this.allPortWWNInfo;
    }

    private PPCAllPortWWNInfo getPortPPCWWNInfo(int n) {
        PPCAllPortWWNInfo pPCAllPortWWNInfo = null;
        MonitorInfoArray monitorInfoArray = this.getPortPPCWWNInfo();
        for (int i = 0; i < monitorInfoArray.size(); ++i) {
            PPCAllPortWWNInfo pPCAllPortWWNInfo2 = (PPCAllPortWWNInfo)monitorInfoArray.get(i);
            int n2 = pPCAllPortWWNInfo2.getPortID();
            if (n != n2) continue;
            pPCAllPortWWNInfo = pPCAllPortWWNInfo2;
            break;
        }
        return pPCAllPortWWNInfo;
    }

    public boolean isErrorWWN(RJHihWWNInfo rJHihWWNInfo) {
        if (this.errorWWNList == null) {
            this.errorWWNList = this.createErrorWWNList();
        }
        boolean bl = this.errorWWNList.contains(rJHihWWNInfo);
        return bl;
    }

    private ArrayList createErrorWWNList() {
        int n;
        ArrayList<RJHihWWNInfo> arrayList = new ArrayList<RJHihWWNInfo>();
        Robj_interface_RJiHostGroupInfoDetail[] robj_interface_RJiHostGroupInfoDetailArray = this.getHostGroupInfoDetail();
        if (robj_interface_RJiHostGroupInfoDetailArray != null) {
            for (n = 0; n < robj_interface_RJiHostGroupInfoDetailArray.length; ++n) {
                Robj_interface_RJiHostGroupInfoDetail robj_interface_RJiHostGroupInfoDetail = robj_interface_RJiHostGroupInfoDetailArray[n];
                short s = robj_interface_RJiHostGroupInfoDetail.getSPort();
                Robj_interface_RJiHostGroup[] robj_interface_RJiHostGroupArray = robj_interface_RJiHostGroupInfoDetail.getObjHostGroup();
                for (int i = 0; i < robj_interface_RJiHostGroupArray.length; ++i) {
                    Robj_interface_RJiWWN[] robj_interface_RJiWWNArray = robj_interface_RJiHostGroupArray[i].getObjWWN();
                    for (int j = 0; j < robj_interface_RJiWWNArray.length; ++j) {
                        RJHihWWNInfo rJHihWWNInfo = new RJHihWWNInfo(robj_interface_RJiWWNArray[j]);
                        if (arrayList.contains(rJHihWWNInfo) || !this.isErrorWWN(s, rJHihWWNInfo)) continue;
                        arrayList.add(rJHihWWNInfo);
                    }
                }
            }
        }
        if (this.dkcAllWWNInfos == null) {
            this.dkcAllWWNInfos = this.getAllWWNList();
        }
        if (this.dkcAllWWNInfos != null) {
            for (n = 0; n < this.dkcAllWWNInfos.length; ++n) {
                short s = this.dkcAllWWNInfos[n].getSPort();
                if (this.dkcAllWWNInfos[n].getObjWWN() == null || this.dkcAllWWNInfos[n].getObjWWN().length <= 0) continue;
                Robj_interface_RJiWWN[] robj_interface_RJiWWNArray = this.dkcAllWWNInfos[n].getObjWWN();
                for (int i = 0; i < robj_interface_RJiWWNArray.length; ++i) {
                    RJHihWWNInfo rJHihWWNInfo = new RJHihWWNInfo(robj_interface_RJiWWNArray[i]);
                    if (arrayList.contains(rJHihWWNInfo) || !this.isErrorWWN(s, rJHihWWNInfo)) continue;
                    arrayList.add(rJHihWWNInfo);
                }
            }
        }
        return arrayList;
    }

    private boolean isErrorWWN(int n, RJHihWWNInfo rJHihWWNInfo) {
        boolean bl = false;
        RJHihWWNInfo rJHihWWNInfo2 = this.getPPCWWNInfo(n, rJHihWWNInfo);
        if (rJHihWWNInfo2 == null && (rJHihWWNInfo2 = this.getPPCWWNInfo(rJHihWWNInfo)) != null) {
            bl = true;
        }
        return bl;
    }

    private RJHihWWNInfo getPPCWWNInfo(RJHihWWNInfo rJHihWWNInfo) {
        RJHihWWNInfo rJHihWWNInfo2 = null;
        MonitorInfoArray monitorInfoArray = this.getPortPPCWWNInfo();
        block0: for (int i = 0; i < monitorInfoArray.size(); ++i) {
            PPCAllPortWWNInfo pPCAllPortWWNInfo = (PPCAllPortWWNInfo)monitorInfoArray.get(i);
            for (int j = 0; j < pPCAllPortWWNInfo.elementSize(); ++j) {
                PPCPortWWNInfo pPCPortWWNInfo = pPCAllPortWWNInfo.getElment(j);
                RJHihWWNInfo rJHihWWNInfo3 = new RJHihWWNInfo(pPCPortWWNInfo);
                if (!rJHihWWNInfo3.equals(rJHihWWNInfo)) continue;
                rJHihWWNInfo2 = rJHihWWNInfo3;
                continue block0;
            }
        }
        return rJHihWWNInfo2;
    }

    private RJHihWWNInfo getPPCWWNInfo(int n, RJHihWWNInfo rJHihWWNInfo) {
        RJHihWWNInfo rJHihWWNInfo2 = null;
        PPCAllPortWWNInfo pPCAllPortWWNInfo = this.getPortPPCWWNInfo(n);
        if (pPCAllPortWWNInfo != null) {
            for (int i = 0; i < pPCAllPortWWNInfo.elementSize(); ++i) {
                PPCPortWWNInfo pPCPortWWNInfo = pPCAllPortWWNInfo.getElment(i);
                RJHihWWNInfo rJHihWWNInfo3 = new RJHihWWNInfo(pPCPortWWNInfo);
                if (!rJHihWWNInfo3.equals(rJHihWWNInfo)) continue;
                rJHihWWNInfo2 = rJHihWWNInfo3;
                break;
            }
        }
        return rJHihWWNInfo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Robj_interface_RJiLUPathIndex[] getLUPathIndex(Robj_interface_RJiPortIndex[] robj_interface_RJiPortIndexArray) {
        Robj_interface_RJiLUPathIndex[] robj_interface_RJiLUPathIndexArray = null;
        try {
            this.stayController = true;
            robj_interface_RJiLUPathIndexArray = this.controlPathPart.getLUPathIndex(robj_interface_RJiPortIndexArray);
        }
        catch (RJDataException rJDataException) {
            this.showErrorMessage(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        finally {
            this.stayController = false;
        }
        return robj_interface_RJiLUPathIndexArray;
    }

    public Robj_interface_RJiLUPathIndex[] getLUPathIndex(Robj_interface_RJiPortIndex robj_interface_RJiPortIndex, Robj_interface_RJiHostGroup robj_interface_RJiHostGroup) {
        Robj_interface_RJiPortIndex[] robj_interface_RJiPortIndexArray;
        RJHihPortInfo rJHihPortInfo = this.getPortInfo(robj_interface_RJiPortIndex);
        RJiPortIndex rJiPortIndex = new RJiPortIndex();
        rJiPortIndex.setSPort(robj_interface_RJiPortIndex.getSPort());
        Robj_interface_RJiLUPathIndex[] robj_interface_RJiLUPathIndexArray = rJHihPortInfo.getLUPath();
        if (robj_interface_RJiLUPathIndexArray == null) {
            robj_interface_RJiPortIndexArray = new Robj_interface_RJiPortIndex[]{rJiPortIndex};
            robj_interface_RJiLUPathIndexArray = this.getLUPathIndex(robj_interface_RJiPortIndexArray);
            rJHihPortInfo.setLUPath(robj_interface_RJiLUPathIndexArray);
        }
        robj_interface_RJiPortIndexArray = new ArrayList();
        for (int i = 0; i < robj_interface_RJiLUPathIndexArray.length; ++i) {
            if (robj_interface_RJiLUPathIndexArray[i].getSPort() != robj_interface_RJiPortIndex.getSPort() || robj_interface_RJiLUPathIndexArray[i].getSHostGroup() != robj_interface_RJiHostGroup.getSHostgroupID()) continue;
            robj_interface_RJiPortIndexArray.add(robj_interface_RJiLUPathIndexArray[i]);
        }
        robj_interface_RJiLUPathIndexArray = robj_interface_RJiPortIndexArray.toArray(new Robj_interface_RJiLUPathIndex[0]);
        return robj_interface_RJiLUPathIndexArray;
    }

    public RJHihPortInfo[] getLUNWWNtoPort(byte[] byArray) {
        ArrayList<RJHihPortInfo> arrayList = new ArrayList<RJHihPortInfo>();
        Robj_interface_RJiHostGroupInfoDetail[] robj_interface_RJiHostGroupInfoDetailArray = this.getHostGroupInfoDetail();
        for (int i = 0; i < robj_interface_RJiHostGroupInfoDetailArray.length; ++i) {
            Robj_interface_RJiHostGroupInfoDetail robj_interface_RJiHostGroupInfoDetail = robj_interface_RJiHostGroupInfoDetailArray[i];
            Robj_interface_RJiHostGroup[] robj_interface_RJiHostGroupArray = robj_interface_RJiHostGroupInfoDetail.getObjHostGroup();
            for (int j = 0; j < robj_interface_RJiHostGroupArray.length; ++j) {
                Robj_interface_RJiWWN[] robj_interface_RJiWWNArray = robj_interface_RJiHostGroupArray[j].getObjWWN();
                for (int k = 0; k < robj_interface_RJiWWNArray.length; ++k) {
                    if (!Arrays.equals(robj_interface_RJiWWNArray[k].getByWWN(), byArray)) continue;
                    RJHihPortInfo rJHihPortInfo = this.getPortInfo((Robj_interface_RJiPortIndex)robj_interface_RJiHostGroupInfoDetail);
                    arrayList.add(rJHihPortInfo);
                }
            }
        }
        RJHihPortInfo[] rJHihPortInfoArray = arrayList.toArray(new RJHihPortInfo[0]);
        return rJHihPortInfoArray;
    }

    private ArrayList getDKCWWNtoPorts(byte[] byArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(256);
        RJiWWN rJiWWN = new RJiWWN();
        rJiWWN.setByWWN(byArray);
        LUNSgetWWNList[] lUNSgetWWNListArray = this.getAllWWNList();
        Object[] objectArray = this.getPortInfo(25);
        Arrays.sort(objectArray);
        if (lUNSgetWWNListArray != null) {
            for (int i = 0; i < lUNSgetWWNListArray.length; ++i) {
                int n;
                RJiWWN[] rJiWWNArray;
                int n2 = Arrays.binarySearch(objectArray, lUNSgetWWNListArray[i], this.portComparetor);
                if (n2 < 0 || (rJiWWNArray = (RJiWWN[])lUNSgetWWNListArray[i].getObjWWN()) == null || (n = Arrays.binarySearch(rJiWWNArray, rJiWWN, this.wwnComparetor)) < 0) continue;
                arrayList.add(objectArray[n2]);
            }
        }
        return arrayList;
    }

    private ArrayList getLUNWWNtoPorts(byte[] byArray) {
        ArrayList<RJHihPortInfo> arrayList = new ArrayList<RJHihPortInfo>();
        Robj_interface_RJiHostGroupInfoDetail[] robj_interface_RJiHostGroupInfoDetailArray = this.getHostGroupInfoDetail();
        for (int i = 0; i < robj_interface_RJiHostGroupInfoDetailArray.length; ++i) {
            Robj_interface_RJiHostGroupInfoDetail robj_interface_RJiHostGroupInfoDetail = robj_interface_RJiHostGroupInfoDetailArray[i];
            Robj_interface_RJiHostGroup[] robj_interface_RJiHostGroupArray = robj_interface_RJiHostGroupInfoDetail.getObjHostGroup();
            for (int j = 0; j < robj_interface_RJiHostGroupArray.length; ++j) {
                Robj_interface_RJiWWN[] robj_interface_RJiWWNArray = robj_interface_RJiHostGroupArray[j].getObjWWN();
                for (int k = 0; k < robj_interface_RJiWWNArray.length; ++k) {
                    if (!Arrays.equals(robj_interface_RJiWWNArray[k].getByWWN(), byArray)) continue;
                    RJHihPortInfo rJHihPortInfo = this.getPortInfo((Robj_interface_RJiPortIndex)robj_interface_RJiHostGroupInfoDetail);
                    arrayList.add(rJHihPortInfo);
                }
            }
        }
        return arrayList;
    }

    public RJHihPortInfo[] getWWNtoPort(byte[] byArray) {
        RJHihWWNInfo rJHihWWNInfo = new RJHihWWNInfo(byArray);
        ArrayList<RJHihPortInfo> arrayList = new ArrayList<RJHihPortInfo>();
        RJHihPortInfo[] rJHihPortInfoArray = this.getPortInfo(25);
        for (int i = 0; i < rJHihPortInfoArray.length; ++i) {
            if (this.getPPCWWNInfo((int)rJHihPortInfoArray[i].getSPort(), rJHihWWNInfo) == null) continue;
            arrayList.add(rJHihPortInfoArray[i]);
        }
        Object[] objectArray = arrayList.toArray(new RJHihPortInfo[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void clearAllCache() {
        super.clearAllCache();
        this.clearPPCCache();
    }

    public void clearPPCCache() {
        this.portAttrInfo = null;
        this.portInfoDetail = null;
        this.allPortInfo = null;
        this.hgInfoDetail = null;
        this.allPortWWNInfo = null;
        this.ppcAllPpcGroupWwnInfos = null;
        this.errorWWNList = null;
        this.dkcAllWWNInfos = null;
        this.dkcAllWWNList = null;
    }

    private RJHihWWNInfo[] getAllDKCWWN(int n) {
        Object[] objectArray = null;
        ArrayList<RJHihWWNInfo> arrayList = new ArrayList<RJHihWWNInfo>();
        if (this.dkcAllWWNInfos == null) {
            this.dkcAllWWNInfos = this.getAllWWNList();
        }
        if (this.dkcAllWWNInfos != null) {
            for (int i = 0; i < this.dkcAllWWNInfos.length; ++i) {
                if (this.dkcAllWWNInfos[i].getSPort() != n) continue;
                Robj_interface_RJiWWN[] robj_interface_RJiWWNArray = this.dkcAllWWNInfos[i].getObjWWN();
                if (robj_interface_RJiWWNArray == null) break;
                for (int j = 0; j < robj_interface_RJiWWNArray.length; ++j) {
                    RJHihWWNInfo rJHihWWNInfo = new RJHihWWNInfo(robj_interface_RJiWWNArray[j].getByWWN());
                    rJHihWWNInfo.setError(this.isErrorWWN(rJHihWWNInfo));
                    arrayList.add(rJHihWWNInfo);
                }
                break;
            }
        }
        objectArray = arrayList.toArray(new RJHihWWNInfo[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LUNSgetWWNList[] getAllWWNList() {
        LUNSgetWWNList[] lUNSgetWWNListArray = null;
        try {
            RJCom.waitCursor(this.getParentPanel());
            this.waitControl();
            this.controller.getAllWWNList();
            this.confirm("getAllWWNList");
            lUNSgetWWNListArray = this.controller.getAllWWNListData();
        }
        finally {
            RJCom.defCursor(this.getParentPanel());
        }
        return lUNSgetWWNListArray;
    }

    public int[] getUniPortIds(byte[] byArray) {
        int[] nArray = new int[]{};
        ArrayList arrayList = this.getLUNWWNtoPorts(byArray);
        ArrayList arrayList2 = this.getDKCWWNtoPorts(byArray);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJHihPortInfo rJHihPortInfo = (RJHihPortInfo)iterator.next();
            if (arrayList2.indexOf(rJHihPortInfo) != -1) continue;
            arrayList2.add(rJHihPortInfo);
        }
        if (arrayList2.size() > 0) {
            nArray = new int[arrayList2.size()];
            for (int i = 0; i < arrayList2.size(); ++i) {
                nArray[i] = ((RJHihPortInfo)arrayList2.get(i)).getSPort();
            }
        }
        return nArray;
    }

    public String getChangePortName(int n, byte[] byArray) {
        RJDataChange rJDataChange = this.controller.getChangeTbl();
        String string = "";
        string = rJDataChange.ChangePortName(n, byArray);
        this.putLog("[MON COM]", "[getChangePortName]", "PortID = " + n + ", PCB = " + byArray[0] + ", ret = " + string);
        return string;
    }

    public String getPortStr(RJHihPortInfo rJHihPortInfo) {
        String string = "";
        String string2 = "";
        if (rJHihPortInfo.getDetail().getByPortKindNo() == 2 || rJHihPortInfo.getDetail().getByPortKindNo() == 6 || rJHihPortInfo.getDetail().getByPortKindNo() == 5 || rJHihPortInfo.getDetail().getByPortKindNo() == 7) {
            if (rJHihPortInfo.getCHAInfo() != null) {
                string2 = this.getChangePortName(rJHihPortInfo.getSPort(), rJHihPortInfo.getCHAInfo().getByCHAModeBit());
            }
            short s = rJHihPortInfo.getDetail().getSPortFibreAddress();
            string = new String(string2 + RJHihDataSupplierP.getPortAddressString(s));
        } else if (rJHihPortInfo.getDetail().getByPortKindNo() == 3) {
            byte[] byArray = new byte[]{0};
            string2 = this.getChangePortName(rJHihPortInfo.getSPort(), byArray);
            string = new String(string2 + "(HTP)");
        }
        return string;
    }

    public PPCAllPPCGroupWWNInfo[] getPPCAllPPCGroupWWNInfo() {
        MonitorInfoArray monitorInfoArray = null;
        if (this.ppcAllPpcGroupWwnInfos == null && (monitorInfoArray = (MonitorInfoArray)this.getMonitorInfo((MonArg)new ArgAllPPCGroupWWNInfo())) != null) {
            this.ppcAllPpcGroupWwnInfos = (PPCAllPPCGroupWWNInfo[])monitorInfoArray.get();
        }
        return this.ppcAllPpcGroupWwnInfos;
    }

    public String getWWNtoPPCGroupName(byte[] byArray) {
        String string = null;
        PPCAllPPCGroupWWNInfo[] pPCAllPPCGroupWWNInfoArray = this.getPPCAllPPCGroupWWNInfo();
        if (pPCAllPPCGroupWWNInfoArray != null) {
            block0: for (int i = 0; i < pPCAllPPCGroupWWNInfoArray.length; ++i) {
                for (int j = 0; j < pPCAllPPCGroupWWNInfoArray[i].elementSize(); ++j) {
                    PPCGroupWWNInfo pPCGroupWWNInfo = pPCAllPPCGroupWWNInfoArray[i].getElement(j);
                    if (!Arrays.equals(pPCGroupWWNInfo.getWWNBytes(), byArray)) continue;
                    string = pPCAllPPCGroupWWNInfoArray[i].getNickName();
                    continue block0;
                }
            }
        }
        return string;
    }

    public RJDataChange getRJDataChange() {
        this.putLog("[PPC_Data]", "getRJDataChange", "--- Function Start ---");
        System.out.println("[PPC_Data] getRJDataChange --- Function Start ---");
        this.waitControl();
        RJDataChange rJDataChange = this.controller.getChangeTbl();
        this.confirm();
        this.putLog("[PPC_Data]", "getRJDataChange", "--- Function End ---");
        System.out.println("[PPC_Data] getRJDataChange --- Function End ---");
        return rJDataChange;
    }

    public boolean ChgPortPriorityInfoAll(int n, int n2, long l) {
        this.putLog("[Monitor]", "[COM]", "RJHihDataSupplierP.ChgPortPriorityInfo Start. nConfig: " + n + " nPPCMode: " + n2 + " nValue: " + l);
        boolean bl = this.controller.ChgPortPriorityInfoAll(n, n2, l);
        this.putLog("[Monitor]", "[]", "RJHihDataSupplierP.ChgPortPriorityInfo End.");
        return bl;
    }

    public boolean ChgPortPriorityInfo(int n, int n2, int n3, int n4, long l) {
        this.putLog("[PPC_Data]", "ChgPortPriorityInfoAll", "--- Function Start ---");
        this.putLog("[PPC]", "[Port]", "ChgPortPriorityInfoAll apply nPortID: " + n + "nPriority: " + n2 + "nConfig: " + n3 + "nPPCMode: " + n4 + "nValue: " + l);
        boolean bl = this.controller.ChgPortPriorityInfo(n, n2, n3, n4, l);
        this.putLog("[PPC_Data]", "ChgPortPriorityInfoAll", "--- Function End ---");
        return bl;
    }

    public boolean ChgControlMode(int n) {
        this.putLog("[PPC_Data]", "ChgControlMode", "--- Function Start ---");
        System.out.println("[PPC_Data] ChgControlMode --- Function Start ---");
        System.out.println("PRM: nMode = " + n);
        this.putLog("[PPC_Data]", "ChgControlMode", "nMode: " + n);
        boolean bl = this.controller.ChgControlMode(n);
        this.putLog("[PPC_Data]", "ChgControlMode", "--- Function End ---");
        System.out.println("[PPC_Data] ChgControlMode --- Function End ---");
        return bl;
    }

    public boolean AddPPCWWN(int[] nArray, byte[] byArray, String string, int n) {
        boolean bl;
        this.putLog("[PPC_Data]", "AddPPCWWN", "--- Function Start ---");
        System.out.println("[PPC_Data] AddPPCWWN --- Function Start ---");
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                System.out.println("PRM: nPortID[" + i + "] = " + nArray[i]);
            }
        } else {
            System.out.println("PRM: nPortID Array = null");
        }
        if (byArray != null) {
            String string2 = RJComUty.btos(byArray);
            if (string2 != null) {
                System.out.println("PRM: bWWN = " + string2);
            } else {
                System.out.println("PRM: bWWN = Trace DataExchange Failed");
            }
        } else {
            System.out.println("PRM: bWWN Array = null");
        }
        if (string != null) {
            System.out.println("PRM: strWWNNickName = " + string);
        } else {
            System.out.println("PRM: strWWNNickName = null");
        }
        System.out.println("PRM: nPriority = " + n);
        this.putLog("[PPC_Data]", "AddPPCWWN", "nPortID: " + nArray);
        for (bl = false; bl < nArray.length; bl += 1) {
            this.putLog("[PPC_Data]", "AddPPCWWN", "nPortID[" + (int)(bl ? 1 : 0) + "]: " + nArray[bl]);
        }
        this.putLog("[PPC_Data]", "AddPPCWWN", "bWWN: " + RJComUty.btos(byArray));
        this.putLog("[PPC_Data]", "AddPPCWWN", "strWWNNickName: " + string);
        this.putLog("[PPC_Data]", "AddPPCWWN", "nPriority: " + n);
        bl = this.controller.AddPPCWWN(nArray, byArray, string, n);
        this.putLog("[PPC_Data]", "AddPPCWWN", "--- Function End ---");
        System.out.println("[PPC_Data] AddPPCWWN --- Function End ---");
        return bl;
    }

    public boolean DelPPCWWN(int[] nArray, byte[] byArray) {
        boolean bl;
        this.putLog("[PPC_Data]", "DelPPCWWN", "--- Function Start ---");
        System.out.println("[PPC_Data] DelPPCWWN --- Function Start ---");
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                System.out.println("PRM: nPortID[" + i + "] = " + nArray[i]);
            }
        } else {
            System.out.println("PRM: nPortID Array = null");
        }
        if (byArray != null) {
            String string = RJComUty.btos(byArray);
            if (string != null) {
                System.out.println("PRM: bWWN = " + string);
            } else {
                System.out.println("PRM: bWWN = Trace DataExchange Failed");
            }
        } else {
            System.out.println("PRM: bWWN Array = null");
        }
        this.putLog("[PPC_Data]", "DelPPCWWN", "nPortID: " + nArray);
        for (bl = false; bl < nArray.length; bl += 1) {
            this.putLog("[PPC_Data]", "DelPPCWWN", "nPortID[" + (int)(bl ? 1 : 0) + "]: " + nArray[bl]);
        }
        this.putLog("[PPC_Data]", "DelPPCWWN", "bWWN: " + RJComUty.btos(byArray));
        bl = this.controller.DelPPCWWN(nArray, byArray);
        this.putLog("[PPC_Data]", "DelPPCWWN", "--- Function End ---");
        System.out.println("[PPC_Data] DelPPCWWN --- Function End ---");
        return bl;
    }

    public boolean ChgPPCWWNPriorityInfo(byte[] byArray, int n, int n2, long l) {
        this.putLog("[PPC_Data]", "ChgPPCWWNPriorityInfo", "--- Function Start ---");
        System.out.println("[PPC_Data] ChgPPCWWNPriorityInfo --- Function Start ---");
        if (byArray != null) {
            String string = RJComUty.btos(byArray);
            if (string != null) {
                System.out.println("PRM: bWWN = " + string);
            } else {
                System.out.println("PRM: bWWN = Trace DataExchange Failed");
            }
        } else {
            System.out.println("PRM: bWWN Array = null");
        }
        System.out.println("PRM: nPriority = " + n);
        System.out.println("PRM: nPPCMode = " + n2);
        System.out.println("PRM: nValue = " + l);
        this.putLog("[PPC_Data]", "ChgPPCWWNPriorityInfo", "bWWN: " + RJComUty.btos(byArray));
        this.putLog("[PPC_Data]", "ChgPPCWWNPriorityInfo", "nPriority: " + n);
        this.putLog("[PPC_Data]", "ChgPPCWWNPriorityInfo", "nPPCMode: " + n2);
        this.putLog("[PPC_Data]", "ChgPPCWWNPriorityInfo", "nValue: " + l);
        boolean bl = this.controller.ChgPPCWWNPriorityInfo(byArray, n, n2, l);
        this.putLog("[PPC_Data]", "ChgPPCWWNPriorityInfo", "--- Function End ---");
        System.out.println("[PPC_Data] ChgPPCWWNPriorityInfo --- Function End ---");
        return bl;
    }

    public boolean ChgPPCWWNPriorityInfoAll(int n, int n2, long l) {
        this.putLog("[PPC_Data]", "ChgPPCWWNPriorityInfoAll", "--- Function Start ---");
        System.out.println("[PPC_Data] ChgPPCWWNPriorityInfoAll --- Function Start ---");
        System.out.println("PRM: nConfig = " + n);
        System.out.println("PRM: nPPCMode = " + n2);
        System.out.println("PRM: nValue = " + l);
        this.putLog("[PPC_Data]", "ChgPPCWWNPriorityInfoAll", "nConfig: " + n);
        this.putLog("[PPC_Data]", "ChgPPCWWNPriorityInfoAll", "nPPCMode: " + n2);
        this.putLog("[PPC_Data]", "ChgPPCWWNPriorityInfoAll", "nValue: " + l);
        boolean bl = this.controller.ChgPPCWWNPriorityInfoAll(n, n2, l);
        this.putLog("[PPC_Data]", "ChgPPCWWNPriorityInfoAll", "--- Function End ---");
        System.out.println("[PPC_Data] ChgPPCWWNPriorityInfoAll --- Function End ---");
        return bl;
    }

    public boolean AddPPCG(String string, byte[] byArray, int n, int n2, long l) {
        this.putLog("[PPC_Data]", "AddPPCG", "--- Function Start ---");
        System.out.println("[PPC_Data] AddPPCG --- Function Start ---");
        if (string != null) {
            System.out.println("PRM: strPPCGNickName = " + string);
        } else {
            System.out.println("PRM: strPPCGNickName = null");
        }
        if (byArray != null) {
            String string2 = RJComUty.btos(byArray);
            if (string2 != null) {
                System.out.println("PRM: bWWN = " + string2);
            } else {
                System.out.println("PRM: bWWN = Trace DataExchange Failed");
            }
        } else {
            System.out.println("PRM: bWWN Array = null");
        }
        System.out.println("PRM: nPriority = " + n);
        System.out.println("PRM: nControlMode = " + n2);
        System.out.println("PRM: nNonPrioUpper = " + l);
        this.putLog("[PPC_Data]", "AddPPCG", "strPPCGNickName: " + string);
        this.putLog("[PPC_Data]", "AddPPCG", "bWWN: " + RJComUty.btos(byArray));
        this.putLog("[PPC_Data]", "AddPPCG", "nPriority: " + n);
        this.putLog("[PPC_Data]", "AddPPCG", "nControlMode: " + n2);
        this.putLog("[PPC_Data]", "AddPPCG", "nNonPrioUpper: " + l);
        boolean bl = this.controller.AddPPCG(string, byArray, n, n2, l);
        this.putLog("[PPC_Data]", "AddPPCG", "--- Function End ---");
        System.out.println("[PPC_Data] AddPPCG --- Function End ---");
        return bl;
    }

    public boolean DelPPCG(String string) {
        this.putLog("[PPC_Data]", "DelPPCG", "--- Function Start ---");
        System.out.println("[PPC_Data] DelPPCG --- Function Start ---");
        if (string != null) {
            System.out.println("PRM: strPPCGNickName = " + string);
        } else {
            System.out.println("PRM: strPPCGNickName = null");
        }
        this.putLog("[PPC_Data]", "DelPPCG", "strPPCGNickName: " + string);
        boolean bl = this.controller.DelPPCG(string);
        this.putLog("[PPC_Data]", "DelPPCG", "--- Function End ---");
        System.out.println("[PPC_Data] DelPPCG --- Function End ---");
        return bl;
    }

    public boolean ChgPPCGNickName(String string, String string2) {
        this.putLog("[PPC_Data]", "ChgPPCGNickName", "--- Function Start ---");
        System.out.println("[PPC_Data] ChgPPCGNickName --- Function Start ---");
        if (string != null) {
            System.out.println("PRM: strPPCGNickNameFrom = " + string);
        } else {
            System.out.println("PRM: strPPCGNickNameFrom = null");
        }
        if (string2 != null) {
            System.out.println("PRM: strPPCGNickNameTo = " + string2);
        } else {
            System.out.println("PRM: strPPCGNickNameTo = null");
        }
        this.putLog("[PPC_Data]", "ChgPPCGNickName", "strPPCGNickNameFrom: " + string);
        this.putLog("[PPC_Data]", "ChgPPCGNickName", "strPPCGNickNameTo: " + string2);
        boolean bl = this.controller.ChgPPCGNickName(string, string2);
        this.putLog("[PPC_Data]", "ChgPPCGNickName", "--- Function End ---");
        System.out.println("[PPC_Data] ChgPPCGNickName --- Function End ---");
        return bl;
    }

    public boolean AddPPCWWNtoPPCG(String string, byte[] byArray) {
        this.putLog("[PPC_Data]", "AddPPCWWNtoPPCG", "--- Function Start ---");
        System.out.println("[PPC_Data] AddPPCWWNtoPPCG --- Function Start ---");
        if (string != null) {
            System.out.println("PRM: strPPCGNickName = " + string);
        } else {
            System.out.println("PRM: strPPCGNickName = null");
        }
        if (byArray != null) {
            String string2 = RJComUty.btos(byArray);
            if (string2 != null) {
                System.out.println("PRM: bWWN = " + string2);
            } else {
                System.out.println("PRM: bWWN Array = Trace DataExchange Failed");
            }
        } else {
            System.out.println("PRM: bWWN Array = null");
        }
        this.putLog("[PPC_Data]", "AddPPCWWNtoPPCG", "strPPCGNickName: " + string);
        this.putLog("[PPC_Data]", "AddPPCWWNtoPPCG", "bWWN: " + RJComUty.btos(byArray));
        boolean bl = this.controller.AddPPCWWNtoPPCG(string, byArray);
        this.putLog("[PPC_Data]", "AddPPCWWNtoPPCG", "--- Function End ---");
        System.out.println("[PPC_Data] AddPPCWWNtoPPCG --- Function End ---");
        return bl;
    }

    public boolean DelPPCWWNfromPPCG(String string, byte[] byArray) {
        this.putLog("[PPC_Data]", "DelPPCWWNfromPPCG", "--- Function Start ---");
        System.out.println("[PPC_Data] DelPPCWWNfromPPCG --- Function Start ---");
        if (string != null) {
            System.out.println("PRM: strPPCGNickName = " + string);
        } else {
            System.out.println("PRM: strPPCGNickName = null");
        }
        if (byArray != null) {
            String string2 = RJComUty.btos(byArray);
            if (string2 != null) {
                System.out.println("PRM: bWWN = " + string2);
            } else {
                System.out.println("PRM: bWWN Array = Trace DataExchange Failed");
            }
        } else {
            System.out.println("PRM: bWWN Array = null");
        }
        this.putLog("[PPC_Data]", "DelPPCWWNfromPPCG", "strPPCGNickName: " + string);
        this.putLog("[PPC_Data]", "DelPPCWWNfromPPCG", "bWWN: " + RJComUty.btos(byArray));
        boolean bl = this.controller.DelPPCWWNfromPPCG(string, byArray);
        this.putLog("[PPC_Data]", "DelPPCWWNfromPPCG", "--- Function End ---");
        System.out.println("[PPC_Data] DelPPCWWNfromPPCG --- Function End ---");
        return bl;
    }

    public RJDataMsg getMessageP(int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(n));
        arrayList.add(new Integer(n2));
        RJDataMsg rJDataMsg = this.getMessage(arrayList);
        return rJDataMsg;
    }

    public int getBootMode() {
        int[][] nArrayArray = new int[][]{{0, 0, 0, 0, 1}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {0, 0, 1, 1, 1}, {0, 1, 0, 0, 2}, {0, 1, 0, 1, 2}, {0, 1, 1, 0, 3}, {0, 1, 1, 1, 4}, {1, 0, 0, 0, 1}, {1, 0, 0, 1, 1}, {1, 0, 1, 0, 1}, {1, 0, 1, 1, 1}, {1, 1, 0, 0, 2}, {1, 1, 0, 1, 2}, {1, 1, 1, 0, 3}, {1, 1, 1, 1, 4}, {10, 0, 0, 0, 1}, {10, 0, 0, 1, 1}, {10, 0, 1, 0, 1}, {10, 0, 1, 1, 1}, {10, 1, 0, 0, 2}, {10, 1, 0, 1, 2}, {10, 1, 1, 0, 3}, {10, 1, 1, 1, 4}, {99, 0, 0, 0, 1}, {99, 0, 0, 1, 1}, {99, 0, 1, 0, 1}, {99, 0, 1, 1, 1}, {99, 1, 0, 0, 3}, {99, 1, 0, 1, 4}, {99, 1, 1, 0, 3}, {99, 1, 1, 1, 4}};
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n2 = this.getVenderID();
        if (this.isTabOption(4, 4)) {
            n3 = 1;
        }
        if (this.isPP(RJHihDef.PP_PPC)) {
            n4 = 1;
        }
        if (this.isPermission(4, 4)) {
            n5 = 1;
        }
        this.putLog("[Monitor]", "[BootMode]", "VenderID:" + n2 + ", Tab:" + n3 + ", PP:" + n4 + ", Premition:" + n5);
        for (int i = 0; i < nArrayArray.length; ++i) {
            if (n2 != nArrayArray[i][0] || n3 != nArrayArray[i][1] || n4 != nArrayArray[i][2] || n5 != nArrayArray[i][3]) continue;
            n = nArrayArray[i][4];
            break;
        }
        if (!this.getFuncBit(3) && n > 2) {
            n = 2;
        }
        return n;
    }

    public boolean WWNComp(byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        for (int i = 0; i < byArray.length && byArray[i] == byArray2[i]; ++i) {
            if (i != 7) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected void errorReset(int n, int n2) {
        String string = new String("BaseMonitor RealTime");
        if (this.isRealTimeMode() && n == 5305 && n2 == 2033) {
            System.out.println("Detect Error in RealTime!!");
            RJHihSuperException rJHihSuperException = new RJHihSuperException("Detect Error in RealTime" + n + "-" + n2);
            throw rJHihSuperException;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.Porttimer != null) {
            this.Porttimer.stop();
        }
        this.setRealTimeError(true);
    }

    public void registTimer(Timer timer) {
        this.timer = timer;
    }

    public void registTimerPort(Timer timer) {
        this.Porttimer = timer;
    }

    public void stopRealTimer() {
        if (this.timer != null) {
            if (this.timer.isRunning()) {
                this.putLog("[Monitor]", "[supplier]", "Real Timer Stop (WWN)");
            }
            this.timer.stop();
        }
        if (this.Porttimer != null) {
            if (this.Porttimer.isRunning()) {
                this.putLog("[Monitor]", "[supplier]", "Real Timer Stop (Port-LUN)");
            }
            this.Porttimer.stop();
        }
    }

    public void setRealTimeError(boolean bl) {
        this.bRealTimeError = bl;
        System.out.println("[PPC_Data] setRealTimeError ------" + this.bRealTimeError);
    }

    public boolean getRealTimeError() {
        return this.bRealTimeError;
    }

    public boolean isRealTimeMode() {
        return this.m_RealTimeMode;
    }

    public void setRealTimeMode(boolean bl) {
        this.m_RealTimeMode = bl;
    }

    public void setPortCount(int n) {
        this.portCount = n;
    }

    public int getPortCount() {
        return this.portCount;
    }

    public void setPPCChangeWWN(byte[] byArray, byte[] byArray2) {
        String string;
        this.putLog("[PPC_Data]", "setPPCChangeWWN", "--- Function Start ---");
        System.out.println("[PPC_Data] setPPCChangeWWN --- Function Start ---");
        if (byArray != null) {
            string = RJComUty.btos(byArray);
            if (string != null) {
                System.out.println("PRM: bBeforeWWN = " + string);
            } else {
                System.out.println("PRM: bBeforeWWN = Trace DataExchange Failed");
            }
        } else {
            System.out.println("PRM: bBeforeWWN Array = null");
        }
        if (byArray2 != null) {
            string = RJComUty.btos(byArray2);
            if (string != null) {
                System.out.println("PRM: bAfterWWN = " + string);
            } else {
                System.out.println("PRM: bAfterWWN = Trace DataExchange Failed");
            }
        } else {
            System.out.println("PRM: bAfterWWN Array = null");
        }
        this.controller.setPPCChangeWWN(byArray, byArray2);
        System.out.println("[PPC_Data] setPPCChangeWWN --- Function End ---");
        this.putLog("[PPC_Data]", "setPPCChangeWWN", "--- Function End ---");
    }

    public void setPPCChangeWWNNickname(byte[] byArray, String string) {
        this.putLog("[PPC_Data]", "setPPCChangeWWNNickname", "--- Function Start ---");
        System.out.println("[PPC_Data] setPPCChangeWWNNickname --- Function Start ---");
        if (byArray != null) {
            String string2 = RJComUty.btos(byArray);
            if (string2 != null) {
                System.out.println("PRM: bTargetWWN = " + string2);
            } else {
                System.out.println("PRM: bTargetWWN = Trace DataExchange Failed");
            }
        } else {
            System.out.println("PRM: bTargetWWN Array = null");
        }
        if (string != null) {
            System.out.println("PRM: strAfterNickName = " + string);
        } else {
            System.out.println("PRM: strAfterNickName = null");
        }
        this.controller.setPPCChangeWWNNickname(byArray, string);
        System.out.println("[PPC_Data] setPPCChangeWWNNickname --- Function End ---");
        this.putLog("[PPC_Data]", "setPPCChangeWWNNickname", "--- Function End ---");
    }

    public void SetPPCPriorityDefaultPortWWN(int n) {
        this.putLog("[PPC_Data]", "SetPPCPriorityDefaultPortWWN", "--- Function Start ---");
        System.out.println("[PPC_Data] SetPPCPriorityDefaultPortWWN --- Function Start ---");
        this.putLog("[PPC_Data]", "SetPPCPriorityDefaultPortWWN", "nMode: " + n);
        System.out.println("PRM: nMode = " + n);
        this.controller.SetPPCPriorityDefaultPortWWN(n);
        this.putLog("[PPC_Data]", "SetPPCPriorityDefaultPortWWN", "--- Function End ---");
        System.out.println("[PPC_Data] SetPPCPriorityDefaultPortWWN --- Function End ---");
    }

    public void SetPPCWWNDelete() {
        this.putLog("[PPC_Data]", "SetPPCWWNDelete", "--- Function Start ---");
        System.out.println("[PPC_Data] SetPPCWWNDelete --- Function Start ---");
        this.controller.SetPPCWWNDelete();
        this.putLog("[PPC_Data]", "SetPPCWWNDelete", "--- Function End ---");
        System.out.println("[PPC_Data] SetPPCWWNDelete --- Function End ---");
    }

    public int CheckPCBStatus() {
        this.putLog("[PPC_Data]", "CheckPCBStatus", "--- Function Start ---");
        System.out.println("[PPC_Data] CheckPCBStatus --- Function Start ---");
        int n = 0;
        PPCNonPortSetPPCExistenceInfo pPCNonPortSetPPCExistenceInfo = (PPCNonPortSetPPCExistenceInfo)this.getMonitorInfo((MonArg)new ArgNonPortSetPPCExistenceInfo());
        if (pPCNonPortSetPPCExistenceInfo != null) {
            n = pPCNonPortSetPPCExistenceInfo.getExistenceFlag();
        } else {
            this.putLog("[PPC_Data]", "CheckPCBStatus", "retclass == null!!!!!!!!!!");
        }
        this.putLog("[PPC_Data]", "CheckPCBStatus", "--- Function End ---");
        System.out.println("[PPC_Data] CheckPCBStatus --- Function End ---");
        return n;
    }

    public void setAttributeChange(String string, int n, int n2, long l) {
        this.putLog("[PPC_Data]", "setAttributeChange", "--- Function Start ---");
        System.out.println("[PPC_Data] setAttributeChange --- Function Start ---");
        this.putLog("[PPC_Data]", "setAttributeChange", "strPPCGroupNickName: " + string);
        System.out.println("PRM: strPPCGroupNickName = " + string);
        this.putLog("[PPC_Data]", "setAttributeChange", "nPriorityMode: " + n);
        System.out.println("PRM: nPriorityMode = " + n);
        this.putLog("[PPC_Data]", "setAttributeChange", "nControlMode: " + n2);
        System.out.println("PRM: nControlMode = " + n2);
        this.putLog("[PPC_Data]", "setAttributeChange", "nNonPrioUpper: " + l);
        System.out.println("PRM: nNonPrioUpper = " + l);
        this.controller.setAttributeChange(string, n, n2, l);
        this.putLog("[PPC_Data]", "setAttributeChange", "--- Function End ---");
        System.out.println("[PPC_Data] setAttributeChange --- Function End ---");
    }

    public void APCustom_backupSetList() {
        this.putLog("[PPC_Data]", "APCustom_backupSetList", "--- Function Start ---");
        System.out.println("[PPC_Data] APCustom_backupSetList --- Function Start ---");
        this.controller.APCustom_backupSetList();
        this.putLog("[PPC_Data]", "APCustom_backupSetList", "--- Function End ---");
        System.out.println("[PPC_Data] APCustom_backupSetList --- Function End ---");
    }

    public void APCustom_restoreSetList() {
        this.putLog("[PPC_Data]", "APCustom_restoreSetList", "--- Function Start ---");
        System.out.println("[PPC_Data] APCustom_restoreSetList --- Function Start ---");
        this.controller.APCustom_restoreSetList();
        this.putLog("[PPC_Data]", "APCustom_restoreSetList", "--- Function End ---");
        System.out.println("[PPC_Data] APCustom_restoreSetList --- Function End ---");
    }

    public void APCustom_clearBackupSetList() {
        this.putLog("[PPC_Data]", "APCustom_clearBackupSetList", "--- Function Start ---");
        System.out.println("[PPC_Data] APCustom_clearBackupSetList --- Function Start ---");
        this.controller.APCustom_clearBackupSetList();
        this.putLog("[PPC_Data]", "APCustom_clearBackupSetList", "--- Function End ---");
        System.out.println("[PPC_Data] APCustom_clearBackupSetList --- Function End ---");
    }

    public void Cancel() {
        this.putLog("[PPC_Data]", "Cancel", "--- Function Start ---");
        System.out.println("[PPC_Data] Cancel --- Function Start ---");
        this.controller.Cancel();
        this.putLog("[PPC_Data]", "Cancel", "--- Function End ---");
        System.out.println("[PPC_Data] Cancel --- Function End ---");
    }

    public MonitorInfoCollection getWWNAbility(ArgWWNAbility argWWNAbility) {
        int n = argWWNAbility.getDataKind();
        MonitorInfoCollection monitorInfoCollection = null;
        this.putLog("[Monitor]", "[supplier]", "getWWNAbility[Cache mode] start [kind = " + n + "]");
        if (n == 2) {
            this.collectWWNAbility(argWWNAbility);
            ArrayList<PPCWWNAbility> arrayList = new ArrayList<PPCWWNAbility>();
            for (int i = 0; i < argWWNAbility.size(); ++i) {
                Robj_interface_RJiWWN robj_interface_RJiWWN = argWWNAbility.getWWN(i);
                robj_interface_RJiWWN.setStrWWNNickName("");
                PPCWWNAbility pPCWWNAbility = (PPCWWNAbility)this.wwnCache.get(robj_interface_RJiWWN);
                if (pPCWWNAbility == null) continue;
                arrayList.add(pPCWWNAbility);
            }
            PPCWWNAbility[] pPCWWNAbilityArray = new PPCWWNAbility[]{};
            pPCWWNAbilityArray = arrayList.toArray(pPCWWNAbilityArray);
            monitorInfoCollection = new MonitorInfoCollection((MonitorElementInfo[])pPCWWNAbilityArray);
        } else {
            monitorInfoCollection = (MonitorInfoCollection)this.getMonitorInfo((MonArg)argWWNAbility);
        }
        this.putLog("[Monitor]", "[supplier]", "getWWNAbility end ");
        return monitorInfoCollection;
    }

    private void collectWWNAbility(ArgWWNAbility argWWNAbility) {
        Object object;
        Robj_interface_RJiWWN robj_interface_RJiWWN;
        int n = argWWNAbility.getDataKind();
        Date date = argWWNAbility.getStartTime();
        Date date2 = argWWNAbility.getEndTime();
        if (!date.equals(this.wwnStart) || !date2.equals(this.wwnEnd)) {
            this.wwnStart = date;
            this.wwnEnd = date2;
            this.wwnCache.clear();
        }
        ArgWWNAbility argWWNAbility2 = new ArgWWNAbility(n, date, date2);
        for (int i = 0; i < argWWNAbility.size(); ++i) {
            robj_interface_RJiWWN = argWWNAbility.getWWN(i);
            object = argWWNAbility.getWWN(i).getByWWN();
            robj_interface_RJiWWN.setStrWWNNickName("");
            PPCWWNAbility pPCWWNAbility = (PPCWWNAbility)this.wwnCache.get(robj_interface_RJiWWN);
            if (pPCWWNAbility != null) continue;
            argWWNAbility2.addWWN(robj_interface_RJiWWN);
            System.out.println("## WWN = " + robj_interface_RJiWWN.getStringWWN());
        }
        if (argWWNAbility2.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.getMonitorInfo((MonArg)argWWNAbility2);
            while (monitorInfoCollection.hasNext()) {
                robj_interface_RJiWWN = (PPCWWNAbility)monitorInfoCollection.next();
                object = robj_interface_RJiWWN.getWWN();
                object.setStrWWNNickName("");
                this.wwnCache.put(object, robj_interface_RJiWWN);
            }
        }
    }

    public void clearWWNAbilityCache() {
        this.wwnStart = null;
        this.wwnEnd = null;
        this.wwnCache.clear();
    }

    public int getPortIcon(RJHihPortInfo rJHihPortInfo) {
        int n = 62;
        int n2 = 0;
        if (rJHihPortInfo.isSecurityOn()) {
            n2 = 1;
        }
        if (rJHihPortInfo.isHighSpeedPort()) {
            n2 += 2;
            if (rJHihPortInfo.isMixmode()) {
                n2 += 10;
            }
        }
        return n += n2;
    }

    public static String getPortAddressString(int n) {
        String[] stringArray = new String[]{"EF", "E8", "E4", "E2", "E1", "E0", "DC", "DA", "D9", "D6", "D5", "D4", "D3", "D2", "D1", "CE", "CD", "CC", "CB", "CA", "C9", "C7", "C6", "C5", "C3", "BC", "BA", "B9", "B6", "B5", "B4", "B3", "B2", "B1", "AE", "AD", "AC", "AB", "AA", "A9", "A7", "A6", "A5", "A3", "9F", "9E", "9D", "9B", "98", "97", "90", "8F", "88", "84", "82", "81", "80", "7C", "7A", "79", "76", "75", "74", "73", "72", "71", "6E", "6D", "6C", "6B", "6A", "69", "67", "66", "65", "63", "5C", "5A", "59", "56", "55", "54", "53", "52", "51", "4E", "4D", "4C", "4B", "4A", "49", "47", "46", "45", "43", "3C", "3A", "39", "36", "35", "34", "33", "32", "31", "2E", "2D", "2C", "2B", "2A", "29", "27", "26", "25", "23", "1F", "1E", "1D", "1B", "18", "17", "10", "0F", "08", "04", "02", "01"};
        String string = n > 0 ? (stringArray.length >= n ? new String("(" + stringArray[n - 1] + ")") : new String("(--)")) : new String("(--)");
        return string;
    }

    public void deleteErrWWNList(RJHihWWNInfo rJHihWWNInfo) {
        int n;
        if (this.errorWWNList == null && (n = this.errorWWNList.indexOf(rJHihWWNInfo)) != -1) {
            this.errorWWNList.remove(n);
        }
    }

    public void setPPCEditing(boolean bl) {
        this.ppcEditing = bl;
    }

    public boolean getPPCEditing() {
        return this.ppcEditing;
    }

    public static Long newLong(long l) {
        Long l2 = null;
        if (l >= 0L) {
            l2 = new Long(l);
        }
        return l2;
    }

    class PortComparetor
    implements Comparator {
        PortComparetor() {
        }

        public int compare(Object object, Object object2) {
            short s = ((Robj_interface_RJiPortIndex)object).getSPort();
            short s2 = ((Robj_interface_RJiPortIndex)object2).getSPort();
            int n = s - s2;
            return n;
        }
    }

    class WWNComparetor
    implements Comparator {
        WWNComparetor() {
        }

        public int compare(Object object, Object object2) {
            String string = ((Robj_interface_RJiWWN)object).getStringWWN();
            String string2 = ((Robj_interface_RJiWWN)object2).getStringWWN();
            int n = string.compareTo(string2);
            return n;
        }
    }
}

