/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.dctl.com;

import java.util.ArrayList;
import sanproject.client.openldevguard.dctl.com.Utility;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDKCIndex;

public class DataLdkc
implements Robj_interface_RJiLDKCIndex {
    private static final int CUGROUP_MAX = 4;
    private static final int INT_BIT = 32;
    private static final int BITMAP_SIZE = 8;
    private final int[] cuBitmap = new int[8];
    private short ldkcNum;

    public DataLdkc(int n) {
        this.ldkcNum = (short)n;
    }

    private int[] execMasking(int[] nArray, int[] nArray2) {
        int n = nArray.length <= nArray2.length ? nArray.length : nArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            nArray[n2] = nArray[n2] & nArray2[i];
        }
        return nArray;
    }

    private boolean isBitmap(int n) {
        int n2 = n / 32;
        int n3 = Integer.MIN_VALUE >>> n % 32;
        return (this.cuBitmap[n2] & n3) != 0;
    }

    private boolean isEquipCuGroup(int n) {
        boolean bl = false;
        int[] nArray = this.getCuBitmap(n);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private int[] makeMaskData(int n) {
        int[] nArray = new int[8];
        int n2 = Utility.convertCuGroupToIndexStart(n);
        int n3 = Utility.convertCuGroupToIndexEnd(n);
        return this.setBit(nArray, n2, n3);
    }

    private int[] setBit(int[] nArray, int n) {
        return this.setBit(nArray, n, n + 1);
    }

    private int[] setBit(int[] nArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            int n3;
            int n4 = Integer.MIN_VALUE >>> i % 32;
            int n5 = n3 = i / 32;
            nArray[n5] = nArray[n5] | n4;
        }
        return nArray;
    }

    public short getSLDKC() {
        return this.ldkcNum;
    }

    public void setSLDKC(short s) {
        this.ldkcNum = s;
    }

    public int addCuIndex(Robj_interface_RJiCUIndex[] robj_interface_RJiCUIndexArray) {
        int n = 0;
        for (int i = 0; i < robj_interface_RJiCUIndexArray.length; ++i) {
            if (robj_interface_RJiCUIndexArray[i].getSLDKC() != this.ldkcNum) continue;
            this.setBit(this.cuBitmap, robj_interface_RJiCUIndexArray[i].getSCU());
            ++n;
        }
        return n;
    }

    public int[] getCuBitmap() {
        return (int[])this.cuBitmap.clone();
    }

    public int[] getCuBitmap(int n) {
        int[] nArray = this.getCuBitmap();
        int[] nArray2 = this.makeMaskData(n);
        int[] nArray3 = this.execMasking(nArray, nArray2);
        return nArray3;
    }

    public ArrayList getCuGroupList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            if (!this.isEquipCuGroup(i)) continue;
            arrayList.add(new Integer(i));
        }
        return arrayList;
    }

    public ArrayList getCuList(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = Utility.convertCuGroupToIndexStart(n);
        int n3 = Utility.convertCuGroupToIndexEnd(n);
        for (int i = n2; i < n3; ++i) {
            if (!this.isBitmap(i)) continue;
            arrayList.add(new Integer(i));
        }
        return arrayList;
    }
}

