/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.pool;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.com.abs.RJaContainMenu;
import sanproject.client.com.abs.RJaMenuItemActionListener;
import sanproject.client.com.abs.RJaPopupMenuSTD;
import sanproject.client.com.abs.RJaTreeManager;
import sanproject.client.com.abs.RJaTreeNode;
import sanproject.client.data.RJDataMsg;
import sanproject.client.pool.RJPoolApplyData;
import sanproject.client.pool.RJPoolApplyItem;
import sanproject.client.pool.RJPoolElement;
import sanproject.client.pool.RJPoolIconTable;
import sanproject.client.pool.RJPoolInfoDialog;
import sanproject.client.pool.RJPoolPoolElement;
import sanproject.client.pool.RJPoolTreePanel;
import sanproject.common.Robj_interface_POOLInfoDetail;

public class RJPoolAOUFolderElement
extends RJPoolElement
implements RJaContainMenu,
RJaMenuItemActionListener {
    private String[] menuItems = new String[]{RJcGuide.text("Pool/PopupAddPoolInfo"), RJcGuide.text("Pool/PopupDeletePools"), RJcGuide.text("Pool/PopupRestorePools")};
    private Component parent = null;
    private JComponent invoker;
    private int locationX = 0;
    private int locationY = 0;
    private DefaultTreeModel treeModel = null;
    private RJaTreeNode node = null;
    private boolean deleteCondition;
    private boolean restoreCondition;

    public RJPoolAOUFolderElement(RJcTreePanel rJcTreePanel) {
        super(RJcGuide.text("Pool/NodeAOU"), rJcTreePanel);
    }

    public void createChildren(RJaTreeManager rJaTreeManager, RJaTreeNode rJaTreeNode) {
        ArrayList arrayList = this.supplier.getAOUPoolList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Robj_interface_POOLInfoDetail robj_interface_POOLInfoDetail = (Robj_interface_POOLInfoDetail)iterator.next();
            RJPoolPoolElement rJPoolPoolElement = new RJPoolPoolElement(robj_interface_POOLInfoDetail.getSPoolId(), this.supplier, (RJcTreePanel)rJaTreeManager);
            rJPoolPoolElement.initDetail(robj_interface_POOLInfoDetail);
            RJaTreeNode rJaTreeNode2 = rJaTreeManager.addObject(rJaTreeNode, rJPoolPoolElement);
            rJPoolPoolElement.setTreeNode(rJaTreeNode2);
        }
    }

    public Icon getIcon(boolean bl) {
        Icon icon = RJPoolIconTable.getIcon(bl ? 1 : 2);
        if (icon == null) {
            icon = super.getIcon(bl);
        }
        return icon;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public void showMenu(JComponent jComponent, int n, int n2, DefaultTreeModel defaultTreeModel, RJaTreeNode rJaTreeNode) {
        this.treeModel = defaultTreeModel;
        this.node = rJaTreeNode;
        this.invoker = jComponent;
        RJaPopupMenuSTD rJaPopupMenuSTD = null;
        if (this.menuItems != null) {
            if (rJaPopupMenuSTD == null) {
                rJaPopupMenuSTD = new RJaPopupMenuSTD(this, this.menuItems);
            }
            if ((rJaPopupMenuSTD = (RJaPopupMenuSTD)this.checkMenu(rJaPopupMenuSTD)) != null) {
                Container container;
                this.locationX = n;
                this.locationY = n2;
                for (container = jComponent.getParent(); container != null; container = container.getParent()) {
                    this.locationX += container.getX();
                    this.locationY += container.getY();
                    if (container instanceof Frame) break;
                }
                this.parent = container;
                rJaPopupMenuSTD.show(jComponent, n, n2);
            }
        }
    }

    private JPopupMenu checkMenu(JPopupMenu jPopupMenu) {
        JPopupMenu jPopupMenu2 = null;
        ((JMenuItem)jPopupMenu.getComponent(0)).setEnabled(false);
        ((JMenuItem)jPopupMenu.getComponent(1)).setEnabled(false);
        ((JMenuItem)jPopupMenu.getComponent(2)).setEnabled(false);
        RJPoolApplyData rJPoolApplyData = this.supplier.getApplyData();
        if (rJPoolApplyData.isOK(2) && this.node.getChildCount() <= 127) {
            ((JMenuItem)jPopupMenu.getComponent(0)).setEnabled(true);
            jPopupMenu2 = jPopupMenu;
        }
        this.checkCondition();
        if (rJPoolApplyData.isOK(16) && this.deleteCondition) {
            ((JMenuItem)jPopupMenu.getComponent(1)).setEnabled(true);
            jPopupMenu2 = jPopupMenu;
        }
        if (rJPoolApplyData.isOK(8) && this.restoreCondition) {
            ((JMenuItem)jPopupMenu.getComponent(2)).setEnabled(true);
            jPopupMenu2 = jPopupMenu;
        }
        return jPopupMenu2;
    }

    private void checkCondition() {
        this.deleteCondition = false;
        this.restoreCondition = false;
        Enumeration<TreeNode> enumeration = this.node.children();
        while (enumeration.hasMoreElements()) {
            RJaTreeNode rJaTreeNode = (RJaTreeNode)enumeration.nextElement();
            RJPoolPoolElement rJPoolPoolElement = (RJPoolPoolElement)rJaTreeNode.getUserObject();
            if (rJPoolPoolElement.isDeleteCondition()) {
                this.deleteCondition = true;
            }
            if (!rJPoolPoolElement.isRestoreCondition()) continue;
            this.restoreCondition = true;
        }
    }

    public void menuItemActionPerformed(ActionEvent actionEvent, int n) {
        switch (n) {
            case 0: {
                this.actionAddPool();
                break;
            }
            case 1: {
                this.actionDelete();
                break;
            }
            case 2: {
                this.actionRestore();
            }
        }
        this.invoker.revalidate();
        this.invoker.repaint(1L);
    }

    private void actionAddPool() {
        RJPoolInfoDialog rJPoolInfoDialog = new RJPoolInfoDialog((Frame)this.parent);
        RJPoolApplyItem rJPoolApplyItem = new RJPoolApplyItem();
        do {
            rJPoolInfoDialog.show(rJPoolApplyItem, 2);
        } while ((rJPoolApplyItem = rJPoolInfoDialog.getResult()) != null && !this.isSuccess(rJPoolApplyItem));
        if (rJPoolApplyItem != null) {
            RJPoolPoolElement rJPoolPoolElement = new RJPoolPoolElement(rJPoolApplyItem.getPoolId(), this.supplier, this.treePanel);
            rJPoolPoolElement.initDetail(rJPoolApplyItem);
            int n = this.treePanel.lookup(this.node, rJPoolPoolElement);
            RJaTreeNode rJaTreeNode = this.treePanel.insertObject(this.node, n, rJPoolPoolElement);
            this.treePanel.getTree().setSelectionPath(new TreePath(rJaTreeNode.getPath()));
            RJPoolApplyData rJPoolApplyData = this.supplier.getApplyData();
            rJPoolApplyData.addPoolInfo(rJPoolApplyItem);
        }
    }

    private boolean isSuccess(RJPoolApplyItem rJPoolApplyItem) {
        boolean bl = true;
        if (!rJPoolApplyItem.isPoolIdValidity()) {
            bl = false;
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            RJDataMsg rJDataMsg = this.supplier.getMessage(311055502);
            this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        } else {
            int n = rJPoolApplyItem.getPoolId();
            Enumeration<TreeNode> enumeration = this.node.children();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                RJaTreeNode rJaTreeNode = (RJaTreeNode)enumeration.nextElement();
                RJPoolPoolElement rJPoolPoolElement = (RJPoolPoolElement)rJaTreeNode.getUserObject();
                if (n == rJPoolPoolElement.getPoolId()) {
                    bl = false;
                    Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
                    RJDataMsg rJDataMsg = this.supplier.getMessage(311055503);
                    this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    private void actionDelete() {
        Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
        RJDataMsg rJDataMsg = this.supplier.getMessage(311059602);
        int n = this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        if (n == 0) {
            Enumeration<TreeNode> enumeration = this.node.children();
            while (enumeration.hasMoreElements()) {
                RJaTreeNode rJaTreeNode = (RJaTreeNode)enumeration.nextElement();
                RJPoolPoolElement rJPoolPoolElement = (RJPoolPoolElement)rJaTreeNode.getUserObject();
                if (!rJPoolPoolElement.isDeleteCondition()) continue;
                rJPoolPoolElement.deletePool();
            }
        }
    }

    private void actionRestore() {
        Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
        RJDataMsg rJDataMsg = this.supplier.getMessage(311059603);
        int n = this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        if (n == 0) {
            Enumeration<TreeNode> enumeration = this.node.children();
            while (enumeration.hasMoreElements()) {
                RJaTreeNode rJaTreeNode = (RJaTreeNode)enumeration.nextElement();
                RJPoolPoolElement rJPoolPoolElement = (RJPoolPoolElement)rJaTreeNode.getUserObject();
                if (!rJPoolPoolElement.isRestoreCondition()) continue;
                rJPoolPoolElement.restorePool();
            }
        }
    }

    public void selectNode(RJaTreeNode rJaTreeNode) {
        RJPoolTreePanel rJPoolTreePanel = (RJPoolTreePanel)this.treePanel;
        if (rJPoolTreePanel != null) {
            rJPoolTreePanel.getFreeTablePanel().setPoolKind(2);
        }
    }
}

