/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.prm;

import java.util.ArrayList;
import java.util.Iterator;
import sanproject.client.data.RJDataControl;
import sanproject.serverux.dataimpl.PRMClass;

public class RJPRMSSIDMng {
    private RJDataControl rdc;
    private int[] nSLPR;
    private int[] nGLPR;
    private int nSSIDLower;
    private int nSSIDUpper;

    public RJPRMSSIDMng(RJDataControl rJDataControl) {
        this.rdc = rJDataControl;
    }

    public void init() {
        PRMClass pRMClass = this.rdc.getPRMClassData();
        if (pRMClass != null) {
            this.nSSIDLower = pRMClass.nSSIDLowerLimit;
            this.nSSIDUpper = pRMClass.nSSIDUpperLimit;
            this.nSLPR = new int[this.nSSIDUpper + 1];
            this.nGLPR = new int[this.nSSIDUpper + 1];
            for (int i = 0; i < this.nSLPR.length; ++i) {
                this.nSLPR[i] = -1;
                this.nGLPR[i] = 0;
            }
        }
    }

    public int getSLPR(int n) {
        if (n < this.nSSIDLower || n > this.nSSIDUpper) {
            throw new IndexOutOfBoundsException();
        }
        return this.nSLPR[n];
    }

    public void setSLPRforFirst(int n, int n2) {
        if (this.getSLPR(n) == -1) {
            this.setSLPR(n, n2);
            this.nGLPR[n] = 0;
        }
    }

    private void setSLPR(int n, int n2) {
        if (n < this.nSSIDLower || n > this.nSSIDUpper) {
            throw new IndexOutOfBoundsException();
        }
        this.nSLPR[n] = n2;
    }

    public void setSLPRtoList(ArrayList arrayList, int n) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.setSLPR((Integer)iterator.next(), n);
        }
    }
}

