/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.sso.certificate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import sanproject.serverux.sso.certificate.HpCmsKeyStoreException;

public class HpCmsKeyStore {
    private static final String KEYSTORE_TYPE = "JKS";
    private static final String KEYSTORE_PASSWORD = "hpsimks";
    private static final File keyStoreFile = new File("../../san/htdocs/san/env/hpcms.ks");

    private HpCmsKeyStore() {
    }

    public static boolean exists() {
        return keyStoreFile.exists();
    }

    public static synchronized KeyStore load() throws HpCmsKeyStoreException {
        KeyStore keyStore = null;
        InputStream inputStream = null;
        try {
            keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            if (keyStoreFile.exists()) {
                inputStream = new FileInputStream(keyStoreFile);
                keyStore.load(inputStream, KEYSTORE_PASSWORD.toCharArray());
            } else {
                keyStore.load(null, KEYSTORE_PASSWORD.toCharArray());
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new HpCmsKeyStoreException("cannot construct the KeyStore", keyStoreException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new HpCmsKeyStoreException("cannot read the KeyStoreFile", fileNotFoundException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new HpCmsKeyStoreException("cannot load the KeyStore", noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new HpCmsKeyStoreException("cannot load the KeyStore", certificateException);
        }
        catch (IOException iOException) {
            throw new HpCmsKeyStoreException("cannot load the KeyStore", iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return keyStore;
    }

    public static synchronized void store(KeyStore keyStore) throws HpCmsKeyStoreException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(keyStoreFile);
            keyStore.store(fileOutputStream, KEYSTORE_PASSWORD.toCharArray());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new HpCmsKeyStoreException("cannot access KeyStoreFile", fileNotFoundException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new HpCmsKeyStoreException("cannot access KeyStoreFile", keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new HpCmsKeyStoreException("cannot access KeyStoreFile", noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new HpCmsKeyStoreException("cannot access KeyStoreFile", certificateException);
        }
        catch (IOException iOException) {
            throw new HpCmsKeyStoreException("cannot access KeyStoreFile", iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

