/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp;

import ch.ethz.iks.slp.Advertiser;
import ch.ethz.iks.slp.Locator;
import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.StandalonePlatformAbstraction;
import java.util.Locale;

public final class ServiceLocationManager
extends SLPCore {
    public static Advertiser getAdvertiser(Locale locale) throws ServiceLocationException {
        ServiceLocationManager.init();
        SLPCore.initMulticastSocket();
        if (advertiser != null) {
            try {
                return (Advertiser)advertiser.newInstance(locale);
            }
            catch (Exception e) {
                throw new ServiceLocationException(20, e.getMessage());
            }
        }
        throw new ServiceLocationException(16, "The current configuration does not support SA functionalities.");
    }

    public static Locator getLocator(Locale locale) throws ServiceLocationException {
        ServiceLocationManager.init();
        if (locator != null) {
            try {
                return (Locator)locator.newInstance(locale);
            }
            catch (Exception e) {
                throw new ServiceLocationException(20, e.getMessage());
            }
        }
        throw new ServiceLocationException(16, "The current configuration does not support UA functionalities.");
    }

    public static int getRefreshInterval() throws ServiceLocationException {
        return -1;
    }

    public static void init() {
        if (SLPCore.platform == null) {
            SLPCore.platform = new StandalonePlatformAbstraction();
            SLPCore.init();
        }
    }

    public static void stop() {
        if (SLPCore.platform != null) {
            SLPCore.shutdown();
        }
    }

    private ServiceLocationManager() {
    }
}

