/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.impl.PlatformAbstraction;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.filter.Filter;
import ch.ethz.iks.slp.impl.filter.RFC1960Filter;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class StandalonePlatformAbstraction
implements PlatformAbstraction {
    private final Logger log = Logger.getLogger(LOGGER_NAME);
    public static String LOGGER_NAME = "net.slp.trace";

    public StandalonePlatformAbstraction() {
        this.log.setUseParentHandlers(false);
        Level pLevel = Level.OFF;
        this.log.setLevel(pLevel);
        if (Level.OFF != pLevel) {
            try {
                FileHandler logFileHandle = new FileHandler(LOGGER_NAME);
                logFileHandle.setFormatter(new SimpleFormatter());
                this.log.addHandler(logFileHandle);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Filter createFilter(String filterString) throws IllegalArgumentException {
        return RFC1960Filter.fromString(filterString);
    }

    @Override
    public void logDebug(String message) {
        this.log.fine(message);
    }

    @Override
    public void logDebug(String message, Throwable exception) {
        this.log.log(Level.FINE, message, exception);
    }

    @Override
    public void logError(String message) {
        this.log.severe(message);
    }

    @Override
    public void logError(String message, Throwable exception) {
        this.log.log(Level.SEVERE, message, exception);
    }

    @Override
    public void logTraceDrop(String string) {
        if (SLPCore.CONFIG.getTraceDrop()) {
            this.log.finer(string);
        }
    }

    @Override
    public void logTraceMessage(String string) {
        if (SLPCore.CONFIG.getTraceMessage()) {
            this.log.finer(string);
        }
    }

    @Override
    public void logTraceReg(String string) {
        if (SLPCore.CONFIG.getTraceReg()) {
            this.log.finer(string);
        }
    }

    @Override
    public void logWarning(String message) {
        this.log.warning(message);
    }

    @Override
    public void logWarning(String message, Throwable exception) {
        this.log.log(Level.WARNING, message, exception);
    }
}

