/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.client.adapter.cimxml;

import com.ws.logging.CIMClientTrace;
import com.ws.wbem.client.adapter.cimxml.CIMXMLRequestStreamWriter;
import com.ws.wbem.client.adapter.cimxml.CIMXMLResponseStreamParser;
import com.ws.wbem.client.adapter.common.HTTPClient;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifierType;
import javax.cim.UnsignedInteger32;
import javax.security.auth.Subject;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.client.EnumerateResponse;
import javax.wbem.client.WBEMClient;
import javax.xml.stream.XMLStreamException;

public class CIMXMLHTTPClient
extends HTTPClient
implements WBEMClient {
    private static final String CONTENT_TYPE_XML = "application/xml";
    private static final String STANDARD_HTTPPORT = "5988";
    private static final String STANDARD_HTTPSPORT = "5989";
    private static final String CIMOM_POST = "/cimom";
    private static final String ERROR = "Could not retrieve error message with ID: ";
    private static final String BUNDLE_NAME = "com.ws.wbem.client.adapter.cimxml.CIMXMLHTTPClient";
    private final Properties mProperties;
    private final AtomicBoolean mInitilized = new AtomicBoolean(false);

    public CIMXMLHTTPClient() {
        this.mProperties = new Properties();
        this.mProperties.put("javax.wbem.client.timeout", "0");
        this.mProperties.put("javax.wbem.client.log.maxfilesize", "5242880");
        this.mProperties.put("javax.wbem.client.log.numfiles", "3");
        this.mProperties.put("javax.wbem.client.log.file.enabled", "OFF");
        this.mProperties.put("javax.wbem.client.log.console.enabled", "OFF");
        this.mProperties.put("javax.wbem.client.log.filename", "");
    }

    private void addHeaders(String operationName, CIMObjectPath target) throws IOException {
        this.addHeader("CIMOperation", "MethodCall");
        this.addHeader("CIMMethod", operationName);
        String namespace = target.getNamespace();
        if (namespace.startsWith("/")) {
            namespace = namespace.substring(1);
        }
        try {
            this.addHeader("CIMObject", URLEncoder.encode(namespace, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.addHeader("CIMObject", namespace);
        }
        this.addHeader("Accept-Language", this.getLocaleString());
    }

    public CloseableIterator<CIMClass> associatorClasses(CIMObjectPath target, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers) throws WBEMException {
        if (target == null || target.getObjectName() == null) {
            throw new WBEMException(4, this.getMessage("ERROR_SOURCE_NULL", null));
        }
        CIMObjectPath newTarget = null;
        newTarget = null != target.getKeys() ? new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), target.getNamespace(), target.getObjectName(), null) : target;
        this.getClientLogger().associatorClasses(newTarget, assocClass, resultClass, role, resultRole, includeQualifiers);
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("Associators", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.associatorClasses(target, assocClass, resultClass, role, resultRole, includeQualifiers);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            CloseableIterator closeableIterator = (CloseableIterator)p.parseSimpleResponse(this.getInputStream(), target);
            return closeableIterator;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.ASSOCIATORCLASSES, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.ASSOCIATORCLASSES, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public CloseableIterator<CIMInstance> associatorInstances(CIMObjectPath target, String assocClass, String resultClass, String role, String resultRole, String[] propertyList) throws WBEMException {
        if (target == null || target.getObjectName() == null) {
            throw new WBEMException(4, this.getMessage("ERROR_SOURCE_NULL", null));
        }
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("Associators", target);
            this.getClientLogger().associatorInstances(target, assocClass, resultClass, role, resultRole, propertyList);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.associatorInstances(target, assocClass, resultClass, role, resultRole, propertyList);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            CloseableIterator closeableIterator = (CloseableIterator)p.parseSimpleResponse(this.getInputStream(), target);
            return closeableIterator;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.OPENASSOCIATORS, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.OPENASSOCIATORS, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public EnumerateResponse<CIMInstance> associators(CIMObjectPath target, String assocClass, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects) throws WBEMException {
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("OpenAssociatorInstances", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.associators(target, assocClass, resultClass, role, resultRole, propertyList, filterQueryLanguage, filterQuery, timeout, continueOnError, maxObjects);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            EnumerateResponse enumerateResponse = (EnumerateResponse)p.parseSimpleResponse(this.getInputStream(), target);
            return enumerateResponse;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.OPENASSOCIATORS, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.OPENASSOCIATORS, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public void close() {
        this.disconnect();
        this.mInitilized.set(false);
    }

    public void closeEnumeration(CIMObjectPath target, String context) throws WBEMException {
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("CloseEnumeration", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.closeEnumeration(target, context);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            p.parseSimpleResponse(this.getInputStream(), target);
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.CLOSEENUMERATION, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.CLOSEENUMERATION, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public void createClass(CIMClass clazz) throws WBEMException {
        if (clazz == null || clazz.getObjectPath() == null) {
            throw new WBEMException(4, this.getMessage("ERROR_CC_NULL", null));
        }
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("CreateClass", clazz.getObjectPath());
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.createClass(clazz);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            p.parseSimpleResponse(this.getInputStream(), clazz.getObjectPath());
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)clazz.getObjectPath(), (String)e.getMessage(), (WBEMOperation)WBEMOperation.CREATECLASS, (String)clazz.getObjectPath().getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)clazz.getObjectPath(), (String)e.getMessage(), (WBEMOperation)WBEMOperation.CREATECLASS, (String)clazz.getObjectPath().getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public CIMObjectPath createInstance(CIMInstance instance) throws WBEMException {
        if (instance == null || instance.getObjectPath() == null) {
            throw new WBEMException(4, this.getMessage("ERROR_CI_NULL", null));
        }
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("CreateInstance", instance.getObjectPath());
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.createInstance(instance);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            CIMObjectPath cIMObjectPath = (CIMObjectPath)p.parseSimpleResponse(this.getInputStream(), instance.getObjectPath());
            return cIMObjectPath;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)instance.getObjectPath(), (String)e.getMessage(), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)instance.getObjectPath().getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)instance.getObjectPath(), (String)e.getMessage(), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)instance.getObjectPath().getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public void deleteClass(CIMObjectPath target) throws WBEMException {
        if (target == null || target.getNamespace() == null || target.getObjectName() == null) {
            throw new WBEMException(4, this.getMessage("ERROR_CCN_NULL", null));
        }
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("DeleteClass", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.deleteClass(target);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            p.parseSimpleResponse(this.getInputStream(), target);
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.DELETECLASS, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.DELETECLASS, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public void deleteInstance(CIMObjectPath target) throws WBEMException {
        if (target == null || target.getNamespace() == null || target.getObjectName() == null) {
            throw new WBEMException(4, this.getMessage("ERROR_CIN_NULL", null));
        }
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("DeleteInstance", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.deleteInstance(target);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            p.parseSimpleResponse(this.getInputStream(), target);
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.DELETEINSTANCE, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.DELETEINSTANCE, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public void deleteQualifierType(CIMObjectPath target) throws WBEMException {
        if (target == null || target.getNamespace() == null || target.getObjectName() == null) {
            throw new WBEMException(4, this.getMessage("ERROR_CTN_NULL", null));
        }
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("DeleteQualifier", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.deleteQualifierType(target);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            p.parseSimpleResponse(this.getInputStream(), target);
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.DELETEQUALIFIERTYPE, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.DELETEQUALIFIERTYPE, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public CloseableIterator<CIMClass> enumerateClasses(CIMObjectPath target, boolean deep, boolean localOnly, boolean includeQualifiers) throws WBEMException {
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("EnumerateClasses", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.enumerateClasses(target, deep, localOnly, includeQualifiers);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            CloseableIterator closeableIterator = (CloseableIterator)p.parseSimpleResponse(this.getInputStream(), target);
            return closeableIterator;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.ENUMERATECLASSES, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.ENUMERATECLASSES, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath target, String[] propertyList) throws WBEMException {
        if (target == null || target.getNamespace() == null || target.getObjectName() == null) {
            throw new WBEMException(4, this.getMessage("ERROR_CIN_NULL", null));
        }
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("EnumerateInstances", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.enumerateInstances(target, propertyList);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            CloseableIterator closeableIterator = (CloseableIterator)p.parseSimpleResponse(this.getInputStream(), target);
            return closeableIterator;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public EnumerateResponse<CIMInstance> enumerateInstances(CIMObjectPath target, String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects) throws WBEMException {
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("OpenEnumerateInstances", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.enumerateInstances(target, propertyList, filterQueryLanguage, filterQuery, timeout, continueOnError, maxObjects);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            EnumerateResponse enumerateResponse = (EnumerateResponse)p.parseSimpleResponse(this.getInputStream(), target);
            return enumerateResponse;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public CloseableIterator<CIMQualifierType<?>> enumerateQualifierTypes(CIMObjectPath target) throws WBEMException {
        if (target == null || target.getNamespace() == null) {
            throw new WBEMException(4, this.getMessage("ERROR_CNN_NULL", null));
        }
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("EnumerateQualifiers", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.enumerateQualifierTypes(target);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            CloseableIterator closeableIterator = (CloseableIterator)p.parseSimpleResponse(this.getInputStream(), target);
            return closeableIterator;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.ENUMERATEQUALIFIERTYPES, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.ENUMERATEQUALIFIERTYPES, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public CloseableIterator<CIMInstance> execQuery(CIMObjectPath target, String query, String queryLanguage) throws WBEMException {
        if (queryLanguage == null || queryLanguage.length() == 0) {
            throw new WBEMException(4, this.getMessage("ERROR_CQL_NULL", null));
        }
        if (query == null || query.length() == 0) {
            throw new WBEMException(4, this.getMessage("ERROR_CQF_NULL", null));
        }
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("ExecQuery", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.execQuery(target, query, queryLanguage);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            CloseableIterator closeableIterator = (CloseableIterator)p.parseSimpleResponse(this.getInputStream(), target);
            return closeableIterator;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.EXECUTEQUERY, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.EXECUTEQUERY, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public EnumerateResponse<CIMInstance> execQueryInstances(CIMObjectPath target, String filterQuery, String filterQueryLanguage, boolean returnQueryResultClass, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects, CIMClass queryResultClass) throws WBEMException {
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("OpenQueryInstances", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.execQueryInstances(target, filterQuery, filterQueryLanguage, returnQueryResultClass, timeout, continueOnError, maxObjects, queryResultClass);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            EnumerateResponse enumerateResponse = (EnumerateResponse)p.parseSimpleResponse(this.getInputStream(), target);
            return enumerateResponse;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.OPENQUERYINSTANCES, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.OPENQUERYINSTANCES, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public CIMClass getClass(CIMObjectPath target, boolean localOnly, boolean includeQualifiers) throws WBEMException {
        if (target == null || target.getObjectName() == null) {
            throw new WBEMException(4, this.getMessage("ERROR_CCN_NULL", null));
        }
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("GetClass", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.getClass(target, localOnly, includeQualifiers);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            CIMClass cIMClass = (CIMClass)p.parseSimpleResponse(this.getInputStream(), target);
            return cIMClass;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.GETCLASS, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.GETCLASS, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    protected String getDefaultHTTPPort() {
        return STANDARD_HTTPPORT;
    }

    protected String getDefaultHTTPSPort() {
        return STANDARD_HTTPSPORT;
    }

    public CIMInstance getInstance(CIMObjectPath target, String[] propertyList) throws WBEMException {
        if (target == null || target.getObjectName() == null) {
            throw new WBEMException(4, this.getMessage("ERROR_CIN_NULL", null));
        }
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("GetInstance", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.getInstance(target, propertyList);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            CIMInstance cIMInstance = (CIMInstance)p.parseSimpleResponse(this.getInputStream(), target);
            return cIMInstance;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.GETINSTANCE, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getLocalizedMessage(), (WBEMOperation)WBEMOperation.GETINSTANCE, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public EnumerateResponse<CIMInstance> getInstances(CIMObjectPath target, String context, UnsignedInteger32 maxObjects) throws WBEMException {
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("PullInstances", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.getInstances(target, context, maxObjects);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            EnumerateResponse enumerateResponse = (EnumerateResponse)p.parseSimpleResponse(this.getInputStream(), target);
            return enumerateResponse;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.PULLINSTANCES, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.PULLINSTANCES, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public EnumerateResponse<CIMInstance> getInstancesWithPath(CIMObjectPath target, String context, UnsignedInteger32 maxObjects) throws WBEMException {
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("PullInstancesWithPath", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.getInstancesWithPath(target, context, maxObjects);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            EnumerateResponse enumerateResponse = (EnumerateResponse)p.parseSimpleResponse(this.getInputStream(), target);
            return enumerateResponse;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.PULLINSTANCESWITHPATH, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.PULLINSTANCESWITHPATH, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    private String getMessage(String pID, Object[] pArguments) {
        String message = null;
        try {
            ResourceBundle labels = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
            message = labels.getString(pID);
        }
        catch (Exception e) {
            return ERROR + pID;
        }
        if (pArguments == null) {
            return message;
        }
        return MessageFormat.format(message, pArguments);
    }

    public String getProperty(String name) {
        return this.mProperties.getProperty(name);
    }

    protected String getProtocolPath() {
        return CIMOM_POST;
    }

    public CIMQualifierType<?> getQualifierType(CIMObjectPath target) throws WBEMException {
        if (target == null || target.getObjectName() == null) {
            throw new WBEMException(4, this.getMessage("ERROR_CTN_NULL", null));
        }
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("GetQualifier", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.getQualifierType(target);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            CIMQualifierType cIMQualifierType = (CIMQualifierType)p.parseSimpleResponse(this.getInputStream(), target);
            return cIMQualifierType;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.GETQUALIFIERTYPE, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getLocalizedMessage(), (WBEMOperation)WBEMOperation.GETQUALIFIERTYPE, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public void initialize(CIMObjectPath name, Subject subject, Locale[] locales) throws WBEMException {
        if (!this.mInitilized.compareAndSet(false, true)) {
            throw new WBEMException(this.getMessage("ALREADY_INITIALIZED", null));
        }
        if (name == null || name.getScheme() == null) {
            throw new IllegalArgumentException(this.getMessage("ERROR_HOST_NOT_SPECIFIED", null));
        }
        this.setLocales(locales);
        CIMClientTrace.initTrace((String)this.mProperties.getProperty("javax.wbem.client.log.maxfilesize"), (String)this.mProperties.getProperty("javax.wbem.client.log.numfiles"), (String)this.mProperties.getProperty("javax.wbem.client.log.dir"), (String)this.mProperties.getProperty("javax.wbem.client.log.filename"), (String)this.mProperties.getProperty("javax.wbem.client.log.console.enabled"), (String)this.mProperties.getProperty("javax.wbem.client.log.file.enabled"));
        this.initializeClient(name, subject, this.mProperties);
    }

    public Object invokeMethod(CIMObjectPath target, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        if (target == null || target.getObjectName() == null || methodName == null) {
            throw new IllegalArgumentException(this.getMessage("ERROR_CMN_NULL", null));
        }
        this.getClientLogger().invokeMethod(target, methodName, inArgs, outArgs);
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeader("CIMOperation", "MethodCall");
            this.addHeader("CIMMethod", methodName);
            try {
                CIMObjectPath newOP = new CIMObjectPath(null, null, null, target.getNamespace(), target.getObjectName(), target.getKeys());
                this.addHeader("CIMObject", URLEncoder.encode(newOP.toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                this.addHeader("CIMObject", target.toString());
            }
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.invokeMethod(target, methodName, inArgs, outArgs);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            ArrayList l = new ArrayList();
            Object o = p.parseInvokeMethodResponse(this.getInputStream(), target, l);
            for (int i = 0; i < l.size(); ++i) {
                if (outArgs == null || outArgs.length < i) continue;
                outArgs[i] = l.get(i);
            }
            Object object = o;
            return object;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.INVOKEMETHOD, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.INVOKEMETHOD, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public void modifyClass(CIMClass clazz) throws WBEMException {
        if (null == clazz || null == clazz.getObjectPath()) {
            throw new IllegalArgumentException(this.getMessage("ERROR_CC_NULL", null));
        }
        this.getClientLogger().modifyClass(clazz);
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("ModifyClass", clazz.getObjectPath());
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.modifyClass(clazz);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            p.parseSimpleResponse(this.getInputStream(), clazz.getObjectPath());
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)clazz.getObjectPath(), (String)e.getMessage(), (WBEMOperation)WBEMOperation.MODIFYCLASS, (String)clazz.getObjectPath().getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)clazz.getObjectPath(), (String)e.getMessage(), (WBEMOperation)WBEMOperation.MODIFYCLASS, (String)clazz.getObjectPath().getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public void modifyInstance(CIMInstance instance, String[] propertyList) throws WBEMException {
        if (null == instance || null == instance.getObjectPath()) {
            throw new IllegalArgumentException(this.getMessage("ERROR_CI_NULL", null));
        }
        this.getClientLogger().modifyInstance(instance, propertyList);
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("ModifyInstance", instance.getObjectPath());
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.modifyInstance(instance, propertyList);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            p.parseSimpleResponse(this.getInputStream(), instance.getObjectPath());
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)instance.getObjectPath(), (String)e.getMessage(), (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)instance.getObjectPath().getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)instance.getObjectPath(), (String)e.getMessage(), (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)instance.getObjectPath().getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public CloseableIterator<CIMClass> referenceClasses(CIMObjectPath target, String resultClass, String role, boolean includeQualifiers) throws WBEMException {
        if (target == null || target.getObjectName() == null) {
            throw new WBEMException(4, this.getMessage("ERROR_SOURCE_NULL", null));
        }
        CIMObjectPath newTarget = null;
        newTarget = null != target.getKeys() ? new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), target.getNamespace(), target.getObjectName(), null) : target;
        this.getClientLogger().referenceClasses(newTarget, resultClass, role, includeQualifiers);
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("References", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.referenceClasses(target, resultClass, role, includeQualifiers);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            CloseableIterator closeableIterator = (CloseableIterator)p.parseSimpleResponse(this.getInputStream(), target);
            return closeableIterator;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.REFERENCECLASSES, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.REFERENCECLASSES, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public CloseableIterator<CIMInstance> referenceInstances(CIMObjectPath target, String resultClass, String role, String[] propertyList) throws WBEMException {
        if (target == null || target.getObjectName() == null) {
            throw new WBEMException(4, this.getMessage("ERROR_SOURCE_NULL", null));
        }
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.getClientLogger().referenceInstances(target, resultClass, role, propertyList);
            this.addHeaders("References", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.referenceInstances(target, resultClass, role, propertyList);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            CloseableIterator closeableIterator = (CloseableIterator)p.parseSimpleResponse(this.getInputStream(), target);
            return closeableIterator;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.OPENREFERENCES, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.OPENREFERENCES, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public EnumerateResponse<CIMInstance> references(CIMObjectPath target, String resultClass, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjects) throws WBEMException {
        this.getClientLogger().references(target, resultClass, role, propertyList, filterQueryLanguage, filterQuery, timeout, continueOnError, maxObjects);
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("OpenReferenceInstances", target);
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.references(target, resultClass, role, propertyList, filterQueryLanguage, filterQuery, timeout, continueOnError, maxObjects);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            EnumerateResponse enumerateResponse = (EnumerateResponse)p.parseSimpleResponse(this.getInputStream(), target);
            return enumerateResponse;
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.OPENREFERENCES, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.OPENREFERENCES, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }

    public void setLocales(Locale[] pLocales) {
        this.mLocales = pLocales;
    }

    public void setProperty(String name, String value) {
        if (null == value) {
            this.mProperties.remove(name);
        } else {
            this.mProperties.put(name, value);
            if ("https.protocols".equals(name)) {
                System.setProperty(name, value);
            }
        }
    }

    public void createQualifierType(CIMQualifierType<?> qualifierType) throws WBEMException {
        this.setQualifierType(qualifierType);
    }

    public void modifyQualifierType(CIMQualifierType<?> qualifierType) throws WBEMException {
        this.setQualifierType(qualifierType);
    }

    public void setQualifierType(CIMQualifierType<?> qualifierType) throws WBEMException {
        if (null == qualifierType || null == qualifierType.getObjectPath()) {
            throw new IllegalArgumentException(this.getMessage("ERROR_CT_NULL", null));
        }
        CIMObjectPath target = qualifierType.getObjectPath();
        CIMXMLRequestStreamWriter requestStreamWriter = null;
        try {
            this.getClientLogger().createQualifierType(qualifierType);
            this.connect(CONTENT_TYPE_XML, null);
            this.addHeaders("SetQualifier", qualifierType.getObjectPath());
            requestStreamWriter = new CIMXMLRequestStreamWriter((OutputStream)this.getOutputStream());
            requestStreamWriter.setQualifierType(qualifierType);
            CIMXMLResponseStreamParser p = new CIMXMLResponseStreamParser();
            p.parseSimpleResponse(this.getInputStream(), target);
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getMessage(), (WBEMOperation)WBEMOperation.CREATEQUALIFIERTYPE, (String)target.getObjectName());
        }
        catch (IOException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)e.getLocalizedMessage(), (WBEMOperation)WBEMOperation.CREATEQUALIFIERTYPE, (String)target.getObjectName());
        }
        finally {
            this.connectionDone();
            if (null != requestStreamWriter) {
                requestStreamWriter.close();
            }
        }
    }
}

