/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationDnsException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseSrvRecord {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseSrvRecord";
    public String[] serverList = null;
    public String protocol = null;
    public String domain = null;

    public SJbaseSrvRecord(String protocol, String domain) {
        this.protocol = protocol;
        this.domain = domain;
    }

    public String[] getServerList() throws SJbaseExCommunicationException {
        String method = "getServerList";
        logger.info(module, method, "", "start");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        InitialDirContext ctx = null;
        Attributes attributes = null;
        try {
            ctx = new InitialDirContext(env);
            String pram = "_" + this.protocol + "._tcp" + "." + this.domain + ".";
            if (this.protocol == null || this.protocol.length() == 0) {
                throw new CommunicationException();
            }
            if (this.protocol.equalsIgnoreCase("ldap") || this.protocol.equalsIgnoreCase("starttls")) {
                pram = "_ldap._tcp." + this.domain + ".";
            } else if (this.protocol.equalsIgnoreCase("kerberos")) {
                pram = "_kerberos._tcp." + this.domain + ".";
            } else {
                throw new CommunicationException();
            }
            attributes = ctx.getAttributes(pram, new String[]{"SRV"});
            Attribute atr = attributes.get("SRV");
            if (atr == null) {
                throw new NamingException();
            }
            this.serverList = new String[atr.size()];
            for (int i = 0; i < atr.size(); ++i) {
                try {
                    String srv = (String)atr.get(i);
                    this.serverList[i] = srv.replace(" ", ",");
                    continue;
                }
                catch (NamingException e) {
                    this.serverList[i] = null;
                }
            }
            Comparator<Object> asc = new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    String method = "compare";
                    logger.info(SJbaseSrvRecord.module, method, "", "start");
                    String[] array1 = a.toString().split(",");
                    String[] array2 = b.toString().split(",");
                    int priority1 = Integer.parseInt(array1[0]);
                    int priority2 = Integer.parseInt(array2[0]);
                    int result = 0;
                    if (priority1 == priority2) {
                        result = 0;
                    } else {
                        int n = result = priority1 < priority2 ? -1 : 1;
                    }
                    if (result == 0) {
                        int weight2;
                        int weight1 = Integer.parseInt(array1[1]);
                        result = weight1 == (weight2 = Integer.parseInt(array2[1])) ? 0 : (weight1 < weight2 ? 1 : -1);
                    }
                    logger.info(SJbaseSrvRecord.module, method, "", "end");
                    return result;
                }
            };
            logger.info(module, method, "sort the host list by priority and weight", "");
            Arrays.sort(this.serverList, asc);
        }
        catch (CommunicationException e) {
            logger.info(module, method, "get srv-record", "invalid1");
            throw new SJbaseExCommunicationDnsException();
        }
        catch (NamingException e) {
            logger.info(module, method, "get srv-record", "invalid2");
            throw new SJbaseExCommunicationDnsException();
        }
        catch (Exception e) {
            logger.info(module, method, "get srv-record", "invalid3");
            throw new SJbaseExCommunicationDnsException();
        }
        logger.info(module, method, "", "end");
        return this.serverList;
    }
}

