/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.Logger;

import java.util.Calendar;
import java.util.Date;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.SJcAuditLogPrinter;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLogElementContainerInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLogPrinterInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJcAuditLogger
implements SJcAuditLoggerInterface {
    protected SJcLoggerInterface logger;
    protected String glSessionId = null;
    private final String LOG_FUNCTION = "SJcAuditLogger";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private final String DEFAULT_ELEMENT_CONTAINER = "SJcAuditLogElemCon";
    private final String STR_DELIMITER = ".";

    public SJcAuditLogger() {
        this.logger = SJcLogUty.getLogger();
    }

    @Override
    public void init(SJbaseUserSession us) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putLog(SJcAuditLogElementContainerInterface ec) {
        String LOG_SUBTITLE = "putLog";
        this.logger.info("SJcAuditLogger", this.LOG_TITLE, LOG_SUBTITLE, "Start. -ec:" + ec);
        try {
            Calendar cal = Calendar.getInstance();
            Date currentDate = cal.getTime();
            ec.setDateTime(currentDate);
            ec.setSessionID(this.glSessionId);
            SJcAuditLogPrinterInterface obj = null;
            Class<?> cla = null;
            String eleClassName = ec.getClass().getSimpleName();
            String priClassName = this.getPrinterClassName(eleClassName);
            this.logger.info("SJcAuditLogger", this.LOG_TITLE, LOG_SUBTITLE, " - printerClassName:" + priClassName);
            try {
                cla = Class.forName(priClassName);
                obj = (SJcAuditLogPrinterInterface)cla.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                this.logger.error("SJcAuditLogger", this.LOG_TITLE, LOG_SUBTITLE, "Not Find AuditLogPrinterClass. ex:", cnfe);
                obj = new SJcAuditLogPrinter();
            }
            catch (ClassCastException cce) {
                this.logger.error("SJcAuditLogger", this.LOG_TITLE, LOG_SUBTITLE, "Invalid AuditLogPrinterClass. ex:", cce);
                obj = new SJcAuditLogPrinter();
            }
            obj.putLog(ec);
        }
        catch (Exception e) {
            this.logger.error("SJcAuditLogger", this.LOG_TITLE, LOG_SUBTITLE, "Exception. ", e);
        }
        catch (UnsatisfiedLinkError e) {
            this.logger.error("SJcAuditLogger", this.LOG_TITLE, LOG_SUBTITLE, "Exception. ", e);
        }
        finally {
            this.logger.info("SJcAuditLogger", this.LOG_TITLE, LOG_SUBTITLE, "End.");
        }
    }

    private String getPrinterClassName(String eleContainer) {
        String printerClassName;
        String LOG_SUBTITLE = "getPrinterClassName";
        this.logger.trace("SJcAuditLogger", this.LOG_TITLE, LOG_SUBTITLE, "Start. - eleContainer:" + eleContainer);
        if (eleContainer.equals("SJcAuditLogElemCon")) {
            printerClassName = SJcEnvUty.getProperty("SN_Base_AuditLogPrinterClass", "");
        } else {
            String pinterClassName = eleContainer.replace("ElemCon", "Printer");
            String printerClassPath = SJcEnvUty.getProperty("SN_AuditLogPrintPackagePath", "");
            if (!printerClassPath.endsWith(".")) {
                printerClassPath = printerClassPath + ".";
            }
            printerClassName = printerClassPath + pinterClassName;
        }
        this.logger.trace("SJcAuditLogger", this.LOG_TITLE, LOG_SUBTITLE, "End. - return:" + printerClassName);
        return printerClassName;
    }

    @Override
    public void login(SJcException ex) {
    }

    @Override
    public void logout(SJcException ex) {
    }

    @Override
    public void destroy() {
    }
}

