/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.com.utility.fileuty.SJcFileOnDisk;
import sanproject.sn2.com.utility.fileuty.SJcFileUtyDirInfo;
import sanproject.sn2.com.utility.fileuty.SJcFileUtyLockManager;
import sanproject.sn2.com.utility.fileuty.SJcFileUtyProcessorImpl;
import sanproject.sn2.com.utility.fileuty.exception.SJcFileUtyException;
import sanproject.sn2.com.utility.fileuty.exception.SJcFileUtyParameterException;
import sanproject.sn2.com.utility.fileuty.inf.SJcFileInterface;
import sanproject.sn2.com.utility.fileuty.inf.SJcFileUtyProcessor;

public class SJcFileUty
implements SJcConst {
    private static SJcFileUtyProcessor PROCESSOR;
    public static final int BYTESIZEALL = -1;
    private static final String ENCODE_UTF8 = "UTF-8";
    private static final int BUFFERSIZE = 1024;
    private static final String CHECK_STR = "..";
    private static final String LOG_FUNCTION = "FileIOUtility";
    private static final String LOG_TITLE = "SJcFileUty";
    private static final String RANDOM_FILE_UNDERBAR = "_";
    private static final String TAR_SEPARATOR = "/";
    private static HashMap<String, String> DOWNLOAD_TABLE;

    private SJcFileUty() {
    }

    public static void setProcessor(SJcFileUtyProcessor processor) {
        PROCESSOR = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(String directoryName, String fileName) throws SJcException {
        Object obj;
        String LOG_SUBTITLE = "loadText";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadText", "Start. - directoryName:" + directoryName + ", fileName:" + fileName);
        if (directoryName == null || fileName == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadText", "Parameter is null.");
            throw new SJcFileUtyParameterException("107018");
        }
        if (fileName.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadText", "fileName.length:" + fileName.length());
            throw new SJcFileUtyParameterException("107018");
        }
        if (directoryName.contains(CHECK_STR) || fileName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadText", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107018");
        }
        String data = "";
        String path = SJcFileUty.getFileALLPath("data", directoryName, fileName);
        Object object = obj = SJcFileUtyLockManager.acquire(path);
        synchronized (object) {
            try {
                SJcFileInterface inf = PROCESSOR.getSJcFile(path);
                byte[] fileData = SJcFileUty.loadBinary(directoryName, fileName, 0, (int)inf.getLength());
                data = new String(fileData, ENCODE_UTF8);
            }
            catch (IOException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadText", "IOException.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadText", "Exception.");
                throw new SJcFileUtyException(ex, "107017");
            }
            finally {
                SJcFileUtyLockManager.release(obj);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadText", "End.");
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveText(String directoryName, String fileName, String data) throws SJcException {
        Object obj;
        String LOG_SUBTITLE = "saveText";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveText", "Start. - directoryName:" + directoryName + ", fileName:" + fileName);
        if (directoryName == null || fileName == null || data == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveText", "Parameter is null.");
            throw new SJcFileUtyParameterException("107019");
        }
        if (fileName.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveText", "fileName.length:" + fileName.length());
            throw new SJcFileUtyParameterException("107019");
        }
        if (directoryName.contains(CHECK_STR) || fileName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveText", "Parameter contains ..");
            throw new SJcFileUtyParameterException("107019");
        }
        String path = SJcFileUty.getFileALLPath("data", directoryName, fileName);
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        Object object = obj = SJcFileUtyLockManager.acquire(path);
        synchronized (object) {
            try {
                SJcFileInterface inf = PROCESSOR.getSJcFile(path);
                SJcFileUty.makeParentDirectory(inf);
                outputStreamWriter = new OutputStreamWriter(inf.getOutputStream(), ENCODE_UTF8);
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                bufferedWriter.write(data);
            }
            catch (UnsupportedEncodingException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveText", "UnsupportedEncoding.", ex);
                throw new SJcFileUtyException(ex, "107016");
            }
            catch (FileNotFoundException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveText", "FileNotFound. " + ex.getMessage());
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (IOException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveText", "IOException.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveText", "Exception.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            finally {
                if (null != bufferedWriter) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException e) {
                        SJcFileUtyLockManager.release(obj);
                        throw new SJcFileUtyException(e, "107017");
                    }
                }
                if (null != outputStreamWriter) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException e) {
                        SJcFileUtyLockManager.release(obj);
                        throw new SJcFileUtyException(e, "107017");
                    }
                }
                SJcFileUtyLockManager.release(obj);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveText", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String directoryName, String fileName) throws SJcException {
        String LOG_SUBTITLE = "loadProperties";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadProperties", "Start. - directoryName:" + directoryName + ", fileName:" + fileName);
        if (directoryName == null || fileName == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadProperties", "Parameter is null.");
            throw new SJcFileUtyParameterException("107018");
        }
        if (fileName.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadProperties", "fileName.length:" + fileName.length());
            throw new SJcFileUtyParameterException("107018");
        }
        if (directoryName.contains(CHECK_STR) || fileName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadProperties", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107018");
        }
        String path = SJcFileUty.getFileALLPath("data", directoryName, fileName);
        Properties prop = new Properties();
        Object obj = SJcFileUtyLockManager.acquire(path);
        InputStream stream = null;
        Object object = obj;
        synchronized (object) {
            try {
                SJcFileInterface inf = PROCESSOR.getSJcFile(path);
                stream = inf.getInputStream();
                prop.load(stream);
            }
            catch (UnsupportedEncodingException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadProperties", "UnsupportedEncoding.", ex);
                throw new SJcFileUtyException(ex, "107015");
            }
            catch (FileNotFoundException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadProperties", "FileNotFound. " + ex.getMessage());
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (IOException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadProperties", "IOException.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadProperties", "Exception.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            finally {
                if (null != stream) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadProperties", "IOException.", e);
                        SJcFileUtyLockManager.release(obj);
                        throw new SJcFileUtyException(e, "107017");
                    }
                }
                SJcFileUtyLockManager.release(obj);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadProperties", "End.");
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(String directoryName, String fileName, Properties prop) throws SJcException {
        String LOG_SUBTITLE = "saveProperties";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveProperties", "Start. - directoryName:" + directoryName + ", fileName:" + fileName);
        if (directoryName == null || fileName == null || prop == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveProperties", "Parameter is null");
            throw new SJcFileUtyParameterException("107019");
        }
        if (fileName.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveProperties", "fileName.length:" + fileName.length());
            throw new SJcFileUtyParameterException("107019");
        }
        if (directoryName.contains(CHECK_STR) || fileName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveProperties", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107019");
        }
        String path = SJcFileUty.getFileALLPath("data", directoryName, fileName);
        Object obj = SJcFileUtyLockManager.acquire(path);
        OutputStream stream = null;
        Object object = obj;
        synchronized (object) {
            try {
                SJcFileInterface inf = PROCESSOR.getSJcFile(path);
                SJcFileUty.makeParentDirectory(inf);
                stream = inf.getOutputStream();
                prop.store(stream, null);
            }
            catch (UnsupportedEncodingException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveProperties", "UnsupportedEncoding.", ex);
                throw new SJcFileUtyException(ex, "107016");
            }
            catch (FileNotFoundException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveProperties", "FileNotFound. " + ex.getMessage());
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (IOException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveProperties", "IOException.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveProperties", "Exception.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            finally {
                if (null != stream) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveProperties", "IOException.", e);
                        SJcFileUtyLockManager.release(obj);
                        throw new SJcFileUtyException(e, "107017");
                    }
                }
                SJcFileUtyLockManager.release(obj);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveProperties", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable loadSerialize(String directoryName, String fileName) throws SJcException {
        String LOG_SUBTITLE = "loadSerialize";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadSerialize", "Start. - directoryName:" + directoryName + ",fileName:" + fileName);
        if (directoryName == null || fileName == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadSerialize", "Parameter is null");
            throw new SJcFileUtyParameterException("107018");
        }
        if (fileName.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadSerialize", "fileName.length:" + fileName.length());
            throw new SJcFileUtyParameterException("107018");
        }
        if (directoryName.contains(CHECK_STR) || fileName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadSerialize", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107018");
        }
        Serializable obj = null;
        String path = SJcFileUty.getFileALLPath("data", directoryName, fileName);
        Object object = SJcFileUtyLockManager.acquire(path);
        InputStream stream = null;
        ObjectInputStream objStream = null;
        FileLock lock = null;
        Object object2 = object;
        synchronized (object2) {
            try {
                SJcFileInterface inf = PROCESSOR.getSJcFile(path);
                stream = inf.getInputStream();
                if (inf instanceof SJcFileOnDisk) {
                    FileChannel channel = ((FileInputStream)stream).getChannel();
                    lock = channel.lock(0L, Long.MAX_VALUE, true);
                }
                objStream = new ObjectInputStream(stream);
                obj = (Serializable)objStream.readObject();
            }
            catch (UnsupportedEncodingException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadSerialize", "UnsupportedEncoding.", ex);
                throw new SJcFileUtyException(ex, "107015");
            }
            catch (FileNotFoundException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadSerialize", "FileNotFound.:" + ex.getMessage());
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (IOException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadSerialize", "IOException.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadSerialize", "Exception.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (Throwable th) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadSerialize", "Throwable. Path = " + path, th);
                throw new SJcFileUtyException(th, "107017");
            }
            finally {
                if (lock != null) {
                    try {
                        lock.release();
                    }
                    catch (IOException ex) {
                        STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "loadSerialize", "FileLock relase IOException.", ex);
                    }
                }
                if (null != objStream) {
                    try {
                        objStream.close();
                    }
                    catch (IOException e) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadSerialize", "IOException.", e);
                        SJcFileUtyLockManager.release(object);
                        throw new SJcFileUtyException(e, "107017");
                    }
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadSerialize", "IOException.", e);
                        SJcFileUtyLockManager.release(object);
                        throw new SJcFileUtyException(e, "107017");
                    }
                }
                SJcFileUtyLockManager.release(object);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadSerialize", "End.");
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSerialize(String directoryName, String fileName, Serializable obj) throws SJcException {
        String LOG_SUBTITLE = "saveSerialize";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveSerialize", "Start. - directoryName:" + directoryName + ", fileName:" + fileName);
        if (directoryName == null || fileName == null || obj == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveSerialize", "Parameter is null");
            throw new SJcFileUtyParameterException("107019");
        }
        if (fileName.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveSerialize", "fileName.length:" + fileName.length());
            throw new SJcFileUtyParameterException("107019");
        }
        if (directoryName.contains(CHECK_STR) || fileName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveSerialize", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107019");
        }
        String path = SJcFileUty.getFileALLPath("data", directoryName, fileName);
        Object object = SJcFileUtyLockManager.acquire(path);
        OutputStream stream = null;
        ObjectOutputStream objStream = null;
        FileLock lock = null;
        Object object2 = object;
        synchronized (object2) {
            try {
                SJcFileInterface inf = PROCESSOR.getSJcFile(path);
                SJcFileUty.makeParentDirectory(inf);
                stream = inf.getOutputStream();
                if (inf instanceof SJcFileOnDisk) {
                    FileChannel channel = ((FileOutputStream)stream).getChannel();
                    lock = channel.lock();
                }
                objStream = new ObjectOutputStream(stream);
                objStream.writeObject(obj);
                if (inf instanceof SJcFileOnDisk) {
                    ((FileOutputStream)stream).getChannel().force(true);
                    ((FileOutputStream)stream).getFD().sync();
                }
            }
            catch (UnsupportedEncodingException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveSerialize", "UnsupportedEncoding.", ex);
                throw new SJcFileUtyException(ex, "107016");
            }
            catch (FileNotFoundException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveSerialize", "FileNotFound. " + ex.getMessage());
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (IOException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveSerialize", "IOException.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveSerialize", "Exception.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            finally {
                if (lock != null) {
                    try {
                        lock.release();
                    }
                    catch (IOException ex) {
                        STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "saveSerialize", "FileLock relase IOException.", ex);
                    }
                }
                if (null != objStream) {
                    try {
                        objStream.close();
                    }
                    catch (IOException e) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveSerialize", "IOException.", e);
                        SJcFileUtyLockManager.release(object);
                        throw new SJcFileUtyException(e, "107017");
                    }
                }
                if (null != stream) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveSerialize", "IOException.", e);
                        SJcFileUtyLockManager.release(object);
                        throw new SJcFileUtyException(e, "107017");
                    }
                }
                SJcFileUtyLockManager.release(object);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveSerialize", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBinary(String directoryName, String fileName, int offset, int length) throws SJcException {
        Object obj;
        String LOG_SUBTITLE = "loadBinary";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadBinary", "Start. - directoryName:" + directoryName + ", fileName:" + fileName + ", offset:" + offset + ", length:" + length);
        if (directoryName == null || fileName == null || offset < 0 || length < -1) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadBinary", "Parameter is invalid.");
            throw new SJcFileUtyParameterException("107018");
        }
        if (fileName.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadBinary", "fileName.length:" + fileName.length());
            throw new SJcFileUtyParameterException("107018");
        }
        if (directoryName.contains(CHECK_STR) || fileName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadBinary", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107018");
        }
        byte[] result = null;
        String path = SJcFileUty.getFileALLPath("data", directoryName, fileName);
        Object object = obj = SJcFileUtyLockManager.acquire(path);
        synchronized (object) {
            try {
                SJcFileInterface inf = PROCESSOR.getSJcFile(path);
                if (length == -1) {
                    length = (int)inf.getLength();
                    length -= offset;
                }
                result = inf.readBytes(offset, length);
            }
            catch (UnsupportedEncodingException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadBinary", "UnsupportedEncoding.", ex);
                throw new SJcFileUtyException(ex, "107015");
            }
            catch (FileNotFoundException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadBinary", "FileNotFound.:" + ex.getMessage());
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (IOException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadBinary", "IOException.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadBinary", "Exception.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            finally {
                SJcFileUtyLockManager.release(obj);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadBinary", "End.");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBinary(String directoryName, String fileName, byte[] data, int offset) throws SJcException {
        Object obj;
        String LOG_SUBTITLE = "saveBinary";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveBinary", "Start. - directoryName:" + directoryName + ", fileName:" + fileName + ", offset:" + offset);
        if (directoryName == null || fileName == null || data == null || offset < 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveBinary", "Parameter is invalid.");
            throw new SJcFileUtyParameterException("107019");
        }
        if (directoryName.contains(CHECK_STR) || fileName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveBinary", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107019");
        }
        if (fileName.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveBinary", "fileName.length:" + fileName.length());
            throw new SJcFileUtyParameterException("107019");
        }
        String path = SJcFileUty.getFileALLPath("data", directoryName, fileName);
        Object object = obj = SJcFileUtyLockManager.acquire(path);
        synchronized (object) {
            try {
                SJcFileInterface inf = PROCESSOR.getSJcFile(path);
                SJcFileUty.makeParentDirectory(inf);
                inf.writeBytes(data, offset);
            }
            catch (UnsupportedEncodingException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveBinary", "UnsupportedEncoding.", ex);
                throw new SJcFileUtyException(ex, "107016");
            }
            catch (FileNotFoundException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveBinary", "FileNotFound. " + ex.getMessage());
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (IOException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveBinary", "IOException.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveBinary", "Exception.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            finally {
                SJcFileUtyLockManager.release(obj);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveBinary", "End.");
    }

    public static void saveNewBinary(String directoryName, String fileName, byte[] data) throws SJcException {
        String LOG_SUBTITLE = "saveNewBinary";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveNewBinary", "Start. - directoryName:" + directoryName + ", fileName:" + fileName);
        String filePath = SJcFileUty.setEndPathSeparator(directoryName) + fileName;
        if (SJcFileUty.exists(filePath)) {
            SJcFileUty.deleteFile(directoryName, fileName);
        }
        SJcFileUty.saveBinary(directoryName, fileName, data, 0);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveNewBinary", "End.");
    }

    public static void saveClasses2Files(String directoryName, HashMap<String, Serializable> map) throws SJcException {
        String LOG_SUBTITLE = "saveClasses2Files";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveClasses2Files", "Start. - directoryName:" + directoryName);
        if (directoryName == null || map == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveClasses2Files", "Parameter is null");
            throw new SJcFileUtyParameterException("107019");
        }
        if (directoryName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveClasses2Files", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107019");
        }
        Set<String> set = map.keySet();
        for (String fileName : set) {
            try {
                Serializable obj = map.get(fileName);
                SJcFileUty.saveSerialize(directoryName, fileName, obj);
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveClasses2Files", "Exception.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveClasses2Files", "End.");
    }

    public static HashMap<String, Object> loadFiles2Classes(String directoryName, String[] fileNames) throws SJcException {
        String LOG_SUBTITLE = "loadFiles2Classes";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadFiles2Classes", "Start. - directoryName:" + directoryName);
        if (directoryName == null || fileNames == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadFiles2Classes", "Parameter is null");
            throw new SJcFileUtyParameterException("107018");
        }
        if (directoryName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadFiles2Classes", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107018");
        }
        HashMap<String, Object> datas = new HashMap<String, Object>();
        for (int i = 0; i < fileNames.length; ++i) {
            try {
                Serializable obj = SJcFileUty.loadSerialize(directoryName, fileNames[i]);
                datas.put(fileNames[i], obj);
                continue;
            }
            catch (Exception ex) {
                datas.put(fileNames[i], null);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadFiles2Classes", "End.");
        return datas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadXMLData(String directoryName, String fileName, Class<?> classObject) throws SJcException {
        Object obj;
        String LOG_SUBTITLE = "loadXMLData";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadXMLData", "Start. - directoryName:" + directoryName + ", fileName:" + fileName);
        if (directoryName == null || fileName == null || classObject == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadXMLData", "Parameter is null.");
            throw new SJcFileUtyParameterException("107018");
        }
        if (directoryName.contains(CHECK_STR) || fileName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadXMLData", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107018");
        }
        if (fileName.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadXMLData", "fileName.length() is Zero.");
            throw new SJcFileUtyParameterException("107018");
        }
        Object objXML = null;
        String path = SJcFileUty.getFileALLPath("data", directoryName, fileName);
        InputStreamReader inputStream = null;
        Object object = obj = SJcFileUtyLockManager.acquire(path);
        synchronized (object) {
            try {
                SJcFileInterface inf = PROCESSOR.getSJcFile(path);
                if (!inf.exists()) {
                    throw new FileNotFoundException(path);
                }
                inputStream = new InputStreamReader(inf.getInputStream(), ENCODE_UTF8);
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{classObject});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                objXML = unmarshaller.unmarshal((Reader)inputStream);
                inputStream.close();
                inputStream = null;
            }
            catch (FileNotFoundException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadXMLData", "FileNotFound. " + ex.getMessage());
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (IOException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadXMLData", "IOException.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (JAXBException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadXMLData", "JAXBException.", ex);
                throw new SJcFileUtyException(ex, "107052");
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {}
                }
                SJcFileUtyLockManager.release(obj);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadXMLData", "End.");
        return objXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveXMLData(String directoryName, String fileName, Object classObject) throws SJcException {
        Object obj;
        String LOG_SUBTITLE = "saveXMLData";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveXMLData", "Start. - directoryName:" + directoryName + ", fileName:" + fileName);
        if (directoryName == null || fileName == null || classObject == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveXMLData", "Parameter is null.");
            throw new SJcFileUtyParameterException("107019");
        }
        if (directoryName.contains(CHECK_STR) || fileName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveXMLData", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107019");
        }
        if (fileName.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveXMLData", "fileName.length() is Zero.");
            throw new SJcFileUtyParameterException("107019");
        }
        String path = SJcFileUty.getFileALLPath("data", directoryName, fileName);
        OutputStreamWriter outputStream = null;
        Object object = obj = SJcFileUtyLockManager.acquire(path);
        synchronized (object) {
            try {
                SJcFileInterface inf = PROCESSOR.getSJcFile(path);
                SJcFileUty.makeParentDirectory(inf);
                outputStream = new OutputStreamWriter(inf.getOutputStream(), ENCODE_UTF8);
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{classObject.getClass()});
                Marshaller marshaller = context.createMarshaller();
                marshaller.setProperty("jaxb.encoding", (Object)ENCODE_UTF8);
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.marshal(classObject, (Writer)outputStream);
                outputStream.close();
                outputStream = null;
            }
            catch (IOException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveXMLData", "IOException.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            catch (JAXBException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveXMLData", "JAXBException.", ex);
                throw new SJcFileUtyException(ex, "107052");
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException ex) {}
                }
                SJcFileUtyLockManager.release(obj);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveXMLData", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFiles(String directoryName, String[] fileNames, String directoryNameComp, String fileNameComp) throws SJcException {
        Object obj;
        String LOG_SUBTITLE = "compressFiles";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "compressFiles", "Start. - directoryName:" + directoryName + ", directoryNameComp:" + directoryNameComp + ", fileNameComp:" + fileNameComp);
        int i = 0;
        boolean logFlg = false;
        if (directoryName == null || fileNames == null || directoryNameComp == null || fileNameComp == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "compressFiles", "Parameter is null.");
            throw new SJcFileUtyParameterException("107019");
        }
        if (directoryName.contains(CHECK_STR) || directoryNameComp.contains(CHECK_STR) || fileNameComp.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "compressFiles", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107019");
        }
        if (fileNames.length == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "compressFiles", "fileNames.length is Zero.");
            throw new SJcFileUtyParameterException("107019");
        }
        for (i = 0; i < fileNames.length; ++i) {
            if (fileNames[i] == null) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "compressFiles", "Parameter is null.");
                throw new SJcFileUtyParameterException("107019");
            }
            if (fileNames[i].length() == 0) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "compressFiles", "fileNames[" + i + "].length() is Zero.");
                throw new SJcFileUtyParameterException("107019");
            }
            if (!fileNames[i].contains(CHECK_STR)) continue;
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "compressFiles", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107019");
        }
        if (fileNameComp.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "compressFiles", "fileNameComp.length is Zero.");
            throw new SJcFileUtyParameterException("107019");
        }
        String outputPath = SJcFileUty.getFileALLPath("data", directoryNameComp, fileNameComp);
        OutputStream outputStream = null;
        TarArchiveOutputStream tarGzipStream = null;
        Object object = obj = SJcFileUtyLockManager.acquire(outputPath);
        synchronized (object) {
            try {
                SJcFileInterface infOutput = PROCESSOR.getSJcFile(outputPath);
                SJcFileUty.makeParentDirectory(infOutput);
                String[] InputPath = new String[fileNames.length];
                SJcFileInterface[] infInput = new SJcFileInterface[fileNames.length];
                for (i = 0; i < fileNames.length; ++i) {
                    InputPath[i] = SJcFileUty.getFileALLPath("data", directoryName, fileNames[i]);
                    infInput[i] = PROCESSOR.getSJcFile(InputPath[i]);
                    if (infOutput.equals(infInput[i])) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "compressFiles", "Output path same Input path. Input path:" + InputPath[i] + ", Output path:" + outputPath);
                        throw new SJcFileUtyParameterException("107022");
                    }
                    if (infOutput.containPath(infInput[i])) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "compressFiles", "Output path contains Input path. Input path:" + InputPath[i] + ", Output path:" + outputPath);
                        throw new SJcFileUtyParameterException("107022");
                    }
                    if (infInput[i].exists()) continue;
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "compressFiles", "FileNotFoundException. Input path:" + InputPath[i]);
                    logFlg = true;
                    throw new FileNotFoundException();
                }
                outputStream = infOutput.getOutputStream();
                tarGzipStream = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream(outputStream));
                for (i = 0; i < fileNames.length; ++i) {
                    SJcFileUty.compressTarGzip(tarGzipStream, infInput[i], "");
                }
                tarGzipStream.close();
                tarGzipStream = null;
                outputStream.close();
                outputStream = null;
            }
            catch (SJcFileUtyParameterException ex) {
                throw ex;
            }
            catch (IOException ex) {
                if (!logFlg) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "compressFiles", "IOException.", ex);
                }
                throw new SJcFileUtyException(ex, "107017");
            }
            finally {
                if (tarGzipStream != null) {
                    try {
                        tarGzipStream.close();
                    }
                    catch (IOException ex) {}
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException ex) {}
                }
                SJcFileUtyLockManager.release(obj);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "compressFiles", "End.");
    }

    private static void compressTarGzip(TarArchiveOutputStream tarGzipStream, SJcFileInterface infInput, String basePath) throws IOException {
        if (!basePath.endsWith(TAR_SEPARATOR)) {
            basePath = basePath + TAR_SEPARATOR;
        }
        if (infInput.isDirectory()) {
            SJcFileInterface[] filesInf = infInput.listFiles();
            if (filesInf.length == 0) {
                String dirPath = basePath + infInput.getFilename() + TAR_SEPARATOR;
                TarArchiveEntry tarEnt = new TarArchiveEntry(dirPath);
                tarGzipStream.putArchiveEntry((ArchiveEntry)tarEnt);
                tarGzipStream.closeArchiveEntry();
            }
            for (int i = 0; i < filesInf.length; ++i) {
                String subBasePath = basePath + infInput.getFilename();
                SJcFileUty.compressTarGzip(tarGzipStream, filesInf[i], subBasePath);
            }
        }
        if (infInput.isFile()) {
            String fileName = basePath + infInput.getFilename();
            TarArchiveEntry tarEnt = new TarArchiveEntry(fileName);
            tarEnt.setSize(infInput.getLength());
            tarEnt.setModTime(infInput.lastModified());
            tarGzipStream.putArchiveEntry((ArchiveEntry)tarEnt);
            InputStream inputStream = infInput.getInputStream();
            try {
                int n = 0;
                byte[] buff = new byte[1024];
                while ((n = inputStream.read(buff)) > 0) {
                    tarGzipStream.write(buff, 0, n);
                }
                tarGzipStream.closeArchiveEntry();
                inputStream.close();
                inputStream = null;
            }
            catch (IOException ex) {
                throw ex;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractFile(String directoryName, String fileName, String directoryNameExtract) throws SJcException {
        Object obj;
        String LOG_SUBTITLE = "extractFile";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "extractFile", "Start. - directoryName:" + directoryName + ", fileName:" + fileName + ", directoryNameExtract:" + directoryNameExtract);
        if (directoryName == null || fileName == null || directoryNameExtract == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "extractFile", "Parameter is null.");
            throw new SJcFileUtyParameterException("107019");
        }
        if (directoryName.contains(CHECK_STR) || fileName.contains(CHECK_STR) || directoryNameExtract.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "extractFile", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107019");
        }
        if (fileName.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "extractFile", "fileName.length is Zero.");
            throw new SJcFileUtyParameterException("107019");
        }
        String inputPath = SJcFileUty.getFileALLPath("data", directoryName, fileName);
        InputStream inputStream = null;
        TarArchiveInputStream tarGzipStream = null;
        Object object = obj = SJcFileUtyLockManager.acquire(inputPath);
        synchronized (object) {
            try {
                SJcFileInterface infInput = PROCESSOR.getSJcFile(inputPath);
                inputStream = infInput.getInputStream();
                tarGzipStream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(inputStream));
                SJcFileUty.extractTarGzip(tarGzipStream, directoryNameExtract);
                tarGzipStream.close();
                tarGzipStream = null;
                inputStream.close();
                inputStream = null;
            }
            catch (IOException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "extractFile", "IOException.", ex);
                throw new SJcFileUtyException(ex, "107017");
            }
            finally {
                if (tarGzipStream != null) {
                    try {
                        tarGzipStream.close();
                    }
                    catch (IOException ex) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {}
                }
                SJcFileUtyLockManager.release(obj);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "extractFile", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractTarGzip(TarArchiveInputStream tarGzipStream, String directoryName) throws IOException {
        TarArchiveEntry tarEnt = tarGzipStream.getNextTarEntry();
        while (tarEnt != null) {
            Object obj;
            String path = tarEnt.getName();
            path = path.replace(TAR_SEPARATOR, SJcConst.sjc_PathSeparator);
            String outputPath = SJcFileUty.getFileALLPath("data", directoryName, path);
            FilterOutputStream outputStream = null;
            Object object = obj = SJcFileUtyLockManager.acquire(outputPath);
            synchronized (object) {
                try {
                    SJcFileInterface infOutput = PROCESSOR.getSJcFile(outputPath);
                    if (tarEnt.isDirectory()) {
                        infOutput.mkdirs();
                    } else {
                        String parentPath = new File(path).getParent();
                        if (parentPath != null) {
                            String outputSubDir = SJcFileUty.getFileALLPath("data", directoryName, parentPath);
                            SJcFileInterface infOutputSubDir = PROCESSOR.getSJcFile(outputSubDir);
                            if (!infOutputSubDir.exists()) {
                                infOutputSubDir.mkdirs();
                            }
                        } else {
                            SJcFileInterface infParent = infOutput.getParent();
                            if (!infParent.exists()) {
                                infParent.mkdirs();
                            }
                        }
                        int n = 0;
                        byte[] buff = new byte[1024];
                        outputStream = new BufferedOutputStream(infOutput.getOutputStream());
                        while ((n = tarGzipStream.read(buff)) > 0) {
                            ((BufferedOutputStream)outputStream).write(buff, 0, n);
                        }
                        outputStream.close();
                        outputStream = null;
                        infOutput.setLastModified(tarEnt.getModTime().getTime());
                    }
                }
                catch (IOException ex) {
                    throw ex;
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {}
                    }
                    SJcFileUtyLockManager.release(obj);
                }
            }
            tarEnt = tarGzipStream.getNextTarEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(String directoryName, String fileName) throws SJcException {
        Object obj;
        String LOG_SUBTITLE = "deleteFile";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "deleteFile", "Start. - directoryName:" + directoryName + ", fileName:" + fileName);
        if (directoryName == null || fileName == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteFile", "Parameter is null.");
            throw new SJcFileUtyParameterException("107021");
        }
        if (directoryName.contains(CHECK_STR) || fileName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteFile", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107021");
        }
        if (fileName.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteFile", "fileName.length:" + fileName.length());
            throw new SJcFileUtyParameterException("107021");
        }
        String path = SJcFileUty.getFileALLPath("data", directoryName, fileName);
        Object object = obj = SJcFileUtyLockManager.acquire(path);
        synchronized (object) {
            try {
                SJcFileInterface inf = PROCESSOR.getSJcFile(path);
                if (!inf.exists()) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteFile", "FileNotFound. path:" + path);
                    throw new FileNotFoundException();
                }
                SJcFileUty.fileDeleteAll(inf);
            }
            catch (IOException ex) {
                throw new SJcFileUtyException(ex, "107020");
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteFile", "Exception.", ex);
                throw new SJcFileUtyException(ex, "107020");
            }
            finally {
                SJcFileUtyLockManager.release(obj);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "deleteFile", "End.");
    }

    private static void fileDeleteAll(SJcFileInterface fileInf) {
        boolean a;
        String LOG_SUBTITLE = "fileDeleteAll";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        if (!fileInf.exists()) {
            return;
        }
        if (fileInf.isFile() && !(a = fileInf.delete())) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "fileDeleteAll", "File delete error. " + fileInf.getPath());
        }
        if (fileInf.isDirectory()) {
            SJcFileInterface[] files = fileInf.listFiles();
            for (int i = 0; i < files.length; ++i) {
                SJcFileUty.fileDeleteAll(files[i]);
            }
            boolean a2 = fileInf.delete();
            if (!a2) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "fileDeleteAll", "Directory delete error. " + fileInf.getPath());
            }
        }
    }

    public static void deleteFiles(String directoryName, String[] fileNames) throws SJcException {
        String LOG_SUBTITLE = "deleteFiles";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "deleteFiles", "Start. - directoryName:" + directoryName);
        if (directoryName == null || fileNames == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteFiles", "Parameter is null.");
            throw new SJcFileUtyParameterException("107021");
        }
        try {
            for (int i = 0; i < fileNames.length; ++i) {
                String path = SJcFileUty.getFileALLPath("data", directoryName, fileNames[i]);
                SJcFileInterface inf = PROCESSOR.getSJcFile(path);
                if (!inf.exists()) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteFiles", "FileNotFound. path:" + path);
                    throw new FileNotFoundException();
                }
                SJcFileUty.deleteFile(directoryName, fileNames[i]);
            }
        }
        catch (Exception ex) {
            throw new SJcFileUtyException(ex, "107020");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "deleteFiles", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String directoryNameFrom, String fileNameFrom, String directoryNameTo, String fileNameTo) throws SJcException {
        String LOG_SUBTITLE = "copyFile";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "copyFile", "Start. - directoryNameFrom:" + directoryNameFrom + ", fileNameFrom:" + fileNameFrom + ", directoryNameTo:" + directoryNameTo + ",fileNameTo:" + fileNameTo);
        if (directoryNameFrom == null || fileNameFrom == null || directoryNameTo == null || fileNameTo == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "copyFile", "Parameter is null.");
            throw new SJcFileUtyParameterException("107024");
        }
        if (directoryNameFrom.contains(CHECK_STR) || fileNameFrom.contains(CHECK_STR) || directoryNameTo.contains(CHECK_STR) || fileNameTo.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "copyFile", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107024");
        }
        if (fileNameFrom.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "copyFile", "fileName.length:" + fileNameFrom.length());
            throw new SJcFileUtyParameterException("107024");
        }
        String pathFrom = SJcFileUty.getFileALLPath("data", directoryNameFrom, fileNameFrom);
        String pathTo = SJcFileUty.getFileALLPath("data", directoryNameTo, fileNameTo);
        Object objFrom = SJcFileUtyLockManager.acquire(pathFrom);
        Object objTo = SJcFileUtyLockManager.acquire(pathTo);
        Object object = objFrom;
        synchronized (object) {
            Object object2 = objTo;
            synchronized (object2) {
                try {
                    SJcFileInterface infFrom = PROCESSOR.getSJcFile(pathFrom);
                    SJcFileInterface infTo = PROCESSOR.getSJcFile(pathTo);
                    if (infFrom.equals(infTo)) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "copyFile", "SamePathException.");
                        throw new SJcFileUtyParameterException("107022");
                    }
                    if (infTo.containPath(infFrom)) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "copyFile", "pathFrom:" + pathFrom + ", pathTo:" + pathTo);
                        throw new SJcFileUtyParameterException("107022");
                    }
                    if (!infFrom.exists()) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "copyFile", "FileNotFound. pathFrom:" + pathFrom);
                        throw new FileNotFoundException();
                    }
                    SJcFileUty.copyAll(infFrom, infTo);
                }
                catch (SJcFileUtyParameterException ex) {
                    throw ex;
                }
                catch (FileNotFoundException ex) {
                    throw new SJcFileUtyException(ex, "107023");
                }
                catch (Exception ex) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "copyFile", "Exception.", ex);
                    throw new SJcFileUtyException(ex, "107023");
                }
                finally {
                    SJcFileUtyLockManager.release(objTo);
                    SJcFileUtyLockManager.release(objFrom);
                }
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "copyFile", "End.");
    }

    private static void copyAll(SJcFileInterface infFrom, SJcFileInterface infTo) throws SJcException {
        if (infFrom.isDirectory()) {
            if (!infTo.exists()) {
                infTo.mkdirs();
            }
            SJcFileInterface[] dirList = infFrom.listFiles();
            for (int i = 0; i < dirList.length; ++i) {
                String destPath = SJcFileUty.setEndPathSeparator(infTo.getPath()) + dirList[i].getFilename();
                SJcFileInterface srcInf = dirList[i];
                SJcFileInterface destInf = PROCESSOR.getSJcFile(destPath);
                SJcFileUty.copyAll(srcInf, destInf);
            }
        } else if (infFrom.isFile()) {
            if (!infTo.getParent().exists()) {
                infTo.getParent().mkdirs();
            }
            byte[] buff = new byte[1024];
            BufferedInputStream inputStream = null;
            FilterOutputStream outputStream = null;
            try {
                int length;
                inputStream = new BufferedInputStream(infFrom.getInputStream());
                outputStream = new BufferedOutputStream(infTo.getOutputStream());
                while ((length = inputStream.read(buff)) >= 0) {
                    ((BufferedOutputStream)outputStream).write(buff, 0, length);
                }
            }
            catch (FileNotFoundException ex) {
                throw new SJcFileUtyException(ex, "107023");
            }
            catch (IOException ex) {
                throw new SJcFileUtyException(ex, "107023");
            }
            catch (Exception ex) {
                throw new SJcFileUtyException(ex, "107023");
            }
            finally {
                if (null != outputStream) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        throw new SJcFileUtyException(e, "107023");
                    }
                }
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        throw new SJcFileUtyException(e, "107023");
                    }
                }
            }
        }
    }

    public static void copyFiles(String directoryNameFrom, String[] fileNameFrom, String directoryNameTo, String[] fileNameTo) throws SJcException {
        String LOG_SUBTITLE = "copyFiles";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "copyFiles", "Start. - directoryNameFrom:" + directoryNameFrom + ", fileNameFrom:" + fileNameFrom + ", directoryNameTo:" + directoryNameTo + ", fileNameTo:" + fileNameTo);
        if (directoryNameFrom == null || fileNameFrom == null || directoryNameTo == null || fileNameTo == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "copyFiles", "parameter is null.");
            throw new SJcFileUtyParameterException("107024");
        }
        if (fileNameFrom.length != fileNameTo.length) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "copyFiles", "Not Same Length Size.");
            throw new SJcFileUtyParameterException("107024");
        }
        for (int i = 0; i < fileNameFrom.length; ++i) {
            try {
                String pathFrom = SJcFileUty.getFileALLPath("data", directoryNameFrom, fileNameFrom[i]);
                SJcFileInterface infFrom = PROCESSOR.getSJcFile(pathFrom);
                if (!infFrom.exists()) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "copyFiles", "FileNotFound. pathFrom:" + pathFrom);
                    throw new FileNotFoundException();
                }
                SJcFileUty.copyFile(directoryNameFrom, fileNameFrom[i], directoryNameTo, fileNameTo[i]);
                continue;
            }
            catch (Exception e) {
                throw new SJcFileUtyException(e, "107023");
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "copyFiles", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveFile(String directoryNameFrom, String fileNameFrom, String directoryNameTo, String fileNameTo) throws SJcException {
        String LOG_SUBTITLE = "moveFile";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "moveFile", "Start. - directoryNameFrom:" + directoryNameFrom + ", fileNameFrom:" + fileNameFrom + ", directoryNameTo:" + directoryNameTo + ", fileNameTo:" + fileNameTo);
        if (directoryNameFrom == null || fileNameFrom == null || directoryNameTo == null || fileNameTo == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "moveFile", "Parameter is null");
            throw new SJcFileUtyParameterException("107026");
        }
        if (directoryNameFrom.contains(CHECK_STR) || fileNameFrom.contains(CHECK_STR) || directoryNameTo.contains(CHECK_STR) || fileNameTo.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "moveFile", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107026");
        }
        if (fileNameFrom.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "moveFile", "fileName.length:" + directoryNameFrom.length());
            throw new SJcFileUtyParameterException("107026");
        }
        String pathFrom = SJcFileUty.getFileALLPath("data", directoryNameFrom, fileNameFrom);
        String pathTo = SJcFileUty.getFileALLPath("data", directoryNameTo, fileNameTo);
        Object objFrom = SJcFileUtyLockManager.acquire(pathFrom);
        Object objTo = SJcFileUtyLockManager.acquire(pathTo);
        Object object = objFrom;
        synchronized (object) {
            Object object2 = objTo;
            synchronized (object2) {
                try {
                    SJcFileInterface infFrom = PROCESSOR.getSJcFile(pathFrom);
                    SJcFileInterface infTo = PROCESSOR.getSJcFile(pathTo);
                    if (infFrom.equals(infTo)) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "moveFile", "SamePathException.");
                        throw new SJcFileUtyParameterException("107022");
                    }
                    if (infTo.containPath(infFrom)) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "moveFile", "pathFrom:" + pathFrom + ", pathTo:" + pathTo);
                        throw new SJcFileUtyParameterException("107022");
                    }
                    if (!infFrom.exists()) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "moveFile", "FileNotFound. pathFrom:" + pathFrom);
                        throw new FileNotFoundException();
                    }
                    SJcFileUty.copyFile(directoryNameFrom, fileNameFrom, directoryNameTo, fileNameTo);
                    SJcFileUty.deleteFile(directoryNameFrom, fileNameFrom);
                }
                catch (SJcFileUtyParameterException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new SJcFileUtyException(ex, "107025");
                }
                finally {
                    SJcFileUtyLockManager.release(objTo);
                    SJcFileUtyLockManager.release(objFrom);
                }
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "moveFile", "End.");
    }

    public static void moveFiles(String directoryNameFrom, String[] fileNameFrom, String directoryNameTo, String[] fileNameTo) throws SJcException {
        String LOG_SUBTITLE = "moveFiles";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "moveFiles", "Start. - directoryNameFrom:" + directoryNameFrom + ", fileNameFrom:" + fileNameFrom + ", directoryNameTo:" + directoryNameTo + ", fileNameTo:" + fileNameTo);
        if (directoryNameFrom == null || fileNameFrom == null || directoryNameTo == null || fileNameTo == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "moveFiles", "parameter is null.");
            throw new SJcFileUtyParameterException("107026");
        }
        if (fileNameFrom.length != fileNameTo.length) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "moveFiles", "Not Same Length Size.");
            throw new SJcFileUtyParameterException("107026");
        }
        for (int i = 0; i < fileNameFrom.length; ++i) {
            try {
                String pathFrom = SJcFileUty.getFileALLPath("data", directoryNameFrom, fileNameFrom[i]);
                SJcFileInterface infFrom = PROCESSOR.getSJcFile(pathFrom);
                if (!infFrom.exists()) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "moveFiles", "FileNotFound. pathFrom:" + pathFrom);
                    throw new FileNotFoundException();
                }
                SJcFileUty.moveFile(directoryNameFrom, fileNameFrom[i], directoryNameTo, fileNameTo[i]);
                continue;
            }
            catch (Exception e) {
                throw new SJcFileUtyException(e, "107025");
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "moveFiles", "End.");
    }

    public static String[] getFileList(String directoryName) throws SJcException {
        String LOG_SUBTITLE = "getFileList";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getFileList", "Start. - directoryName:" + directoryName);
        if (directoryName == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getFileList", "Parameter is null.");
            throw new SJcFileUtyParameterException("107029");
        }
        if (directoryName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getFileList", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107029");
        }
        String[] listStr = new String[]{};
        ArrayList<String> list = new ArrayList<String>();
        String directoryPath = SJcFileUty.getDirectoryALLPath("data", directoryName);
        try {
            SJcFileInterface inf = PROCESSOR.getSJcFile(directoryPath);
            if (!inf.isDirectory()) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getFileList", "DirectoryNotFound. directoryPath:" + directoryPath);
                throw new FileNotFoundException();
            }
            SJcFileInterface[] fileList = inf.listFiles();
            if (fileList != null) {
                for (int i = 0; i < fileList.length; ++i) {
                    if (!fileList[i].isFile()) continue;
                    list.add(fileList[i].getFilename());
                }
                listStr = new String[list.size()];
                listStr = list.toArray(listStr);
            }
        }
        catch (Exception ex) {
            throw new SJcFileUtyException(ex, "107027");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getFileList", "End.");
        return listStr;
    }

    public static String[] getDirectoryList(String directoryName) throws SJcException {
        String LOG_SUBTITLE = "getDirectoryList";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getDirectoryList", "Start. - directoryName:" + directoryName);
        if (directoryName == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getDirectoryList", "Parameter is null.");
            throw new SJcFileUtyParameterException("107028");
        }
        if (directoryName.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getDirectoryList", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107028");
        }
        String[] listStr = new String[]{};
        ArrayList<String> list = new ArrayList<String>();
        String directoryPath = SJcFileUty.getDirectoryALLPath("data", directoryName);
        try {
            SJcFileInterface inf = PROCESSOR.getSJcFile(directoryPath);
            if (!inf.isDirectory()) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getDirectoryList", "FileNotFound. directoryPath:" + directoryPath);
                throw new FileNotFoundException();
            }
            SJcFileInterface[] directoryList = inf.listFiles();
            if (directoryList != null) {
                for (int i = 0; i < directoryList.length; ++i) {
                    if (!directoryList[i].isDirectory()) continue;
                    list.add(directoryList[i].getFilename());
                }
                listStr = new String[list.size()];
                listStr = list.toArray(listStr);
            }
        }
        catch (Exception ex) {
            throw new SJcFileUtyException(ex, "107027");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getDirectoryList", "End.");
        return listStr;
    }

    private static String getFileALLPath(String dataType, String directoryName, String fileName) {
        String LOG_SUBTITLE = "getFileALLPath";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getFileALLPath", "Start.");
        String dataPath = System.getProperty("SN_DataPath");
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getFileALLPath", "End.");
        return SJcFileUty.setEndPathSeparator(dataPath) + SJcFileUty.getFilePath(dataType, directoryName, fileName);
    }

    private static String getDirectoryALLPath(String dataType, String directoryName) {
        String LOG_SUBTITLE = "getDirectoryALLPath";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getDirectoryALLPath", "Start.");
        String dataPath = System.getProperty("SN_DataPath");
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getDirectoryALLPath", "End.");
        return SJcFileUty.setEndPathSeparator(dataPath) + SJcFileUty.getDirectoryPath(dataType, directoryName);
    }

    private static String getFilePath(String dataType, String directoryName, String fileName) {
        String LOG_SUBTITLE = "getFilePath";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getFilePath", "Start.");
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getFilePath", "End.");
        return SJcFileUty.setEndPathSeparator(SJcFileUty.getDirectoryPath(dataType, directoryName)) + fileName;
    }

    private static String getDirectoryPath(String dataType, String directoryName) {
        String LOG_SUBTITLE = "getDirectoryPath";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getDirectoryPath", "Start.");
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getDirectoryPath", "End.");
        return SJcFileUty.setEndPathSeparator(dataType) + directoryName;
    }

    public static String setEndPathSeparator(String path) {
        String result = path;
        if (result != null && !result.endsWith(SJcConst.sjc_PathSeparator)) {
            result = result + SJcConst.sjc_PathSeparator;
        }
        return result;
    }

    public static String concatFolderPath(String base, String ext) {
        String result = SJcFileUty.setEndPathSeparator(base);
        if (result != null && ext != null) {
            result = SJcFileUty.setEndPathSeparator(result + ext);
        }
        return result;
    }

    public static Serializable loadFile2Class(String directoryName, String fileName) throws Exception {
        return SJcFileUty.loadSerialize(directoryName, fileName);
    }

    public static void saveClass2File(String directoryName, String fileName, Serializable obj) throws Exception {
        SJcFileUty.saveSerialize(directoryName, fileName, obj);
    }

    private static boolean isNULLParameter(Object[] obj) {
        boolean result = false;
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] != null) continue;
            result = true;
            break;
        }
        return result;
    }

    public static void encryptFile(String directoryNameFrom, String fileNameFrom, String directoryNameTo, String fileNameTo) throws SJcException {
        SJcFileInterface infTo;
        String LOG_SUBTITLE = "encryptFile";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "encryptFile", "start");
        Object[] params = new String[]{directoryNameFrom, fileNameFrom, directoryNameTo, fileNameTo};
        if (SJcFileUty.isNULLParameter(params)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "encryptFile", (String)params[0] + " " + (String)params[1] + " " + (String)params[2] + " " + (String)params[3]);
            throw new SJcFileUtyParameterException("107000");
        }
        if (fileNameFrom.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "encryptFile", "fileName.length:" + fileNameFrom.length());
            throw new SJcFileUtyParameterException("107000");
        }
        String fromPath = SJcFileUty.getFileALLPath("data", directoryNameFrom, fileNameFrom);
        String toPath = SJcFileUty.getFileALLPath("data", directoryNameTo, fileNameTo);
        SJcFileInterface infFrom = PROCESSOR.getSJcFile(fromPath);
        if (infFrom.equals(infTo = PROCESSOR.getSJcFile(toPath))) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "encryptFile", "Specified files are same.");
            throw new SJcFileUtyParameterException("107030");
        }
        byte[] plainText = SJcFileUty.loadBinary(directoryNameFrom, fileNameFrom, 0, -1);
        byte[] encData = SJcSecureUty.encryptByte(plainText);
        SJcFileInterface file = infTo;
        if (file.exists() && file.isFile()) {
            SJcFileUty.deleteFile(directoryNameTo, fileNameTo);
        }
        SJcFileUty.saveBinary(directoryNameTo, fileNameTo, encData, 0);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "encryptFile", "end");
    }

    public static void decryptFile(String directoryNameFrom, String fileNameFrom, String directoryNameTo, String fileNameTo) throws SJcException {
        SJcFileInterface infTo;
        String LOG_SUBTITLE = "decryptFile";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "decryptFile", "start");
        Object[] params = new String[]{directoryNameFrom, fileNameFrom, directoryNameTo, fileNameTo};
        if (SJcFileUty.isNULLParameter(params)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "decryptFile", (String)params[0] + " " + (String)params[1] + " " + (String)params[2] + " " + (String)params[3]);
            throw new SJcFileUtyParameterException("107000");
        }
        if (fileNameFrom.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "decryptFile", "fileName.length:" + fileNameFrom.length());
            throw new SJcFileUtyParameterException("107000");
        }
        String fromPath = SJcFileUty.getFileALLPath("data", directoryNameFrom, fileNameFrom);
        String toPath = SJcFileUty.getFileALLPath("data", directoryNameTo, fileNameTo);
        SJcFileInterface infFrom = PROCESSOR.getSJcFile(fromPath);
        if (infFrom.equals(infTo = PROCESSOR.getSJcFile(toPath))) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "decryptFile", "Specified files are same.");
            throw new SJcFileUtyParameterException("107031");
        }
        byte[] encData = SJcFileUty.loadBinary(directoryNameFrom, fileNameFrom, 0, -1);
        byte[] plainText = SJcSecureUty.decryptByte(encData);
        SJcFileInterface file = infTo;
        if (file.exists() && file.isFile()) {
            SJcFileUty.deleteFile(directoryNameTo, fileNameTo);
        }
        SJcFileUty.saveBinary(directoryNameTo, fileNameTo, plainText, 0);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "decryptFile", "end");
    }

    public static byte[] getHashValueFile(String directoryName, String fileName) throws SJcException {
        String LOG_SUBTITLE = "getHashValueFile";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getHashValueFile", "start");
        Object[] params = new String[]{directoryName, fileName};
        if (SJcFileUty.isNULLParameter(params)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getHashValueFile", (String)params[0] + " " + (String)params[1]);
            throw new SJcFileUtyParameterException("107000");
        }
        byte[] plainText = SJcFileUty.loadBinary(directoryName, fileName, 0, -1);
        byte[] hashVal = SJcSecureUty.getHashValueByte(plainText);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getHashValueFile", "end");
        return hashVal;
    }

    public static String getHashValueFileHex(String directoryName, String fileName) throws SJcException {
        String LOG_SUBTITLE = "getHashValueFileHex";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getHashValueFileHex", "start");
        Object[] params = new String[]{directoryName, fileName};
        if (SJcFileUty.isNULLParameter(params)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getHashValueFileHex", (String)params[0] + " " + (String)params[1]);
            throw new SJcFileUtyParameterException("107000");
        }
        byte[] plainText = SJcFileUty.loadBinary(directoryName, fileName, 0, -1);
        String hashVal = SJcSecureUty.getHashValueByteHex(plainText);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getHashValueFileHex", "end");
        return hashVal;
    }

    public static void copyInternalToExternal(String directoryNameInternal, String[] fileNameInternal, String directoryNameExternal, String[] fileNameExternal) throws SJcException {
        String LOG_SUBTITLE = "copyInternalToExternal";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "copyInternalToExternal", "Start. - directoryNameInternal:" + directoryNameInternal + ", directoryNameExternal:" + directoryNameExternal);
        SJcFileUty.copyFileEx(directoryNameInternal, fileNameInternal, directoryNameExternal, fileNameExternal, false, true, "copyInternalToExternal", STD_LOGGER);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "copyInternalToExternal", "End.");
    }

    public static void copyExternalToInternal(String directoryNameExternal, String[] fileNameExternal, String directoryNameInternal, String[] fileNameInternal) throws SJcException {
        String LOG_SUBTITLE = "copyExternalToInternal";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "copyExternalToInternal", "Start. - directoryNameExternal:" + directoryNameExternal + ", directoryNameInternal:" + directoryNameInternal);
        SJcFileUty.copyFileEx(directoryNameExternal, fileNameExternal, directoryNameInternal, fileNameInternal, true, false, "copyExternalToInternal", STD_LOGGER);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "copyExternalToInternal", "End.");
    }

    private static void copyFileEx(String directoryNameFrom, String[] fileNameFrom, String directoryNameTo, String[] fileNameTo, boolean from_flg, boolean to_flg, String LOG_SUBTITLE, SJcLoggerInterface STD_LOGGER) throws SJcException {
        int i;
        if (directoryNameFrom == null || fileNameFrom == null || directoryNameTo == null || fileNameTo == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Parameter is null.");
            throw new SJcFileUtyParameterException("107024");
        }
        if (directoryNameFrom.contains(CHECK_STR) || directoryNameTo.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107024");
        }
        if (fileNameFrom.length == 0 || fileNameTo.length == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "fileNameFrom.length:" + fileNameFrom.length + ", fileNameTo.length:" + fileNameTo.length);
            throw new SJcFileUtyParameterException("107024");
        }
        for (i = 0; i < fileNameFrom.length; ++i) {
            if (fileNameFrom[i] == null) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Parameter is null.");
                throw new SJcFileUtyParameterException("107024");
            }
            if (fileNameFrom[i].length() == 0) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "fileNameFrom[" + i + "].length() is Zero.");
                throw new SJcFileUtyParameterException("107024");
            }
            if (!fileNameFrom[i].contains(CHECK_STR)) continue;
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107024");
        }
        for (i = 0; i < fileNameTo.length; ++i) {
            if (fileNameTo[i] == null) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Parameter is null.");
                throw new SJcFileUtyParameterException("107024");
            }
            if (fileNameTo[i].length() == 0) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "fileNameTo[" + i + "].length() is Zero.");
                throw new SJcFileUtyParameterException("107024");
            }
            if (!fileNameTo[i].contains(CHECK_STR)) continue;
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107024");
        }
        if (fileNameFrom.length != fileNameTo.length) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Not Same Length Size.");
            throw new SJcFileUtyParameterException("107024");
        }
        for (i = 0; i < fileNameFrom.length; ++i) {
            try {
                SJcFileInterface infTo;
                SJcFileInterface infFrom;
                String pathFrom = null;
                if (from_flg) {
                    pathFrom = directoryNameFrom.length() != 0 ? SJcFileUty.setEndPathSeparator(directoryNameFrom) + fileNameFrom[i] : fileNameFrom[i];
                    if (!SJcFileUty.isAbsolutePath(pathFrom)) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Not absolute path. pathFrom:" + pathFrom);
                        throw new SJcFileUtyParameterException("107024");
                    }
                } else {
                    pathFrom = SJcFileUty.getFileALLPath("data", directoryNameFrom, fileNameFrom[i]);
                }
                if (!(infFrom = PROCESSOR.getSJcFile(pathFrom)).exists()) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "FileNotFound. pathFrom:" + pathFrom);
                    throw new FileNotFoundException();
                }
                String pathTo = null;
                if (to_flg) {
                    pathTo = directoryNameTo.length() != 0 ? SJcFileUty.setEndPathSeparator(directoryNameTo) + fileNameTo[i] : fileNameTo[i];
                    if (!SJcFileUty.isAbsolutePath(pathTo)) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Not absolute path. pathTo:" + pathTo);
                        throw new SJcFileUtyParameterException("107024");
                    }
                } else {
                    pathTo = SJcFileUty.getFileALLPath("data", directoryNameTo, fileNameTo[i]);
                }
                if (infFrom.equals(infTo = PROCESSOR.getSJcFile(pathTo))) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Same path. pathFrom:" + pathFrom + ", pathTo:" + pathTo);
                    throw new SJcFileUtyParameterException("107022");
                }
                if (infFrom.isDirectory() && infTo.containPath(infFrom)) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "pathTo contains pathFrom. pathFrom:" + pathFrom + ", pathTo:" + pathTo);
                    throw new SJcFileUtyParameterException("107022");
                }
                SJcFileUty.copyFileEx(infFrom, infTo);
                continue;
            }
            catch (SJcFileUtyParameterException ex) {
                throw ex;
            }
            catch (FileNotFoundException ex) {
                throw new SJcFileUtyException(ex, "107023");
            }
            catch (SJcException e) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "SJcException.", e);
                throw new SJcFileUtyException(e, "107023");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileEx(SJcFileInterface infFrom, SJcFileInterface infTo) throws SJcException {
        Object objFrom = SJcFileUtyLockManager.acquire(infFrom.getPath());
        Object objTo = SJcFileUtyLockManager.acquire(infTo.getPath());
        Object object = objFrom;
        synchronized (object) {
            Object object2 = objTo;
            synchronized (object2) {
                try {
                    SJcFileUty.copyAll(infFrom, infTo);
                }
                catch (SJcException ex) {
                    throw ex;
                }
                finally {
                    SJcFileUtyLockManager.release(objTo);
                    SJcFileUtyLockManager.release(objFrom);
                }
            }
        }
    }

    public static boolean isAbsolutePath(String path) {
        File file = new File(path);
        String absolutePath = file.getAbsolutePath();
        absolutePath = absolutePath.toUpperCase();
        absolutePath = absolutePath.replace("\\", TAR_SEPARATOR);
        String path_tmp = path.toUpperCase();
        return absolutePath.equals(path_tmp = path_tmp.replace("\\", TAR_SEPARATOR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUploadFile(String fileName, String directoryNameTo, String fileNameTo) throws SJcException {
        String LOG_SUBTITLE = "getUploadFile";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getUploadFile", "Start. - fileName:" + fileName + ", directoryNameTo:" + directoryNameTo + ", fileNameTo:" + fileNameTo);
        if (fileName == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getUploadFile", "fileName:" + fileName);
            throw new SJcFileUtyParameterException("107034");
        }
        if (directoryNameTo == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getUploadFile", "directoryNameTo:" + directoryNameTo);
            SJcFileUty.deleteFile(FILE_UPLOAD_DIRECTORY, fileName);
            throw new SJcFileUtyParameterException("107034");
        }
        String orgFileName = SJcFileUty.getOrgFileName(fileName);
        if (fileNameTo == null) {
            fileNameTo = orgFileName;
        }
        if (fileName.length() == 0 || fileNameTo.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getUploadFile", "fileName.length:" + fileName.length() + ", fileNameTo.length:" + fileNameTo.length());
            SJcFileUty.deleteFile(FILE_UPLOAD_DIRECTORY, fileName);
            throw new SJcFileUtyParameterException("107034");
        }
        String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
        String upLoadDirPath = SJcFileUty.concatFolderPath(dataPath, SJcConst.FILE_UPLOAD_DIRECTORY);
        String pathFrom = upLoadDirPath + fileName;
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getUploadFile", "pathFrom:" + pathFrom);
        String pathTo = SJcFileUty.getFileALLPath("data", directoryNameTo, fileNameTo);
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getUploadFile", "pathTo:" + pathTo);
        if (pathFrom.contains(CHECK_STR) || pathTo.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getUploadFile", "fileName:" + fileName + ", directoryNameTo:" + directoryNameTo + ", fileNameTo:" + fileNameTo);
            SJcFileUty.deleteFile(FILE_UPLOAD_DIRECTORY, fileName);
            throw new SJcFileUtyParameterException("107034");
        }
        Object objFrom = SJcFileUtyLockManager.acquire(pathFrom);
        Object objTo = SJcFileUtyLockManager.acquire(pathTo);
        Object object = objFrom;
        synchronized (object) {
            Object object2 = objTo;
            synchronized (object2) {
                try {
                    SJcFileInterface infFrom = PROCESSOR.getSJcFile(pathFrom);
                    if (!infFrom.isFile()) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getUploadFile", "FileNotFound. pathFrom:" + pathFrom);
                        throw new FileNotFoundException();
                    }
                    SJcFileUty.allPathCopy(pathFrom, pathTo);
                    SJcFileUty.deleteFile(FILE_UPLOAD_DIRECTORY, fileName);
                }
                catch (FileNotFoundException ex) {
                    throw new SJcFileUtyException(ex, "107032");
                }
                catch (Exception ex) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getUploadFile", "Exception.", ex);
                    SJcFileUty.deleteFile(FILE_UPLOAD_DIRECTORY, fileName);
                    throw new SJcFileUtyException(ex, "107032");
                }
                finally {
                    SJcFileUtyLockManager.release(objTo);
                    SJcFileUtyLockManager.release(objFrom);
                }
            }
        }
        STD_LOGGER.trace("LOG_FUNCTION", "LOG_TITLE", "LOG_SUBTITLE", "End.");
        return orgFileName;
    }

    private static String getOrgFileName(String fileName) {
        String orgFileName = "";
        int idx = fileName.indexOf(RANDOM_FILE_UNDERBAR);
        if (idx != -1) {
            orgFileName = fileName.substring(idx + 1);
        }
        return orgFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveDownloadFile(String directoryNameFrom, String fileNameFrom) throws SJcException {
        String LOG_SUBTITLE = "saveDownloadFile";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveDownloadFile", "Start. - directoryNameFrom:" + directoryNameFrom + ", fileNameFrom:" + fileNameFrom);
        if (directoryNameFrom == null || fileNameFrom == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveDownloadFile", "Parameter is null.");
            throw new SJcFileUtyParameterException("107035");
        }
        if (directoryNameFrom.contains(CHECK_STR) || fileNameFrom.contains(CHECK_STR)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveDownloadFile", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107035");
        }
        if (fileNameFrom.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveDownloadFile", "fileNameFrom.length:" + fileNameFrom.length());
            throw new SJcFileUtyParameterException("107035");
        }
        UUID randomName = UUID.randomUUID();
        String newFileName = randomName.toString();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "saveDownloadFile", "newFileName:" + newFileName);
        String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
        String downLoadDirPath = SJcFileUty.concatFolderPath(dataPath, SJcConst.FILE_DOWNLOAD_DIRECTORY);
        String pathTo = downLoadDirPath + newFileName;
        String pathFrom = SJcFileUty.getFileALLPath("data", directoryNameFrom, fileNameFrom);
        Object objFrom = SJcFileUtyLockManager.acquire(pathFrom);
        Object objTo = SJcFileUtyLockManager.acquire(pathTo);
        Object object = objFrom;
        synchronized (object) {
            Object object2 = objTo;
            synchronized (object2) {
                try {
                    SJcFileInterface infFrom = PROCESSOR.getSJcFile(pathFrom);
                    SJcFileInterface infTo = PROCESSOR.getSJcFile(pathTo);
                    if (infFrom.equals(infTo)) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveDownloadFile", "SamePathException.");
                        throw new SJcFileUtyParameterException("107022");
                    }
                    if (!infFrom.isFile()) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveDownloadFile", "FileNotFound. pathFrom:" + pathFrom);
                        throw new FileNotFoundException();
                    }
                    SJcFileUty.allPathCopy(pathFrom, pathTo);
                }
                catch (SJcFileUtyParameterException ex) {
                    throw ex;
                }
                catch (FileNotFoundException ex) {
                    throw new SJcFileUtyException(ex, "107033");
                }
                catch (Exception ex) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveDownloadFile", "Exception.", ex);
                    throw new SJcFileUtyException(ex, "107033");
                }
                finally {
                    SJcFileUtyLockManager.release(objTo);
                    SJcFileUtyLockManager.release(objFrom);
                }
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveDownloadFile", "End.");
        return newFileName;
    }

    private static void allPathCopy(String pathFrom, String pathTo) throws SJcException {
        SJcFileInterface infFrom = PROCESSOR.getSJcFile(pathFrom);
        SJcFileInterface infTo = PROCESSOR.getSJcFile(pathTo);
        try {
            if (!infFrom.isFile()) {
                throw new FileNotFoundException();
            }
            SJcFileUty.copyAll(infFrom, infTo);
        }
        catch (IOException ex) {
            throw new SJcFileUtyException(ex, "107023");
        }
        catch (Exception ex) {
            throw new SJcFileUtyException(ex, "107023");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setDownloadFile(String directoryNameFrom, String fileNameFrom) throws SJcException {
        Object objFrom;
        String LOG_SUBTITLE = "setDownloadFile";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "Start. - directoryNameFrom:" + directoryNameFrom + ", fileNameFrom:" + fileNameFrom);
        if (directoryNameFrom == null || fileNameFrom == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "Parameter is null.");
            throw new SJcFileUtyParameterException("107035");
        }
        if (SJcFileUty.isContainsUpperDir(directoryNameFrom, fileNameFrom)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "Parameter contains ../.");
            throw new SJcFileUtyParameterException("107035");
        }
        if (fileNameFrom.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "fileNameFrom.length() is Zero.");
            throw new SJcFileUtyParameterException("107035");
        }
        UUID randomName = UUID.randomUUID();
        String downloadFileKey = randomName.toString();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "downloadFileKey:" + downloadFileKey);
        String path = SJcFileUty.getFileALLPath("data", directoryNameFrom, fileNameFrom);
        Object object = objFrom = SJcFileUtyLockManager.acquire(path);
        synchronized (object) {
            try {
                SJcFileInterface infFrom = PROCESSOR.getSJcFile(path);
                if (!infFrom.exists() || !infFrom.isFile()) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "FileNotFound. path:" + path);
                    throw new FileNotFoundException();
                }
                HashMap<String, String> hashMap = DOWNLOAD_TABLE;
                synchronized (hashMap) {
                    String old_path = DOWNLOAD_TABLE.get(downloadFileKey);
                    if (old_path != null) {
                        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "DownLoadTable update. key:" + downloadFileKey + ", old_path:" + old_path + ", new_path:" + path);
                        DOWNLOAD_TABLE.remove(downloadFileKey);
                    }
                    DOWNLOAD_TABLE.put(downloadFileKey, path);
                }
            }
            catch (FileNotFoundException ex) {
                throw new SJcFileUtyException(ex, "107033");
            }
            finally {
                SJcFileUtyLockManager.release(objFrom);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "End.");
        return downloadFileKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setDownloadFile(String fileAllPath) throws SJcException {
        Object objFrom;
        String LOG_SUBTITLE = "setDownloadFile";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "Start. - filePath:" + fileAllPath);
        if (fileAllPath == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "Parameter is null.");
            throw new SJcFileUtyParameterException("107035");
        }
        if (fileAllPath.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "fileNameFrom.length() is Zero.");
            throw new SJcFileUtyParameterException("107035");
        }
        UUID randomName = UUID.randomUUID();
        String downloadFileKey = randomName.toString();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "downloadFileKey:" + downloadFileKey);
        Object object = objFrom = SJcFileUtyLockManager.acquire(fileAllPath);
        synchronized (object) {
            try {
                SJcFileInterface infFrom = PROCESSOR.getSJcFile(fileAllPath);
                if (!infFrom.exists() || !infFrom.isFile()) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "FileNotFound. path:" + fileAllPath);
                    throw new FileNotFoundException();
                }
                HashMap<String, String> hashMap = DOWNLOAD_TABLE;
                synchronized (hashMap) {
                    String old_path = DOWNLOAD_TABLE.get(downloadFileKey);
                    if (old_path != null) {
                        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "DownLoadTable update. key:" + downloadFileKey + ", old_path:" + old_path + ", new_path:" + fileAllPath);
                        DOWNLOAD_TABLE.remove(downloadFileKey);
                    }
                    DOWNLOAD_TABLE.put(downloadFileKey, fileAllPath);
                }
            }
            catch (FileNotFoundException ex) {
                throw new SJcFileUtyException(ex, "107033");
            }
            finally {
                SJcFileUtyLockManager.release(objFrom);
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "setDownloadFile", "End.");
        return downloadFileKey;
    }

    public static String getDownloadFile(String downloadKey) throws SJcException {
        String LOG_SUBTITLE = "getDownloadFile";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getDownloadFile", "Start. - downloadKey:" + downloadKey);
        if (downloadKey == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getDownloadFile", "Parameter is null.");
            throw new SJcFileUtyParameterException("107035");
        }
        String path = DOWNLOAD_TABLE.get(downloadKey);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getDownloadFile", "End.");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDownloadFile(String downloadKey) throws SJcException {
        String LOG_SUBTITLE = "deleteDownloadFile";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "deleteDownloadFile", "Start. - downloadKey:" + downloadKey);
        if (downloadKey == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteDownloadFile", "Parameter is null.");
            throw new SJcFileUtyParameterException("107035");
        }
        HashMap<String, String> hashMap = DOWNLOAD_TABLE;
        synchronized (hashMap) {
            DOWNLOAD_TABLE.remove(downloadKey);
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "deleteDownloadFile", "End.");
    }

    public static OutputStream getOutStream(String path) throws SJcException {
        String LOG_SUBTITLE = "getOutStream";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getOutStream", "Start. - path:" + path);
        if (path == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getOutStream", "path:" + path);
            throw new SJcFileUtyParameterException("107019");
        }
        OutputStream stream = null;
        try {
            SJcFileInterface inf = PROCESSOR.getSJcFile(path);
            stream = inf.getOutputStream();
        }
        catch (Exception e) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getOutStream", "Exception.", e);
            throw new SJcFileUtyException(e, "107017");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getOutStream", "End.");
        return stream;
    }

    public static InputStream getInStream(String path) throws SJcException {
        String LOG_SUBTITLE = "getInStream";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getInStream", "Start. - path:" + path);
        if (path == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getInStream", "path:" + path);
            throw new SJcFileUtyParameterException("107018");
        }
        InputStream stream = null;
        try {
            SJcFileInterface inf = PROCESSOR.getSJcFile(path);
            stream = inf.getInputStream();
        }
        catch (Exception e) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getInStream", "Exception.", e);
            throw new SJcFileUtyException(e, "107017");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getInStream", "End.");
        return stream;
    }

    public static boolean exists(String path) {
        String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
        String validPath = dataPath + path;
        SJcFileInterface file = PROCESSOR.getSJcFile(validPath);
        return file.exists();
    }

    public static long getFileSize(String dir, String filename) {
        long ret = -1L;
        String path = SJcFileUty.getFileALLPath("data", dir, filename);
        SJcFileInterface file = PROCESSOR.getSJcFile(path);
        ret = file.getLength();
        return ret;
    }

    public static boolean makeDirectory(String dir) {
        String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
        String validPath = SJcFileUty.concatFolderPath(dataPath, dir);
        SJcFileInterface file = PROCESSOR.getSJcFile(validPath);
        boolean ret = file.mkdirs();
        return ret;
    }

    public static boolean makeDirectoryAbsolutePath(String dir) {
        SJcFileInterface file = PROCESSOR.getSJcFile(dir);
        boolean ret = file.mkdirs();
        return ret;
    }

    public static boolean existsAbsolutePath(String path) {
        SJcFileInterface file = PROCESSOR.getSJcFile(path);
        return file.exists();
    }

    private static boolean makeParentDirectory(SJcFileInterface inf) {
        boolean ret = true;
        SJcFileInterface parent = inf.getParent();
        String parentPath = parent.getPath();
        if (parentPath == null) {
            return false;
        }
        if (!parent.exists()) {
            ret = parent.mkdirs();
        }
        return ret;
    }

    private static boolean isContainsUpperDir(String directoryNameFrom, String fileNameFrom) {
        boolean result = false;
        if (directoryNameFrom.contains(CHECK_STR + File.separator) || fileNameFrom.contains(CHECK_STR + File.separator)) {
            result = true;
        } else if (directoryNameFrom.contains("../") || fileNameFrom.contains("../")) {
            result = true;
        }
        return result;
    }

    public static Serializable loadSerializeWithDec(String directoryName, String fileName) throws SJcException {
        Serializable obj = null;
        String LOG_SUBTITLE = "loadSerializeWithDec";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadSerializeWithDec", "Start. - directoryName:" + directoryName + ", fileName:" + fileName);
        byte[] binData = SJcFileUty.loadBinary(directoryName, fileName, 0, -1);
        try {
            obj = (Serializable)SJcSecureUty.decryptDeserialize(binData);
        }
        catch (SJcException ex) {
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "loadSerializeWithDec", "Decrypt Error. - directoryName:" + directoryName + ", fileName:" + fileName);
            obj = SJcFileUty.loadSerialize(directoryName, fileName);
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadSerializeWithDec", "End.");
        return obj;
    }

    public static void saveSerializeWithEnc(String directoryName, String fileName, Serializable obj) throws SJcException {
        String LOG_SUBTITLE = "saveSerializeWithEnc";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveSerializeWithEnc", "Start. - directoryName:" + directoryName + ", fileName:" + fileName);
        byte[] binData = SJcSecureUty.encryptSerialize(obj);
        SJcFileUty.saveNewBinary(directoryName, fileName, binData);
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveSerializeWithEnc", "End.");
    }

    public static Serializable loadSerializeNoLock(String directoryName, String fileName) throws SJcException {
        Serializable obj = null;
        String LOG_SUBTITLE = "loadSerializeNoLock";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadSerializeNoLock", "Start. - directoryName:" + directoryName + ", fileName:" + fileName);
        byte[] binData = SJcFileUty.loadBinary(directoryName, fileName, 0, -1);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(binData));
            obj = (Serializable)in.readObject();
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "loadSerializeNoLock", "Error.", ex);
            throw new SJcFileUtyException(ex, "107017");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ex) {
                    STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "loadSerializeNoLock", "ObjectInputStream close error.", ex);
                }
            }
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "loadSerializeNoLock", "End.");
        return obj;
    }

    static {
        ArrayList<SJcFileUtyDirInfo> dirList = new ArrayList<SJcFileUtyDirInfo>();
        PROCESSOR = new SJcFileUtyProcessorImpl(dirList);
        DOWNLOAD_TABLE = new HashMap();
    }
}

