/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.webapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sanproject.sn2.base.authentication.def.SJbaseHcsAuthorizationType;
import sanproject.sn2.base.authentication.plugin.SJbaseHCSXMLUtility;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.com.utility.SJcWordUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.generated.svp.APIInfo;
import sanproject.sn2.generated.svp.EchoCommand;
import sanproject.sn2.generated.svp.ObjectFactory;
import sanproject.sn2.generated.svp.RAIDSVPServerMessage;
import sanproject.sn2.generated.svp.Response;
import sanproject.sn2.servlet.webapi.def.SJsvlErrorCode;
import sanproject.sn2.servlet.webapi.exception.SJsvlWebApiException;

public class SJsvlHCSServletUty {
    private static final String LOG_FUNCTION = "WebApi";
    private static final String LOG_TITLE = "SJsvlHCSServletUty";
    private static final SJcLoggerInterface LOGGER = SJcLogUty.getLogger("SN_HCS.log");

    public static String getSessionId(HttpServletRequest request) {
        String LOG_SUBTITLE = "getSessionId";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getSessionId", "Start.");
        String result = SJsvlHCSServletUty.getAuthorization(request, SJbaseHcsAuthorizationType.HSSO);
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getSessionId", "End. - result:" + result);
        return result;
    }

    public static String getAuthorization(HttpServletRequest request, Enum<SJbaseHcsAuthorizationType> kubun) {
        String LOG_SUBTITLE = "getAuthorization";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getAuthorization", "Start. type:" + kubun);
        String result = null;
        String authKubun = null;
        if (null == request) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getAuthorization", "request is null.");
            return result;
        }
        if (null == kubun) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getAuthorization", "type is null.");
            return result;
        }
        if (SJbaseHcsAuthorizationType.BASIC.equals(kubun)) {
            authKubun = SJbaseHcsAuthorizationType.BASIC.getValue();
        } else if (SJbaseHcsAuthorizationType.HSSO.equals(kubun)) {
            authKubun = SJbaseHcsAuthorizationType.HSSO.getValue();
        }
        String authorization = request.getHeader("Authorization");
        if (null == authorization) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getAuthorization", "Header Field Authorization is not exist.");
            return result;
        }
        int beginIndex = authKubun.length() + " ".length();
        if (beginIndex + 1 > authorization.length()) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getAuthorization", "Header Field Authorization length is short. length:" + authorization.length());
            return result;
        }
        beginIndex = 0;
        int endIndex = authKubun.length() + " ".length();
        String kbnDlmt = authorization.substring(beginIndex, endIndex);
        boolean checkError = false;
        if (SJbaseHcsAuthorizationType.BASIC.equals(kubun)) {
            if (!(authKubun + " ").equalsIgnoreCase(kbnDlmt)) {
                checkError = true;
            }
        } else if (SJbaseHcsAuthorizationType.HSSO.equals(kubun) && !(authKubun + " ").equals(kbnDlmt)) {
            checkError = true;
        }
        if (checkError) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getAuthorization", "Header Field Authorization is not (type + delimiter). typeDlmt:" + kbnDlmt);
            return result;
        }
        beginIndex = authKubun.length() + " ".length();
        result = authorization.substring(beginIndex);
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getAuthorization", "End.");
        return result;
    }

    public static RAIDSVPServerMessage getRequestBody(HttpServletRequest request) throws SJsvlWebApiException {
        String LOG_SUBTITLE = "getRequestBody";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getRequestBody", "Start.");
        RAIDSVPServerMessage result = null;
        ServletInputStream inputStream = null;
        Class<RAIDSVPServerMessage> classObject = RAIDSVPServerMessage.class;
        try {
            inputStream = request.getInputStream();
            result = (RAIDSVPServerMessage)SJbaseHCSXMLUtility.xml2Java((InputStream)inputStream, classObject);
        }
        catch (IOException ioex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getRequestBody", SJsvlErrorCode.INPUT_STREAM_READ_ERROR.name(), ioex);
            throw new SJsvlWebApiException(SJsvlErrorCode.INPUT_STREAM_READ_ERROR);
        }
        catch (Exception ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getRequestBody", SJsvlErrorCode.CONVERT_XML_TO_JAVA_ERROR.name(), ex);
            throw new SJsvlWebApiException(SJsvlErrorCode.CONVERT_XML_TO_JAVA_ERROR);
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getRequestBody", "End.");
        return result;
    }

    public static void setResponseBody(HttpServletResponse response, RAIDSVPServerMessage message) throws SJsvlWebApiException {
        String LOG_SUBTITLE = "setResponseBody";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setResponseBody", "Start.");
        RAIDSVPServerMessage classObject = message;
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            SJbaseHCSXMLUtility.java2Xml(classObject, (OutputStream)outputStream);
        }
        catch (Throwable th) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "setResponseBody", SJsvlErrorCode.CONVERT_JAVA_TO_XML_ERROR.name(), th);
            throw new SJsvlWebApiException(SJsvlErrorCode.CONVERT_JAVA_TO_XML_ERROR);
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "setResponseBody", "End.");
    }

    public static SJbaseUserSessionInterface checkAuthority(String sessionId, int authBit) throws SJsvlWebApiException {
        String LOG_SUBTITLE = "checkAuthority";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "checkAuthority", "Start. - sessionId:" + sessionId + " authBit:" + authBit);
        SJbaseUserSessionInterface session = null;
        session = SJsvlHCSServletUty.getSession(sessionId);
        if (null == session) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "checkAuthority", SJsvlErrorCode.SESSION_NOTFOUND.name());
            throw new SJsvlWebApiException(SJsvlErrorCode.SESSION_NOTFOUND);
        }
        SJcRoleResourceContainer resourceContainer = session.getRoleResourceInfo();
        if (!resourceContainer.checkAuthority(authBit)) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "checkAuthority", SJsvlErrorCode.AUTHORITY_ERROR.name() + "sessionId:" + sessionId + " authBit:" + authBit);
            throw new SJsvlWebApiException(SJsvlErrorCode.AUTHORITY_ERROR);
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "checkAuthority", "End.");
        return session;
    }

    public static void checkSessionIdFormat(String sessionId) {
        String LOG_SUBTITLE = "checkSessionIdFormat";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "checkSessionIdFormat", "Start. - sessionId:" + sessionId);
        if (null == sessionId) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "checkSessionIdFormat", SJsvlErrorCode.SESSION_ID_NULL_ERROR.name());
            throw new SJsvlWebApiException(SJsvlErrorCode.SESSION_ID_NULL_ERROR);
        }
        if (32 != sessionId.length()) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "checkSessionIdFormat", SJsvlErrorCode.SESSION_ID_LENGETH_ERROR.name() + "length:" + sessionId.length());
            throw new SJsvlWebApiException(SJsvlErrorCode.SESSION_ID_LENGETH_ERROR);
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "checkSessionIdFormat", "End.");
    }

    public static SJbaseUserSessionInterface getSession(String sessionId) throws SJsvlWebApiException {
        String LOG_SUBTITLE = "getSession";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getSession", "Start. - sessionId:" + sessionId);
        SJbaseUserSessionInterface session = null;
        if (null == sessionId) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getSession", SJsvlErrorCode.SESSION_ID_NULL_ERROR.name());
            throw new SJsvlWebApiException(SJsvlErrorCode.SESSION_ID_NULL_ERROR);
        }
        SJbaseUserSessionManager sessionManager = (SJbaseUserSessionManager)SJcSingletonManagerUty.getSingleton(SJbaseUserSessionManager.class);
        if (null == sessionManager) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getSession", SJsvlErrorCode.SESSION_MANAGER_NOTFOUND.name());
            throw new SJsvlWebApiException(SJsvlErrorCode.SESSION_MANAGER_NOTFOUND);
        }
        session = sessionManager.getUserSession(sessionId);
        if (session != null) {
            session.alive();
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getSession", "End.");
        return session;
    }

    public static SJctrUserController getUserController(SJbaseUserSessionInterface session) {
        String LOG_SUBTITLE = "getUserController";
        SJctrUserController ctl = (SJctrUserController)session.getUserController();
        if (ctl == null) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getUserController", SJsvlErrorCode.SESSION_NOTFOUND.name());
            throw new SJsvlWebApiException(SJsvlErrorCode.SESSION_NOTFOUND);
        }
        return ctl;
    }

    public static void setErrorResponseBody(HttpServletResponse response, String apiVersion, String commandName, SJsvlWebApiException wapiex) throws IOException {
        if (wapiex.getErrStatus() != null) {
            SJsvlHCSServletUty.setResponseBody(response, SJsvlHCSServletUty.createResponseErrorMessage(apiVersion, commandName, wapiex));
        } else {
            response.sendError(wapiex.getRspCd());
        }
    }

    private static RAIDSVPServerMessage createResponseErrorMessage(String apiVersion, String commandName, SJsvlWebApiException wapiex) {
        String LOG_SUBTITLE = "createResponseErrorMessage";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "createResponseErrorMessage", "Start.");
        RAIDSVPServerMessage serverMessage = null;
        ObjectFactory factory = new ObjectFactory();
        serverMessage = factory.createRAIDSVPServerMessage();
        APIInfo apiinfo = factory.createAPIInfo();
        apiinfo.setVersion(apiVersion);
        Response response = factory.createResponse();
        EchoCommand command = factory.createEchoCommand();
        command.setName(commandName);
        command.setStatus(wapiex.getCommandStatus());
        command.setResult("");
        command.setResultsource(wapiex.getCauseClassName());
        if (SJsvlHCSServletUty.isSetErrorMessageFunction(commandName)) {
            command.setMessageid(SJsvlHCSServletUty.getMessageId(wapiex));
            command.setMessageJa(SJsvlHCSServletUty.getMessageJA(wapiex));
            command.setMessageEn(SJsvlHCSServletUty.getMessageEN(wapiex));
            command.setMeasureJa(SJsvlHCSServletUty.getMeasureJA(wapiex));
            command.setMeasureEn(SJsvlHCSServletUty.getMeasureEN(wapiex));
        } else {
            command.setMessageid("");
        }
        response.setEchoCommand(command);
        serverMessage.setAPIInfo(apiinfo);
        serverMessage.setResponse(response);
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "createResponseErrorMessage", "End.");
        return serverMessage;
    }

    private static String getMessageId(SJsvlWebApiException wapiex) {
        String result = "";
        Throwable cause = wapiex.getCause();
        if (cause instanceof SJcException) {
            SJcMessage msg = ((SJcException)cause).getMsg();
            result = msg.getMsgID();
        }
        return result;
    }

    private static String getMessageJA(SJsvlWebApiException wapiex) {
        return SJsvlHCSServletUty.getMessage(wapiex, "JA");
    }

    private static String getMessageEN(SJsvlWebApiException wapiex) {
        return SJsvlHCSServletUty.getMessage(wapiex, "EN");
    }

    private static String getMessage(SJsvlWebApiException wapiex, String lang) {
        String LOG_SUBTITLE = "getMessage";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMessage", "Start. - lang:" + lang);
        String result = "";
        Throwable cause = wapiex.getCause();
        if (cause instanceof SJcException) {
            SJcMessage msg = ((SJcException)cause).getMsg();
            SJcMessageHandleInterface message = SJcWordUty.getMessageInfo(lang);
            result = message.getMessage(msg.getFunctionID(), msg.getModuleID(), msg.getMsgID());
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMessage", "End. - result:" + result);
        return result;
    }

    private static String getMeasureJA(SJsvlWebApiException wapiex) {
        return SJsvlHCSServletUty.getMeasure(wapiex, "JA");
    }

    private static String getMeasureEN(SJsvlWebApiException wapiex) {
        return SJsvlHCSServletUty.getMeasure(wapiex, "EN");
    }

    private static String getMeasure(SJsvlWebApiException wapiex, String lang) {
        String LOG_SUBTITLE = "getMeasure";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMeasure", "Start. - lang:" + lang);
        String result = "";
        Throwable cause = wapiex.getCause();
        if (cause instanceof SJcException) {
            SJcMessage msg = ((SJcException)cause).getMsg();
            SJcMessageHandleInterface message = SJcWordUty.getMessageInfo(lang);
            result = message.getMeasuresMessage(msg.getFunctionID(), msg.getModuleID(), msg.getMsgID());
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getMeasure", "End. - result:" + result);
        return result;
    }

    private static boolean isSetErrorMessageFunction(String commandName) {
        boolean result = false;
        if (commandName.equals("GetSnTaskInfo")) {
            result = true;
        }
        return result;
    }
}

