/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.jserver;

import com.ws.utilities.NetworkUtils;
import com.ws.wbem.jserver.JServerClassLoader;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerTraceProperties;
import com.ws.wbem.jserver.embed.EndPoint;
import com.ws.wbem.jserver.embed.JWBEMServerProtocolData;
import com.ws.wbem.jserver.embed.Protocol;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.StringTokenizer;

public class StartJWBEMServer {
    private static final String CLOSE = "close";
    private static final String JWBEMSERVER_CLASS = "com.ws.wbem.jserver.JWBEMServer";
    private static Class<?> mClass;
    private static boolean mIsRunning;
    private static JServerProperties mProperties;
    private static final String STARTJWBEMSERVER = "StartJWBEMServer";

    private static String[] getClassPaths() {
        String[] ret = new String[]{};
        String classpathString = JServerProperties.getClassPath();
        if (classpathString != null) {
            int count = 0;
            StringTokenizer tok = new StringTokenizer(classpathString, ":", false);
            ret = new String[tok.countTokens()];
            while (tok.hasMoreTokens()) {
                String path = tok.nextToken();
                ret[count] = new String("file:" + path);
                ++count;
            }
        }
        return ret;
    }

    private static void loadPropertyFile() throws Exception {
        String bind;
        String basedir = System.getProperty("com.ws.jserver.basedir");
        if (basedir == null) {
            Path currentRelativePath = Paths.get("..", new String[0]);
            basedir = currentRelativePath.toAbsolutePath().toString();
        }
        mProperties = new JServerProperties(basedir);
        try {
            new JServerTraceProperties();
        }
        catch (Exception currentRelativePath) {
            // empty catch block
        }
        String serverIP = bind = JServerProperties.getBindIP();
        if (bind == null || bind.length() == 0) {
            serverIP = NetworkUtils.getLocalIPAddress();
        }
        JServerProperties.setServerhost(serverIP);
        String portFile = JServerProperties.getOMCAPropertiesFile();
        if (portFile != null && portFile.length() > 0) {
            Object[] argument = new Object[]{basedir};
            portFile = MessageFormat.format(portFile, argument);
            try {
                File f = new File(portFile);
                if (f.exists()) {
                    f.delete();
                }
                f.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("-h")) {
            System.out.println("java -jar jserver.jar");
            System.out.println("Note:\n");
            System.out.println("\tThe following system property may be set to override the base directory: com.ws.jserver.basedir");
            System.exit(1);
        }
        try {
            StartJWBEMServer.start(null);
        }
        catch (Throwable e) {
            Throwable t = e;
            if (null != e.getCause()) {
                t = e.getCause();
            }
            t.printStackTrace();
        }
    }

    private static synchronized Object start(JWBEMServerProtocolData data) throws Exception {
        if (mIsRunning) {
            throw new Exception("The J WBEM Server is already running.");
        }
        StartJWBEMServer.loadPropertyFile();
        JServerClassLoader dynClassLoader = new JServerClassLoader(JServerProperties.getBasedir(), StartJWBEMServer.getClassPaths(), StartJWBEMServer.class.getClassLoader());
        mClass = dynClassLoader.loadClass(JWBEMSERVER_CLASS);
        Class<JWBEMServerProtocolData> embedType = JWBEMServerProtocolData.class;
        Method embedMethod = mClass.getDeclaredMethod("setEmbedded", embedType);
        if (null == embedMethod) {
            throw new Exception("com.ws.wbem.jserver.JWBEMServer does not have required method");
        }
        embedMethod.invoke(null, data);
        Class[] argTypes = new Class[]{JServerProperties.class};
        Method method = mClass.getMethod(STARTJWBEMSERVER, argTypes);
        Object[] arglist = new Object[]{mProperties};
        Object ret = method.invoke(null, arglist);
        if (ret != null) {
            mIsRunning = true;
        }
        return ret;
    }

    public static boolean startServer() {
        Object obj = null;
        try {
            obj = StartJWBEMServer.start(null);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        return obj != null;
    }

    public static boolean startServer(JWBEMServerProtocolData data) {
        if (StartJWBEMServer.validateEmbeddedData(data)) {
            Boolean obj = null;
            try {
                obj = StartJWBEMServer.start(data) != null;
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
            return obj != null;
        }
        return false;
    }

    public static synchronized boolean stopServer() {
        try {
            final Method method = mClass.getMethod(CLOSE, null);
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        method.invoke(null, (Object[])null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            new Thread(task).start();
            mIsRunning = false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean validateEmbeddedData(JWBEMServerProtocolData data) {
        Protocol[] protocols;
        boolean ret = false;
        if (null != data && null != (protocols = data.getSupportedProtocols())) {
            for (int idx = 0; idx < protocols.length && !ret; ++idx) {
                EndPoint[] endPts;
                Protocol p = protocols[idx];
                if (!p.getEnabledDefault() || null == (endPts = p.getEndPoints())) continue;
                for (int endPtIdx = 0; endPtIdx < endPts.length && !ret; ++endPtIdx) {
                    EndPoint e = endPts[endPtIdx];
                    if (!e.getEnabledDefault()) continue;
                    ret = true;
                }
            }
        }
        return ret;
    }

    private StartJWBEMServer() {
    }

    static {
        mIsRunning = false;
    }
}

