/*
 * Decompiled with CFR 0.152.
 */
package sanproject.snctrl.com.utility;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJcExecCmdUty {
    private static final String LOG_FUNCTION = "Jetty";
    private static final String LOG_TITLE = SJcExecCmdUty.class.getSimpleName();
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    public static String KEY_STDOUT = "STDOUT";
    public static String KEY_STDERR = "STDERR";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized HashMap<String, ArrayList<String>> execCmd(ArrayList<String> strcmd) {
        Process execProc = null;
        HashMap<String, ArrayList<String>> mapStdErr = new HashMap<String, ArrayList<String>>();
        mapStdErr.put(KEY_STDOUT, new ArrayList());
        mapStdErr.put(KEY_STDERR, new ArrayList());
        String LOG_SUBTITLE = "execCmd";
        try {
            ProcessBuilder builder = new ProcessBuilder(strcmd);
            execProc = builder.start();
            SJcStreamThread stdoutThread = new SJcStreamThread(execProc.getInputStream());
            stdoutThread.start();
            SJcStreamThread stderrThread = new SJcStreamThread(execProc.getErrorStream());
            stderrThread.start();
            execProc.waitFor();
            stdoutThread.join();
            stderrThread.join();
            mapStdErr.put(KEY_STDOUT, stdoutThread.getList());
            mapStdErr.put(KEY_STDERR, stderrThread.getList());
        }
        catch (Exception ex) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "execCmd", "Exception.", (Throwable)ex);
        }
        finally {
            if (execProc != null) {
                try {
                    execProc.getInputStream().close();
                }
                catch (IOException ioe) {}
                try {
                    execProc.getOutputStream().close();
                }
                catch (IOException ioe) {}
                try {
                    execProc.getErrorStream().close();
                }
                catch (IOException ioe) {}
                execProc.destroy();
            }
        }
        return mapStdErr;
    }

    public static ArrayList<String> createStrcmd(String ... param) {
        ArrayList<String> strcmd = new ArrayList<String>();
        for (int i = 0; i < param.length; ++i) {
            strcmd.add(param[i]);
        }
        return strcmd;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SJcStreamThread
    extends Thread {
        private BufferedReader is;
        private ArrayList<String> list = new ArrayList();
        private static final int BUFFER_SIZE = 1024;
        private static final String LOG_FUNCTION = "Jetty";
        private static final String LOG_TITLE = SJcStreamThread.class.getSimpleName();
        private SJcLoggerInterface logger = SJcLogUty.getLogger();

        public SJcStreamThread(InputStream is) {
            this.is = new BufferedReader(new InputStreamReader(is), 1024);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String LOG_SUBTITLE = "run";
            this.logger.trace("Jetty", LOG_TITLE, "run", "Start.");
            try {
                String line;
                while ((line = this.is.readLine()) != null) {
                    this.list.add(line);
                }
            }
            catch (IOException e) {
                this.logger.warn("Jetty", LOG_TITLE, "run", "Error occured.", (Throwable)e);
            }
            finally {
                if (this.is != null) {
                    try {
                        this.is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.logger.trace("Jetty", LOG_TITLE, "run", "End.");
        }

        public ArrayList<String> getList() {
            return this.list;
        }
    }
}

