/*
 * Decompiled with CFR 0.152.
 */
package sanproject.snctrl.thread;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.snctrl.com.SJsnctrlSnConst;
import sanproject.snctrl.com.utility.SJcSleepUty;

public class SJsnctrlMonitoringWork {
    private static final String LOG_FUNCTION = "Jetty";
    private static final String LOG_TITLE = SJsnctrlMonitoringWork.class.getSimpleName();
    final SJcLoggerInterface logger = SJcLogUty.getLogger((String)"SN_MonitoringWork.log");
    private MonitoringWorkThread thread = new MonitoringWorkThread();
    private String workDir = null;
    private String extract_lock = null;
    private static final long CHECK_WAIT_TIME = 1000L;
    private static final long CHECK_DELAY_TIME = 3000L;
    private static final long JOIN_TIME = 1000L;
    private static final long EVENT_WAIT_TIME = 100L;
    boolean monitoring = false;
    boolean monitoringSet = false;

    public SJsnctrlMonitoringWork(String dkcPath) {
        this.workDir = dkcPath + SJsnctrlSnConst.SJ_DIR_NAME_SN2_WORK;
        this.extract_lock = this.workDir + File.separator + ".extract_lock";
        this.monitoringSet = this.getMonitoringSetFlg();
    }

    private boolean getMonitoringSetFlg() {
        String LOG_SUBTITLE = "getMonitoringSetFlg";
        this.logger.info(LOG_FUNCTION, LOG_TITLE, "getMonitoringSetFlg", "Start.");
        boolean flg = false;
        try {
            Properties prop = SJcFileUty.loadProperties((String)"webappctrl", (String)"webappctrl.properties");
            String flgStr = prop.getProperty("SJ_MONITORING_SET");
            this.logger.info(LOG_FUNCTION, LOG_TITLE, "getMonitoringSetFlg", "SJ_MONITORING_SET = " + flgStr);
            if (flgStr != null) {
                flg = Boolean.valueOf(flgStr);
            }
        }
        catch (Exception ex) {
            this.logger.error(LOG_FUNCTION, LOG_TITLE, "getMonitoringSetFlg", "Exception.", (Throwable)ex);
        }
        this.logger.info(LOG_FUNCTION, LOG_TITLE, "getMonitoringSetFlg", "End.");
        return flg;
    }

    public synchronized void startMonitoring() {
        String LOG_SUBTITLE = "startMonitoring";
        this.logger.info(LOG_FUNCTION, LOG_TITLE, "startMonitoring", "Start.");
        if (!this.monitoringSet) {
            this.logger.info(LOG_FUNCTION, LOG_TITLE, "startMonitoring", "End.");
            return;
        }
        if (this.monitoring) {
            this.monitoring = false;
            while (true) {
                this.logger.info(LOG_FUNCTION, LOG_TITLE, "startMonitoring", "interrupt.");
                this.thread.interrupt();
                try {
                    this.logger.info(LOG_FUNCTION, LOG_TITLE, "startMonitoring", "join start.");
                    this.thread.join(1000L);
                    this.logger.info(LOG_FUNCTION, LOG_TITLE, "startMonitoring", "join end.");
                    boolean threadAlived = this.thread.isAlive();
                    this.logger.info(LOG_FUNCTION, LOG_TITLE, "startMonitoring", "thread alive = " + threadAlived);
                    if (!threadAlived) break;
                }
                catch (InterruptedException ex) {
                    this.logger.warn(LOG_FUNCTION, LOG_TITLE, "startMonitoring", "InterruptedException.");
                    break;
                }
            }
        }
        this.monitoring = true;
        this.thread = new MonitoringWorkThread();
        this.thread.start();
        this.logger.info(LOG_FUNCTION, LOG_TITLE, "startMonitoring", "End.");
    }

    public synchronized void stopMonitoring() {
        String LOG_SUBTITLE = "stopMonitoring";
        this.logger.info(LOG_FUNCTION, LOG_TITLE, "stopMonitoring", "Start.");
        if (!this.monitoringSet) {
            this.logger.info(LOG_FUNCTION, LOG_TITLE, "stopMonitoring", "End.");
            return;
        }
        if (this.monitoring) {
            this.monitoring = false;
            while (true) {
                this.logger.info(LOG_FUNCTION, LOG_TITLE, "stopMonitoring", "interrupt.");
                this.thread.interrupt();
                try {
                    this.logger.info(LOG_FUNCTION, LOG_TITLE, "stopMonitoring", "join start.");
                    this.thread.join(1000L);
                    this.logger.info(LOG_FUNCTION, LOG_TITLE, "stopMonitoring", "join end.");
                    boolean threadAlived = this.thread.isAlive();
                    this.logger.info(LOG_FUNCTION, LOG_TITLE, "stopMonitoring", "thread alive = " + threadAlived);
                    if (!threadAlived) break;
                }
                catch (InterruptedException ex) {
                    this.logger.warn(LOG_FUNCTION, LOG_TITLE, "stopMonitoring", "InterruptedException.");
                    break;
                }
            }
        }
        this.logger.info(LOG_FUNCTION, LOG_TITLE, "stopMonitoring", "End. monitoring = " + this.monitoring);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MonitoringWorkThread
    extends Thread {
        private MonitoringWorkThread() {
        }

        @Override
        public void run() {
            boolean checkFlg;
            String LOG_SUBTITLE = "run";
            SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "run", "Start.");
            SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "run", "Delay Start. 3000(ms).");
            boolean waitResult = SJcSleepUty.sleepSchedule(3000L);
            if (!waitResult) {
                SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "run", "End.");
                return;
            }
            while (!(checkFlg = this.checkExtractLock())) {
                if (!SJsnctrlMonitoringWork.this.monitoring) {
                    SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "run", "monitoring is false.");
                    SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "run", "End.");
                    return;
                }
                waitResult = SJcSleepUty.sleepSchedule(1000L);
                if (waitResult) continue;
                SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "run", "End.");
                return;
            }
            try {
                boolean monitorResult;
                do {
                    if (SJsnctrlMonitoringWork.this.monitoring) continue;
                    SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "run", "monitoring is false.");
                    break;
                } while (monitorResult = this.monitoringWork());
            }
            catch (InterruptedException ie) {
                SJsnctrlMonitoringWork.this.logger.warn(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "run", "InterruptedException.");
            }
            catch (Exception ex) {
                SJsnctrlMonitoringWork.this.logger.error(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "run", "Exception.", (Throwable)ex);
            }
            SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "run", "End.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean monitoringWork() throws IOException, InterruptedException {
            String LOG_SUBTITLE = "monitoringWork";
            SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "monitoringWork", "Start.");
            boolean result = false;
            ArrayList<String> dirList = this.getDirList();
            if (dirList.isEmpty()) {
                SJsnctrlMonitoringWork.this.logger.warn(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "monitoringWork", "Work Directory is Empty.");
                return result;
            }
            WatchService ws = null;
            try {
                ws = FileSystems.getDefault().newWatchService();
                for (String dirStr : dirList) {
                    Path dirPath = Paths.get(dirStr, new String[0]);
                    dirPath.register(ws, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                }
                SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "monitoringWork", "Monitoring Start.");
                WatchKey watchKey = ws.take();
                SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "monitoringWork", "Event Occurred.");
                SJcSleepUty.sleepSchedule(100L);
                Iterator<WatchEvent<?>> i$ = watchKey.pollEvents().iterator();
                while (i$.hasNext()) {
                    WatchEvent<?> watchEvent;
                    WatchEvent<?> ev = watchEvent = i$.next();
                    Path name = (Path)ev.context();
                    SJsnctrlMonitoringWork.this.logger.warn(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "monitoringWork", ev.kind().name() + ":" + name.toString());
                }
                SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "monitoringWork", "Monitoring End.");
            }
            finally {
                if (ws != null) {
                    ws.close();
                }
            }
            result = true;
            SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "monitoringWork", "End.");
            return result;
        }

        private boolean checkExtractLock() {
            String LOG_SUBTITLE = "checkExtractLock";
            boolean checkFlg = false;
            File file = new File(SJsnctrlMonitoringWork.this.extract_lock);
            if (file.exists()) {
                SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "checkExtractLock", ".extract_lock is exists.");
                checkFlg = false;
            } else {
                SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "checkExtractLock", ".extract_lock is nothing.");
                checkFlg = true;
            }
            return checkFlg;
        }

        private ArrayList<String> getDirList() {
            String LOG_SUBTITLE = "getDirList";
            SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "getDirList", "Start.");
            ArrayList<String> dirList = new ArrayList<String>();
            File workFile = new File(SJsnctrlMonitoringWork.this.workDir);
            File[] workFiles = workFile.listFiles();
            if (workFiles == null) {
                return dirList;
            }
            dirList.add(workFile.getPath());
            SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "MONITOR", workFile.getPath());
            this.getSubDirList(dirList, workFile);
            SJsnctrlMonitoringWork.this.logger.info(SJsnctrlMonitoringWork.LOG_FUNCTION, LOG_TITLE, "getDirList", "End.");
            return dirList;
        }

        private void getSubDirList(ArrayList<String> monitoringList, File searchDir) {
            File[] workFiles = searchDir.listFiles();
            if (workFiles == null) {
                return;
            }
            for (File f : workFiles) {
                if (!f.isDirectory()) continue;
                monitoringList.add(f.getPath());
                this.getSubDirList(monitoringList, f);
            }
        }
    }
}

