/*
 * Decompiled with CFR 0.152.
 */
package spfc;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import spfc.SPFC_ApplicationCtrl;
import spfc.comm.SPFC_CommPanel;
import spfc.ctrl.SPFC_BaseCtrl;
import spfc.ctrl.SPFC_FileTransferProtocol959Ctrl;

public class SPFC_UploadPanel
extends SPFC_CommPanel {
    protected static final int INPUT_NO_ERR = 0;
    protected static final int INPUT_ERR_ADDRESS = 1;
    protected static final int INPUT_ERR_FILENAME = 16;
    protected SPFC_FileTransferProtocol959Ctrl m_clsFTPClient = null;
    private JComboBox m_cmbAddress;
    private JButton m_btnRemove;
    private JTextField m_tfdClientFile;
    private JButton m_btnReference;
    private JRadioButton m_rbnBinaryMode;
    private JRadioButton m_rbnAsciiMode;
    private JButton m_btnUpload;
    private JButton m_btnExit;
    protected SPFC_ApplicationCtrl m_clsAppCtrl;

    public SPFC_UploadPanel(SPFC_ApplicationCtrl sPFC_ApplicationCtrl) {
        this.m_clsAppCtrl = sPFC_ApplicationCtrl;
        this.buildLayout();
        this.initPanel();
    }

    protected void finalize() throws Throwable {
        this.m_cmbAddress = null;
        this.m_tfdClientFile = null;
        this.m_rbnBinaryMode = null;
        this.m_rbnAsciiMode = null;
        this.m_btnUpload = null;
        this.m_btnExit = null;
    }

    protected void initPanel() {
    }

    protected void buildLayout() {
        Color color = new Color(192, 192, 192);
        this.setLayout(null);
        this.setBackground(color);
        String string = SPFC_ApplicationCtrl.UPLOAD_PANEL_ADDRESS_LABEL_TEXT;
        JLabel jLabel = SPFC_BaseCtrl.getBaseFieldLabel();
        jLabel.setText(string);
        jLabel.setBounds(new Rectangle(10, 10, 200, 30));
        jLabel.setFont(SPFC_BaseCtrl.m_fntAppBoldFont);
        string = SPFC_ApplicationCtrl.UPLOAD_PANEL_ADDRESS_FIELD_TEXT;
        this.m_cmbAddress = new JComboBox<String>(new String[]{string});
        this.m_cmbAddress.setBounds(new Rectangle(10, 2, 220, 26));
        this.m_cmbAddress.setFont(SPFC_BaseCtrl.m_fntAppTextFont);
        this.m_cmbAddress.setEditable(true);
        this.m_cmbAddress.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SPFC_UploadPanel.this.onServerChanged(itemEvent);
            }
        });
        string = SPFC_ApplicationCtrl.UPLOAD_PANEL_REMOVE_BUTTON_TEXT;
        this.m_btnRemove = SPFC_BaseCtrl.getBaseAppButton();
        this.m_btnRemove.setText(string);
        this.m_btnRemove.setBounds(new Rectangle(240, 2, 110, 26));
        this.m_btnRemove.setFont(SPFC_BaseCtrl.m_fntAppBoldFont);
        this.m_btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SPFC_UploadPanel.this.onRemove(actionEvent);
            }
        });
        JPanel jPanel = SPFC_BaseCtrl.getBaseFieldBackPanel();
        jPanel.setBounds(new Rectangle(218, 10, 372, 30));
        jPanel.add(this.m_cmbAddress);
        if (this.m_clsAppCtrl.isVisibleRemoveAddress()) {
            jPanel.add(this.m_btnRemove);
        }
        this.add(jLabel);
        this.add(jPanel);
        string = SPFC_ApplicationCtrl.UPLOAD_PANEL_CLIENTFILE_LABEL_TEXT;
        jLabel = SPFC_BaseCtrl.getBaseFieldLabel();
        jLabel.setText(string);
        jLabel.setBounds(new Rectangle(10, 45, 200, 30));
        jLabel.setFont(SPFC_BaseCtrl.m_fntAppBoldFont);
        string = SPFC_ApplicationCtrl.UPLOAD_PANEL_CLIENTFILE_FIELD_TEXT;
        this.m_tfdClientFile = new JTextField(string);
        this.m_tfdClientFile.setBounds(new Rectangle(10, 2, 220, 26));
        this.m_tfdClientFile.setFont(SPFC_BaseCtrl.m_fntAppTextFont);
        this.m_tfdClientFile.setColumns(255);
        this.m_tfdClientFile.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                SPFC_UploadPanel.this.onClientFileChanged(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                SPFC_UploadPanel.this.onClientFileChanged(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SPFC_UploadPanel.this.onClientFileChanged(documentEvent);
            }
        });
        string = SPFC_ApplicationCtrl.UPLOAD_PANEL_REFERENCE_BUTTON_TEXT;
        this.m_btnReference = SPFC_BaseCtrl.getBaseAppButton();
        this.m_btnReference.setText(string);
        this.m_btnReference.setBounds(new Rectangle(240, 2, 120, 26));
        this.m_btnReference.setFont(SPFC_BaseCtrl.m_fntAppBoldFont);
        this.m_btnReference.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SPFC_UploadPanel.this.onReference(actionEvent);
            }
        });
        jPanel = SPFC_BaseCtrl.getBaseFieldBackPanel();
        jPanel.setBounds(new Rectangle(218, 45, 372, 30));
        jPanel.add(this.m_tfdClientFile);
        jPanel.add(this.m_btnReference);
        this.add(jLabel);
        this.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setBackground(color);
        jPanel.setBounds(new Rectangle(10, 100, 580, 30));
        string = SPFC_ApplicationCtrl.UPLOAD_PANEL_ASCIIMODE_BUTTON_TEXT;
        this.m_rbnAsciiMode = new JRadioButton(string);
        this.m_rbnAsciiMode.setBounds(new Rectangle(132, 2, 125, 26));
        this.m_rbnAsciiMode.setFont(SPFC_BaseCtrl.m_fntAppBoldFont);
        this.m_rbnAsciiMode.setOpaque(false);
        this.m_rbnAsciiMode.setSelected(!this.m_clsAppCtrl.isFTPBinaryMode());
        jPanel.add(this.m_rbnAsciiMode);
        string = SPFC_ApplicationCtrl.UPLOAD_PANEL_BINARYMODE_BUTTON_TEXT;
        this.m_rbnBinaryMode = new JRadioButton(string);
        this.m_rbnBinaryMode.setBounds(new Rectangle(12, 2, 125, 26));
        this.m_rbnBinaryMode.setFont(SPFC_BaseCtrl.m_fntAppBoldFont);
        this.m_rbnBinaryMode.setOpaque(false);
        this.m_rbnBinaryMode.setSelected(this.m_clsAppCtrl.isFTPBinaryMode());
        jPanel.add(this.m_rbnBinaryMode);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_rbnAsciiMode);
        buttonGroup.add(this.m_rbnBinaryMode);
        string = SPFC_ApplicationCtrl.UPLOAD_PANEL_UPLOAD_BUTTON_TEXT;
        this.m_btnUpload = SPFC_BaseCtrl.getBaseAppButton();
        this.m_btnUpload.setText(string);
        this.m_btnUpload.setBounds(new Rectangle(358, 2, 125, 26));
        this.m_btnUpload.setFont(SPFC_BaseCtrl.m_fntAppBoldFont);
        this.m_btnUpload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SPFC_UploadPanel.this.onUpload(actionEvent);
            }
        });
        jPanel.add(this.m_btnUpload);
        string = SPFC_ApplicationCtrl.UPLOAD_PANEL_EXIT_BUTTON_TEXT;
        this.m_btnExit = SPFC_BaseCtrl.getBaseAppButton();
        this.m_btnExit.setText(string);
        this.m_btnExit.setBounds(new Rectangle(498, 2, 80, 26));
        this.m_btnExit.setFont(SPFC_BaseCtrl.m_fntAppBoldFont);
        this.m_btnExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SPFC_UploadPanel.this.onExit(actionEvent);
            }
        });
        jPanel.add(this.m_btnExit);
        this.add(jPanel);
        this.setPanelEnabled();
    }

    public void addAddress(String string) {
        if (string != null && !(string = string.trim()).equals("")) {
            boolean bl = false;
            int n = this.m_cmbAddress.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                String string2 = (String)this.m_cmbAddress.getItemAt(n2);
                if (string2.equals("")) {
                    this.m_cmbAddress.removeItemAt(n2);
                }
                if (string.equals(string2)) {
                    final int n3 = n2;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            SPFC_UploadPanel.this.m_cmbAddress.setSelectedIndex(n3);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                this.m_cmbAddress.addItem(string);
            }
        }
    }

    public String getAddress() {
        return (String)this.m_cmbAddress.getSelectedItem();
    }

    public String[] getAllAddress() {
        int n = this.m_cmbAddress.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.m_cmbAddress.getItemAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public void setClientFilePath(String string) {
        this.m_tfdClientFile.setText(string);
    }

    public String getClientFilePath() {
        return new String(this.m_tfdClientFile.getText());
    }

    public boolean isBinaryMode() {
        return this.m_rbnBinaryMode.isSelected();
    }

    public boolean isAsciiMode() {
        return !this.isBinaryMode();
    }

    protected int inputCheck() {
        int n = 0;
        String string = this.getAddress();
        String string2 = this.getClientFilePath();
        if (string == null || string.equals("")) {
            n |= 1;
        }
        if (string2 == null || string2.equals("")) {
            n |= 0x10;
        }
        return n;
    }

    protected void setPanelEnabled() {
        int n = this.inputCheck();
        if ((n & 1) > 0) {
            this.m_btnRemove.setEnabled(false);
        } else {
            this.m_btnRemove.setEnabled(true);
        }
        if ((n & 1) > 0 || (n & 0x10) > 0) {
            this.m_btnUpload.setEnabled(false);
        } else {
            this.m_btnUpload.setEnabled(true);
        }
    }

    public void uploadStart() {
        this.m_cmbAddress.setEnabled(false);
        this.m_btnRemove.setEnabled(false);
        this.m_tfdClientFile.setEnabled(false);
        this.m_btnReference.setEnabled(false);
        this.m_rbnBinaryMode.setEnabled(false);
        this.m_rbnAsciiMode.setEnabled(false);
        this.m_btnUpload.setEnabled(false);
    }

    public void uploadEnd() {
        this.m_cmbAddress.setEnabled(true);
        this.m_btnRemove.setEnabled(true);
        this.m_tfdClientFile.setEnabled(true);
        this.m_btnReference.setEnabled(true);
        this.m_rbnBinaryMode.setEnabled(true);
        this.m_rbnAsciiMode.setEnabled(true);
        this.m_btnUpload.setEnabled(true);
        System.gc();
    }

    protected void uploadCheck() throws Exception {
        boolean bl = true;
        String string = new String("");
        try {
            String string2 = this.getClientFilePath();
            File file = new File(string2);
            int n = string2.length();
            if (n > 200) {
                string = "The file path specified by [File Name on Client] is too long.\nThe file can not be transmitted if the file path has more than 200 words.";
            } else if (file != null && !file.exists()) {
                string = "The file specified by [File Name on Client] does not exist.";
            } else if (file != null && !file.canRead()) {
                string = "The file specified by [File Name on Client] cannot be read.";
            } else if (file != null && !file.isFile()) {
                string = "The object specified by [File Name on Client] is not a file.";
            } else if (file != null && (double)file.length() > 1509949.44) {
                string = "The file specified by [File Name on Client] is too large.\nIf the file size is 1.44 MBytes or larger, you cannot send the file.";
            } else {
                String string3 = file.getName();
                n = string3.length();
                int n2 = 0;
                while (n2 < n) {
                    char c = string3.charAt(n2);
                    if (c == '\\' || c == '/' || c == ';' || c == ':' || c == '*' || c == '?' || c == '\"' || c == '<' || c == '>' || c == '|') {
                        string = "The file name with  \\ / ; : ? \" < > |  specified by [File Name on Client] can not be used.";
                        break;
                    }
                    ++n2;
                }
                if (n2 == n) {
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            string = "The file name specified by [File Name on Client] is incorrect.";
        }
        if (bl) {
            this.m_tfdClientFile.grabFocus();
            this.m_tfdClientFile.selectAll();
            throw new Exception(string);
        }
    }

    protected void onClientFileChanged(DocumentEvent documentEvent) {
        this.setCursor(new Cursor(3));
        this.setPanelEnabled();
        this.setCursor(new Cursor(0));
    }

    protected void onServerChanged(ItemEvent itemEvent) {
        SPFC_CommPanel.debug_logWrite("SPFC_UploadPanel::onServerChanged( )");
        this.setCursor(new Cursor(3));
        String string = this.getAddress();
        this.addAddress(string);
        this.setPanelEnabled();
        this.setCursor(new Cursor(0));
    }

    protected void onRemove(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        String string = this.getAddress();
        int n = this.m_cmbAddress.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)this.m_cmbAddress.getItemAt(n2);
            if (!string2.equals("") && string2.equals(string)) {
                this.m_cmbAddress.removeItemAt(n2);
                break;
            }
            ++n2;
        }
        this.setCursor(new Cursor(0));
    }

    protected void onReference(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        String string = this.getClientFilePath();
        JFileChooser jFileChooser = new JFileChooser(string);
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            string = jFileChooser.getSelectedFile().getAbsolutePath();
            this.setClientFilePath(string);
            SPFC_CommPanel.debug_logWrite("Selected Path : " + string);
        }
        this.setCursor(new Cursor(0));
    }

    protected void onUpload(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        Thread thread = new Thread(){

            /*
             * Loose catch block
             */
            public void run() {
                block29: {
                    boolean bl;
                    block27: {
                        bl = false;
                        SPFC_UploadPanel.this.uploadStart();
                        String string = SPFC_UploadPanel.this.getClientFilePath();
                        File file = new File(string);
                        String string2 = file.getName().trim();
                        boolean bl2 = true;
                        String string3 = SPFC_UploadPanel.this.getAddress();
                        int n = SPFC_UploadPanel.this.m_clsAppCtrl.getFTPPort();
                        SPFC_CommPanel.debug_logWrite("  address : '" + string3 + "'");
                        SPFC_CommPanel.debug_logWrite("     port :  " + n);
                        SPFC_CommPanel.debug_logWrite("     user : '" + SPFC_UploadPanel.this.m_clsAppCtrl.getFTPUser() + "'");
                        SPFC_CommPanel.debug_logWrite(" password : '" + SPFC_UploadPanel.this.m_clsAppCtrl.getFTPPassword() + "'");
                        SPFC_CommPanel.debug_logWrite("  passive :  " + SPFC_UploadPanel.this.m_clsAppCtrl.isFTPPassiveMode());
                        SPFC_CommPanel.debug_logWrite("directory : '" + SPFC_UploadPanel.this.m_clsAppCtrl.getFTPDirectory() + "'");
                        SPFC_CommPanel.debug_logWrite("   binary :  " + SPFC_UploadPanel.this.isBinaryMode());
                        SPFC_CommPanel.debug_logWrite("    local : '" + string + "'");
                        SPFC_CommPanel.debug_logWrite("     send : '" + string2 + "'");
                        SPFC_UploadPanel.this.m_clsFTPClient = new SPFC_FileTransferProtocol959Ctrl(string3, n);
                        SPFC_CommPanel.logWrite(SPFC_UploadPanel.this.m_clsFTPClient.getLog());
                        SPFC_UploadPanel.this.m_clsFTPClient.login(SPFC_UploadPanel.this.m_clsAppCtrl.getFTPUser(), SPFC_UploadPanel.this.m_clsAppCtrl.getFTPPassword());
                        SPFC_CommPanel.logWrite(SPFC_UploadPanel.this.m_clsFTPClient.getLog());
                        SPFC_UploadPanel.this.m_clsFTPClient.setPassiveMode(SPFC_UploadPanel.this.m_clsAppCtrl.isFTPPassiveMode());
                        SPFC_CommPanel.logWrite(SPFC_UploadPanel.this.m_clsFTPClient.getLog());
                        SPFC_UploadPanel.this.m_clsFTPClient.changeDirectory(SPFC_UploadPanel.this.m_clsAppCtrl.getFTPDirectory());
                        SPFC_CommPanel.logWrite(SPFC_UploadPanel.this.m_clsFTPClient.getLog());
                        ArrayList arrayList = new ArrayList();
                        try {
                            arrayList = SPFC_UploadPanel.this.m_clsFTPClient.getDirectoryNameList();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        SPFC_CommPanel.logWrite(SPFC_UploadPanel.this.m_clsFTPClient.getLog());
                        int n2 = arrayList.size();
                        int n3 = 0;
                        while (n3 < n2) {
                            String string4 = (String)arrayList.get(n3);
                            if (string2.equals(string4)) {
                                String string5 = "The file name is already used by an existing file.\nAre you sure you want to overwrite the existing file?";
                                SPFC_CommPanel.logWrite(string5);
                                if (!SPFC_BaseCtrl.showConfirm("overwrite?", string5)) {
                                    bl2 = false;
                                    break;
                                }
                                SPFC_CommPanel.logWrite("The file will be overwritten.");
                            }
                            ++n3;
                        }
                        if (!bl2) break block27;
                        SPFC_UploadPanel.this.m_clsFTPClient.setBinaryMode(SPFC_UploadPanel.this.isBinaryMode());
                        SPFC_CommPanel.logWrite(SPFC_UploadPanel.this.m_clsFTPClient.getLog());
                        SPFC_UploadPanel.this.setCursor(new Cursor(3));
                        SPFC_UploadPanel.this.m_clsFTPClient.upload(string, string2);
                        SPFC_CommPanel.logWrite(SPFC_UploadPanel.this.m_clsFTPClient.getLog());
                        bl = true;
                    }
                    Object var14_20 = null;
                    try {
                        if (SPFC_UploadPanel.this.m_clsFTPClient != null) {
                            SPFC_UploadPanel.this.m_clsFTPClient.logout();
                            SPFC_CommPanel.logWrite(SPFC_UploadPanel.this.m_clsFTPClient.getLog());
                            SPFC_UploadPanel.this.m_clsFTPClient = null;
                        }
                        if (bl) {
                            String string = "The file has been uploaded successfully.";
                            SPFC_CommPanel.logWrite(string);
                            SPFC_BaseCtrl.showMessage("Success", string);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SPFC_UploadPanel.this.uploadEnd();
                    SPFC_UploadPanel.this.setCursor(new Cursor(0));
                    {
                        break block29;
                        catch (UnknownHostException unknownHostException) {
                            String string = "The server specified by [SVP IP Address] could not be found. : ";
                            string = string + unknownHostException.getMessage();
                            SPFC_CommPanel.logWrite(string);
                            SPFC_BaseCtrl.showAlert("UnknownHost Error : ", string);
                            SPFC_UploadPanel.this.m_cmbAddress.grabFocus();
                            Object var14_21 = null;
                            try {
                                if (SPFC_UploadPanel.this.m_clsFTPClient != null) {
                                    SPFC_UploadPanel.this.m_clsFTPClient.logout();
                                    SPFC_CommPanel.logWrite(SPFC_UploadPanel.this.m_clsFTPClient.getLog());
                                    SPFC_UploadPanel.this.m_clsFTPClient = null;
                                }
                                if (bl) {
                                    String string6 = "The file has been uploaded successfully.";
                                    SPFC_CommPanel.logWrite(string6);
                                    SPFC_BaseCtrl.showMessage("Success", string6);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            SPFC_UploadPanel.this.uploadEnd();
                            SPFC_UploadPanel.this.setCursor(new Cursor(0));
                            break block29;
                        }
                        catch (IOException iOException) {
                            String string = "An error occurred while transmitting data. : ";
                            string = string + iOException.getMessage();
                            SPFC_CommPanel.logWrite(string);
                            SPFC_BaseCtrl.showAlert("I/O Error : ", string);
                            Object var14_22 = null;
                            try {
                                if (SPFC_UploadPanel.this.m_clsFTPClient != null) {
                                    SPFC_UploadPanel.this.m_clsFTPClient.logout();
                                    SPFC_CommPanel.logWrite(SPFC_UploadPanel.this.m_clsFTPClient.getLog());
                                    SPFC_UploadPanel.this.m_clsFTPClient = null;
                                }
                                if (bl) {
                                    String string7 = "The file has been uploaded successfully.";
                                    SPFC_CommPanel.logWrite(string7);
                                    SPFC_BaseCtrl.showMessage("Success", string7);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            SPFC_UploadPanel.this.uploadEnd();
                            SPFC_UploadPanel.this.setCursor(new Cursor(0));
                            break block29;
                        }
                        catch (Exception exception) {
                            String string = exception.getMessage();
                            SPFC_CommPanel.logWrite(string);
                            SPFC_BaseCtrl.showAlert("Error : ", string);
                            Object var14_23 = null;
                            try {
                                if (SPFC_UploadPanel.this.m_clsFTPClient != null) {
                                    SPFC_UploadPanel.this.m_clsFTPClient.logout();
                                    SPFC_CommPanel.logWrite(SPFC_UploadPanel.this.m_clsFTPClient.getLog());
                                    SPFC_UploadPanel.this.m_clsFTPClient = null;
                                }
                                if (bl) {
                                    String string8 = "The file has been uploaded successfully.";
                                    SPFC_CommPanel.logWrite(string8);
                                    SPFC_BaseCtrl.showMessage("Success", string8);
                                }
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            SPFC_UploadPanel.this.uploadEnd();
                            SPFC_UploadPanel.this.setCursor(new Cursor(0));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_24 = null;
                        try {
                            if (SPFC_UploadPanel.this.m_clsFTPClient != null) {
                                SPFC_UploadPanel.this.m_clsFTPClient.logout();
                                SPFC_CommPanel.logWrite(SPFC_UploadPanel.this.m_clsFTPClient.getLog());
                                SPFC_UploadPanel.this.m_clsFTPClient = null;
                            }
                            if (bl) {
                                String string = "The file has been uploaded successfully.";
                                SPFC_CommPanel.logWrite(string);
                                SPFC_BaseCtrl.showMessage("Success", string);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        SPFC_UploadPanel.this.uploadEnd();
                        SPFC_UploadPanel.this.setCursor(new Cursor(0));
                        throw throwable;
                    }
                }
            }
        };
        try {
            this.uploadStart();
            this.uploadCheck();
        }
        catch (Exception exception) {
            SPFC_BaseCtrl.showAlert("Error", exception.getMessage());
            this.uploadEnd();
            this.setCursor(new Cursor(0));
            return;
        }
        thread.start();
        thread = null;
        this.setCursor(new Cursor(0));
    }

    protected void onExit(ActionEvent actionEvent) {
        SPFC_CommPanel.debug_logWrite("onExit( )");
        this.setCursor(new Cursor(3));
        this.m_clsAppCtrl.exitApplication(0);
        this.setCursor(new Cursor(0));
    }

    public void abortFTPConnection() {
        SPFC_CommPanel.debug_logWrite("abortFTPConnection( )");
        if (this.m_clsFTPClient != null) {
            try {
                this.m_clsFTPClient.abort();
                this.m_clsFTPClient.logout();
                SPFC_CommPanel.logWrite(this.m_clsFTPClient.getLog());
                this.m_clsFTPClient = null;
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

