/*
 * Decompiled with CFR 0.152.
 */
package spfc.ctrl;

import java.awt.Component;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Date;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import spfc.comm.SPFC_BaseButton;
import spfc.comm.SPFC_BaseFieldBackPanel;
import spfc.comm.SPFC_BlackFieldBackPanel;
import spfc.comm.SPFC_BlackLabel;
import spfc.comm.SPFC_BlueFieldBackPanel;
import spfc.comm.SPFC_BlueLabel;
import spfc.comm.SPFC_GreenFieldBackPanel;
import spfc.comm.SPFC_GreenLabel;
import spfc.comm.SPFC_RedFieldBackPanel;
import spfc.comm.SPFC_RedLabel;

public class SPFC_BaseCtrl {
    protected static boolean m_bDebugMode = false;
    public static Font m_fntAppBoldFont = new Font("Dialog", 1, 12);
    public static Font m_fntAppTextFont = new Font("Dialog", 0, 12);
    public static final int COMPONENT_COLOR_RED = 1;
    public static final int COMPONENT_COLOR_GREEN = 2;
    public static final int COMPONENT_COLOR_BLUE = 3;
    public static final int COMPONENT_COLOR_BLACK = 4;
    protected static int m_iCompColor = 3;
    protected static boolean m_bFileOut = false;
    protected static boolean m_bLinePrint = false;
    protected static String m_stLogFile = ".applog";

    public static void setDebugMode(boolean bl) {
        m_bDebugMode = bl;
    }

    public static void setLinePrint(boolean bl) {
        m_bLinePrint = bl;
    }

    public static void setFileOut(boolean bl) {
        m_bFileOut = bl;
        if (bl) {
            String string = "";
            Date date = new Date();
            SPFC_BaseCtrl.logWrite("");
            SPFC_BaseCtrl.logWrite("");
            SPFC_BaseCtrl.logWrite("");
            SPFC_BaseCtrl.logWrite("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            SPFC_BaseCtrl.logWrite("++ " + date.toString() + "create spfc log writer");
            SPFC_BaseCtrl.logWrite("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        }
    }

    public static void showSystemProperties() {
        Properties properties = System.getProperties();
        properties.list(System.out);
    }

    public static JLabel getBaseFieldLabel() {
        JLabel jLabel;
        switch (m_iCompColor) {
            case 1: {
                jLabel = new SPFC_RedLabel();
                break;
            }
            case 2: {
                jLabel = new SPFC_GreenLabel();
                break;
            }
            case 3: {
                jLabel = new SPFC_BlueLabel();
                break;
            }
            case 4: {
                jLabel = new SPFC_BlackLabel();
                break;
            }
            default: {
                jLabel = new SPFC_BlueLabel();
            }
        }
        return jLabel;
    }

    public static JPanel getBaseFieldBackPanel() {
        SPFC_BaseFieldBackPanel sPFC_BaseFieldBackPanel;
        switch (m_iCompColor) {
            case 1: {
                sPFC_BaseFieldBackPanel = new SPFC_RedFieldBackPanel();
                break;
            }
            case 2: {
                sPFC_BaseFieldBackPanel = new SPFC_GreenFieldBackPanel();
                break;
            }
            case 3: {
                sPFC_BaseFieldBackPanel = new SPFC_BlueFieldBackPanel();
                break;
            }
            case 4: {
                sPFC_BaseFieldBackPanel = new SPFC_BlackFieldBackPanel();
                break;
            }
            default: {
                sPFC_BaseFieldBackPanel = new SPFC_BlueFieldBackPanel();
            }
        }
        return sPFC_BaseFieldBackPanel;
    }

    public static JButton getBaseAppButton() {
        return new SPFC_BaseButton();
    }

    public static void logWrite(String string) {
        if (m_bLinePrint) {
            System.out.println(string);
        }
        if (m_bFileOut) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(m_stLogFile, true));
                bufferedWriter.write(string);
                bufferedWriter.newLine();
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void debug_logWrite(String string) {
        if (m_bDebugMode) {
            SPFC_BaseCtrl.logWrite("++ " + string);
        }
    }

    public static void setComponentColor(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            n = 3;
        }
        m_iCompColor = n;
    }

    public static boolean showConfirm(String string, String string2) {
        Component component = null;
        String string3 = string2;
        String string4 = string;
        int n = 0;
        int n2 = 3;
        JOptionPane jOptionPane = new JOptionPane();
        int n3 = JOptionPane.showConfirmDialog(component, string3, string4, n, n2);
        return n3 == 0;
    }

    public static void showMessage(String string, String string2) {
        Component component = null;
        String string3 = string2;
        String string4 = string;
        int n = 1;
        JOptionPane jOptionPane = new JOptionPane();
        JOptionPane.showMessageDialog(component, string3, string4, n);
    }

    public static void showAlert(String string, String string2) {
        Component component = null;
        String string3 = string2;
        String string4 = string;
        int n = 0;
        JOptionPane jOptionPane = new JOptionPane();
        JOptionPane.showMessageDialog(component, string3, string4, n);
    }
}

