/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.process;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import sanproject.session.common.exception.SJsessionAuthenticationException;
import sanproject.session.common.exception.SJsessionException;
import sanproject.session.common.exception.SJsessionParameterException;
import sanproject.session.server.common.SJsessionLockManager;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.exception.SJsessionConnectionIDException;
import sanproject.session.server.process.inf.SJsessionProcessInterface;
import sanproject.session.server.process.plugin.SJsessionProcessPluginItem;
import sanproject.session.server.process.plugin.SJsessionProcessPluginManager;
import sanproject.session.server.store.SJsessionInfo;
import sanproject.session.server.store.SJsessionInfoApp;
import sanproject.session.server.store.SJsessionStoreHouse;
import sanproject.session.server.unique.SJsessionUniqueIDManager;
import sanproject.sn2.base.authentication.SJbaseAuthenticationSystem;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcInstanceCreateUty;
import sanproject.sn2.com.utility.SJcUserGroupInfoUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionProcessBase
implements SJsessionProcessInterface {
    protected static final String LOG_FUNCTION = "SessionServer";
    protected String LOG_TITLE = this.getClass().getSimpleName();
    protected SJcLoggerInterface logger = SJsessionServerUty.getLogger();
    protected String appID = null;
    protected String loginType = null;
    protected SJbaseAuthenticationSystem authBase = null;
    protected HashMap<String, Object> loginEntry = null;
    protected SJsessionStoreHouse store = null;
    private static Object syncObject = new Object();

    public SJsessionProcessBase(String appID, String loginType) {
        this.appID = appID;
        this.loginType = loginType;
        this.store = SJsessionStoreHouse.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, Object> authentication(HashMap<String, Object> loginEntry) throws SJsessionException {
        Object obj;
        String LOG_SUBTITLE = "authentication";
        String userID = (String)loginEntry.get("AUTHENTICATION_USERID");
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "authentication", "Start. User ID:" + userID);
        this.loginEntry = loginEntry;
        if (!this.checkLoginParameter()) {
            throw new SJsessionParameterException("107001");
        }
        HashMap<String, Object> result = null;
        Integer uniqueID = 0;
        Object object = obj = SJsessionLockManager.acquire(this.getSyncID());
        synchronized (object) {
            block15: {
                try {
                    this.authBase = this.getAuthBase();
                    boolean resultAuth = this.execAuthentication();
                    if (resultAuth) {
                        String gsid = this.getGlocalSessionID();
                        result = this.createLoginResultInfo(gsid);
                        String password = (String)loginEntry.get("AUTHENTICATION_PASSWORD");
                        SJsessionInfo session = this.getSession(gsid);
                        if (session == null) {
                            uniqueID = this.getUniqueID(gsid);
                            this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "authentication", "New Login. User ID:" + userID + " GSID:" + gsid + " CUID:" + uniqueID);
                            result.put("IDENTICAL_USERID", uniqueID);
                            this.addSessionInfo(result, password);
                        } else {
                            uniqueID = session.getConUniqID();
                            this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "authentication", "SSO Login. User ID:" + userID + " GSID:" + gsid + " CUID:" + uniqueID);
                            result.put("IDENTICAL_USERID", uniqueID);
                            this.chgSessionInfo(gsid, result, password);
                        }
                        break block15;
                    }
                    uniqueID = this.getDummyID();
                    throw this.createAuthException(uniqueID);
                }
                catch (SJsessionConnectionIDException cex) {
                    uniqueID = cex.getConUniqID();
                    throw this.createAuthException(uniqueID);
                }
                catch (SJsessionAuthenticationException aex) {
                    if (!this.existUniqueID(aex)) {
                        throw this.createAuthException(uniqueID);
                    }
                    throw aex;
                }
                catch (SJsessionException ex) {
                    throw this.createAuthException(uniqueID);
                }
                finally {
                    SJsessionLockManager.release(obj);
                }
            }
        }
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "authentication", "End. User ID:" + userID);
        return result;
    }

    protected boolean checkLoginParameter() {
        return true;
    }

    protected boolean execAuthentication() throws SJsessionAuthenticationException {
        String LOG_SUBTITLE = "execAuthentication";
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "execAuthentication", "Start.");
        boolean ret = false;
        String userID = (String)this.loginEntry.get("AUTHENTICATION_USERID");
        String pass = (String)this.loginEntry.get("AUTHENTICATION_PASSWORD");
        SJsessionProcessPluginItem plugin = SJsessionProcessPluginManager.getPluginItem(this.appID, this.loginType);
        String[] authSysList = plugin.getAuthName();
        ret = this.authBase.authentication(userID, pass, authSysList);
        if (ret) {
            String gsid = this.authBase.getSessionID();
            this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "execAuthentication", "Login succeeded. User ID:" + userID + " GSID:" + gsid);
        } else {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "execAuthentication", "Authentication error occured. User ID: " + userID);
        }
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "execAuthentication", "End.");
        return ret;
    }

    protected SJbaseAuthenticationSystem getAuthBase() throws SJsessionAuthenticationException {
        String LOG_SUBTITLE = "getAuthBase";
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "getAuthBase", "Start.");
        SJbaseAuthenticationSystem ret = null;
        String authBaseClassName = SJcEnvUty.getProperty("SN_Base_AuthenticationBase");
        try {
            ret = (SJbaseAuthenticationSystem)SJcInstanceCreateUty.newInstance(authBaseClassName);
        }
        catch (ClassCastException cce) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "getAuthBase", "ClassCastException", cce);
            throw new SJsessionAuthenticationException("107003");
        }
        if (ret == null) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "getAuthBase", "Not found class name for authentication base. name:" + authBaseClassName);
            throw new SJsessionAuthenticationException("107003");
        }
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "getAuthBase", "End.");
        return ret;
    }

    protected String getGlocalSessionID() {
        String gsid = (String)this.loginEntry.get("GLOBALSESSIONID");
        if (gsid == null) {
            gsid = this.authBase.getSessionID();
        }
        return gsid;
    }

    protected HashMap<String, Object> createLoginResultInfo(String gsid) {
        String LOG_SUBTITLE = "createLoginResultInfo";
        HashMap<Object, Object> result = new HashMap<String, Object>();
        if (this.isReLogin()) {
            result = new HashMap<String, Object>(this.loginEntry);
            result.remove("AUTHENTICATION_PASSWORD");
            return result;
        }
        result.put("AUTHENTICATION_USERID", this.loginEntry.get("AUTHENTICATION_USERID"));
        result.put("LOGINTYPE", this.loginEntry.get("LOGINTYPE"));
        result.put("LANG", this.loginEntry.get("LANG"));
        result.put("ADDRESS", this.loginEntry.get("ADDRESS"));
        result.put("APPLICATIONID", this.appID);
        result.put("GLOBALSESSIONID", gsid);
        result.put("USER_IDENTICALNAME", this.authBase.getUserID());
        result.put("DISPLAY_USERID", this.authBase.getUserName());
        result.put("LOGINTIME", new Date());
        result.put("AUTHENTICATION_NAME", this.authBase.getAuthSystemName());
        String[] usergroupid = this.authBase.getGroupID();
        String[] roleid = this.authBase.getRoleID();
        boolean[] rsgid = this.authBase.getResourceGrpMap();
        boolean allrsg = this.authBase.isAllRSG();
        if (null != roleid && null != rsgid) {
            SJcRoleResourceContainer roleRsgContainer = null;
            try {
                roleRsgContainer = SJcUserGroupInfoUty.getRoleResourceObject(roleid, rsgid, allrsg);
            }
            catch (Exception ex) {
                this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "createLoginResultInfo", "SJcUserGroupInfoUty.getRoleResourceObject() Error.");
            }
            result.put("USERGROUPS", new String[]{""});
            result.put("RESOURCE_ROLE", roleRsgContainer);
            result.put("USER_ROLES", roleid);
            result.put("RESOURCE_GROUP_IDS", rsgid);
            result.put("ALL_RSG_FLG", allrsg);
        } else if (null != usergroupid) {
            result.put("USERGROUPS", usergroupid);
            result.put("RESOURCE_ROLE", SJcUserGroupInfoUty.getUserGroupObject(usergroupid));
        }
        result.put("AUTHENTICATION_OBJECT", this.authBase.getAuthObject());
        return result;
    }

    protected int getUniqueID(String gsid) throws SJsessionException {
        int uniqueID = 0;
        SJsessionUniqueIDManager idMgr = SJsessionUniqueIDManager.getIDManager(this.appID);
        if (idMgr == null) {
            return uniqueID;
        }
        if (this.isReLogin()) {
            Integer uniqueIDI = (Integer)this.loginEntry.get("IDENTICAL_USERID");
            uniqueID = uniqueIDI;
            idMgr.reAssignment(uniqueID, gsid);
        } else {
            try {
                uniqueID = idMgr.getID(gsid);
            }
            catch (SJsessionConnectionIDException ex) {
                if (this.syncUniqueID(idMgr)) {
                    uniqueID = idMgr.getID(gsid);
                }
                throw ex;
            }
        }
        return uniqueID;
    }

    protected int getDummyID() {
        int uniqueID = 0;
        SJsessionUniqueIDManager idMgr = SJsessionUniqueIDManager.getIDManager(this.appID);
        if (idMgr == null) {
            return uniqueID;
        }
        uniqueID = idMgr.getDummyID();
        return uniqueID;
    }

    protected SJsessionAuthenticationException createAuthException(int uniqueID) {
        String LOG_SUBTITLE = "createAuthException";
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("IDENTICAL_USERID", uniqueID);
        SJsessionAuthenticationException aex = new SJsessionAuthenticationException("107000");
        aex.setAuthResult(result);
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "createAuthException", "Authentication Exception Throw. CUID:" + uniqueID);
        return aex;
    }

    protected boolean existUniqueID(SJsessionAuthenticationException ex) {
        HashMap result = ex.getAuthResult();
        return result.containsKey("IDENTICAL_USERID");
    }

    protected void addSessionInfo(HashMap<String, Object> authResult, String password) throws SJsessionException {
        SJsessionProcessPluginItem plugin = SJsessionProcessPluginManager.getPluginItem(this.appID, this.loginType);
        boolean insertFlg = plugin.getInsertFlg();
        if (insertFlg) {
            SJsessionInfo sesInfo = SJsessionServerUty.convertToSessionInfo(authResult, this.authBase.getAuthSystem(), password);
            this.store.addSession(sesInfo);
        }
    }

    protected void chgSessionInfo(String gsid, HashMap<String, Object> authResult, String password) throws SJsessionException {
        SJsessionInfoApp infoApp = SJsessionServerUty.convertToLoginInfo(authResult, this.authBase.getAuthSystem(), password);
        if (this.isSessionInsert()) {
            this.store.chgSession(gsid, infoApp);
        }
    }

    protected boolean isReLogin() {
        Boolean reLoginFlg = (Boolean)this.loginEntry.get("RELOGIN_FLG");
        return reLoginFlg != null && reLoginFlg != false;
    }

    protected boolean isSessionInsert() {
        boolean insertFlg = false;
        SJsessionProcessPluginItem plugin = SJsessionProcessPluginManager.getPluginItem(this.appID, this.loginType);
        if (plugin != null) {
            insertFlg = plugin.getInsertFlg();
        }
        return insertFlg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean syncUniqueID(SJsessionUniqueIDManager idMgr) {
        boolean syncFlg = false;
        Object object = syncObject;
        synchronized (object) {
            List<SJsessionInfo> sessionList = this.store.getSessionInfoList();
            ArrayList<String> gsidList = new ArrayList<String>();
            for (SJsessionInfo session : sessionList) {
                gsidList.add(session.getGlobalSessionID());
            }
            syncFlg = idMgr.syncID(gsidList);
        }
        return syncFlg;
    }

    protected SJsessionInfo getSession(String gsid) {
        return this.store.getSession(gsid);
    }

    protected String getSyncID() {
        String syncID = null;
        syncID = this.isReLogin() ? (String)this.loginEntry.get("GLOBALSESSIONID") : UUID.randomUUID().toString();
        return syncID;
    }
}

