/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.process.plugin;

import java.util.HashMap;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.process.plugin.SJsessionProcessPluginItem;
import sanproject.sn2.com.plugin.SJcPluginItem;
import sanproject.sn2.com.plugin.SJcPluginList;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionProcessPluginList
extends SJcPluginList {
    private static final String LOG_FUNCTION = "SessionServer";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private SJcLoggerInterface logger = SJsessionServerUty.getLogger();
    private static final String KEY_PROCESSLIST_AUTHNAME_SUFFIX = ".authname";
    private static final String KEY_PROCESSLIST_INSERTFLG_SUFFIX = ".insert_flg";
    private static final String KEY_PROCESSLIST_REAUTHTIME_SUFFIX = ".reauth_time";
    private static final String KEY_PROCESSLIST_REAUTHDELAY_SUFFIX = ".reauth_delay";

    @Override
    protected String[] getAdditionalSuffixKeys() {
        return new String[]{KEY_PROCESSLIST_AUTHNAME_SUFFIX, KEY_PROCESSLIST_INSERTFLG_SUFFIX, KEY_PROCESSLIST_REAUTHTIME_SUFFIX, KEY_PROCESSLIST_REAUTHDELAY_SUFFIX};
    }

    @Override
    protected SJcPluginItem getItem(String name, HashMap<String, String> attributes) {
        String LOG_SUBTITLE = "getItem";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "getItem", "Start. - name:" + name);
        SJsessionProcessPluginItem item = new SJsessionProcessPluginItem();
        String itemName = attributes.get(".name");
        item.setName(itemName);
        String className = attributes.get(".class");
        item.setClassName(className);
        String authname = attributes.get(KEY_PROCESSLIST_AUTHNAME_SUFFIX);
        if (null != authname) {
            String[] t_authNames = authname.split(",");
            String[] authNames = new String[t_authNames.length];
            for (int i = 0; i < t_authNames.length; ++i) {
                authNames[i] = t_authNames[i].trim();
            }
            item.setAuthName(authNames);
        }
        String insert_flg = attributes.get(KEY_PROCESSLIST_INSERTFLG_SUFFIX);
        item.setInsertFlg(Boolean.valueOf(insert_flg));
        String retry_time = attributes.get(KEY_PROCESSLIST_REAUTHTIME_SUFFIX);
        try {
            int iRetry_time = Integer.parseInt(retry_time);
            if (iRetry_time > 0) {
                item.setReAuthTime(iRetry_time);
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        String reAuth_delay = attributes.get(KEY_PROCESSLIST_REAUTHDELAY_SUFFIX);
        try {
            int reAauth_delay = Integer.parseInt(reAuth_delay);
            if (reAauth_delay > 0) {
                item.setReAuthDelay(reAauth_delay);
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "getItem", "End.");
        return item;
    }
}

