/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.receive.manager;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import sanproject.session.common.receive.inf.SJsessionReceiveInterface;
import sanproject.session.common.receive.inf.SJsessionReceiveServerInterface;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.store.manager.SJsessionEventManager;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;

public class SJsessionReceiveModuleManager {
    private static final String LOG_FUNCTION = "SessionServer";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private HashMap<String, ReceiveInfo> receiveModuleList = new HashMap();
    Timer chkTimer = null;
    private static SJsessionReceiveModuleManager mgr;

    private SJsessionReceiveModuleManager() {
        this.startTask();
    }

    public static void createInstance() {
        mgr = new SJsessionReceiveModuleManager();
    }

    public static SJsessionReceiveModuleManager getInstance() {
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReceiveModule(String connectionID, SJsessionReceiveServerInterface inf) {
        ReceiveInfo receiveInfo = new ReceiveInfo();
        receiveInfo.setReceiver(inf);
        receiveInfo.updateLastTime();
        HashMap<String, ReceiveInfo> hashMap = this.receiveModuleList;
        synchronized (hashMap) {
            this.receiveModuleList.put(connectionID, receiveInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SJsessionReceiveInterface getReceiveModule(String connectionID) {
        ReceiveInfo receiveInfo = null;
        HashMap<String, ReceiveInfo> hashMap = this.receiveModuleList;
        synchronized (hashMap) {
            receiveInfo = this.receiveModuleList.get(connectionID);
        }
        if (receiveInfo == null) {
            return null;
        }
        SJsessionReceiveServerInterface receiver = receiveInfo.getReceiver();
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReceiveModule(String connectionID) {
        String LOG_SUBTITLE = "removeReceiveModule";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, this.LOG_TITLE, "removeReceiveModule", "Start. Connection ID:" + connectionID);
        HashMap<String, ReceiveInfo> hashMap = this.receiveModuleList;
        synchronized (hashMap) {
            this.receiveModuleList.remove(connectionID);
        }
        logger.info(LOG_FUNCTION, this.LOG_TITLE, "removeReceiveModule", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAvailable(String connectionID) {
        boolean available = false;
        HashMap<String, ReceiveInfo> hashMap = this.receiveModuleList;
        synchronized (hashMap) {
            available = this.receiveModuleList.containsKey(connectionID);
            if (available) {
                ReceiveInfo receiveInfo = this.receiveModuleList.get(connectionID);
                receiveInfo.updateLastTime();
            }
        }
        return available;
    }

    private void startTask() {
        String LOG_SUBTITLE = "startTask";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, this.LOG_TITLE, "startTask", "Start.");
        int receive_polling = SJcEnvUty.getProperty2int("SN_SESSION_RECEIVE_POLLING", 300);
        logger.info(LOG_FUNCTION, this.LOG_TITLE, "startTask", "SN_SESSION_RECEIVE_POLLING:" + receive_polling);
        if (receive_polling <= 0) {
            logger.info(LOG_FUNCTION, this.LOG_TITLE, "startTask", "SN_SESSION_RECEIVE_POLLING:" + receive_polling + " changed default.");
            receive_polling = 300;
        }
        long pollingPeriod = receive_polling * 1000;
        this.chkTimer = new Timer();
        ChkReceiveTask chkTimeTask = new ChkReceiveTask();
        this.chkTimer.schedule((TimerTask)chkTimeTask, pollingPeriod, pollingPeriod);
        logger.info(LOG_FUNCTION, this.LOG_TITLE, "startTask", "End.");
    }

    public void finish() {
        String LOG_SUBTITLE = "finish";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, this.LOG_TITLE, "finish", "Start.");
        if (this.chkTimer != null) {
            this.chkTimer.cancel();
            this.chkTimer = null;
        }
        SJsessionEventManager.finish();
        logger.info(LOG_FUNCTION, this.LOG_TITLE, "finish", "End.");
    }

    private class ReceiveInfo {
        private SJsessionReceiveServerInterface receiver = null;
        private long lastTime = SJsessionServerUty.getSystemTime();

        private ReceiveInfo() {
        }

        public void setReceiver(SJsessionReceiveServerInterface receiver) {
            this.receiver = receiver;
        }

        public SJsessionReceiveServerInterface getReceiver() {
            return this.receiver;
        }

        public void updateLastTime() {
            this.lastTime = SJsessionServerUty.getSystemTime();
        }

        public long getLastTime() {
            return this.lastTime;
        }
    }

    private class ChkReceiveTask
    extends TimerTask {
        private ChkReceiveTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String LOG_SUBTITLE = "ChkReceiveTask";
            SJcLoggerInterface logger = SJsessionServerUty.getLogger();
            logger.info(SJsessionReceiveModuleManager.LOG_FUNCTION, SJsessionReceiveModuleManager.this.LOG_TITLE, "ChkReceiveTask", "Start.");
            HashMap hashMap = SJsessionReceiveModuleManager.this.receiveModuleList;
            synchronized (hashMap) {
                Iterator itKey = SJsessionReceiveModuleManager.this.receiveModuleList.keySet().iterator();
                while (itKey.hasNext()) {
                    String connectionID = (String)itKey.next();
                    ReceiveInfo receiveInfo = (ReceiveInfo)SJsessionReceiveModuleManager.this.receiveModuleList.get(connectionID);
                    SJsessionReceiveServerInterface receiver = receiveInfo.getReceiver();
                    long keepTime = -1L;
                    try {
                        keepTime = receiver.getKeepTime();
                    }
                    catch (RemoteException ex) {
                        logger.warn(SJsessionReceiveModuleManager.LOG_FUNCTION, SJsessionReceiveModuleManager.this.LOG_TITLE, "ChkReceiveTask", "getKeepTime RemoteException.");
                    }
                    if (keepTime == -1L) continue;
                    keepTime *= 1000L;
                    long lastTime = receiveInfo.getLastTime();
                    long nowTime = SJsessionServerUty.getSystemTime();
                    if (nowTime - lastTime < 0L) {
                        logger.warn(SJsessionReceiveModuleManager.LOG_FUNCTION, SJsessionReceiveModuleManager.this.LOG_TITLE, "ChkReceiveTask", "System progress time went around. nowTime:" + nowTime + " lastTime:" + lastTime);
                    }
                    if (nowTime - lastTime <= keepTime && nowTime - lastTime >= 0L) continue;
                    logger.info(SJsessionReceiveModuleManager.LOG_FUNCTION, SJsessionReceiveModuleManager.this.LOG_TITLE, "ChkReceiveTask", "Receive Module Timeout. Connection ID:" + connectionID + " Receive Module:" + receiver.getClass().getSimpleName());
                    try {
                        if (SJsessionEventManager.isExistsHandler(connectionID)) {
                            SJsessionEventManager.stopHandler(connectionID);
                        }
                    }
                    catch (SJcException ex) {
                        // empty catch block
                    }
                    itKey.remove();
                }
            }
            logger.info(SJsessionReceiveModuleManager.LOG_FUNCTION, SJsessionReceiveModuleManager.this.LOG_TITLE, "ChkReceiveTask", "End.");
        }
    }
}

