/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.receive.plugin;

import java.util.HashMap;
import java.util.ListIterator;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.receive.plugin.SJsessionReceivePluginItem;
import sanproject.session.server.receive.plugin.SJsessionReceivePluginList;
import sanproject.sn2.com.plugin.SJcPluginItem;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionReceivePluginManager {
    private static final String LOG_FUNCTION = "SessionServer";
    private static final String LOG_TITLE = SJsessionReceivePluginManager.class.getSimpleName();
    private static SJcLoggerInterface logger = SJsessionServerUty.getLogger();
    private static HashMap<String, SJsessionReceivePluginItem> receiveModulePlugin;

    public static void registReceiveModulePlugins() {
        String LOG_SUBTITLE = "registReceiveModulePlugins";
        logger.info(LOG_FUNCTION, LOG_TITLE, "registReceiveModulePlugins", "Start.");
        receiveModulePlugin = new HashMap();
        String filePath = SJsessionReceivePluginManager.getFilePath();
        SJsessionReceivePluginList pluginList = new SJsessionReceivePluginList();
        pluginList.loadFile(filePath);
        ListIterator<SJcPluginItem> iterator = pluginList.getPluginList().listIterator();
        while (iterator.hasNext()) {
            SJsessionReceivePluginItem item = null;
            try {
                item = (SJsessionReceivePluginItem)iterator.next();
            }
            catch (ClassCastException cce) {
                logger.error(LOG_FUNCTION, LOG_TITLE, "registReceiveModulePlugins", "Item class is invald.", cce);
                continue;
            }
            if (!SJsessionReceivePluginManager.checkPluginItem(item)) continue;
            String appID = item.getKey();
            receiveModulePlugin.put(appID, item);
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "registReceiveModulePlugins", "End.");
    }

    private static String getFilePath() {
        String fileName = SJcEnvUty.getProperty("SN_SESSION_RECEIVE_PLUGIN");
        String receivePath = SJsessionServerUty.getReceivePath();
        String filePath = SJcFileUty.concatFolderPath(receivePath, fileName);
        return filePath;
    }

    private static boolean checkPluginItem(SJsessionReceivePluginItem item) {
        String LOG_SUBTITLE = "checkPluginItem";
        logger.trace(LOG_FUNCTION, LOG_TITLE, "checkPluginItem", "Start.");
        if (item == null || item.getName() == null || item.getClassName() == null) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "checkPluginItem", "Plugin item is invald.");
            return false;
        }
        logger.trace(LOG_FUNCTION, LOG_TITLE, "checkPluginItem", "End.");
        return true;
    }

    public static SJsessionReceivePluginItem getPluginItem(String appID) {
        String defaultKey;
        SJsessionReceivePluginItem plugin = null;
        plugin = receiveModulePlugin.get(appID);
        if (plugin == null && (defaultKey = SJsessionServerUty.getDefaultPluginKey()) != null) {
            plugin = receiveModulePlugin.get(defaultKey);
        }
        return plugin;
    }

    public static HashMap<String, SJsessionReceivePluginItem> getPluginMap() {
        return receiveModulePlugin;
    }
}

