/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.remote;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import sanproject.session.common.SJsessionDef;
import sanproject.session.common.exception.SJsessionException;
import sanproject.session.common.exception.SJsessionParameterException;
import sanproject.session.common.exception.SJsessionReceiveInstanceException;
import sanproject.session.common.exception.SJsessionVersionException;
import sanproject.session.common.receive.inf.SJsessionReceiveInterface;
import sanproject.session.common.receive.inf.SJsessionReceiveServerInterface;
import sanproject.session.common.remote.inf.SJsessionRemoteInterface;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.receive.manager.SJsessionReceiveModuleManager;
import sanproject.session.server.receive.plugin.SJsessionReceivePluginItem;
import sanproject.session.server.receive.plugin.SJsessionReceivePluginManager;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcInstanceCreateUty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionRemote
extends UnicastRemoteObject
implements SJsessionRemoteInterface {
    private static final long serialVersionUID = 1111111111113311111L;
    private static final transient String LOG_FUNCTION = "SessionServer";
    private final transient String LOG_TITLE = this.getClass().getSimpleName();

    @Override
    public SJsessionReceiveInterface getSessionReceiver(HashMap info) throws RemoteException, SJsessionException {
        String LOG_SUBTITLE = "getSessionReceiver";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, this.LOG_TITLE, "getSessionReceiver", "Start.");
        Object[][] check_item = new Object[][]{{"VERSION", Integer.class, true}, {"APPLICATIONID", String.class, true}};
        if (!SJsessionServerUty.checkParams(info, check_item)) {
            throw new SJsessionParameterException("107001");
        }
        if (!this.checkVersion(info)) {
            throw new SJsessionVersionException("107001");
        }
        String appID = (String)info.get("APPLICATIONID");
        SJsessionReceiveServerInterface receive = this.getReceiveObj(appID);
        receive.initialize();
        boolean keep_flg = SJsessionReceivePluginManager.getPluginItem(appID).getReceiverKeepflg();
        if (keep_flg) {
            SJsessionReceiveModuleManager receiveMgr = SJsessionReceiveModuleManager.getInstance();
            String conID = receive.getConnectionID();
            receiveMgr.addReceiveModule(conID, receive);
            logger.info(LOG_FUNCTION, this.LOG_TITLE, "getSessionReceiver", "add Receive Module. APP:" + appID + ", Connection ID:" + conID);
        }
        logger.info(LOG_FUNCTION, this.LOG_TITLE, "getSessionReceiver", "End.");
        return receive;
    }

    private boolean checkVersion(HashMap<String, Object> info) {
        String LOG_SUBTITLE = "checkVersion";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.trace(LOG_FUNCTION, this.LOG_TITLE, "checkVersion", "Start.");
        Integer clienVer = (Integer)info.get("VERSION");
        if (clienVer > SJsessionDef.VERSION_VAL) {
            logger.error(LOG_FUNCTION, this.LOG_TITLE, "checkVersion", "invalid version. client:" + clienVer + " server:" + SJsessionDef.VERSION_VAL);
            return false;
        }
        logger.trace(LOG_FUNCTION, this.LOG_TITLE, "checkVersion", "End.");
        return true;
    }

    private SJsessionReceiveServerInterface getReceiveObj(String appid) throws SJsessionReceiveInstanceException {
        String LOG_SUBTITLE = "getReceiveObj";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.trace(LOG_FUNCTION, this.LOG_TITLE, "getReceiveObj", "Start.");
        SJsessionReceiveServerInterface receive = null;
        SJsessionReceivePluginItem item = SJsessionReceivePluginManager.getPluginItem(appid);
        if (item == null) {
            logger.error(LOG_FUNCTION, this.LOG_TITLE, "getReceiveObj", "request receive plugin doesn't exist. appID:" + appid);
            throw new SJsessionReceiveInstanceException("107003");
        }
        String className = item.getClassName();
        logger.info(LOG_FUNCTION, this.LOG_TITLE, "getReceiveObj", "receive className:" + className);
        try {
            receive = (SJsessionReceiveServerInterface)SJcInstanceCreateUty.newInstance(className, new Class[]{String.class}, new Object[]{appid});
        }
        catch (ClassCastException cce) {
            logger.error(LOG_FUNCTION, this.LOG_TITLE, "getReceiveObj", "ClassCastException", cce);
            throw new SJsessionReceiveInstanceException("107003");
        }
        if (receive == null) {
            logger.error(LOG_FUNCTION, this.LOG_TITLE, "getReceiveObj", "request receiver cannot be created.");
            throw new SJsessionReceiveInstanceException("107003");
        }
        logger.trace(LOG_FUNCTION, this.LOG_TITLE, "getReceiveObj", "End.");
        return receive;
    }

    @Override
    public SJsessionReceiveInterface getSessionReceiverByConID(HashMap info) throws RemoteException, SJsessionException {
        String LOG_SUBTITLE = "getSessionReceiverByConID";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, this.LOG_TITLE, "getSessionReceiverByConID", "Start.");
        Object[][] check_item = new Object[][]{{"VERSION", Integer.class, true}, {"CONNECTIONID", String.class, true}};
        if (!SJsessionServerUty.checkParams(info, check_item)) {
            throw new SJsessionParameterException("107001");
        }
        if (!this.checkVersion(info)) {
            throw new SJsessionVersionException("107001");
        }
        String conID = (String)info.get("CONNECTIONID");
        SJsessionReceiveModuleManager receiveMgr = SJsessionReceiveModuleManager.getInstance();
        SJsessionReceiveInterface result = receiveMgr.getReceiveModule(conID);
        if (result == null) {
            logger.error(LOG_FUNCTION, this.LOG_TITLE, "getSessionReceiverByConID", "No request receiver. ConnectionID:" + conID);
            throw new SJsessionReceiveInstanceException("107003");
        }
        logger.info(LOG_FUNCTION, this.LOG_TITLE, "getSessionReceiverByConID", "End. Connection ID:" + conID);
        return result;
    }

    @Override
    public void checkConnect() {
    }
}

