/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.store.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionEventHandler {
    private static final String LOG_FUNCTION = "SessionServer";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private SJcLoggerInterface logger = null;
    private List<HashMap<String, Object>> eventTable = null;
    private Object syncObject = new Object();
    private boolean finish_flg = false;
    private String appID = null;

    public SJsessionEventHandler(String appID) {
        this.appID = appID;
        this.eventTable = new ArrayList<HashMap<String, Object>>();
        this.logger = SJsessionServerUty.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<HashMap<String, Object>> waitEvent() {
        String LOG_SUBTITLE = "waitEvent";
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "waitEvent", "Start.");
        ArrayList<HashMap<String, Object>> eventStoreList = new ArrayList<HashMap<String, Object>>();
        if (this.finish_flg) {
            this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "waitEvent", "finish flag is already [ON].");
            return eventStoreList;
        }
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.eventTable.isEmpty()) {
                this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "waitEvent", "event already exists.");
                eventStoreList = new ArrayList<HashMap<String, Object>>(this.eventTable);
                this.eventTable.clear();
                return eventStoreList;
            }
        }
        try {
            this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "waitEvent", "wait start.");
            this.wait();
            this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "waitEvent", "wait release.");
            if (this.finish_flg) {
                this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "waitEvent", "finish flag is [ON].");
                return eventStoreList;
            }
            object = this.syncObject;
            synchronized (object) {
                eventStoreList = new ArrayList<HashMap<String, Object>>(this.eventTable);
                this.eventTable.clear();
            }
        }
        catch (InterruptedException ex) {
            this.logger.error(LOG_FUNCTION, this.LOG_TITLE, "waitEvent", "InterruptedException.", ex);
            return eventStoreList;
        }
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "waitEvent", "End.");
        return eventStoreList;
    }

    public synchronized void notifyEvent() {
        String LOG_SUBTITLE = "notifyEvent";
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "notifyEvent", "Start.");
        this.notify();
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "notifyEvent", "End.");
    }

    public synchronized void finish() {
        String LOG_SUBTITLE = "finish";
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "finish", "Start.");
        this.finish_flg = true;
        this.notify();
        this.logger.info(LOG_FUNCTION, this.LOG_TITLE, "finish", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEvent(String eventKind, HashMap<String, Object> eventInfo) {
        String LOG_SUBTITLE = "setEvent";
        String gsid = (String)eventInfo.get("GLOBALSESSIONID");
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "setEvent", "Start. Event:" + eventKind + " GSID:" + gsid);
        Object object = this.syncObject;
        synchronized (object) {
            HashMap<String, Object> map = new HashMap<String, Object>(eventInfo);
            map.put("EVENT_KIND", eventKind);
            this.eventTable.add(map);
        }
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "setEvent", "Event:" + eventKind + " GSID:" + gsid + " APP:" + this.appID);
        this.notifyEvent();
        this.logger.trace(LOG_FUNCTION, this.LOG_TITLE, "setEvent", "End.");
    }
}

