/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.store.task;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import sanproject.session.common.exception.SJsessionException;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.process.plugin.SJsessionProcessPluginItem;
import sanproject.session.server.process.plugin.SJsessionProcessPluginManager;
import sanproject.session.server.store.SJsessionInfo;
import sanproject.session.server.store.SJsessionInfoApp;
import sanproject.session.server.store.SJsessionStoreHouse;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;

public class SJsessionReauthTask {
    private final String LOG_FUNCTION = "SessionServer";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    Object syncObject = new Object();
    HashMap<String, ReAuthTimer> timerTable = new HashMap();
    private SJcLoggerInterface logger = SJsessionServerUty.getLogger();

    public void startTask(String appID, String loginType) {
        String LOG_SUBTITLE = "startTask";
        this.logger.info("SessionServer", this.LOG_TITLE, "startTask", "Start.");
        SJsessionProcessPluginItem item = SJsessionProcessPluginManager.getPluginItem(appID, loginType);
        int val = item.getReAuthTime();
        this.logger.info("SessionServer", this.LOG_TITLE, "startTask", "POLLING_TIME:" + val);
        if (val == -1) {
            this.logger.info("SessionServer", this.LOG_TITLE, "startTask", "End.");
            return;
        }
        long reAuthPeriod = val * 1000;
        int delay = item.getReAuthDelay();
        this.logger.info("SessionServer", this.LOG_TITLE, "startTask", "DELAY_TIME:" + delay);
        if (delay == -1) {
            delay = val;
        }
        long reAuthDelay = delay * 1000;
        ReAuthTimer timer = new ReAuthTimer(appID, loginType);
        timer.schedule(reAuthDelay, reAuthPeriod);
        this.timerTable.put(this.getKey(appID, loginType), timer);
        this.logger.info("SessionServer", this.LOG_TITLE, "startTask", "End.");
    }

    public void finish() {
        String LOG_SUBTITLE = "finish";
        this.logger.info("SessionServer", this.LOG_TITLE, "finish", "Start.");
        Iterator<String> itKey = this.timerTable.keySet().iterator();
        while (itKey.hasNext()) {
            ReAuthTimer reAuthTimer = null;
            String timerKey = itKey.next();
            reAuthTimer = this.timerTable.get(timerKey);
            if (reAuthTimer == null) continue;
            reAuthTimer.getTimer().cancel();
            reAuthTimer.setTimer(null);
            reAuthTimer.setTask(null);
            itKey.remove();
        }
        this.logger.info("SessionServer", this.LOG_TITLE, "finish", "End.");
    }

    private String getKey(String appID, String loginType) {
        return appID + "." + loginType;
    }

    class ReAuthTask
    extends TimerTask {
        String appID = null;
        String loginType = null;

        public ReAuthTask(String appID, String loginType) {
            this.appID = appID;
            this.loginType = loginType;
        }

        public void run() {
            String LOG_SUBTITLE = "ReAuthTask";
            SJsessionReauthTask.this.logger.info("SessionServer", SJsessionReauthTask.this.LOG_TITLE, "ReAuthTask", "Start.");
            SJsessionStoreHouse store = SJsessionStoreHouse.getInstance();
            List<SJsessionInfo> sessionList = store.getSessionInfoList();
            for (SJsessionInfo session : sessionList) {
                SJsessionInfoApp loginInfo;
                String gsid = session.getGlobalSessionID();
                if (!session.isExits(this.appID) || null == (loginInfo = session.getLoginInfo(this.appID)) || !this.loginType.equals(loginInfo.getLoginType())) continue;
                try {
                    store.reauthenticateSession(gsid, this.appID);
                }
                catch (SJsessionException ex) {
                    try {
                        store.removeLoginInfo(gsid, this.appID);
                    }
                    catch (SJsessionException e) {}
                }
            }
            SJsessionReauthTask.this.logger.info("SessionServer", SJsessionReauthTask.this.LOG_TITLE, "ReAuthTask", "End.");
        }
    }

    class ReAuthTimer {
        Timer reAuthTimer = new Timer();
        ReAuthTask reAuthTask = null;

        public ReAuthTimer(String appID, String loginType) {
            this.reAuthTask = new ReAuthTask(appID, loginType);
        }

        public void setTimer(Timer reAuthTimer) {
            this.reAuthTimer = reAuthTimer;
        }

        public Timer getTimer() {
            return this.reAuthTimer;
        }

        public void setTask(ReAuthTask reAuthTask) {
            this.reAuthTask = reAuthTask;
        }

        public ReAuthTask getTask() {
            return this.reAuthTask;
        }

        public void schedule(long delay, long period) {
            this.reAuthTimer.schedule((TimerTask)this.reAuthTask, delay, period);
        }
    }
}

