/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import java.util.ArrayList;
import sanproject.client.data.RJDataChange;
import sanproject.client.data.RJDataControl;

public class RJComCHA {
    private static final int PORT_MAX_DKC = 256;
    private static final int PORT_MAX_DKC_HM = 64;
    private static final int CL_MAX_DKC = 2;
    private static final int CHA_MAX_DKC = 32;
    private static final int CHA_MAX_DKC_HM = 16;
    private static final int PORT_MAX_CHA = 8;
    private static final int PORT_MAX_CHA_HM = 4;
    private static final int PORT_MAX_BLK = 4;
    private static final int PORT_MAX_CL = 128;
    private static final int PORT_MAX_CL_HM = 32;
    private static final int CHA_MAX_CL = 16;
    private static final int CHA_MAX_CL_HM = 8;
    private static final int PORT_FCOE = 6;
    private static String[] HostIF = new String[]{"(***)", "Fibre", "Serial", "Mfibre", "(***)", "iSCSI", "FCoE"};
    private static int[] HostIFType = new int[]{0, 1, 2, 4, 0, 16, 32};
    private static short[] Block01 = new short[]{0, 1};
    private static PKType PK_Unknown;
    static boolean bInit;
    private static short[] PortPCBMaskToCHANumber;
    private static short[] PortPCBMaskToCHANumber_HM;
    private static ArrayList listPK;

    private static void checkInitialized() {
        if (!bInit) {
            bInit = true;
            listPK = new ArrayList();
            PK_Unknown = new PKType(0, "(***)", "(***)", 0, "(***)", null);
            if (!RJDataControl.getDataControl().isHM()) {
                PKType pKType = new PKType(100, "Serial 4Port", "Serial", 2, "Serial 4Port", null);
                listPK.add(pKType);
                PKType pKType2 = new PKType(101, "8MF  (Mfibre)", "Mfibre 4P", 3, "Mfibre 4Port", null);
                listPK.add(pKType2);
                PKType pKType3 = new PKType(106, "16MU (Mfibre)", "Mfibre 8P", 3, "Mfibre 8Port", null);
                listPK.add(pKType3);
                PKType pKType4 = new PKType(105, "8FC  (Fibre )", "Fibre 4P", 1, "Fibre 4Port", null);
                listPK.add(pKType4);
                PKType pKType5 = new PKType(102, "16FC (Fibre )", "Fibre 8P", 1, "Fibre 8Port", null);
                listPK.add(pKType5);
                PKType pKType6 = new PKType(103, "16MF (Mfibre)", "Mfibre 8P", 3, "Mfibre 8Port", null);
                listPK.add(pKType6);
                PKType pKType7 = new PKType(108, "8UFC (Fibre )", "Fibre 4P", 1, "Fibre 4Port", null);
                listPK.add(pKType7);
                PKType pKType8 = new PKType(107, "16UFC(Fibre )", "Fibre 8P", 1, "Fibre 8Port", null);
                listPK.add(pKType8);
                PKType pKType9 = new PKType(110, "8FOE (FCoE  )", "FCoE 8P", 6, "FCoE 8Port", null);
                listPK.add(pKType9);
            } else {
                PKType pKType = new PKType(108, "HF8G (CHB)", "HF8G", 1, "HF8G", null);
                listPK.add(pKType);
            }
        }
    }

    private static PKType getPKTypeInfo(byte by) {
        RJComCHA.checkInitialized();
        PKType pKType = PK_Unknown;
        for (int i = 0; i < listPK.size(); ++i) {
            if (((PKType)listPK.get(i)).getPKType() != by) continue;
            pKType = (PKType)listPK.get(i);
            break;
        }
        return pKType;
    }

    public static boolean isPKFibre(byte by) {
        PKType pKType = RJComCHA.getPKTypeInfo(by);
        int n = pKType.getHostIF();
        int n2 = HostIFType[n] & 1;
        return n2 != 0;
    }

    public static boolean isPKSerial(byte by) {
        PKType pKType = RJComCHA.getPKTypeInfo(by);
        int n = pKType.getHostIF();
        int n2 = HostIFType[n] & 2;
        return n2 != 0;
    }

    public static boolean isPKMfibre(byte by) {
        PKType pKType = RJComCHA.getPKTypeInfo(by);
        int n = pKType.getHostIF();
        int n2 = HostIFType[n] & 4;
        return n2 != 0;
    }

    public static boolean isPKIscsi(byte by) {
        PKType pKType = RJComCHA.getPKTypeInfo(by);
        int n = pKType.getHostIF();
        int n2 = HostIFType[n] & 0x10;
        return n2 != 0;
    }

    public static short[] getPortBlockIDs(byte by) {
        PKType pKType = RJComCHA.getPKTypeInfo(by);
        return pKType.getBlocks();
    }

    public static String toPKString(byte by) {
        PKType pKType = RJComCHA.getPKTypeInfo(by);
        int n = pKType.getHostIF();
        String string = HostIF[n];
        return string;
    }

    public static String toPKPortString(byte by) {
        PKType pKType = RJComCHA.getPKTypeInfo(by);
        String string = pKType.getHostIFPort();
        return string;
    }

    public static String toPKDetailString(byte by) {
        PKType pKType = RJComCHA.getPKTypeInfo(by);
        String string = pKType.getPKName();
        return string;
    }

    public static String toPKDetailStringShort(byte by) {
        PKType pKType = RJComCHA.getPKTypeInfo(by);
        String string = pKType.getPKNameShort();
        return string;
    }

    public static short getPortBlockID(short s) {
        RJDataControl rJDataControl = RJDataControl.getDataControl();
        if (rJDataControl.isHM() ? s < 0 || s >= 64 : s < 0 || s >= 256) {
            throw new IndexOutOfBoundsException();
        }
        short s2 = 0;
        s2 = rJDataControl.isHM() ? (short)(s / 4 & 0) : (short)(s / 4 & 1);
        return s2;
    }

    public static short getPortToCluster(short s) {
        RJDataControl rJDataControl = RJDataControl.getDataControl();
        if (rJDataControl.isHM() ? s < 0 || s >= 64 : s < 0 || s >= 256) {
            throw new IndexOutOfBoundsException();
        }
        short s2 = 0;
        s2 = rJDataControl.isHM() ? (short)((s / 32 & 1) + 1) : (short)((s / 128 & 1) + 1);
        return s2;
    }

    public static short getPortToCHANumber(short s) {
        RJDataControl rJDataControl = RJDataControl.getDataControl();
        if (rJDataControl.isHM() ? s < 0 || s >= 64 : s < 0 || s >= 256) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        short s2 = 0;
        if (rJDataControl.isHM()) {
            n = s / 4 & 7;
            s2 = PortPCBMaskToCHANumber_HM[n];
        } else {
            n = s / 8 & 0xF;
            s2 = PortPCBMaskToCHANumber[n];
        }
        return s2;
    }

    public static short getPortToCHAPort(short s) {
        RJDataControl rJDataControl = RJDataControl.getDataControl();
        if (rJDataControl.isHM() ? s < 0 || s >= 64 : s < 0 || s >= 256) {
            throw new IndexOutOfBoundsException();
        }
        short s2 = 0;
        s2 = rJDataControl.isHM() ? (short)(s & 3) : (short)(s & 7);
        return s2;
    }

    public static short getCHAPortToPort(short s, short s2, short s3) {
        short s4 = 0;
        short s5 = 0;
        short s6 = 0;
        short[] sArray = new short[]{0};
        RJDataControl rJDataControl = RJDataControl.getDataControl();
        if (rJDataControl.isHM()) {
            s4 = (short)((s - 1) * 32);
            s5 = 4;
            sArray = PortPCBMaskToCHANumber_HM;
            s6 = 8;
        } else {
            s4 = (short)((s - 1) * 128);
            s5 = 8;
            sArray = PortPCBMaskToCHANumber;
            s6 = 16;
        }
        if (s < 1 || s > 2) {
            throw new IndexOutOfBoundsException();
        }
        if (s2 < 1 || s2 > s6) {
            throw new IndexOutOfBoundsException();
        }
        if (s3 < 0 || s3 >= s5) {
            throw new IndexOutOfBoundsException();
        }
        boolean bl = false;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] != s2) continue;
            s4 = (short)(s4 + i * s5);
            bl = true;
            break;
        }
        if (!bl) {
            throw new IndexOutOfBoundsException();
        }
        s4 = (short)(s4 + s3);
        return s4;
    }

    public static String toPortName(short s) {
        RJDataChange rJDataChange;
        RJDataControl rJDataControl = RJDataControl.getDataControl();
        if (rJDataControl.isHM() ? s < 0 || s >= 64 : s < 0 || s >= 256) {
            throw new IndexOutOfBoundsException();
        }
        String string = "***";
        byte[] byArray = new byte[]{0};
        if (rJDataControl != null && (rJDataChange = rJDataControl.getChangeTbl()) != null) {
            string = rJDataChange.ChangePortName(s, byArray);
        }
        return string;
    }

    public static String toPortNameShort(short s) {
        String string = "***";
        String string2 = RJComCHA.toPortName(s);
        if (string2 != null && string2.length() >= 5) {
            string = string2.substring(2, 3) + string2.substring(4, 5);
        } else {
            System.out.println("Unexpected Port Name Format");
        }
        return string;
    }

    private static int getPortHostIF(byte by) {
        int n = 0;
        switch (by) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 6: {
                n = 6;
                break;
            }
        }
        return n;
    }

    public static boolean isPortFibre(byte by) {
        int n = RJComCHA.getPortHostIF(by);
        int n2 = HostIFType[n] & 1;
        return n2 != 0;
    }

    public static boolean isPortSerial(byte by) {
        int n = RJComCHA.getPortHostIF(by);
        int n2 = HostIFType[n] & 2;
        return n2 != 0;
    }

    public static boolean isPortMfibre(byte by) {
        int n = RJComCHA.getPortHostIF(by);
        int n2 = HostIFType[n] & 4;
        return n2 != 0;
    }

    public static boolean isPortIscsi(byte by) {
        int n = RJComCHA.getPortHostIF(by);
        int n2 = HostIFType[n] & 0x10;
        return n2 != 0;
    }

    public static String toPortKindString(byte by) {
        int n = RJComCHA.getPortHostIF(by);
        String string = HostIF[n];
        return string;
    }

    static {
        bInit = false;
        PortPCBMaskToCHANumber = new short[]{1, 3, 2, 4, 9, 11, 10, 12, 5, 7, 6, 8, 13, 15, 14, 16};
        PortPCBMaskToCHANumber_HM = new short[]{1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 7, 8, 15, 16};
        listPK = null;
    }

    private static class PKType {
        private byte pktyp;
        private String PKName;
        private String PKNameShort;
        private int HostIF;
        private String HostIFPort;
        private short[] Blocks;

        PKType(byte by, String string, String string2, int n, String string3, short[] sArray) {
            this.pktyp = by;
            this.PKName = string;
            this.PKNameShort = string2;
            this.HostIF = n;
            this.HostIFPort = string3;
            this.Blocks = sArray;
        }

        byte getPKType() {
            return this.pktyp;
        }

        String getPKName() {
            return this.PKName;
        }

        String getPKNameShort() {
            return this.PKNameShort;
        }

        int getHostIF() {
            return this.HostIF;
        }

        String getHostIFPort() {
            return this.HostIFPort;
        }

        short[] getBlocks() {
            return this.Blocks;
        }
    }
}

