/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EmptyStackException;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcEventLockControl;

public class RJcEventQueue
extends EventQueue {
    private static RJcEventQueue eventQueue = null;
    private static RJcEventLockControl lockController = new RJcEventLockControl();

    public static void pushEventQueue() {
        if (eventQueue == null) {
            eventQueue = new RJcEventQueue();
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(eventQueue);
        }
    }

    public static EventQueue getEventQueue() {
        EventQueue eventQueue = RJcEventQueue.eventQueue;
        if (eventQueue == null) {
            eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        }
        return eventQueue;
    }

    public static void popEventQueue() {
        eventQueue.pop();
        eventQueue = null;
    }

    public static void addTopWindow(Window window) {
        lockController.addTopWindow(window);
    }

    public static void setLock(boolean bl, Window window) {
        if (bl) {
            lockController.lockWindow(window);
        } else {
            lockController.unlockWindow(window);
        }
        RJCom.putLog("[Com]", "[EventQueue]", "setLock(" + bl + ") " + window.getName(), 0);
    }

    public static boolean isLock(Window window) {
        boolean bl = lockController.isLock(window.getName());
        return bl;
    }

    public static boolean isLock(AWTEvent aWTEvent) {
        String string;
        boolean bl = false;
        if (aWTEvent instanceof InputEvent && !RJcEventQueue.isExitKey(aWTEvent) && (string = RJcEventQueue.getWindowName(aWTEvent)) != null) {
            bl = lockController.isLock(string);
        }
        return bl;
    }

    public static boolean isExitKey(AWTEvent aWTEvent) {
        KeyEvent keyEvent;
        boolean bl = false;
        if (aWTEvent instanceof KeyEvent && (keyEvent = (KeyEvent)aWTEvent).isAltDown() && keyEvent.isControlDown() && keyEvent.isShiftDown() && keyEvent.getKeyCode() == 68) {
            bl = true;
        }
        return bl;
    }

    private static String getWindowName(AWTEvent aWTEvent) {
        String string = null;
        Object object = aWTEvent.getSource();
        if (object instanceof Component) {
            string = RJcEventQueue.getWindowName((Component)object);
        }
        return string;
    }

    private static String getWindowName(Component component) {
        String string = null;
        Window window = RJComUty.getTopWindow(component);
        if (window != null) {
            string = window.getName();
        }
        return string;
    }

    public void postEvent(AWTEvent aWTEvent) {
        super.postEvent(aWTEvent);
    }

    public AWTEvent getNextEvent() throws InterruptedException {
        AWTEvent aWTEvent = null;
        boolean bl = false;
        while (RJcEventQueue.isLock(aWTEvent = super.getNextEvent())) {
        }
        return aWTEvent;
    }

    protected void dispatchEvent(AWTEvent aWTEvent) {
        super.dispatchEvent(aWTEvent);
    }

    private void traceEvent(AWTEvent aWTEvent) {
        if (RJcEventQueue.isLock(aWTEvent) && aWTEvent instanceof InputEvent) {
            System.out.println("[Com]   [EventQueue]  IgnoreEvent " + aWTEvent.getID() + " " + aWTEvent);
        } else if (!(aWTEvent instanceof MouseEvent) || aWTEvent.getID() != 503) {
            System.out.println("[Com]   [EventQueue]  AvailEvent " + aWTEvent.getID() + " " + aWTEvent);
        }
    }

    public void push(EventQueue eventQueue) {
        RJCom.putLog("[Com]", "[EventQueue]", "push(" + eventQueue + ")", 0);
        super.push(eventQueue);
    }

    public void pop() throws EmptyStackException {
        RJCom.putLog("[Com]", "[EventQueue]", "pop()", 0);
        super.pop();
    }
}

