/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.abs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sanproject.client.com.abs.RJaTable;
import sanproject.client.com.abs.RJaTableDataModel;
import sanproject.client.com.abs.RJaTableHeader;

public class RJaTableManager
extends JPanel
implements ChangeListener {
    public static final int NO_HEADER = 0;
    public static final int SINGLE_HEADER = 1;
    public static final int DOUBLE_HEADER = 2;
    private InnerScrollPane scrollPane = new InnerScrollPane(this);
    private BorderLayout thisLayout = new BorderLayout();
    private RJaTable rhTable = null;
    private RJaTable vpTable = null;
    protected RJaTableDataModel model;
    private Vector refreshTarget = null;

    public RJaTableManager() {
        this((RJaTableDataModel)null);
    }

    public RJaTableManager(RJaTableDataModel rJaTableDataModel) {
        this.setLayout(this.thisLayout);
        this.scrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.scrollPane, "Center");
        if (rJaTableDataModel != null) {
            this.createTable(rJaTableDataModel);
        }
    }

    public void createTable(RJaTableDataModel rJaTableDataModel) {
        this.model = rJaTableDataModel;
        this.scrollPane.setViewportView(null);
        this.scrollPane.setRowHeaderView(null);
        if (rJaTableDataModel != null) {
            this.scrollPane.setHeaderMode(rJaTableDataModel.getHeaderMode());
            rJaTableDataModel.setTable(this);
            TableColumnModel tableColumnModel = rJaTableDataModel.getVPColumnModel();
            if (tableColumnModel != null) {
                this.vpTable = new RJaTable(0, this);
                this.vpTable.setColumnModel(tableColumnModel);
                ArrayList arrayList = rJaTableDataModel.getVPColumnGroup();
                RJaTableHeader rJaTableHeader = (RJaTableHeader)this.vpTable.getTableHeader();
                rJaTableHeader.setColumnGroup(arrayList);
                this.vpTable.setAutoResizeMode(rJaTableDataModel.getAutoResizeMode());
                ListSelectionModel listSelectionModel = this.getListSelectionModel();
                if (listSelectionModel != null) {
                    this.vpTable.setSelectionModel(listSelectionModel);
                    this.vpTable.changeSelection(0, 0, false, false);
                }
                this.vpTable.setSelectionMode(2);
                this.scrollPane.setTable(this.vpTable);
                this.scrollPane.setViewportView(this.vpTable);
                if (rJaTableDataModel.getHeaderMode() == 0) {
                    this.vpTable.setTableHeader(null);
                    this.scrollPane.setColumnHeader(null);
                }
                this.scrollPane.setRowHeader(null);
                TableColumnModel tableColumnModel2 = rJaTableDataModel.getRHColumnModel();
                if (tableColumnModel2 != null) {
                    Serializable serializable;
                    this.rhTable = new RJaTable(1, this);
                    this.rhTable.setColumnModel(tableColumnModel2);
                    this.rhTable.setSelectionModel(this.vpTable.getSelectionModel());
                    int n = 0;
                    Enumeration<TableColumn> enumeration = tableColumnModel2.getColumns();
                    while (enumeration.hasMoreElements()) {
                        serializable = enumeration.nextElement();
                        n += serializable.getPreferredWidth();
                    }
                    this.rhTable.setPreferredScrollableViewportSize(new Dimension(n, 0));
                    this.scrollPane.setRowHeaderView(this.rhTable);
                    this.scrollPane.getRowHeader().addChangeListener(this);
                    if (rJaTableDataModel.getHeaderMode() != 0) {
                        serializable = this.rhTable.getTableHeader();
                        this.scrollPane.setCorner("UPPER_LEFT_CORNER", (Component)serializable);
                    }
                }
            }
        }
    }

    public RJaTableDataModel setModel(RJaTableDataModel rJaTableDataModel) {
        RJaTableDataModel rJaTableDataModel2 = this.model;
        this.model = rJaTableDataModel;
        if (rJaTableDataModel != null) {
            rJaTableDataModel.setTable(this);
        }
        return rJaTableDataModel2;
    }

    public void setTableTitle(String string) {
        this.add((Component)new JLabel(string, 0), "North");
    }

    public void setRowHeight(int n, int n2) {
        this.vpTable.setRowHeight(n, n2);
        if (this.rhTable != null) {
            this.rhTable.setRowHeight(n, n2);
        }
    }

    public RJaTable getTable() {
        return this.getVPTable();
    }

    public RJaTable getVPTable() {
        return this.vpTable;
    }

    public RJaTable getRHTable() {
        return this.rhTable;
    }

    public RJaTableDataModel getDataModel() {
        return this.model;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public ListSelectionModel getListSelectionModel() {
        return null;
    }

    public void superRefresh() {
        this.refresh();
        if (this.refreshTarget != null) {
            Enumeration enumeration = this.refreshTarget.elements();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                component.repaint();
            }
        }
    }

    public void refresh() {
        if (this.rhTable != null) {
            this.rhTable.revalidate();
        }
        this.vpTable.revalidate();
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
        this.repaint();
    }

    public void setRefreshTarget(Component component) {
        if (this.refreshTarget == null) {
            this.refreshTarget = new Vector(4, 2);
        }
        this.refreshTarget.add(component);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void visibleRow(int n, int n2) {
        int n3 = this.getTable().getRowHeight();
        int n4 = n * n3;
        JViewport jViewport = this.scrollPane.getViewport();
        Rectangle rectangle = jViewport.getViewRect();
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        int n5 = jScrollBar.getValue();
        int n6 = n5 + jScrollBar.getVisibleAmount();
        if (n4 < n5) {
            jScrollBar.setValue(n4);
        } else if (n4 + n2 * n3 >= n6) {
            int n7 = Math.min(n4, jScrollBar.getMaximum() - jScrollBar.getVisibleAmount());
            jScrollBar.setValue(n7);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JViewport jViewport = (JViewport)changeEvent.getSource();
        Rectangle rectangle = jViewport.getViewRect();
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        int n = jScrollBar.getValue();
        int n2 = n + jScrollBar.getVisibleAmount();
        if (rectangle.y < n) {
            jScrollBar.setValue(rectangle.y);
        } else if (rectangle.y + rectangle.height > n2) {
            jScrollBar.setValue(rectangle.y);
        }
    }

    public void debug() {
        this.print("TotalColumnWidth = " + this.vpTable.getColumnModel().getTotalColumnWidth());
        this.print("ViewPortSize = " + this.scrollPane.getViewport().getExtentSize());
    }

    public void print(String string) {
        System.out.println(string);
    }

    class InnerScrollPane
    extends JScrollPane
    implements AncestorListener {
        private int headerMode = 1;
        private RJaTableManager manager;
        private JTable table;
        private JPanel panel = null;

        InnerScrollPane(RJaTableManager rJaTableManager2) {
            this.manager = rJaTableManager2;
            JScrollBar jScrollBar = this.getHorizontalScrollBar();
            if (jScrollBar != null) {
                jScrollBar.addAncestorListener(this);
            }
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            if (this.manager.getVPTable() != null) {
                this.manager.refresh();
            }
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void setHeaderMode(int n) {
            this.headerMode = n;
        }

        public void setTable(JTable jTable) {
            this.table = jTable;
        }
    }
}

