/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import sanproject.client.exdevice.data.EmulationTypeInfo;
import sanproject.client.exdevice.data.ExternalVolumeInfo;
import sanproject.client.exdevice.data.ExternalVolumeManager;
import sanproject.client.exdevice.data.LdevManager;
import sanproject.client.exdevice.data.LprManager;
import sanproject.client.exdevice.data.PathGroupInfo;
import sanproject.client.exdevice.data.PathGroupManager;
import sanproject.client.exdevice.data.PhysicalPathInfo;
import sanproject.client.exdevice.data.PresetData;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.data.ProductManager;
import sanproject.client.exdevice.data.ProfileInfo;
import sanproject.client.exdevice.data.Singleton;
import sanproject.client.exdevice.data.SsidManager;
import sanproject.client.exdevice.data.TargetPortInfo;
import sanproject.client.exdevice.data.VmaInfo;
import sanproject.client.exdevice.data.VolumeOperationDataControl;
import sanproject.client.exdevice.data.VpgInfo;
import sanproject.client.exdevice.data.VpgManager;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.EXDAddVolume;
import sanproject.serverux.dataimpl.EXDAddVolumeForEXD;
import sanproject.serverux.dataimpl.EXDExternalDevice;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.serverux.dataimpl.EXDLDEVInfoDetail;
import sanproject.serverux.dataimpl.EXDPhysicalPath;
import sanproject.serverux.dataimpl.EXDSubsystem;
import sanproject.serverux.dataimpl.EXDTargetPort;
import sanproject.serverux.dataimpl.EXDVpg;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail;

public class AddVolumeData
extends PresetData {
    private static final String LOG_NAME = "AddVolumeData";
    public static final int OP_ADDVOL = 1;
    private ProductInfo mProduct;
    private PathGroupInfo mPathGroup;
    private ExternalVolumeInfo mVolume;
    RJiLDEVInfoDetail[] mLdevList = null;
    Robj_interface_RJiLDEVIndex[] mBackupLdevIndexList = null;
    private boolean mflgSsidRegistry = false;
    public static final int MAX_DIVIDE = 2048;
    private int mMaxLdevCount = 2048;
    private static VmaInfo mVmaInfo = new VmaInfo();

    public AddVolumeData(ProductInfo productInfo, PathGroupInfo pathGroupInfo, ExternalVolumeInfo externalVolumeInfo) {
        this.mProduct = productInfo;
        this.mPathGroup = pathGroupInfo;
        this.mVolume = externalVolumeInfo;
        this.mVolume.setModify(true);
        this.mPathGroup.setModify(true);
        this.mProduct.setModify(true);
        ProfileInfo profileInfo = this.mProduct.getProfileInfo();
        byte by = profileInfo.getDefaultPathMode();
        this.setPathMode(by);
    }

    public ProductInfo getProductInfo() {
        return this.mProduct;
    }

    public PathGroupInfo getPathGroupInfo() {
        return this.mPathGroup;
    }

    public ExternalVolumeInfo getExternalVolumeInfo() {
        return this.mVolume;
    }

    public RJiLDEVInfoDetail[] getLdevInfo() {
        if (this.mLdevList == null) {
            this.mLdevList = this.createLdev();
            this.mBackupLdevIndexList = new RJiLDEVIndex[this.mLdevList.length];
        }
        for (int i = 0; i < this.mBackupLdevIndexList.length; ++i) {
            RJiLDEVInfoDetail rJiLDEVInfoDetail = this.mLdevList[i];
            short s = rJiLDEVInfoDetail.getSLDKC();
            short s2 = rJiLDEVInfoDetail.getSCU();
            short s3 = rJiLDEVInfoDetail.getSLDEV();
            RJiLDEVIndex rJiLDEVIndex = new RJiLDEVIndex();
            rJiLDEVIndex.setLDEVIndex(s, s2, s3);
            this.mBackupLdevIndexList[i] = rJiLDEVIndex;
        }
        return this.mLdevList;
    }

    public void restoreLdev() {
        LdevManager ldevManager = LdevManager.getInstance();
        ldevManager.removeLdevMap((Robj_interface_RJiLDEVIndex[])this.mLdevList);
        EmulationTypeInfo emulationTypeInfo = this.mVolume.getEmulationTypeInfo();
        for (int i = 0; i < this.mLdevList.length; ++i) {
            Robj_interface_RJiLDEVIndex robj_interface_RJiLDEVIndex = this.mBackupLdevIndexList[i];
            short s = robj_interface_RJiLDEVIndex.getSLDKC();
            short s2 = robj_interface_RJiLDEVIndex.getSCU();
            short s3 = robj_interface_RJiLDEVIndex.getSLDEV();
            this.mLdevList[i].setLDEVIndex(s, s2, s3);
            ldevManager.setLdevMap(s, s2, s3, emulationTypeInfo);
        }
    }

    public void setLdevs() {
        this.mVolume.setLdevInfos((Robj_interface_RJiLDEVInfoDetail[])this.mLdevList);
        short s = 0;
        if (this.mLdevList != null) {
            s = (short)this.mLdevList.length;
        }
        RJiLDEVInfoDetail rJiLDEVInfoDetail = s > 0 ? this.mLdevList[0] : null;
        VpgInfo vpgInfo = this.mVolume.getVpgInfo();
        vpgInfo.setLdevSummary((Robj_interface_RJiLDEVIndex)rJiLDEVInfoDetail, s);
    }

    private RJiLDEVInfoDetail[] createLdev() {
        RJiLDEVInfoDetail[] rJiLDEVInfoDetailArray = new RJiLDEVInfoDetail[]{};
        BigInteger bigInteger = this.mVolume.getCapacity();
        EmulationTypeInfo emulationTypeInfo = this.mVolume.getEmulationTypeInfo();
        if (emulationTypeInfo == null) {
            return rJiLDEVInfoDetailArray;
        }
        int n = emulationTypeInfo.getEmulationId();
        int n2 = emulationTypeInfo.getEmulationKind();
        int n3 = this.mMaxLdevCount;
        ArrayList arrayList = this.mMaxLdevCount > 0 ? emulationTypeInfo.getHdevCapacityList(bigInteger) : new ArrayList();
        if (n3 > arrayList.size()) {
            n3 = arrayList.size();
        }
        ArrayList<RJiLDEVInfoDetail> arrayList2 = new ArrayList<RJiLDEVInfoDetail>(n3);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && arrayList2.size() < n3) {
            BigInteger bigInteger2 = (BigInteger)iterator.next();
            RJiLDEVInfoDetail rJiLDEVInfoDetail = new RJiLDEVInfoDetail();
            rJiLDEVInfoDetail.setLDEVIndex((short)-1, (short)-1, (short)-1);
            rJiLDEVInfoDetail.lLDEVLBASize = bigInteger2.longValue();
            rJiLDEVInfoDetail.byVolumeFlag = (byte)n2;
            rJiLDEVInfoDetail.lLDEVSize = emulationTypeInfo.isOpenType() ? rJiLDEVInfoDetail.lLDEVLBASize >> 1 : emulationTypeInfo.lbaToCyl(bigInteger2).longValue();
            rJiLDEVInfoDetail.iEmulationType = n;
            arrayList2.add(rJiLDEVInfoDetail);
        }
        rJiLDEVInfoDetailArray = arrayList2.toArray(rJiLDEVInfoDetailArray);
        return rJiLDEVInfoDetailArray;
    }

    private void removeLdev() {
        if (this.mLdevList != null) {
            Singleton singleton;
            if (this.mflgSsidRegistry) {
                singleton = SsidManager.getInstance();
                ((SsidManager)singleton).removeLdev((Robj_interface_RJiLDEVIndex[])this.mLdevList);
            }
            singleton = LdevManager.getInstance();
            ((LdevManager)singleton).removeLdevMap((Robj_interface_RJiLDEVIndex[])this.mLdevList);
            this.mLdevList = null;
            this.setLdevs();
        }
    }

    public int getNumOfLdev() {
        int n = 0;
        if (this.mLdevList != null) {
            n = this.mLdevList.length;
        }
        return n;
    }

    void setSsidRegistry() {
        this.mflgSsidRegistry = true;
    }

    EXDVpg getPgInfo() {
        VpgInfo vpgInfo = this.mVolume.getVpgInfo();
        return vpgInfo.getEXDVpg();
    }

    public boolean setExg(int n) {
        boolean bl = false;
        VpgInfo vpgInfo = this.mVolume.getVpgInfo();
        EXDVpg eXDVpg = vpgInfo.getEXDVpg();
        if (n != eXDVpg.getIFB4()) {
            VpgManager vpgManager = VpgManager.getInstance();
            vpgManager.releasePg((Robj_interface_RJiPGIndex)eXDVpg);
            bl = vpgManager.addPgInfo(n, vpgInfo);
            int n2 = vpgInfo.getEXDVpg().getIFB4();
            int n3 = vpgInfo.getEXDVpg().getIPG();
            this.mVolume.getEXDExternalVolume().setPGIndex(n2, n3);
        } else {
            bl = true;
        }
        return bl;
    }

    void setOneToOneMode(boolean bl) {
        EXDExternalVolume eXDExternalVolume = this.mVolume.getEXDExternalVolume();
        eXDExternalVolume.setOneToOneMode(bl);
    }

    public void setEmulationType(EmulationTypeInfo emulationTypeInfo) {
        EmulationTypeInfo emulationTypeInfo2 = this.getEmulationType();
        if (!emulationTypeInfo.equals(emulationTypeInfo2)) {
            this.removeLdev();
            this.mVolume.setEmulationTypeInfo(emulationTypeInfo);
        }
    }

    public EmulationTypeInfo getEmulationType() {
        return this.mVolume.getEmulationTypeInfo();
    }

    public void setMaxLdevCount(int n) {
        if (this.mVolume.isCmd() || this.mVolume.isInheritDrive()) {
            n = 1;
        }
        if (this.mMaxLdevCount != n) {
            this.removeLdev();
            this.mMaxLdevCount = n;
        }
    }

    public int getMaxLdevCount() {
        return this.mMaxLdevCount;
    }

    public void setCacheMode(boolean bl) {
        EXDExternalVolume eXDExternalVolume = this.mVolume.getEXDExternalVolume();
        if (this.mVolume.isCmd() || this.mProduct.isOwn()) {
            bl = false;
        }
        eXDExternalVolume.setCacheMode(bl);
    }

    public void setInflowControl(boolean bl) {
        EXDExternalVolume eXDExternalVolume = this.mVolume.getEXDExternalVolume();
        eXDExternalVolume.setInflowControl(bl);
    }

    public void setPathMode(byte by) {
        EXDExternalVolume eXDExternalVolume = this.mVolume.getEXDExternalVolume();
        eXDExternalVolume.setPathMode(by);
    }

    public void setClpr(int n) {
        EXDExternalVolume eXDExternalVolume = this.mVolume.getEXDExternalVolume();
        eXDExternalVolume.setSCLPR((short)n);
        LprManager lprManager = LprManager.getInstance();
        short s = lprManager.getSlpr(n);
        short s2 = eXDExternalVolume.getSSLPR();
        if (s2 != s) {
            this.removeLdev();
        }
        eXDExternalVolume.setSSLPR(s);
    }

    public VmaInfo getVmaInfo() {
        return mVmaInfo;
    }

    Object getApplyData() {
        TargetPortInfo targetPortInfo;
        EXDAddVolumeForEXD eXDAddVolumeForEXD = new EXDAddVolumeForEXD();
        EXDSubsystem eXDSubsystem = this.mProduct.getEXDSubsystem();
        eXDAddVolumeForEXD.setSubsystem(eXDSubsystem);
        EXDExternalVolume eXDExternalVolume = this.mVolume.getEXDExternalVolume();
        eXDAddVolumeForEXD.setPGInfo(eXDExternalVolume);
        long l = eXDExternalVolume.getExternalDeviceInfo().getVolumeSize();
        eXDExternalVolume.setLPGLBASize(l);
        PhysicalPathInfo[] physicalPathInfoArray = new PhysicalPathInfo[]{};
        physicalPathInfoArray = this.mPathGroup.getPhysicalPathInfo().toArray(physicalPathInfoArray);
        EXDPhysicalPath[] eXDPhysicalPathArray = new EXDPhysicalPath[physicalPathInfoArray.length];
        EXDTargetPort[] eXDTargetPortArray = new EXDTargetPort[physicalPathInfoArray.length];
        for (int i = 0; i < physicalPathInfoArray.length; ++i) {
            PhysicalPathInfo physicalPathInfo = physicalPathInfoArray[i];
            eXDPhysicalPathArray[i] = physicalPathInfo.getEXDPhysicalPath();
            targetPortInfo = physicalPathInfo.getTargetPortInfo();
            eXDTargetPortArray[i] = targetPortInfo.getEXDTargetPort();
        }
        eXDAddVolumeForEXD.setPhysicalPath(eXDPhysicalPathArray);
        eXDAddVolumeForEXD.setTargetPort(eXDTargetPortArray);
        SsidManager ssidManager = SsidManager.getInstance();
        for (int i = 0; i < this.mLdevList.length; ++i) {
            targetPortInfo = this.mLdevList[i];
            int n = ssidManager.getSsidInfo((Robj_interface_RJiLDEVIndex)targetPortInfo).getSsid();
            EXDLDEVInfoDetail eXDLDEVInfoDetail = new EXDLDEVInfoDetail();
            eXDLDEVInfoDetail.setLDEVIndex(targetPortInfo.getSLDKC(), targetPortInfo.getSCU(), targetPortInfo.getSLDEV());
            eXDLDEVInfoDetail.setLLDEVLBASize(targetPortInfo.getLLDEVLBASize());
            eXDLDEVInfoDetail.setSSID(n);
            eXDAddVolumeForEXD.setLdev(eXDLDEVInfoDetail);
        }
        return eXDAddVolumeForEXD;
    }

    protected int setApplyResult(Object object) {
        int n = ((EXDAddVolumeForEXD)object).getResult();
        VolumeOperationDataControl volumeOperationDataControl = VolumeOperationDataControl.getInstance();
        n = volumeOperationDataControl.chkLisencedCapacityOver(n);
        if (n == 0) {
            this.mProduct.setModify(false);
            this.mPathGroup.setModify(false);
            this.mVolume.setModify(false);
            RJiLDEVInfoDetail[] rJiLDEVInfoDetailArray = this.getLdevInfo();
            SsidManager ssidManager = SsidManager.getInstance();
            ssidManager.applyComplete((Robj_interface_RJiLDEVIndex[])rJiLDEVInfoDetailArray);
            EXDVpg eXDVpg = this.mVolume.getVpgInfo().getEXDVpg();
            int n2 = eXDVpg.referPathGroupId();
            ExternalVolumeManager externalVolumeManager = ExternalVolumeManager.getInstance();
            externalVolumeManager.clearCache(n2);
        }
        return n;
    }

    void enterPreset() {
        ProductManager productManager = ProductManager.getInstance();
        productManager.addProductInfo(this.mProduct);
        ExternalVolumeManager externalVolumeManager = ExternalVolumeManager.getInstance();
        externalVolumeManager.addExternalVolume(this.mVolume);
    }

    void removePreset() {
        ExternalVolumeInfo externalVolumeInfo = this.getExternalVolumeInfo();
        ExternalVolumeManager externalVolumeManager = ExternalVolumeManager.getInstance();
        externalVolumeManager.removeExternalVolume(externalVolumeInfo);
        if (!externalVolumeInfo.isModify()) {
            return;
        }
        this.removeLdev();
        VpgManager vpgManager = VpgManager.getInstance();
        vpgManager.releasePg((Robj_interface_RJiPGIndex)this.getPgInfo());
        this.mProduct.setModify(false);
        this.mPathGroup.setModify(false);
        ProductManager productManager = ProductManager.getInstance();
        productManager.removeProductInfo(this.mProduct);
        PathGroupManager pathGroupManager = PathGroupManager.getInstance();
        pathGroupManager.removePathGroup(this.mPathGroup);
    }

    public int compareTo(Object object) {
        String string = AddVolumeData.getCompValue(this);
        String string2 = AddVolumeData.getCompValue(object);
        return string.compareTo(string2);
    }

    public boolean equals(EXDSubsystem eXDSubsystem) {
        return this.mProduct.equals(eXDSubsystem);
    }

    public boolean equals(Object object) {
        boolean bl;
        try {
            String string = AddVolumeData.getCompValue(this);
            String string2 = AddVolumeData.getCompValue(object);
            bl = string.equals(string2);
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return this.mVolume.toString();
    }

    private static String getCompValue(Object object) {
        String string;
        if (object instanceof AddVolumeData) {
            string = ((AddVolumeData)object).getExternalVolumeInfo().getCharacteristic2();
        } else if (object instanceof ExternalVolumeInfo) {
            string = ((ExternalVolumeInfo)object).getCharacteristic2();
        } else if (object instanceof EXDExternalVolume) {
            string = ((EXDExternalVolume)object).getExternalDeviceInfo().getIdentity2();
        } else if (object instanceof EXDExternalDevice) {
            string = ((EXDExternalDevice)object).getIdentity2();
        } else if (object instanceof EXDAddVolumeForEXD) {
            string = ((EXDAddVolumeForEXD)object).getPGInfo().getExternalDeviceInfo().getIdentity2();
        } else if (object instanceof EXDAddVolume) {
            EXDExternalVolume eXDExternalVolume = (EXDExternalVolume)((EXDAddVolume)object).getPGIndex();
            string = eXDExternalVolume.getExternalDeviceInfo().getIdentity2();
        } else {
            string = (String)object;
        }
        return string;
    }
}

