/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.hur.dialog.jnl;

import javax.swing.text.Document;
import sanproject.client.hur.dialog.jnl.RJHurBaseTextField;
import sanproject.client.hur.dialog.jnl.RJHurRestrictDocument;

public class RJHurNumericField
extends RJHurBaseTextField {
    private static final String CLASSNAME = "RJHurNumericField";
    private int m_iMin = 0;
    private int m_iMax = 0;
    private int m_iBase = 10;
    private boolean m_bChkMin = true;
    private boolean m_bChkMax = true;

    public RJHurNumericField(int n) {
        this(String.valueOf(n));
    }

    public RJHurNumericField(String string) {
        super(string);
        this.initInstance();
    }

    protected Document getDefaultDocument() {
        return new NumericFieldDocument();
    }

    private void initInstance() {
        this.setHorizontalAlignment(2);
    }

    public void setRange(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.m_iMin = n;
        this.m_iMax = n2;
        this.m_iBase = n3;
        this.m_bChkMin = bl;
        this.m_bChkMax = bl2;
    }

    public void setRestrict(int n) {
        Document document = this.getDefaultDocument();
        if (document instanceof RJHurRestrictDocument) {
            RJHurRestrictDocument rJHurRestrictDocument = (RJHurRestrictDocument)document;
            rJHurRestrictDocument.setIsNumeric(true);
            rJHurRestrictDocument.setStringLimit(n);
            this.setDocument(document);
        }
    }

    public boolean chkRangeForce() {
        boolean bl = true;
        String string = this.getText();
        if (string.length() != 0) {
            try {
                int n = Integer.parseInt(string, this.m_iBase);
                return this.m_iMin <= n && n <= this.m_iMax;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    protected class NumericFieldDocument
    extends RJHurRestrictDocument {
        private static final String CLASSNAME = "RJHurNumericField.NumericFieldDocument";

        protected String getEffectiveCharacters() {
            switch (RJHurNumericField.this.m_iBase) {
                case 16: {
                    return "0123456789abcdefABCDEF";
                }
            }
            return "0123456789";
        }

        protected boolean chkRange(String string) {
            if (string.length() != 0) {
                try {
                    int n = Integer.parseInt(string, RJHurNumericField.this.m_iBase);
                    if (RJHurNumericField.this.m_bChkMin && RJHurNumericField.this.m_iMin > n) {
                        return false;
                    }
                    if (RJHurNumericField.this.m_bChkMax && n > RJHurNumericField.this.m_iMax) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }
    }
}

