/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.lunm;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcMenuAction;
import sanproject.client.com.RJcPopupMenu;
import sanproject.client.com.abs.RJaDataModelEntry;
import sanproject.client.com.abs.RJaTableDataModel;
import sanproject.client.lunm.RJLunConstants;
import sanproject.client.lunm.RJLunDnDTable;
import sanproject.client.lunm.RJLunGdata;
import sanproject.client.lunm.RJLunLDEVTableModel;
import sanproject.client.lunm.RJLunLUTableModel;
import sanproject.client.lunm.RJLunMenuSub;
import sanproject.client.lunm.RJLunMngr;
import sanproject.client.lunm.RJLunTreePanel;
import sanproject.client.lunm.data.RJLunDataSupplier;
import sanproject.client.lunm.data.RJLunHostElement;
import sanproject.client.lunm.data.RJLunLDEVElement;
import sanproject.client.lunm.data.RJLunLUElement;

public class RJLunLUTablePanel
extends RJLunDnDTable
implements RJLunConstants {
    protected RJLunDataSupplier supplier;
    protected RJLunMngr LUNMPanel = null;
    private RJLunTreePanel treePanel = null;
    private RJLunHostElement HostElement = null;
    private RJcPopupMenu menu;

    public RJLunLUTablePanel(RJLunDataSupplier rJLunDataSupplier, RJLunMngr rJLunMngr) {
        this.supplier = rJLunDataSupplier;
        this.LUNMPanel = rJLunMngr;
        this.treePanel = this.LUNMPanel.getTreePanel();
        this.createTable(null);
    }

    public void init() {
        if (this.model != null) {
            this.model.removeAll();
        }
        RJLunGdata.RemLUNP = 0;
        RJLunGdata.RemLUNG = 0;
        this.LUNMPanel.m_pathL1.setText(RJLunGdata.GD_SELP + "0");
        this.LUNMPanel.m_pathL2.setText(RJLunGdata.GD_REMP + RJLunGdata.RemLUNP);
        this.LUNMPanel.m_pathL3.setText(RJLunGdata.GD_REMG + RJLunGdata.RemLUNG);
    }

    public void createTable(RJaTableDataModel rJaTableDataModel) {
        if (rJaTableDataModel == null) {
            rJaTableDataModel = new RJLunLUTableModel(this.supplier, this);
        }
        super.createTable(rJaTableDataModel);
        this.LUNMPanel.m_pathL1.setText(RJLunGdata.GD_SELP + "0");
        this.LUNMPanel.m_pathL2.setText(RJLunGdata.GD_REMP + RJLunGdata.RemLUNP);
        this.LUNMPanel.m_pathL3.setText(RJLunGdata.GD_REMG + RJLunGdata.RemLUNG);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        RJLunGdata.changeDnDButtonStatus(this.getTable().getTableManager().getName());
        int[] nArray = this.getDataModel().getSelectedRows();
        this.LUNMPanel.m_pathL1.setText(RJLunGdata.GD_SELP + nArray.length);
    }

    public void completedTable() {
        super.completedTable();
    }

    public void setTableData(RJLunHostElement rJLunHostElement, ArrayList arrayList) {
        this.HostElement = rJLunHostElement;
        ((RJLunLUTableModel)this.model).removeAll();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJLunLUElement rJLunLUElement = (RJLunLUElement)iterator.next();
            ((RJLunLUTableModel)this.model).addRow(rJLunLUElement);
        }
    }

    protected void showPopupMenu(MouseEvent mouseEvent, Object object) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (jPopupMenu.isPopupTrigger(mouseEvent)) {
            RJLunMenuSub.PopTableModel = (RJLunLUTableModel)this.model;
            RJLunMenuSub.PopSelRow = RJLunMenuSub.PopTableModel.getSelectedRows()[0];
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int[] nArray = jTable.getSelectedRows();
            Arrays.sort(nArray);
            int n2 = Arrays.binarySearch(nArray, n);
            if (n2 >= 0) {
                this.menu = new RJcPopupMenu(this.getMenuAction());
                this.SetVisible_MenuItem();
                if (this.menu.countComponents() > 0) {
                    this.menu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        } else {
            int[] nArray = ((RJLunLUTableModel)this.model).getSelectedRows();
            int n = nArray.length;
            this.LUNMPanel.m_pathL1.setText(RJLunGdata.GD_SELP + n);
        }
    }

    private RJcMenuAction[] getMenuAction() {
        RJcMenuAction[] rJcMenuActionArray = new RJcMenuAction[]{new RJcMenuAction(RJcGuide.text("LUNM/PM41")){

            public void actionPerformed(ActionEvent actionEvent) {
                RJLunMenuSub.jMenuItem9_proc(actionEvent);
            }
        }, new RJcMenuAction(RJcGuide.text("LUNM/PM42")){

            public void actionPerformed(ActionEvent actionEvent) {
                RJLunMenuSub.jMenuItem10_proc(actionEvent);
            }
        }, new RJcMenuAction(), new RJcMenuAction(RJcGuide.text("LUNM/PM43")){

            public void actionPerformed(ActionEvent actionEvent) {
                RJLunMenuSub.jMenuItem11_proc(actionEvent);
            }
        }, new RJcMenuAction(RJcGuide.text("LUNM/PM44")){

            public void actionPerformed(ActionEvent actionEvent) {
                RJLunMenuSub.jMenuItem12_proc(actionEvent);
            }
        }, new RJcMenuAction(), new RJcMenuAction(RJcGuide.text("LUNM/PM45")){

            public void actionPerformed(ActionEvent actionEvent) {
                RJLunMenuSub.jMenuItem13_proc(actionEvent);
            }
        }, new RJcMenuAction(RJcGuide.text("LUNM/PM46")){

            public void actionPerformed(ActionEvent actionEvent) {
                RJLunMenuSub.jMenuItem14_proc(actionEvent);
            }
        }, new RJcMenuAction(), new RJcMenuAction(RJcGuide.text("LUNM/GD_PMPathCopy")){

            public void actionPerformed(ActionEvent actionEvent) {
                RJLunMenuSub.jMenuItemPathCopy_proc(actionEvent);
            }
        }};
        return rJcMenuActionArray;
    }

    private void SetVisible_MenuItem() {
        this.menu.setVisible(RJcGuide.text("LUNM/PM41"), false);
        this.menu.setVisible(RJcGuide.text("LUNM/PM42"), false);
        this.menu.setVisible(RJcGuide.text("LUNM/PM43"), false);
        this.menu.setVisible(RJcGuide.text("LUNM/PM44"), false);
        this.menu.setVisible(RJcGuide.text("LUNM/PM45"), false);
        this.menu.setVisible(RJcGuide.text("LUNM/PM46"), false);
        this.menu.setVisible(RJcGuide.text("LUNM/GD_PMPathCopy"), false);
        RJLunLUTableModel rJLunLUTableModel = (RJLunLUTableModel)this.model;
        int[] nArray = rJLunLUTableModel.getSelectedRows();
        RJaDataModelEntry rJaDataModelEntry = rJLunLUTableModel.getRow(nArray[0]);
        RJLunLUElement rJLunLUElement = (RJLunLUElement)rJaDataModelEntry.get("LUN");
        this.makeLpathMenu(rJLunLUElement);
    }

    private void makeLpathMenu(RJLunLUElement rJLunLUElement) {
        RJLunLUTableModel rJLunLUTableModel = (RJLunLUTableModel)this.model;
        int[] nArray = rJLunLUTableModel.getSelectedRows();
        boolean bl = false;
        if (RJLunGdata.m_currentPort.isPortSecuritySwitch()) {
            bl = true;
        }
        short s = RJLunGdata.m_currentHost.getHostGroupNo();
        if (RJLunGdata.m_viewMode == 0) {
            byte by;
            short s2 = rJLunLUElement.getLUPathCnt();
            if (s2 > 0 && (by = rJLunLUElement.getVolumeFlg()) != 2 && nArray.length == 1 && rJLunLUElement.getVolumeInfo() == 0 && !rJLunLUElement.isVVol() && !rJLunLUElement.isRmtCmdDev() && (byte)(rJLunLUElement.getLDEVGuardStatus() & 0xC3) == -128) {
                if (rJLunLUElement.isCmdDev()) {
                    this.menu.setVisible(RJcGuide.text("LUNM/PM42"), true);
                    if (rJLunLUElement.isCmdDevSec()) {
                        this.menu.setVisible(RJcGuide.text("LUNM/PM44"), true);
                    } else {
                        this.menu.setVisible(RJcGuide.text("LUNM/PM43"), true);
                    }
                } else {
                    this.menu.setVisible(RJcGuide.text("LUNM/PM41"), true);
                }
            }
            if (this.chkPathExist()) {
                this.menu.setVisible(RJcGuide.text("LUNM/PM45"), true);
                if (nArray.length == 1) {
                    this.menu.setVisible(RJcGuide.text("LUNM/PM46"), true);
                }
                this.menu.setVisible(RJcGuide.text("LUNM/GD_PMPathCopy"), true);
            }
        } else if (this.chkPathExist() && nArray.length == 1) {
            this.menu.setVisible(RJcGuide.text("LUNM/PM46"), true);
        }
    }

    private boolean chkPathExist() {
        boolean bl = false;
        RJLunLUTableModel rJLunLUTableModel = (RJLunLUTableModel)this.model;
        int[] nArray = rJLunLUTableModel.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            RJaDataModelEntry rJaDataModelEntry = rJLunLUTableModel.getRow(nArray[i]);
            RJLunLUElement rJLunLUElement = (RJLunLUElement)rJaDataModelEntry.get("LUN");
            if (rJLunLUElement.getLUPathCnt() <= 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void addLUPath(RJLunLDEVElement rJLunLDEVElement, short s, short s2, short s3) {
        Object object;
        String string;
        RJLunLUElement rJLunLUElement = null;
        RJLunLUTableModel rJLunLUTableModel = (RJLunLUTableModel)this.model;
        RJaDataModelEntry rJaDataModelEntry = rJLunLUTableModel.getRow(s);
        if (rJaDataModelEntry != null) {
            rJLunLUElement = (RJLunLUElement)rJaDataModelEntry.get("LUN");
            rJLunLUElement.setLDEVElement(rJLunLDEVElement);
            rJLunLUElement.addLUPathCnt((short)1);
            rJLunLUElement.setModify(true);
            rJaDataModelEntry.put("LDEV", rJLunLUElement.getLDEVDispData(rJLunLUElement.getLDEVInfoDetail()));
            rJaDataModelEntry.put("ETYPE", rJLunLUElement.getEmulationDispData(rJLunLUElement.getLUSECount(), rJLunLUElement.getEmulationType()));
            rJaDataModelEntry.put("CAPA", new Long(rJLunLUElement.getLDEVLBASize()));
            rJaDataModelEntry.put("RAID", rJLunLUElement.getRaidLevelDispData(rJLunLUElement.getRaidLevel(), rJLunLUElement.getFB4(), rJLunLUElement.getPG()));
            rJaDataModelEntry.put("PATH", new Integer(rJLunLUElement.getLUPathCnt()));
            rJaDataModelEntry.put("ATTRI", rJLunLUElement.getLDEVGuardStr(rJLunLUElement.getLDEVGuardStatus(), rJLunLUElement.getVolumeInfo()));
        } else {
            string = RJComUty.itoh(s, 4);
            rJLunLUElement = new RJLunLUElement(string, this.LUNMPanel.getTreePanel());
            rJLunLUElement.initData(this.HostElement, s, null, rJLunLDEVElement.getLDEVInfoDetail(), rJLunLDEVElement);
            this.HostElement.addLUElement(rJLunLUElement);
            rJLunLUElement.setLDEVElement(rJLunLDEVElement);
            rJLunLUElement.addLUPathCnt((short)1);
            rJLunLUElement.setModify(true);
            object = "PORT" + s2 + "HOST" + s3 + "LU" + s;
            this.supplier.delLUMap((String)object);
        }
        this.HostElement.getPortElement().addPathCount((short)1);
        this.supplier.getDataControl().addLUPath(rJLunLDEVElement.getLDKC(), rJLunLDEVElement.getCU(), rJLunLDEVElement.getLDEV(), s, s2, s3);
        string = "PORT" + s2 + "HOST" + s3 + "LU" + s;
        object = this.supplier.getLUMap(string);
        rJLunLDEVElement.setArryLUMapKey(string);
        if (object == null) {
            this.supplier.setLUMap(string, rJLunLUElement);
        }
        this.refresh();
    }

    public void releaseLUPath(int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        String string = (String)this.LUNMPanel.getLDKCCmb().getSelectedItem();
        short s = 0;
        if (string != null) {
            s = (short)Integer.parseInt(string, 16);
        }
        String string2 = (String)this.LUNMPanel.getCUCmb().getSelectedItem();
        short s2 = 0;
        if (string2 != null) {
            s2 = (short)Integer.parseInt(string2, 16);
        }
        for (int i = 0; i < n2; ++i) {
            RJLunLUTableModel rJLunLUTableModel = (RJLunLUTableModel)this.model;
            RJaDataModelEntry rJaDataModelEntry = rJLunLUTableModel.getRow(nArray[i]);
            RJLunLUElement rJLunLUElement = (RJLunLUElement)rJaDataModelEntry.get("LUN");
            short s3 = rJLunLUElement.getHostElement().getPortNo();
            short s4 = rJLunLUElement.getHostElement().getHostGroupNo();
            short s5 = rJLunLUElement.getLUN();
            short s6 = rJLunLUElement.getLDEVElement().getLDKC();
            short s7 = rJLunLUElement.getLDEVElement().getCU();
            short s8 = rJLunLUElement.getLDEVElement().getLDEV();
            rJLunLUElement.releaseLUPathCnt();
            this.supplier.getDataControl().delLUPath(s5, s3, s4);
            ++n;
            RJLunLDEVTableModel rJLunLDEVTableModel = (RJLunLDEVTableModel)this.LUNMPanel.getLDEVTablePanel().getDataModel();
            if (string != null && string2 != null && s == s6 && s2 == s7) {
                rJLunLDEVTableModel.addRow(rJLunLUElement.getLDEVElement());
                rJLunLDEVTableModel.sortLdev();
            }
            String string3 = "PORT" + s3 + "HOST" + s4 + "LU" + s5;
            rJLunLUElement.getLDEVElement().removeArryLUMapKey(string3);
            rJLunLUElement.setLDEVElement(null);
            rJLunLUElement.setCopy(false);
            if (rJLunLUElement.getBeforeLDEVElement() == null) {
                rJLunLUElement.setModify(false);
            } else {
                rJLunLUElement.setModify(true);
                RJLunGdata.setDelPathInfo(s3, s4, s5, s6, s7, s8);
            }
            this.HostElement.getPortElement().releasePathCount((short)1);
        }
        RJLunGdata.m_pathL2.setText(RJLunGdata.GD_REMP + (RJLunGdata.RemLUNP += n));
        RJLunGdata.m_pathL3.setText(RJLunGdata.GD_REMG + (RJLunGdata.RemLUNG += n));
        this.refresh();
        this.LUNMPanel.getLDEVTablePanel().refresh();
    }

    public RJLunHostElement getHostElement() {
        return this.HostElement;
    }

    public void setHostElement(RJLunHostElement rJLunHostElement) {
        this.HostElement = rJLunHostElement;
    }
}

