/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.hihsm.attribute;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcGuide;
import sanproject.client.data.RJDataMsg;
import sanproject.client.monitor.com.RJHihBasePanel;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihLdevElement;
import sanproject.client.monitor.com.RJHihMonitoringView;
import sanproject.client.monitor.com.RJHihSuperException;
import sanproject.client.monitor.hihsm.attribute.RJHihAtErrorDialog;
import sanproject.client.monitor.hihsm.attribute.RJHihAttrCenterPanel;
import sanproject.client.monitor.hihsm.attribute.RJHihAttributeData;
import sanproject.common.Robj_interface_HIHsmErrorInfo;
import sanproject.serverux.arg.monitor.HIHsmSetAttributeInfo;
import sanproject.serverux.arg.monitor.HIHsmSetAttributeInfoEx;
import sanproject.serverux.arg.monitor.HIHsmSetFixParityGroupInfo;
import sanproject.serverux.arg.monitor.HIHsmSetUseRateLimitInfo;
import sanproject.serverux.data.applymarker.ApplyMonitor;

public class RJHihAttributePanel
extends RJHihBasePanel {
    private RJHihMonitoringView extraPanel;
    private RJHihAttrCenterPanel centerPanel;
    private JButton applyButton;
    private JButton refreshButton;
    private boolean refreshDrawing;
    private JButton closeButton;

    public RJHihAttributePanel() {
        this(null, null);
    }

    public RJHihAttributePanel(RJHihDataSupplier rJHihDataSupplier, ActionListener actionListener) {
        super(rJHihDataSupplier, actionListener);
        this.extraPanel = new RJHihMonitoringView(this.supplier);
        this.refreshDrawing = false;
        this.initialize();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setMainTitle(RJcGuide.text("Attribute/Title"));
        this.setTitle(RJcGuide.text("Attribute/AttributeTitle"));
        this.extraPanel.setPreferredSize(new Dimension(200, 48));
        this.extraPanel.setBackground(SystemColor.inactiveCaptionBorder);
        this.addExtra(this.extraPanel);
        this.centerPanel = new RJHihAttrCenterPanel(this.supplier);
        this.add((Component)this.centerPanel, "Center");
        boolean bl = this.supplier.isPermission(2);
        this.applyButton = this.newButton("Attribute/ApplyBtn");
        this.applyButton.setEnabled(bl);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJHihAttributePanel.this.applyButton_actionPerformed(actionEvent);
            }
        });
        this.refreshButton = this.newButton("Refresh");
        this.refreshButton.setEnabled(bl);
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJHihAttributePanel.this.refreshButton_actionPerformed(actionEvent);
            }
        });
        this.closeButton = this.newButton("Attribute/CloseBtn");
        this.closeButton.addActionListener(this.listener);
        this.addButton(this.applyButton, 0);
        this.addButton(this.refreshButton, 0);
        this.addButton(this.closeButton, 0);
        this.buttonCreate();
    }

    public boolean showPanel(boolean bl) {
        this.extraPanel.init();
        this.centerPanel.init();
        return true;
    }

    public boolean chkSts() {
        RJHihAttributeData rJHihAttributeData = (RJHihAttributeData)this.supplier.getAttributedata();
        return rJHihAttributeData.chkSts();
    }

    public String getWindowName() {
        return "Attribute";
    }

    private void setHihsmData() {
        RJHihAttributeData rJHihAttributeData = (RJHihAttributeData)this.supplier.getAttributedata();
        HIHsmSetFixParityGroupInfo[] hIHsmSetFixParityGroupInfoArray = rJHihAttributeData.getPgInfo();
        for (int i = 0; i < hIHsmSetFixParityGroupInfoArray.length; ++i) {
            HIHsmSetFixParityGroupInfo hIHsmSetFixParityGroupInfo = hIHsmSetFixParityGroupInfoArray[i];
            if (hIHsmSetFixParityGroupInfo == null) continue;
            this.supplier.setHIHSMData((ApplyMonitor)hIHsmSetFixParityGroupInfo);
        }
        HIHsmSetAttributeInfo[] hIHsmSetAttributeInfoArray = rJHihAttributeData.getLdevInfo();
        for (int i = 0; i < hIHsmSetAttributeInfoArray.length; ++i) {
            HIHsmSetAttributeInfo hIHsmSetAttributeInfo = hIHsmSetAttributeInfoArray[i];
            if (hIHsmSetAttributeInfo == null) continue;
            this.supplier.setHIHSMData((ApplyMonitor)hIHsmSetAttributeInfo);
        }
        HIHsmSetUseRateLimitInfo hIHsmSetUseRateLimitInfo = rJHihAttributeData.getClassInfo();
        if (hIHsmSetUseRateLimitInfo != null) {
            this.supplier.setHIHSMData((ApplyMonitor)hIHsmSetUseRateLimitInfo);
        }
    }

    private void applyButton_actionPerformed(ActionEvent actionEvent) {
        this.setHihsmData();
        int n = this.applyEx(true, false);
        this.supplier.putLog("[Attribute]", "[Apply]", "sts = " + n);
        if (n != 0) {
            this.supplier.cancel();
        }
    }

    public void applyEndEx(boolean bl, Object object) {
        this.supplier.putLog("[Attribute]", "[ApplyEnd]", "rlt = " + bl);
        if (bl) {
            ArrayList arrayList = this.extractError(object);
            if (arrayList == null) {
                this.centerPanel.init();
                this.showApplyEndMsg();
            } else {
                Dialog dialog = (Dialog)this.supplier.searchWindow(this);
                RJHihAtErrorDialog rJHihAtErrorDialog = new RJHihAtErrorDialog(dialog, this.supplier);
                rJHihAtErrorDialog.show(arrayList);
                this.centerPanel.init();
            }
        } else {
            int n = this.getErrLevel();
            this.endRequest(n, 0);
        }
    }

    private ArrayList extractError(Object object) {
        ArrayList<HIHsmSetAttributeInfoEx> arrayList = null;
        if (object instanceof ArrayList) {
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof HIHsmSetAttributeInfoEx)) continue;
                HIHsmSetAttributeInfoEx hIHsmSetAttributeInfoEx = (HIHsmSetAttributeInfoEx)e;
                this.putLog(hIHsmSetAttributeInfoEx);
                Robj_interface_HIHsmErrorInfo robj_interface_HIHsmErrorInfo = hIHsmSetAttributeInfoEx.getErrorInfo();
                if (robj_interface_HIHsmErrorInfo.getPartCode() == 0) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<HIHsmSetAttributeInfoEx>();
                }
                arrayList.add(hIHsmSetAttributeInfoEx);
            }
        }
        return arrayList;
    }

    private void putLog(HIHsmSetAttributeInfoEx hIHsmSetAttributeInfoEx) {
        Robj_interface_HIHsmErrorInfo robj_interface_HIHsmErrorInfo = hIHsmSetAttributeInfoEx.getErrorInfo();
        int[] nArray = robj_interface_HIHsmErrorInfo.getErrorCodes();
        this.supplier.putLog("[HIHSM]", "[Apply]", "HIHsmSetAttributeInfoEx [->" + (hIHsmSetAttributeInfoEx.getReserveFlag() == 0 ? "Normal  " : "Reserved") + ", ownerID=" + hIHsmSetAttributeInfoEx.getOwnerID() + ", part=" + robj_interface_HIHsmErrorInfo.getPartCode() + "]");
        if (robj_interface_HIHsmErrorInfo.getPartCode() != 0) {
            String string = null;
            int[] nArray2 = hIHsmSetAttributeInfoEx.getLdkc();
            int[] nArray3 = hIHsmSetAttributeInfoEx.getCu();
            int[] nArray4 = hIHsmSetAttributeInfoEx.getLdev();
            for (int i = 0; i < nArray3.length; ++i) {
                String string2 = ", ";
                if (i % 4 == 0) {
                    if (i != 0) {
                        this.supplier.putLog("[HIHSM]", "[Apply]", string + "]");
                    }
                    string = "    ";
                    string2 = "";
                }
                RJHihLdevElement rJHihLdevElement = new RJHihLdevElement(nArray2[i], nArray3[i], nArray4[i], null, null);
                string = string + string2 + "[" + rJHihLdevElement + ", code=" + nArray[i] + "]";
            }
            this.supplier.putLog("[HIHSM]", "[Apply]", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshButton_actionPerformed(ActionEvent actionEvent) {
        if (!this.refreshDrawing) {
            try {
                this.refreshDrawing = true;
                boolean bl = true;
                this.supplier.putLog("[Attribute]", "[Refresh]", "Button ActionPerformed");
                if (this.chkSts()) {
                    Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
                    RJDataMsg rJDataMsg = this.supplier.getMessage(11009107);
                    int n = this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
                    if (n != 0) {
                        bl = false;
                    }
                }
                if (bl) {
                    this.centerPanel.init();
                }
            }
            finally {
                this.refreshDrawing = false;
            }
        }
    }

    public boolean chgTab() {
        boolean bl = super.chgTab();
        if (bl) {
            try {
                this.centerPanel.refresh();
            }
            catch (RJHihSuperException rJHihSuperException) {
                this.supplier.putLog("[Attribute]", "[chgTab]", "HIHSM :catch RJHihSuperException " + rJHihSuperException.getMessage());
            }
        }
        return bl;
    }
}

