/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.performance.port;

import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import sanproject.client.com.RJcGuide;
import sanproject.client.monitor.com.RJHihChartData;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihDef;
import sanproject.client.monitor.com.RJHihItemChangeAdapter;
import sanproject.client.monitor.com.RJHihTimePair;
import sanproject.client.monitor.performance.RJHihPerfChartAxisComboBox;
import sanproject.client.monitor.performance.RJHihPerfChartPanel;
import sanproject.client.monitor.performance.RJHihPerfPPCTableModel;
import sanproject.client.monitor.performance.RJHihPerfTablePanel;
import sanproject.client.monitor.performance.port.RJHihPortDetailComboBox;
import sanproject.client.monitor.performance.port.RJHihPtLunDetailChartData;

public class RJHihPortChartPanel
extends RJHihPerfChartPanel
implements RJHihDef {
    private JCheckBox DetailCheck = null;
    private RJHihPortDetailComboBox DetailCombo = null;
    private static final Integer[] AxisItems = new Integer[]{new Integer(10), new Integer(20), new Integer(50), new Integer(100), new Integer(200), new Integer(500), new Integer(1000), new Integer(2000), new Integer(5000), new Integer(10000), new Integer(20000), new Integer(50000), new Integer(100000)};
    private RJHihPtLunDetailChartData m_detaildata = null;
    private boolean m_bDetailFlg = false;
    private boolean m_bYAxis_KB_Flg = false;
    private boolean m_bIsLUNSelected = false;
    public RJHihPerfTablePanel tablepanel = null;
    public boolean m_UndoCheckEvent = false;

    public RJHihPortChartPanel(RJHihPerfChartAxisComboBox rJHihPerfChartAxisComboBox, JCheckBox jCheckBox, RJHihPortDetailComboBox rJHihPortDetailComboBox, RJHihPerfTablePanel rJHihPerfTablePanel) {
        super.setAxisYComboBox(rJHihPerfChartAxisComboBox);
        this.DetailCheck = jCheckBox;
        this.DetailCombo = rJHihPortDetailComboBox;
        this.tablepanel = rJHihPerfTablePanel;
        if (rJHihPerfChartAxisComboBox != null) {
            rJHihPerfChartAxisComboBox.setItems((Object[])AxisItems, this);
            rJHihPerfChartAxisComboBox.setMaximumRowCount(11);
        }
        this.DetailCheck.addItemListener(new RJHihItemChangeAdapter(){

            public void itemChanged(ItemEvent itemEvent) {
                RJHihPortChartPanel.this.DetailCheckSelectionChanged(itemEvent);
            }
        });
    }

    public void init(RJHihDataSupplier rJHihDataSupplier) {
        super.init(rJHihDataSupplier);
    }

    protected String getXAxisTitle(RJHihChartData rJHihChartData) {
        MessageFormat messageFormat = new MessageFormat(RJcGuide.text("Port_LUN/AXISXLABEL"));
        String string = messageFormat.format(new String[]{String.valueOf(this.supplier.getMonitoringInfo().getIntervalTime())});
        if (this.DetailCheck.isEnabled() && this.DetailCheck.isSelected()) {
            string = this.getSelectedName(this.tablepanel.getDataModel());
        }
        return string;
    }

    protected String getYAxisTitle(RJHihChartData rJHihChartData) {
        String string = null;
        if (this.DetailCheck != null && this.DetailCombo != null) {
            if (this.DetailCheck.isEnabled() && this.DetailCheck.isSelected()) {
                if (this.DetailCombo.isEnabled()) {
                    int n = this.DetailCombo.getSelectedIndex();
                    if (this.nSelectedRate == CHART_RATE_MB) {
                        n += 3;
                    }
                    if (n == 0) {
                        string = "Port_LUN/AXISSCALELABEL_LUN_DETAIL_IO";
                    } else if (n == 1) {
                        string = "Port_LUN/AXISSCALELABEL_LUN_DETAIL_READ";
                    } else if (n == 2) {
                        string = "Port_LUN/AXISSCALELABEL_LUN_DETAIL_WRITE";
                    } else if (n == 3) {
                        string = "Port_LUN/AXISSCALELABEL_LUN_DETAIL_READHIT";
                    } else if (n == 4) {
                        string = "Port_LUN/AXISSCALELABEL_LUN_DETAIL_WRITEHIT";
                    } else if (n == 5) {
                        string = "Port_LUN/AXISSCALELABEL_LUN_DETAIL_BACKTRANS";
                    }
                } else if (this.nSelectedRate == CHART_RATE_IOPS) {
                    string = "Port_LUN/AXISSCALELABEL_PORT_DETAIL_IO";
                } else if (this.nSelectedRate == CHART_RATE_MB) {
                    string = "Port_LUN/AXISSCALELABEL_PORT_DETAIL_MB";
                }
            } else if (this.nSelectedRate == CHART_RATE_IOPS) {
                string = "Port_LUN/AXISSCALELABEL_IO";
            } else if (this.nSelectedRate == CHART_RATE_MB) {
                string = "Port_LUN/AXISSCALELABEL_MB";
            }
        }
        return RJcGuide.text(string);
    }

    public void setMonitoringRate(int n) {
        int n2 = n == 0 ? RJHihPerfChartPanel.CHART_RATE_IOPS : RJHihPerfChartPanel.CHART_RATE_MB;
        super.setSelectedRate(n2);
    }

    public void setDetailData(RJHihPtLunDetailChartData rJHihPtLunDetailChartData) {
        this.m_detaildata = null;
        this.m_detaildata = rJHihPtLunDetailChartData;
    }

    public void DetailcomboItemChanged(int n) {
        if (this.m_detaildata != null && n != -1 && this.m_drawedchartData != null && this.m_bDetailFlg) {
            if (this.nSelectedRate == CHART_RATE_MB) {
                n += 3;
            }
            RJHihTimePair rJHihTimePair = this.m_drawedchartData.getDrawTerm();
            this.clearChart();
            this.m_drawedchartData = null;
            this.m_drawedchartData = new RJHihChartData();
            this.m_drawedchartData.setDrawTerm(rJHihTimePair);
            this.collectChartData(this.m_drawedchartData, n);
            this.drawScale(this.m_drawedchartData);
            this.drawChart(this.m_drawedchartData);
        }
    }

    private void collectChartData(RJHihChartData rJHihChartData, int n) {
        this.addLabels(rJHihChartData, n);
        this.addChartValues(rJHihChartData, n);
        rJHihChartData.completeLabels();
        rJHihChartData.completeChartValues();
    }

    private void addLabels(RJHihChartData rJHihChartData, int n) {
        if (n == 0) {
            rJHihChartData.addLabel(new String(RJcGuide.text("Port_LUN/CHARTLEGEND_IO_SEQ")));
            rJHihChartData.addLabel(new String(RJcGuide.text("Port_LUN/CHARTLEGEND_IO_RND")));
        } else if (n == 1) {
            rJHihChartData.addLabel(new String(RJcGuide.text("Port_LUN/CHARTLEGEND_READ_SEQ")));
            rJHihChartData.addLabel(new String(RJcGuide.text("Port_LUN/CHARTLEGEND_READ_RND")));
        } else if (n == 2) {
            rJHihChartData.addLabel(new String(RJcGuide.text("Port_LUN/CHARTLEGEND_WRITE_SEQ")));
            rJHihChartData.addLabel(new String(RJcGuide.text("Port_LUN/CHARTLEGEND_WRITE_RND")));
        } else if (n == 3) {
            rJHihChartData.addLabel(new String(RJcGuide.text("Port_LUN/CHARTLEGEND_READHIT_SEQ")));
            rJHihChartData.addLabel(new String(RJcGuide.text("Port_LUN/CHARTLEGEND_READHIT_RND")));
        } else if (n == 4) {
            rJHihChartData.addLabel(new String(RJcGuide.text("Port_LUN/CHARTLEGEND_WRITEHIT_SEQ")));
            rJHihChartData.addLabel(new String(RJcGuide.text("Port_LUN/CHARTLEGEND_WRITEHIT_RND")));
        } else if (n == 5) {
            rJHihChartData.addLabel(new String(RJcGuide.text("Port_LUN/CHARTLEGEND_BACKTRANS_CTD")));
            rJHihChartData.addLabel(new String(RJcGuide.text("Port_LUN/CHARTLEGEND_BACKTRANS_DTC_SEQ")));
            rJHihChartData.addLabel(new String(RJcGuide.text("Port_LUN/CHARTLEGEND_BACKTRANS_DTC_RND")));
        }
    }

    private void addChartValues(RJHihChartData rJHihChartData, int n) {
        RJHihPtLunDetailChartData rJHihPtLunDetailChartData;
        if (this.DetailCheck.isEnabled() && this.DetailCheck.isSelected() && this.DetailCombo.isEnabled() && (rJHihPtLunDetailChartData = this.m_detaildata) != null) {
            switch (n) {
                case 0: {
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nIOSeq, null);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nIORnd, null);
                    break;
                }
                case 1: {
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nReadSeq, null);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nReadRnd, null);
                    break;
                }
                case 2: {
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nWriteSeq, null);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nWriteRnd, null);
                    break;
                }
                case 3: {
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nReadHitSeq, null);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nReadHitRnd, null);
                    break;
                }
                case 4: {
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nWriteHitSeq, null);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nWriteHitRnd, null);
                    break;
                }
                case 5: {
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nBackTransCtoD, null);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nBackTransDtoCSeq, null);
                    rJHihChartData.addChartValues((Object)rJHihPtLunDetailChartData.nBackTransDtoCRnd, null);
                    break;
                }
            }
        }
    }

    public void SetDetailFlg(boolean bl) {
        this.m_bDetailFlg = bl;
    }

    public void ClearDrawedChartData() {
        this.m_drawedchartData = null;
        this.m_detaildata = null;
        this.m_bDetailFlg = false;
        this.m_bIsLUNSelected = false;
        this.DetailCheck.setSelected(false);
    }

    public void setYAxisKB(boolean bl) {
        this.m_bYAxis_KB_Flg = bl;
    }

    private void DetailCheckSelectionChanged(ItemEvent itemEvent) {
        if (!this.m_UndoCheckEvent) {
            if (this.m_bIsLUNSelected) {
                this.DetailCombo.setEnabled(this.DetailCheck.isSelected());
            }
            RJHihChartData rJHihChartData = new RJHihChartData();
            rJHihChartData.setDrawTerm(this.supplier.getMonitoringInfo().getMonitoringTime());
            ((RJHihPerfPPCTableModel)this.tablepanel.getDataModel()).collectCacheChartData(rJHihChartData);
            this.drawScale(rJHihChartData);
            this.drawChart(rJHihChartData);
        }
    }

    public void SetLUNSelected() {
        this.m_bIsLUNSelected = true;
    }
}

