/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.dctl;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import sanproject.client.com.RJComFuncPanel;
import sanproject.client.data.RJDataControl;
import sanproject.client.openldevguard.dctl.DruOperation;
import sanproject.client.openldevguard.dctl.ManageDeleteAllExtents;
import sanproject.client.openldevguard.dctl.ManageExpirationLock;
import sanproject.client.openldevguard.dctl.ManageGuardRetention;
import sanproject.client.openldevguard.dctl.ManageLdevInfo;
import sanproject.client.openldevguard.dctl.ManageLdkcCu;
import sanproject.client.openldevguard.dctl.ManageRsgInfo;
import sanproject.client.openldevguard.dctl.ManageVmaInfo;
import sanproject.client.openldevguard.dctl.OperationNothing;
import sanproject.client.openldevguard.dctl.RJODGDApplyEndListener;
import sanproject.client.openldevguard.dctl.RJODGDApplyThread;
import sanproject.client.openldevguard.dctl.RJODGDErrInfo;
import sanproject.client.openldevguard.dctl.RJODGDException;
import sanproject.client.openldevguard.dctl.RJODGDLdev;
import sanproject.client.openldevguard.dctl.com.ManageReadDataInterface;
import sanproject.client.openldevguard.dctl.com.ManageReadWriteDataInterface;
import sanproject.client.openldevguard.dctl.com.Mediator;
import sanproject.client.openldevguard.dctl.com.Operation;
import sanproject.client.openldevguard.dctl.extent.RJODGDExtentManager;
import sanproject.client.openldevguard.gui.logging.Logger;
import sanproject.serverux.dataimpl.SanRmiOutputInterface;

public class RJODGDDataControl
implements Mediator {
    private static final int ERP_CLIENT = 9610;
    private static final int ERC_UNKNOWN_ERR = 7060;
    private static final int ERC_NO_VOL = 8112;
    private final RJDataControl commonDataControl;
    private final String logName;
    private ArrayList applyEndListener;
    private ArrayList errorInfoList;
    private boolean noVolMsgFlg;
    private DruOperation operation;
    private int hasLdkcNumber;
    private int hasCuGroup;
    private int selectLdkcNumber;
    private int selectCuGroup;
    private ArrayList managerList;
    private ManageLdkcCu ldkcCuManager;
    private ManageGuardRetention guardRetentionManager;
    private ManageVmaInfo vmaInfoManager;
    private ManageDeleteAllExtents deleteAllExtentsManager;
    private ManageExpirationLock expirationLockManager;
    private RJODGDExtentManager extentManager;
    private ManageRsgInfo rsgInfoManager;
    private ManageLdevInfo ldevInfoManager;

    public RJODGDDataControl(RJDataControl rJDataControl) throws RJODGDException {
        this.commonDataControl = rJDataControl;
        this.logName = "DataControl";
        this.operation = OperationNothing.getInstance();
        RJODGDErrInfo.clearMassageCache();
        this.noVolMsgFlg = true;
        this.hasLdkcNumber = -1;
        this.hasCuGroup = -1;
        this.selectLdkcNumber = -1;
        this.selectCuGroup = -1;
        this.applyEndListener = new ArrayList();
        this.errorInfoList = new ArrayList();
        this.managerList = new ArrayList();
        this.ldkcCuManager = new ManageLdkcCu(this);
        this.rsgInfoManager = new ManageRsgInfo(this);
        this.ldevInfoManager = new ManageLdevInfo(this);
        this.guardRetentionManager = new ManageGuardRetention(this);
        this.vmaInfoManager = new ManageVmaInfo(this);
        this.deleteAllExtentsManager = new ManageDeleteAllExtents(this);
        this.expirationLockManager = new ManageExpirationLock(this);
        this.extentManager = new RJODGDExtentManager(this);
    }

    public void initStructure() throws RJODGDException {
        Iterator iterator;
        long l = System.currentTimeMillis();
        Logger.put(Level.FINE, this.logName, "The initialization of the base data begins.");
        this.operation = OperationNothing.getInstance();
        this.hasLdkcNumber = -1;
        this.hasCuGroup = -1;
        this.extentManager.clearExtent();
        int n = this.getFuncOption();
        this.initManagerFuncOption(n);
        List list = this.getDataManager(2);
        list.addAll(this.getDataManager(3));
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            iterator = (ManageReadDataInterface)iterator2.next();
            this.initManagerData((ManageReadDataInterface)((Object)iterator));
        }
        long l2 = System.currentTimeMillis();
        iterator = new StringBuffer("The initialization of the base data ends. ");
        ((StringBuffer)((Object)iterator)).append("<Time = ").append(l2 - l).append(" ms>");
        Logger.put(Level.FINE, this.logName, ((StringBuffer)((Object)iterator)).toString());
        iterator = this.ldkcCuManager.getLdkcList().iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            ArrayList arrayList = this.ldkcCuManager.getCuGroupList(n2);
            if (arrayList.size() <= 0) continue;
            this.noVolMsgFlg = false;
            break;
        }
        if (this.noVolMsgFlg) {
            this.noVolMsgFlg = false;
            throw new RJODGDException(9610, 8112);
        }
    }

    private int getFuncOption() throws RJODGDException {
        String string = System.getProperty("user.home") + File.separator + ".webconsole" + File.separator + "debug.properties";
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = properties.getProperty("FuncOption", "00000000");
        int n = (int)Long.parseLong(string2, 16);
        return n;
    }

    private void initManagerFuncOption(int n) {
        List list = this.getDataManagerSub(0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManageReadDataInterface manageReadDataInterface = (ManageReadDataInterface)iterator.next();
            manageReadDataInterface.setFuncOption(n);
        }
    }

    private void initData() throws RJODGDException {
        if (this.isChangeDisplayedArea()) {
            long l = System.currentTimeMillis();
            Object object = new StringBuffer("The initialization of the detail data begins. ");
            ((StringBuffer)object).append("<LDKC = ").append(this.selectLdkcNumber).append("> ");
            ((StringBuffer)object).append("<CU Group = ").append(this.selectCuGroup).append(">");
            Logger.put(Level.FINE, this.logName, ((StringBuffer)object).toString());
            object = this.getDataManagerSub(4);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ManageReadDataInterface manageReadDataInterface = (ManageReadDataInterface)iterator.next();
                this.initManagerData(manageReadDataInterface);
            }
            this.hasLdkcNumber = this.selectLdkcNumber;
            this.hasCuGroup = this.selectCuGroup;
            long l2 = System.currentTimeMillis();
            StringBuffer stringBuffer = new StringBuffer("The initialization of the detail data ends. ");
            stringBuffer.append("<Time = ").append(l2 - l).append(" ms>");
            Logger.put(Level.FINE, this.logName, stringBuffer.toString());
        }
    }

    private void initManagerData(ManageReadDataInterface manageReadDataInterface) throws RJODGDException {
        try {
            StringBuffer stringBuffer = new StringBuffer("    ");
            stringBuffer.append(manageReadDataInterface.getClass().getName());
            stringBuffer.append(".initData()");
            Logger.put(Level.FINE, this.logName, stringBuffer.toString());
            long l = System.currentTimeMillis();
            manageReadDataInterface.initData();
            long l2 = System.currentTimeMillis();
            StringBuffer stringBuffer2 = new StringBuffer("    initData() return. <Time = ");
            stringBuffer2.append(l2 - l).append(" ms>");
            Logger.put(Level.FINE, this.logName, stringBuffer2.toString());
        }
        catch (RJODGDException rJODGDException) {
            Logger.put(Level.WARNING, this.logName, rJODGDException.getMessage());
            throw rJODGDException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.put(Level.WARNING, this.logName, exception.getMessage());
            throw new RJODGDException(9610, 7060);
        }
    }

    private boolean isChangeDisplayedArea() {
        return this.hasLdkcNumber != this.selectLdkcNumber || this.hasCuGroup != this.selectCuGroup;
    }

    protected void createErrInfo(Object[] objectArray) throws ClassCastException {
        this.errorInfoList.clear();
        List list = this.getDataManagerRW(3);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof SanRmiOutputInterface) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ManageReadWriteDataInterface manageReadWriteDataInterface = (ManageReadWriteDataInterface)iterator.next();
                    List list2 = manageReadWriteDataInterface.makeErrInfo((SanRmiOutputInterface)objectArray[i]);
                    this.errorInfoList.addAll(list2);
                }
                continue;
            }
            throw new ClassCastException(objectArray[i].getClass().getName());
        }
        String string = this.errorInfoList.size() + " errors created.";
        Logger.put(Level.FINE, this.logName, string);
    }

    protected List getApplyData() {
        Object object;
        ArrayList arrayList = new ArrayList();
        List list = this.getDataManagerRW(3);
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (ManageReadWriteDataInterface)object2.next();
            if (!object.isModify()) continue;
            List list2 = object.makeApplyData();
            arrayList.addAll(list2);
        }
        object2 = arrayList.size() + " Apply data created.";
        Logger.put(Level.FINE, this.logName, (String)object2);
        object = arrayList.iterator();
        while (object.hasNext()) {
            Logger.put(Level.FINE, this.logName, "    --> " + object.next().getClass().getName());
        }
        return arrayList;
    }

    protected List getApplyEndListener() {
        return this.applyEndListener;
    }

    protected DruOperation getOperationState() {
        return this.operation;
    }

    protected ManageGuardRetention getGuardRetentionManager() {
        return this.guardRetentionManager;
    }

    protected ManageVmaInfo getSetVmaDataManager() {
        return this.vmaInfoManager;
    }

    protected ManageDeleteAllExtents getDeleteAllExtentsManager() {
        return this.deleteAllExtentsManager;
    }

    protected ManageExpirationLock getExpirationLockManager() {
        return this.expirationLockManager;
    }

    protected ManageRsgInfo getRsgInfoManager() {
        return this.rsgInfoManager;
    }

    protected ManageLdevInfo getLdevInfoManager() {
        return this.ldevInfoManager;
    }

    public List getDataManager(int n) {
        ArrayList<ManageReadDataInterface> arrayList = new ArrayList<ManageReadDataInterface>();
        Iterator iterator = this.managerList.iterator();
        while (iterator.hasNext()) {
            ManageReadDataInterface manageReadDataInterface = (ManageReadDataInterface)iterator.next();
            if (manageReadDataInterface.getDataPriority() != n) continue;
            arrayList.add(manageReadDataInterface);
        }
        return arrayList;
    }

    public List getDataManagerRW(int n) {
        ArrayList<ManageReadDataInterface> arrayList = new ArrayList<ManageReadDataInterface>();
        Iterator iterator = this.managerList.iterator();
        while (iterator.hasNext()) {
            ManageReadDataInterface manageReadDataInterface = (ManageReadDataInterface)iterator.next();
            if (!(manageReadDataInterface instanceof ManageReadWriteDataInterface) || manageReadDataInterface.getDataPriority() < n) continue;
            arrayList.add(manageReadDataInterface);
        }
        return arrayList;
    }

    public List getDataManagerSub(int n) {
        ArrayList<ManageReadDataInterface> arrayList = new ArrayList<ManageReadDataInterface>();
        Iterator iterator = this.managerList.iterator();
        while (iterator.hasNext()) {
            ManageReadDataInterface manageReadDataInterface = (ManageReadDataInterface)iterator.next();
            if (manageReadDataInterface.getDataPriority() < n) continue;
            arrayList.add(manageReadDataInterface);
        }
        return arrayList;
    }

    public void notifyOperation(Operation operation) {
        if (this.operation.equals(OperationNothing.getInstance())) {
            this.operation = (DruOperation)operation;
        } else if (operation.equals(OperationNothing.getInstance())) {
            boolean bl;
            ManageReadWriteDataInterface manageReadWriteDataInterface;
            List list = this.getDataManagerRW(3);
            Iterator iterator = list.iterator();
            for (bl = false; !bl && iterator.hasNext(); bl |= manageReadWriteDataInterface.isModify()) {
                manageReadWriteDataInterface = (ManageReadWriteDataInterface)iterator.next();
            }
            if (!bl) {
                this.operation = OperationNothing.getInstance();
            }
        }
    }

    public void setDataManager(ManageReadDataInterface manageReadDataInterface) {
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof ManageReadDataInterface && object2 instanceof ManageReadDataInterface) {
                    int n;
                    int n2 = 0;
                    int n3 = ((ManageReadDataInterface)object).getDataPriority();
                    if (n3 < (n = ((ManageReadDataInterface)object2).getDataPriority())) {
                        n2 = -1;
                    } else if (n3 > n) {
                        n2 = 1;
                    }
                    return n2;
                }
                throw new ClassCastException();
            }
        };
        this.managerList.add(manageReadDataInterface);
        Collections.sort(this.managerList, comparator);
    }

    public int getLdkc() {
        return this.selectLdkcNumber;
    }

    public int getCuGroup() {
        return this.selectCuGroup;
    }

    public int getOperation() {
        return this.operation.getOperation();
    }

    public boolean addApplyEndListener(RJODGDApplyEndListener rJODGDApplyEndListener) {
        return this.applyEndListener.add(rJODGDApplyEndListener);
    }

    public void pushParentPanel(RJComFuncPanel rJComFuncPanel) {
        List list = this.getDataManagerSub(0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManageReadDataInterface manageReadDataInterface = (ManageReadDataInterface)iterator.next();
            manageReadDataInterface.pushParentPanel(rJComFuncPanel);
        }
    }

    public void applyStart() throws RJODGDException {
        RJODGDApplyThread rJODGDApplyThread = new RJODGDApplyThread(this);
        rJODGDApplyThread.setDataControl(this.commonDataControl);
        rJODGDApplyThread.start();
    }

    public RJODGDErrInfo[] getErrInfo() {
        return this.errorInfoList.toArray(new RJODGDErrInfo[0]);
    }

    public ArrayList getEquipLdkcList() {
        return this.ldkcCuManager.getLdkcList();
    }

    public ArrayList getEquipCuGroupList(int n) {
        return this.ldkcCuManager.getCuGroupList(n);
    }

    public ArrayList getEquipCuList(int n, int n2) {
        this.selectLdkcNumber = n;
        this.selectCuGroup = n2;
        return this.ldkcCuManager.getCuList(n, n2);
    }

    public int[] getEquipCuBitmap() {
        return this.ldkcCuManager.getCuBitmap(this.selectLdkcNumber, this.selectCuGroup);
    }

    public ArrayList getEquipLDEVIndex() {
        return this.guardRetentionManager.getEquipLDEVIndex();
    }

    public RJODGDLdev[] getLdevs(int n) throws RJODGDException {
        ArrayList<RJODGDLdev> arrayList = new ArrayList<RJODGDLdev>();
        this.initData();
        for (int i = 0; i < 256; ++i) {
            if (!this.ldevInfoManager.isDruVolume(this.hasLdkcNumber, n, i)) continue;
            arrayList.add(new RJODGDLdev(this, this.hasLdkcNumber, n, i));
        }
        return arrayList.toArray(new RJODGDLdev[0]);
    }

    public void initChangeData() {
        long l = System.currentTimeMillis();
        this.operation = OperationNothing.getInstance();
        List list = this.getDataManagerRW(3);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManageReadWriteDataInterface manageReadWriteDataInterface = (ManageReadWriteDataInterface)iterator.next();
            manageReadWriteDataInterface.initChangeData();
        }
        long l2 = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer("The change data is cleared. ");
        stringBuffer.append("<Time = ").append(l2 - l).append(" ms>");
        Logger.put(Level.FINE, this.logName, stringBuffer.toString());
    }

    public void updateData() {
        long l = System.currentTimeMillis();
        Logger.put(Level.FINE, this.logName, "The update of detailed data begins.");
        this.operation = OperationNothing.getInstance();
        List list = this.getDataManagerRW(3);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManageReadWriteDataInterface manageReadWriteDataInterface = (ManageReadWriteDataInterface)iterator.next();
            manageReadWriteDataInterface.updateData();
        }
        long l2 = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer("The update of detailed data ends. ");
        stringBuffer.append("<Time = ").append(l2 - l).append(" ms>");
        Logger.put(Level.FINE, this.logName, stringBuffer.toString());
    }

    public boolean isSupportFunctionVma() {
        return this.vmaInfoManager.isSupport();
    }

    public boolean isSupportFunctionExtent() {
        return this.deleteAllExtentsManager.isSupport();
    }

    public boolean canChgAuditLockStatus() {
        return this.operation.canChgExpirationLock();
    }

    public boolean getAuditLockStatus() {
        return this.expirationLockManager.isLocked();
    }

    public boolean chgAuditLockStatus() {
        return this.expirationLockManager.chgLockStatus();
    }

    public RJODGDExtentManager getExtentManager() {
        return this.extentManager;
    }

    public Collection getMultiSettingData() {
        return this.deleteAllExtentsManager.getDeleteAllExtentsData();
    }

    public void setAllReleaseList(ArrayList arrayList) {
        this.deleteAllExtentsManager.deleteAllExtents(arrayList);
    }

    public void setAllDefaultList(List list) {
    }

    public void setCopyList(List list, int n, int n2) {
    }
}

