/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.dctl.extent;

import java.util.logging.Level;
import sanproject.client.openldevguard.dctl.RJODGDDataControl;
import sanproject.client.openldevguard.dctl.RJODGDException;
import sanproject.client.openldevguard.dctl.extent.ManageExtentInfo;
import sanproject.client.openldevguard.dctl.extent.RJODGDLbaManager;
import sanproject.client.openldevguard.gui.logging.Logger;

public class RJODGDExtentManager {
    private final String logName;
    private int hasLdkcNumber;
    private int hasCuNumber;
    private int hasLdevNumber;
    private ManageExtentInfo extentInfoManager;

    public RJODGDExtentManager(RJODGDDataControl rJODGDDataControl) {
        this.logName = "ExtManager";
        this.extentInfoManager = new ManageExtentInfo(rJODGDDataControl);
        this.clearExtent();
    }

    public void clearExtent() {
        this.hasLdkcNumber = -1;
        this.hasCuNumber = -1;
        this.hasLdevNumber = -1;
    }

    public void initExtent(int n, int n2, int n3, long l, int n4) throws RJODGDException {
        if (this.isChangeDisplayedArea(n, n2, n3)) {
            StringBuffer stringBuffer = new StringBuffer("The initialization of the Extent detail data begins. ");
            stringBuffer.append("<LDKC = ").append(n).append(">");
            stringBuffer.append("<CU = ").append(n2).append(">");
            stringBuffer.append("<LDEV = ").append(n3).append("> ");
            Logger.put(Level.FINE, this.logName, stringBuffer.toString());
            this.extentInfoManager.initExtentInfo(n, n2, n3, l, n4);
            this.hasLdkcNumber = this.extentInfoManager.getLdkcNumber();
            this.hasCuNumber = this.extentInfoManager.getCuNumber();
            this.hasLdevNumber = this.extentInfoManager.getLdevNumber();
            Logger.put(Level.FINE, this.logName, "The initialization of the Extent detail data ends.");
        }
    }

    public long getCapacity(int n) {
        return this.extentInfoManager.getCapacity(n);
    }

    public byte getGuard(int n) {
        return this.extentInfoManager.getGuard(n);
    }

    public long getLbaEnd(int n) {
        return this.extentInfoManager.getLbaEnd(n);
    }

    public RJODGDLbaManager getLbaManager() {
        return new RJODGDLbaManager(0L, this.extentInfoManager.getExtentRangeMax());
    }

    public long getLbaStart(int n) {
        return this.extentInfoManager.getLbaStart(n);
    }

    public byte getShredProgress(int n) {
        return this.extentInfoManager.getShredProgress(n);
    }

    public byte getShredState(int n) {
        return this.extentInfoManager.getShredState(n);
    }

    public int getTerm(int n) {
        return this.extentInfoManager.getTerm(n);
    }

    public int getTotalExtent() {
        return this.extentInfoManager.getTotalExtent();
    }

    public boolean isChangeDisplayedArea(int n, int n2, int n3) {
        return this.hasLdkcNumber != n || this.hasCuNumber != n2 || this.hasLdevNumber != n3;
    }

    public boolean isSetExtent(int n) {
        return this.extentInfoManager.isSetExtent(n);
    }

    public boolean isShred(int n) {
        return this.getShredState(n) == 1;
    }

    public boolean isSupprtExtent() {
        return this.extentInfoManager.isSupport();
    }

    public boolean canCancelShred(int n) {
        return false;
    }

    public void cancelShred(int n) {
    }

    public boolean canChgAttribute(int n) {
        return false;
    }

    public boolean canChgTerm(int n) {
        return false;
    }

    public boolean canReleaseExtent(int n) {
        return false;
    }

    public boolean canSetExtent(int n) {
        return false;
    }

    public byte getOldGuard(int n) {
        return this.getGuard(n);
    }

    public int getOldTerm(int n) {
        return this.getTerm(n);
    }

    public int getShredProgress() {
        return 0;
    }

    public boolean isModify(int n) {
        return false;
    }

    public void releaseExtent(int n) {
    }

    public void setExtent(int n, long l, long l2, byte by) {
    }

    public void setExtReleaseShred(boolean bl) {
    }

    public void setGuard(int n, byte by) {
    }

    public void setTerm(int n, int n2) {
    }
}

