/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import sanproject.client.com.RJComFuncPanel;
import sanproject.client.com.RJcTabPanel;
import sanproject.client.data.RJDataControl;
import sanproject.client.openldevguard.color.ColorManager;
import sanproject.client.openldevguard.gui.DataControlWrapper;
import sanproject.client.openldevguard.gui.DefaultDataControlWrapper;
import sanproject.client.openldevguard.gui.DefaultFuncPanel;
import sanproject.client.openldevguard.gui.GuidanceColorModel;
import sanproject.client.openldevguard.gui.OpenLDEVGuardException;

public abstract class AbstractComPanel
extends RJcTabPanel {
    protected static final Level SEVERE = Level.SEVERE;
    protected static final Level WARNING = Level.WARNING;
    protected static final Level INFO = Level.INFO;
    protected static final Level CONFIG = Level.CONFIG;
    protected static final Level FINE = Level.FINE;
    protected static final Level FINER = Level.FINER;
    protected static final Level FINEST = Level.FINEST;
    private final DataControlWrapper mdcwCurrentWrapper;
    protected static final int END_REQUEST_APPLY = 1;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$sanproject$client$openldevguard$gui$DefaultFuncPanel;

    public AbstractComPanel() {
        DataControlWrapper dataControlWrapper;
        this.initInstance();
        RJDataControl rJDataControl = this.getDataCtl();
        try {
            dataControlWrapper = this.createDataControlWrapper(rJDataControl);
            if (dataControlWrapper == null) {
                dataControlWrapper = new DefaultDataControlWrapper(rJDataControl);
            }
        }
        catch (OpenLDEVGuardException openLDEVGuardException) {
            openLDEVGuardException.printStackTrace(System.err);
            dataControlWrapper = null;
        }
        this.mdcwCurrentWrapper = dataControlWrapper;
        ColorManager colorManager = ColorManager.getInstance();
        GuidanceColorModel guidanceColorModel = new GuidanceColorModel(rJDataControl);
        colorManager.setModel(guidanceColorModel);
        Color color = colorManager.getPanelForeground();
        Color color2 = colorManager.getPanelBackground();
        this.setOpaque(true);
        this.setForeground(color);
        this.setBackground(color2);
    }

    public abstract int getFunctionID();

    public abstract String getProductNumber();

    public abstract String getTabTitle();

    public abstract void createPanel() throws OpenLDEVGuardException;

    public abstract void destroyPanel();

    public abstract boolean isPanelEnabledInStartingFromSVP();

    protected final synchronized void openWaitDialog() {
        this.openWaitDialog(null);
    }

    protected final synchronized void openWaitDialog(Runnable runnable) {
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = AbstractComPanel.class$("java.awt.Frame")) : class$java$awt$Frame, this);
        this.mdcwCurrentWrapper.openWaitDialog(frame, runnable);
    }

    protected final synchronized void closeWaitDialog() {
        this.mdcwCurrentWrapper.closeWaitDialog();
    }

    protected void setFrameEnabled(boolean bl) {
        DefaultFuncPanel defaultFuncPanel = (DefaultFuncPanel)SwingUtilities.getAncestorOfClass(class$sanproject$client$openldevguard$gui$DefaultFuncPanel == null ? (class$sanproject$client$openldevguard$gui$DefaultFuncPanel = AbstractComPanel.class$("sanproject.client.openldevguard.gui.DefaultFuncPanel")) : class$sanproject$client$openldevguard$gui$DefaultFuncPanel, this);
        if (defaultFuncPanel != null) {
            defaultFuncPanel.setFrameEnabled(bl);
        }
    }

    protected final boolean isEditable() {
        DataControlWrapper dataControlWrapper = this.getWrapper();
        boolean bl = this.hasProductWritePermission() && dataControlWrapper.isModifyMode();
        return bl;
    }

    public final boolean isProductInstalled() {
        String string = this.getProductNumber();
        boolean bl = this.getTabID().isPPInstalled(string);
        return bl;
    }

    public final boolean hasProductTabOption() {
        boolean bl = this.getTabID().hasTabOption();
        return bl;
    }

    public final boolean hasProductWritePermission() {
        boolean bl = this.getTabID().hasWritePermission();
        return bl;
    }

    public final boolean isBootFromSVP() {
        boolean bl = this.getTabID().isSVP();
        return bl;
    }

    public final DataControlWrapper getWrapper() {
        return this.mdcwCurrentWrapper;
    }

    protected final void setWaitCursor() {
        Cursor cursor = new Cursor(3);
        this.setCursor(cursor);
    }

    protected final void setDefaultCursor() {
        Cursor cursor = new Cursor(0);
        this.setCursor(cursor);
    }

    protected abstract DataControlWrapper createDataControlWrapper(RJDataControl var1) throws OpenLDEVGuardException;

    public void endRequest(int n) {
        if (n != 10) {
            super.endRequest(n);
        }
        if (n != 6 && n != 7) {
            this.setFrameEnabled(true);
        }
    }

    public int endRequest(int n, int n2) {
        int n3 = super.endRequest(n, n2);
        switch (n) {
            case 0: 
            case 4: 
            case 5: {
                n3 = 1;
            }
        }
        if (n3 == 1) {
            this.setFrameEnabled(true);
        }
        return n3;
    }

    public void rmvObj() {
        this.destroyPanel();
        super.rmvObj();
    }

    public void setParent(Component component) {
        super.setParent(component);
        this.mdcwCurrentWrapper.pushParentPanel((RJComFuncPanel)component);
    }

    public JPanel getMyPanel() {
        return this;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

