/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import sanproject.client.com.RJCom;
import sanproject.client.data.RJDataControl;
import sanproject.client.openldevguard.gui.logging.DataControlRecord;

public class DataControlHandler
extends Handler {
    private final List maltRecordList;
    private RJDataControl mrdcController;

    public DataControlHandler(RJDataControl rJDataControl) {
        this.mrdcController = rJDataControl;
        this.maltRecordList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void publish(LogRecord logRecord) {
        if (this.isLoggable(logRecord)) {
            List list = this.maltRecordList;
            synchronized (list) {
                this.maltRecordList.add(logRecord);
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        ArrayList arrayList;
        List list = this.maltRecordList;
        synchronized (list) {
            arrayList = new ArrayList(this.maltRecordList);
            this.maltRecordList.clear();
        }
        list = Collections.synchronizedList(arrayList);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LogRecord logRecord = (LogRecord)iterator.next();
            this.flushDataControl(logRecord);
        }
    }

    public final void close() {
    }

    public final boolean isLoggable(LogRecord logRecord) {
        boolean bl = false;
        if (this.mrdcController != null) {
            bl = super.isLoggable(logRecord);
        }
        return bl;
    }

    private void flushDataControl(LogRecord logRecord) {
        if (logRecord instanceof DataControlRecord) {
            DataControlRecord dataControlRecord = (DataControlRecord)logRecord;
            String string = dataControlRecord.getPPName();
            String string2 = dataControlRecord.getKeyName();
            String string3 = dataControlRecord.getMessage();
            RJCom.putLog(this.mrdcController, string, string2, string3, 0);
        } else {
            Level level = logRecord.getLevel();
            String string = logRecord.getMessage();
            DataControlRecord dataControlRecord = new DataControlRecord(level, string);
            this.flushDataControl(dataControlRecord);
        }
    }
}

