/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.server.adapters.ih.common;

import com.ws.utilities.CipherUtilities;
import com.ws.wbem.client.adapter.common.TLSInfo;
import com.ws.wbem.jserver.DaemonThreadFactory;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.profiles.common.WSBaseProvider;
import com.ws.wbem.server.services.indication.IndicationDeliveryInfo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.WBEMClient;
import javax.wbem.provider.ProviderHandle;

public abstract class IndicationHandler
extends WSBaseProvider
implements com.ws.wbem.jserver.IndicationHandler {
    private final int SUBSCRIPTION_REMOVAL_ACTION_REMOVE = 2;
    private final int SUBSCRIPTION_REMOVAL_ACTION_DISABLE = 3;
    private final int SUBSCRIPTION_STATE_DISABLE = 4;
    protected final int DEFAULT_RETRIES = 3;
    protected final int DEFAULT_RETRY_WAIT = 30;
    protected final int DEFAULT_SUBSCRIPTION_REMOVAL_ACTION = 2;
    protected final long DEFAULT_SUBSCRIPTION_REMOVAL_TIME_INTERVAL = 2592000000L;
    protected int mRetries = 3;
    protected int mRetryWait = 30;
    protected int mSubscriptionRemovalAction = 2;
    protected int mClientTimeout = 3000;
    public static final String CPN_DESTINATION = "Destination";
    public static final String CPN_DELIVERYRETRYATTEMPTS = "DeliveryRetryAttempts";
    public static final String CPN_DELIVERYRETRYINTERVAL = "DeliveryRetryInterval";
    public static final String CPN_SUBSCRIPTIONREMOVALACTION = "SubscriptionRemovalAction";
    public static final String CPN_SUBSCRIPTIONREMOVALTIMEINTERVAL = "SubscriptionRemovalTimeInterval";
    public static final String CPN_SUBSCRIPTIONSTATE = "SubscriptionState";
    protected final Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    protected WBEMClient mWBEMClient;
    protected boolean mStarted = false;
    protected CIMInstance mInstIndicationHandler;
    protected final Map<String, LinkedBlockingQueue<IndicationDeliveryInfo>> currentIndicationsMap = Collections.synchronizedMap(new HashMap());
    protected final Map<CIMObjectPath, FailedSubscriptionInfo> mFailedSubscriptionHash;
    protected long mSubscriptionRemovalTimeInterval = 2592000000L;
    private static final int DELIVERY_THREADS = 40;
    private final ThreadPoolExecutor deliveryExecutor = new ThreadPoolExecutor(1, 40, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new DaemonThreadFactory());
    private final FailedSubscriptionMonitorTask mFailedSubscriptionMonitorTask;
    private final String CN_INDICATIONSERVICE = "CIM_IndicationService";
    protected TLSInfo mTLSInfo;

    public IndicationHandler() {
        this.mFailedSubscriptionHash = Collections.synchronizedMap(new HashMap());
        this.mFailedSubscriptionMonitorTask = new FailedSubscriptionMonitorTask();
        this.deliveryExecutor.execute(this.mFailedSubscriptionMonitorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverEvent(CIMInstance cIMInstance, CIMInstance cIMInstance2, CIMInstance cIMInstance3) {
        if (!this.mStarted) {
            this.mLogger.severe("Tried to deliver HTTP Indication but service is stopped");
            return;
        }
        if (cIMInstance == null) {
            this.mLogger.severe("deliverIndication was called but the specified indication was null");
            return;
        }
        String string = (String)cIMInstance2.getPropertyValue(CPN_DESTINATION);
        if (string == null) {
            this.mLogger.log(Level.SEVERE, "Cannot deliver event because \"Destination\" value of the listener instance is null:\n{0}", cIMInstance2);
            return;
        }
        IndicationDeliveryInfo indicationDeliveryInfo = new IndicationDeliveryInfo(UUID.randomUUID().toString(), cIMInstance, cIMInstance2, cIMInstance3);
        boolean bl = false;
        LinkedBlockingQueue<IndicationDeliveryInfo> linkedBlockingQueue = null;
        Object object = this.currentIndicationsMap;
        synchronized (object) {
            linkedBlockingQueue = this.currentIndicationsMap.get(string);
            if (null != linkedBlockingQueue) {
                linkedBlockingQueue.add(indicationDeliveryInfo);
            } else {
                linkedBlockingQueue = new LinkedBlockingQueue();
                linkedBlockingQueue.add(indicationDeliveryInfo);
                this.currentIndicationsMap.put(string, linkedBlockingQueue);
                bl = true;
            }
        }
        if (bl) {
            object = new DeliverIndicationTask(string, linkedBlockingQueue);
            this.deliveryExecutor.execute((Runnable)object);
        }
    }

    protected abstract DeliveryStatus deliverIndication(Object var1, CIMInstance var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deliveryFailure(IndicationDeliveryInfo indicationDeliveryInfo, long l) {
        block18: {
            try {
                CIMObjectPath cIMObjectPath;
                block19: {
                    if (this.mSubscriptionRemovalAction != 2 && this.mSubscriptionRemovalAction != 3) break block18;
                    cIMObjectPath = indicationDeliveryInfo.getSubscription().getObjectPath();
                    try {
                        this.mWBEMClient.getInstance(cIMObjectPath, null);
                    }
                    catch (WBEMException wBEMException) {
                        if (wBEMException.getID() != 6) break block19;
                        return;
                    }
                }
                this.mLogger.log(Level.FINEST, "Indication from Subscription, {0}, has failed.  Check now many times", new Object[]{cIMObjectPath});
                Map<CIMObjectPath, FailedSubscriptionInfo> map = this.mFailedSubscriptionHash;
                synchronized (map) {
                    boolean bl = false;
                    if (this.mFailedSubscriptionHash.containsKey(cIMObjectPath)) {
                        this.mFailedSubscriptionHash.remove(cIMObjectPath);
                        this.mLogger.log(Level.FINEST, "Indication from Subscription, {0}, has failed twice", new Object[]{cIMObjectPath});
                        bl = true;
                    } else {
                        this.mFailedSubscriptionHash.put(cIMObjectPath, new FailedSubscriptionInfo(cIMObjectPath, l));
                    }
                    if (bl) {
                        if (this.mSubscriptionRemovalAction == 2) {
                            try {
                                this.mLogger.log(Level.WARNING, "Indication Subscription, {0}, is being removed because indication could not be delivered", cIMObjectPath);
                                this.mWBEMClient.deleteInstance(cIMObjectPath);
                            }
                            catch (WBEMException wBEMException) {
                                this.mLogger.log(Level.SEVERE, "Tried to delete IndicationSubscription:\n{0} because of a failed delivery but caught  WBEMException:\n\t{1}", new Object[]{cIMObjectPath, wBEMException});
                            }
                        } else {
                            CIMInstance cIMInstance;
                            CIMInstance cIMInstance2 = indicationDeliveryInfo.getSubscription();
                            ArrayList<CIMProperty> arrayList = new ArrayList<CIMProperty>();
                            for (CIMProperty cIMProperty : cIMInstance = cIMInstance2.getProperties()) {
                                String string = cIMProperty.getName();
                                if (string.equalsIgnoreCase(CPN_SUBSCRIPTIONSTATE)) continue;
                                arrayList.add(cIMProperty);
                            }
                            arrayList.add(new CIMProperty(CPN_SUBSCRIPTIONSTATE, CIMDataType.UINT16_T, (Object)new UnsignedInteger16(4), false));
                            CIMInstance cIMInstance3 = new CIMInstance(cIMInstance2.getObjectPath(), arrayList.toArray(new CIMProperty[arrayList.size()]));
                            try {
                                this.mLogger.log(Level.WARNING, "Indication Subscription, {0}, is being disabled because indication could not be delivered", cIMObjectPath);
                                this.mWBEMClient.modifyInstance(cIMInstance3, new String[]{CPN_SUBSCRIPTIONSTATE});
                            }
                            catch (WBEMException wBEMException) {
                                this.mLogger.log(Level.SEVERE, "Tried to set SubscriptionState to disabled for IndicationSubscription:\n{0}\nbut ModifyInstance method failed with exception: \n{1}", new Object[]{cIMObjectPath, wBEMException});
                            }
                        }
                    } else {
                        this.mLogger.log(Level.FINEST, "Indication Subscription, {0}, has failed for the first time. Don't delete it just yet", cIMObjectPath);
                    }
                }
            }
            catch (Throwable throwable) {
                this.mLogger.log(Level.SEVERE, "Caught exception trying to handle failed indication delivery", throwable);
            }
        }
    }

    protected abstract Object getDestinationObject(String var1);

    public void initialize(ProviderHandle providerHandle) {
        this.mWBEMClient = providerHandle;
    }

    public void refreshIndicationServiceValues() {
        try {
            CloseableIterator closeableIterator = this.mWBEMClient.enumerateInstances(new CIMObjectPath(null, null, null, "interop", "CIM_IndicationService", null), null);
            if (closeableIterator.hasNext()) {
                this.refreshIndicationServiceValues((CIMInstance)closeableIterator.next());
            }
        }
        catch (WBEMException wBEMException) {
            this.mLogger.log(Level.INFO, "Caught exception trying to retrieve indication service to get ReliableIndications values", wBEMException);
            this.mRetries = 3;
            this.mRetryWait = 30;
        }
    }

    public void refreshIndicationServiceValues(CIMInstance cIMInstance) {
        if (null != cIMInstance) {
            UnsignedInteger32 unsignedInteger32;
            UnsignedInteger16 unsignedInteger16;
            UnsignedInteger32 unsignedInteger322;
            UnsignedInteger16 unsignedInteger162 = (UnsignedInteger16)cIMInstance.getPropertyValue(CPN_DELIVERYRETRYATTEMPTS);
            if (null != unsignedInteger162) {
                this.mRetries = unsignedInteger162.intValue();
            }
            if (null != (unsignedInteger322 = (UnsignedInteger32)cIMInstance.getPropertyValue(CPN_DELIVERYRETRYINTERVAL))) {
                this.mRetryWait = unsignedInteger322.intValue();
            }
            if (null != (unsignedInteger16 = (UnsignedInteger16)cIMInstance.getPropertyValue(CPN_SUBSCRIPTIONREMOVALACTION))) {
                this.mSubscriptionRemovalAction = unsignedInteger16.intValue();
            }
            if (null != (unsignedInteger32 = (UnsignedInteger32)cIMInstance.getPropertyValue(CPN_SUBSCRIPTIONREMOVALTIMEINTERVAL))) {
                this.mSubscriptionRemovalTimeInterval = unsignedInteger32.intValue() * 1000;
            }
        }
    }

    protected void refreshTLSInfo() {
        block11: {
            if (this.mStarted) {
                this.mTLSInfo = null;
                if (null != this.mInstIndicationHandler) {
                    CIMObjectPath cIMObjectPath = this.mInstIndicationHandler.getObjectPath();
                    try {
                        CloseableIterator closeableIterator = mHandle.associatorInstances(cIMObjectPath, "CIM_ElementSettingData", "CIM_SettingData", "ManagedElement", "SettingData", null);
                        if (closeableIterator.hasNext()) {
                            String string;
                            CIMInstance cIMInstance = (CIMInstance)closeableIterator.next();
                            String[] stringArray = (String[])cIMInstance.getPropertyValue("EnabledCipherSuites");
                            String string2 = CipherUtilities.validateCiphers((String[])stringArray);
                            if (null != string2) {
                                this.mLogger.log(Level.SEVERE, "the SettingData instance, {0}, contains the following invalid ciphers: {1}", new Object[]{cIMInstance.getObjectPath(), string2});
                                break block11;
                            }
                            String string3 = JServerProperties.getBasedir();
                            Boolean bl = (Boolean)cIMInstance.getPropertyValue("MutualAuthenticationRequired");
                            boolean bl2 = null != bl ? bl : false;
                            bl = (Boolean)cIMInstance.getPropertyValue("ValidateCertHostName");
                            boolean bl3 = null != bl ? bl : true;
                            bl = null;
                            String string4 = (String)cIMInstance.getPropertyValue("KeyStoreFile");
                            if (null != string4) {
                                string4 = MessageFormat.format(string4, string3);
                            }
                            if (null != (string = (String)cIMInstance.getPropertyValue("TrustStoreFile"))) {
                                string = MessageFormat.format(string, string3);
                            }
                            String string5 = (String)cIMInstance.getPropertyValue("KeyStorePassword");
                            String string6 = null;
                            try {
                                string6 = TLSInfo.decryptPassword((String)string5);
                            }
                            catch (Exception exception) {
                                this.mLogger.log(Level.WARNING, "Could not decrypt keystore password in SettingData instance {0}", new Object[]{cIMInstance.getObjectPath()});
                            }
                            if (null != string6) {
                                this.mTLSInfo = new TLSInfo(bl2, bl3, string4, string6, string, stringArray);
                            }
                            break block11;
                        }
                        this.mLogger.log(Level.WARNING, "Could not find SettingData instance for {0}", cIMObjectPath.getObjectName());
                    }
                    catch (WBEMException wBEMException) {
                        Object[] objectArray = new Object[]{cIMObjectPath, wBEMException};
                        this.mLogger.log(Level.SEVERE, "Caught exception getting SettingData that is associated to {0}: {1} ", objectArray);
                    }
                }
            }
        }
    }

    public void shutdown() {
        this.mFailedSubscriptionMonitorTask.done();
        this.deliveryExecutor.shutdown();
    }

    public void start(CIMInstance cIMInstance) {
        this.mInstIndicationHandler = cIMInstance;
        this.mStarted = true;
        this.refreshIndicationServiceValues();
    }

    public void stop() {
        this.mStarted = false;
    }

    public class FailedSubscriptionMonitorTask
    implements Runnable {
        public boolean mDone = false;

        public void done() {
            this.mDone = true;
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            String string = thread.getThreadGroup().getName();
            thread.setName(string + ":" + "FailedSubscriptionMonitorTask");
            while (!this.mDone) {
                long l = System.currentTimeMillis();
                Collection<FailedSubscriptionInfo> collection = IndicationHandler.this.mFailedSubscriptionHash.values();
                Iterator<FailedSubscriptionInfo> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    FailedSubscriptionInfo failedSubscriptionInfo = iterator.next();
                    long l2 = failedSubscriptionInfo.getFailureTime();
                    if (l <= l2 + IndicationHandler.this.mSubscriptionRemovalTimeInterval) continue;
                    iterator.remove();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected class FailedSubscriptionInfo {
        private final CIMObjectPath mOpFailedSubscription;
        private final long mSubscriptionFailureTime;

        public FailedSubscriptionInfo(CIMObjectPath cIMObjectPath, long l) {
            this.mOpFailedSubscription = cIMObjectPath;
            this.mSubscriptionFailureTime = l;
        }

        public long getFailureTime() {
            return this.mSubscriptionFailureTime;
        }

        public CIMObjectPath getSubscriptionObjectPath() {
            return this.mOpFailedSubscription;
        }
    }

    protected static enum DeliveryStatus {
        SUCCESSFUL,
        UNSUCCESSFUL,
        ERROR;

    }

    public class DeliverIndicationTask
    implements Runnable {
        private LinkedBlockingQueue<IndicationDeliveryInfo> mDeliveryInfoQueue;
        private final String mDestination;
        private int mConsecutiveUnsuccessfullDeliveryAttempts;

        public DeliverIndicationTask(String string, LinkedBlockingQueue<IndicationDeliveryInfo> linkedBlockingQueue) {
            this.mDestination = string;
            this.mDeliveryInfoQueue = linkedBlockingQueue;
            this.mConsecutiveUnsuccessfullDeliveryAttempts = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            String string = thread.getThreadGroup().getName();
            thread.setName(string + ":" + "DeliverIndicationTask" + " - " + this.mDestination);
            Object object = IndicationHandler.this.getDestinationObject(this.mDestination);
            IndicationDeliveryInfo indicationDeliveryInfo = null;
            boolean bl = true;
            while (bl) {
                if (null == indicationDeliveryInfo && this.mDeliveryInfoQueue.isEmpty()) {
                    for (int i = 0; i < 5; ++i) {
                        try {
                            Thread.sleep(1000L);
                            if (this.mDeliveryInfoQueue.isEmpty()) continue;
                            break;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (null == indicationDeliveryInfo) {
                    indicationDeliveryInfo = this.mDeliveryInfoQueue.poll();
                }
                CIMInstance cIMInstance = IndicationHandler.this.currentIndicationsMap;
                synchronized (cIMInstance) {
                    if (null == indicationDeliveryInfo) {
                        bl = false;
                        this.mDeliveryInfoQueue = null;
                        IndicationHandler.this.currentIndicationsMap.remove(this.mDestination);
                        continue;
                    }
                }
                cIMInstance = indicationDeliveryInfo.getIndication();
                if (null == cIMInstance) {
                    IndicationHandler.this.mLogger.severe("Trying to deliver a null indication");
                    indicationDeliveryInfo = this.mDeliveryInfoQueue.poll();
                    continue;
                }
                long l = System.currentTimeMillis();
                IndicationHandler.this.mLogger.log(Level.FINE, "Attempting to deliver indication {0} to {1}", new Object[]{cIMInstance.getObjectPath(), indicationDeliveryInfo.getDestination()});
                DeliveryStatus deliveryStatus = IndicationHandler.this.deliverIndication(object, cIMInstance);
                if (DeliveryStatus.SUCCESSFUL != deliveryStatus) {
                    ++this.mConsecutiveUnsuccessfullDeliveryAttempts;
                    if (this.mConsecutiveUnsuccessfullDeliveryAttempts > IndicationHandler.this.mRetries) {
                        IndicationHandler.this.mLogger.log(Level.FINE, "Delivery of indication {0} to {1} was unsuccessful and max retries has already been met.  Mark all subscriptions for this destination as failed", new Object[]{cIMInstance.getObjectPath(), indicationDeliveryInfo.getDestination()});
                        Map<String, LinkedBlockingQueue<IndicationDeliveryInfo>> map = IndicationHandler.this.currentIndicationsMap;
                        synchronized (map) {
                            while (null != indicationDeliveryInfo) {
                                IndicationHandler.this.deliveryFailure(indicationDeliveryInfo, l);
                                indicationDeliveryInfo = this.mDeliveryInfoQueue.poll();
                            }
                            continue;
                        }
                    }
                    IndicationHandler.this.mLogger.log(Level.FINE, "Delivery of indication {0} to {1} was unsuccessful, will retry", new Object[]{cIMInstance.getObjectPath(), indicationDeliveryInfo.getDestination()});
                    if (IndicationHandler.this.mRetryWait <= 0) continue;
                    try {
                        Thread.sleep(IndicationHandler.this.mRetryWait * 1000);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                IndicationHandler.this.mLogger.log(Level.FINE, "Successfull delivered indication {0} to {1}", new Object[]{cIMInstance.getObjectPath(), indicationDeliveryInfo.getDestination()});
                this.mConsecutiveUnsuccessfullDeliveryAttempts = 0;
                indicationDeliveryInfo = this.mDeliveryInfoQueue.poll();
            }
        }
    }
}

