/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.server.services.indication;

import com.ws.wbem.IndicationType;
import com.ws.wbem.jserver.DaemonThreadFactory;
import com.ws.wbem.jserver.IndicationHandler;
import com.ws.wbem.jserver.JServerEventService;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.WBEMServer;
import com.ws.wbem.jserver.services.ObjectManagerAdapterService;
import com.ws.wbem.profiles.dmtf.indications.IndicationsBackupStore;
import com.ws.wbem.server.services.indication.FilterActivation;
import com.ws.wbem.server.services.indication.IndicationDeliveryInfo;
import com.ws.wbem.server.services.indication.RepeatNotificationPolicy;
import com.ws.wbem.server.services.indication.SubActivation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMClass;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;
import org.wbemservices.wbem.query.SelectList;
import org.wbemservices.wbem.repository.ReadersWriter;

public class EventService
implements JServerEventService {
    private static final String CN_INDICATIONFILTER = "cim_indicationfilter";
    private static final String CN_INDICATIONSUBSCRIPTION = "cim_indicationsubscription";
    public static final String CPN_DESTINATION = "Destination";
    private static final String CPN_FILTER = "Filter";
    private static final String CPN_HANDLER = "Handler";
    private static final String CPN_NAME = "Name";
    public static final String CPN_REPEATNOTIFICATIONCOUNT = "RepeatNotificationCount";
    public static final String CPN_REPEATNOTIFICATIONINTERVAL = "RepeatNotificationInterval";
    public static final String CPN_REPEATNOTIFICATIONGAP = "RepeatNotificationGap";
    private static final String CPN_SOURCENAMESPACE = "SourceNameSpace";
    private static final String CPN_SOURCENAMESPACES = "SourceNameSpaces";
    public static final String CPN_SUBSCRIPTIONSTATE = "SubscriptionState";
    private static final int INDICATION_THREADS = 40;
    private static final long MAX_VERIFICATION_TIME = 86400000L;
    private static final int LCLISTSIZE = 8;
    public static final UnsignedInteger16 SUBSCRIPTION_STATE_DISABLED = new UnsignedInteger16(4);
    private static EventService mEventService;
    private final int SUBSCRIPTION_STATE_DISABLE = 4;
    protected final Map<CIMObjectPath, RepeatNotificationInfo> mRepeatNotificationInfoHash;
    private final ReadersWriter cfl = new ReadersWriter();
    private final Map<String, ArrayList<ArrayList<SubActivation>>> classFilterMap = new HashMap<String, ArrayList<ArrayList<SubActivation>>>();
    public HashMap<String, FilterActivation> filterActivations = new HashMap();
    private final ThreadPoolExecutor indicationExecutor;
    private final RepeatNotificationMonitorTask repeatNotificationMonitorTask;
    private final String mInteropNamespace = JServerProperties.getInteropNamespace();
    private Logger mLogger;
    protected ProviderHandle mProviderHandle = null;
    public WBEMServer mServer;

    public static EventService getEventService() {
        return mEventService;
    }

    public EventService() {
        this.indicationExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(40, (ThreadFactory)new DaemonThreadFactory());
        this.mRepeatNotificationInfoHash = Collections.synchronizedMap(new HashMap());
        this.repeatNotificationMonitorTask = new RepeatNotificationMonitorTask();
        this.indicationExecutor.execute(this.repeatNotificationMonitorTask);
        mEventService = this;
    }

    private void activateFilters() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), EventService.CN_INDICATIONFILTER, null);
                    Object object = EventService.this.mProviderHandle.enumerateInstances(cIMObjectPath, null);
                    if (object.hasNext()) {
                        EventService.this.activateFilters((Iterator<CIMInstance>)object, false);
                    }
                    if ((object = IndicationsBackupStore.readData()).hasNext()) {
                        EventService.this.activateFilters((Iterator<CIMInstance>)object, true);
                    }
                }
                catch (WBEMException wBEMException) {
                    EventService.this.mLogger.log(Level.SEVERE, "Indication Service failed to activate filters", wBEMException);
                }
            }
        }, "ActivateFilters");
        thread.setDaemon(true);
        thread.start();
    }

    protected void activateFilters(Iterator<CIMInstance> iterator, boolean bl) throws WBEMException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), CN_INDICATIONFILTER, null);
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(null, null, null, cIMObjectPath.getNamespace(), CN_INDICATIONSUBSCRIPTION, null);
        try {
            while (iterator.hasNext()) {
                CloseableIterator closeableIterator;
                CIMInstance cIMInstance = iterator.next();
                CIMObjectPath cIMObjectPath3 = new CIMObjectPath(null, null, null, cIMObjectPath.getNamespace(), cIMInstance.getClassName(), cIMInstance.getKeys());
                try {
                    closeableIterator = this.mProviderHandle.referenceInstances(cIMObjectPath3, cIMObjectPath2.getObjectName(), "", null);
                }
                catch (WBEMException wBEMException) {
                    continue;
                }
                ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
                while (closeableIterator.hasNext()) {
                    CIMObjectPath cIMObjectPath4;
                    CIMInstance cIMInstance2;
                    CIMInstance cIMInstance3;
                    Object object;
                    CIMObjectPath cIMObjectPath5;
                    boolean bl2 = false;
                    CIMObjectPath cIMObjectPath6 = ((CIMInstance)closeableIterator.next()).getObjectPath();
                    CIMObjectPath cIMObjectPath7 = null;
                    for (int i = 0; i < cIMObjectPath6.getKeys().length; ++i) {
                        cIMObjectPath5 = cIMObjectPath6.getKeys()[i];
                        if (!cIMObjectPath5.getName().equalsIgnoreCase(CPN_HANDLER)) continue;
                        try {
                            cIMObjectPath7 = (CIMObjectPath)cIMObjectPath5.getValue();
                            continue;
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                    if (!this.checkPersist(cIMObjectPath7) && !bl) {
                        this.mProviderHandle.deleteInstance(cIMObjectPath6);
                        try {
                            this.mProviderHandle.deleteInstance(cIMObjectPath7);
                        }
                        catch (WBEMException wBEMException) {}
                    } else {
                        CIMInstance cIMInstance4 = this.mProviderHandle.getInstance(cIMObjectPath6, null);
                        if (!SUBSCRIPTION_STATE_DISABLED.equals(cIMInstance4.getPropertyValue(CPN_SUBSCRIPTIONSTATE))) {
                            arrayList.add(this.mProviderHandle.getInstance(cIMObjectPath7, null));
                            arrayList.add(cIMInstance4);
                            bl2 = true;
                        }
                    }
                    if (!bl2) continue;
                    String string = null;
                    cIMObjectPath5 = null;
                    try {
                        string = (String)cIMInstance.getProperty(CPN_SOURCENAMESPACE).getValue();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        cIMObjectPath5 = (CIMObjectPath)cIMInstance.getProperty(CPN_SOURCENAMESPACES).getValue();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (null == string && null == cIMObjectPath5) {
                        cIMObjectPath5 = new String[]{cIMObjectPath3.getNamespace()};
                    } else if (null == cIMObjectPath5) {
                        cIMObjectPath5 = new String[]{string};
                    } else if (null == string || !Arrays.asList(cIMObjectPath5).contains(string)) {
                        // empty if block
                    }
                    if (((String[])cIMObjectPath5).length > 1 || !cIMObjectPath5[0].equalsIgnoreCase(cIMObjectPath3.getNamespace())) {
                        object = new HashSet();
                        cIMInstance3 = new CIMObjectPath(null, null, null, this.mInteropNamespace, "CIM_Namespace", null);
                        cIMInstance2 = this.mProviderHandle.enumerateInstances((CIMObjectPath)cIMInstance3, null);
                        while (cIMInstance2.hasNext()) {
                            cIMObjectPath4 = ((CIMInstance)cIMInstance2.next()).getObjectPath();
                            object.add(((String)cIMObjectPath4.getKey(CPN_NAME).getValue()).toLowerCase());
                        }
                        for (CIMObjectPath cIMObjectPath8 : cIMObjectPath5) {
                            if (object.contains(cIMObjectPath8.toLowerCase())) continue;
                        }
                    }
                    object = arrayList.iterator();
                    cIMInstance3 = (CIMInstance)object.next();
                    cIMInstance2 = (CIMInstance)object.next();
                    cIMObjectPath4 = (CIMObjectPath)cIMInstance.getPropertyValue(CPN_NAME);
                    FilterActivation filterActivation = this.filterActivations.get(cIMObjectPath4);
                    if (null == filterActivation) {
                        filterActivation = new FilterActivation(cIMObjectPath3, cIMInstance, this, (String[])cIMObjectPath5);
                        filterActivation.run();
                        filterActivation.activate(cIMInstance3, cIMInstance2);
                        this.filterActivations.put((String)cIMObjectPath4, filterActivation);
                        while (object.hasNext()) {
                            cIMInstance3 = (CIMInstance)object.next();
                            cIMInstance2 = (CIMInstance)object.next();
                            filterActivation.activateSubscription(cIMInstance3, cIMInstance2);
                        }
                        continue;
                    }
                    while (object.hasNext()) {
                        cIMInstance3 = (CIMInstance)object.next();
                        cIMInstance2 = (CIMInstance)object.next();
                        filterActivation.activateSubscription(cIMInstance3, cIMInstance2);
                    }
                }
            }
        }
        catch (WBEMException wBEMException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addClassFilter(String string, SubActivation subActivation) {
        boolean bl = false;
        this.cfl.writeLock();
        try {
            ArrayList<ArrayList<SubActivation>> arrayList = this.classFilterMap.get(this.fixNamespace(string));
            IndicationType indicationType = subActivation.getIndicationType();
            int n = indicationType.getOffset();
            if (n < 0) {
                n = 0;
            }
            if (arrayList == null) {
                arrayList = new ArrayList();
                for (int i = 0; i < 8; ++i) {
                    arrayList.add(new ArrayList());
                }
                ArrayList<SubActivation> arrayList2 = arrayList.get(n);
                arrayList2.add(subActivation);
                this.classFilterMap.put(this.fixNamespace(string), arrayList);
                bl = true;
            } else {
                ArrayList<SubActivation> arrayList3 = arrayList.get(n);
                if (arrayList3.size() == 0) {
                    bl = true;
                }
                arrayList3.add(subActivation);
            }
        }
        finally {
            this.cfl.writeUnlock();
        }
        return bl;
    }

    private boolean checkPersist(CIMObjectPath cIMObjectPath) {
        boolean bl = true;
        try {
            CIMInstance cIMInstance = this.mProviderHandle.getInstance(cIMObjectPath, null);
            CIMProperty cIMProperty = cIMInstance.getProperty("PersistenceType");
            Object object = null;
            int n = 2;
            if (null != cIMProperty && null != (object = cIMProperty.getValue())) {
                n = ((UnsignedInteger16)object).intValue();
            }
            if (3 == n) {
                this.mLogger.info("Persistence type is TRANSIENT ");
                bl = false;
            } else {
                this.mLogger.info("Request to remove permanent subscription ignored");
            }
        }
        catch (Exception exception) {
            this.mLogger.log(Level.SEVERE, "Exception checking PersistenceType, using PERMANENT", exception);
        }
        return bl;
    }

    public void close() {
        this.repeatNotificationMonitorTask.done();
        this.indicationExecutor.shutdownNow();
    }

    public void deliverEvent(CIMInstance cIMInstance, CIMInstance[] cIMInstanceArray) {
        if (null == cIMInstance) {
            this.mLogger.severe("Event service cannot deliver indication because specified indication is null");
        } else {
            this.indicationExecutor.execute(new IndicationDeliverer(cIMInstance, cIMInstanceArray));
        }
    }

    private void deliverEventToIndicationHandler(CIMInstance cIMInstance, CIMInstance cIMInstance2, CIMInstance cIMInstance3, IndicationHandler indicationHandler) {
        if (indicationHandler != null) {
            indicationHandler.deliverEvent(cIMInstance, cIMInstance2, cIMInstance3);
        } else {
            this.mLogger.log(Level.SEVERE, "Provider trying to deliver event but there is no IndicationHandlers registered to indication service");
        }
    }

    public IndicationType determineIndicationType(String string, String string2) {
        IndicationType indicationType = IndicationType.getIndicationTypeByClassName((String)string2);
        if (null == indicationType) {
            indicationType = IndicationType.Process;
            if (this.isTypeOf(string, string2, IndicationType.InstanceModification.getClassName())) {
                indicationType = IndicationType.InstanceModification;
            } else if (this.isTypeOf(string, string2, IndicationType.InstanceDeletion.getClassName())) {
                indicationType = IndicationType.InstanceDeletion;
            } else if (this.isTypeOf(string, string2, IndicationType.InstanceCreation.getClassName())) {
                indicationType = IndicationType.InstanceCreation;
            } else if (this.isTypeOf(string, string2, IndicationType.InstanceMethodCall.getClassName())) {
                indicationType = IndicationType.InstanceMethodCall;
            } else if (this.isTypeOf(string, string2, IndicationType.InstanceRead.getClassName())) {
                indicationType = IndicationType.InstanceRead;
            } else if (this.isTypeOf(string, string2, IndicationType.ClassCreation.getClassName())) {
                indicationType = IndicationType.ClassCreation;
            } else if (this.isTypeOf(string, string2, IndicationType.ClassDeletion.getClassName())) {
                indicationType = IndicationType.ClassDeletion;
            } else if (this.isTypeOf(string, string2, IndicationType.ClassModification.getClassName())) {
                indicationType = IndicationType.ClassModification;
            }
        }
        return indicationType;
    }

    private String fixNamespace(String string) {
        if (string.startsWith("/")) {
            return string.substring(1, string.length());
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SubActivation> getClassFilters(String string, String string2, String string3) {
        this.cfl.readLock();
        String string4 = string.toLowerCase() + ":" + string2.toLowerCase();
        IndicationType indicationType = this.determineIndicationType(string, string3);
        try {
            List list = this.classFilterMap.get(this.fixNamespace(string4));
            if (list == null) {
                this.mLogger.log(Level.WARNING, "Could not find class filter list for class: " + this.fixNamespace(string4));
                List<SubActivation> list2 = null;
                return list2;
            }
            List list3 = (List)list.get(indicationType.getOffset());
            return list3;
        }
        finally {
            this.cfl.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRepeatNotification(RepeatNotificationPolicy repeatNotificationPolicy, CIMInstance cIMInstance, CIMInstance cIMInstance2, CIMInstance cIMInstance3, IndicationHandler indicationHandler) {
        boolean bl = false;
        long l = System.currentTimeMillis();
        RepeatNotificationInfo repeatNotificationInfo = null;
        Map<CIMObjectPath, RepeatNotificationInfo> map = this.mRepeatNotificationInfoHash;
        synchronized (map) {
            repeatNotificationInfo = this.mRepeatNotificationInfoHash.get(cIMInstance3.getObjectPath());
            if (null == repeatNotificationInfo) {
                repeatNotificationInfo = new RepeatNotificationInfo(repeatNotificationPolicy, cIMInstance, cIMInstance2, cIMInstance3, indicationHandler, l);
                this.mRepeatNotificationInfoHash.put(cIMInstance3.getObjectPath(), repeatNotificationInfo);
                bl = true;
            }
        }
        if (bl) {
            if (repeatNotificationPolicy == RepeatNotificationPolicy.Suppress) {
                this.deliverEventToIndicationHandler(cIMInstance, cIMInstance2, cIMInstance3, indicationHandler);
            }
        } else {
            repeatNotificationInfo.indicationTriggered(cIMInstance, l);
        }
    }

    public void initialize(WBEMServer wBEMServer, ProviderHandle providerHandle, Logger logger) {
        logger.info("Initializing Event Service");
        this.mLogger = logger;
        this.mProviderHandle = providerHandle;
        this.mServer = wBEMServer;
        this.activateFilters();
    }

    private boolean isTypeOf(String string, String string2, String string3) {
        if (string2.equalsIgnoreCase(string3)) {
            return true;
        }
        try {
            CloseableIterator closeableIterator = this.mProviderHandle.enumerateClasses(new CIMObjectPath(null, null, null, string, string3, null), true, false, true);
            while (closeableIterator.hasNext()) {
                CIMClass cIMClass = (CIMClass)closeableIterator.next();
                if (!string2.equalsIgnoreCase(cIMClass.getName())) continue;
                return true;
            }
        }
        catch (WBEMException wBEMException) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeClassFilter(String string, SubActivation subActivation) {
        boolean bl = false;
        this.cfl.writeLock();
        try {
            int n;
            IndicationType indicationType = subActivation.getIndicationType();
            int n2 = indicationType.getOffset();
            ArrayList<ArrayList<SubActivation>> arrayList = this.classFilterMap.get(this.fixNamespace(string));
            if (arrayList == null) {
                boolean bl2 = false;
                return bl2;
            }
            ArrayList<SubActivation> arrayList2 = arrayList.get(n2);
            arrayList2.remove(subActivation);
            if (arrayList2.size() == 0) {
                bl = true;
            }
            for (n = 0; n < 8 && arrayList.get(n).size() == 0; ++n) {
            }
            if (n == 8) {
                this.classFilterMap.remove(this.fixNamespace(string));
            }
        }
        finally {
            this.cfl.writeUnlock();
        }
        return bl;
    }

    public void reset() throws WBEMException {
    }

    public class RepeatNotificationMonitorTask
    implements Runnable {
        Boolean mDone = false;

        public void done() {
            this.mDone = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            String string = thread.getThreadGroup().getName();
            thread.setName(string + ":" + "RepeatNotificationMonitorTask");
            while (!this.mDone.booleanValue()) {
                long l = System.currentTimeMillis();
                HashMap<CIMObjectPath, RepeatNotificationInfo> hashMap = new HashMap<CIMObjectPath, RepeatNotificationInfo>(EventService.this.mRepeatNotificationInfoHash);
                for (Map.Entry entry : hashMap.entrySet()) {
                    CIMInstance cIMInstance;
                    RepeatNotificationInfo repeatNotificationInfo = (RepeatNotificationInfo)entry.getValue();
                    if (l - repeatNotificationInfo.getVerifiedTime() > 86400000L) {
                        block17: {
                            Map<CIMObjectPath, RepeatNotificationInfo> map;
                            try {
                                cIMInstance = EventService.this.mProviderHandle.getInstance(repeatNotificationInfo.getSubscriptionObjectPath(), null);
                                if (null != cIMInstance.getPropertyValue(EventService.CPN_SUBSCRIPTIONSTATE) && ((UnsignedInteger16)cIMInstance.getPropertyValue(EventService.CPN_SUBSCRIPTIONSTATE)).intValue() == 4) {
                                    map = EventService.this.mRepeatNotificationInfoHash;
                                    synchronized (map) {
                                        EventService.this.mRepeatNotificationInfoHash.remove(entry.getKey());
                                        continue;
                                    }
                                }
                            }
                            catch (WBEMException wBEMException) {
                                if (wBEMException.getID() != 6) break block17;
                                map = EventService.this.mRepeatNotificationInfoHash;
                                synchronized (map) {
                                    EventService.this.mRepeatNotificationInfoHash.remove(entry.getKey());
                                    continue;
                                }
                            }
                        }
                        repeatNotificationInfo.resetVerifiedTime();
                    }
                    cIMInstance = EventService.this.mRepeatNotificationInfoHash;
                    synchronized (cIMInstance) {
                        EventService.this.mRepeatNotificationInfoHash.put((CIMObjectPath)entry.getKey(), repeatNotificationInfo);
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected class RepeatNotificationInfo {
        private CIMInstance mFirstDeliveryInstance;
        private final CIMInstance mInstListener;
        private final CIMInstance mInstSubscription;
        private int mIndicationCount;
        private final long mRepeatNotificationGap;
        private final long mRepeatNotificationInterval;
        private final int mRepeatNotificationCount;
        private final RepeatNotificationPolicy mRepeatNotificationPolicy;
        private long mGapStartTime;
        private long mIntervalStartTime;
        private long mVerifiedTime;
        private final IndicationHandler mIndicationHandlerOMA;

        public RepeatNotificationInfo(RepeatNotificationPolicy repeatNotificationPolicy, CIMInstance cIMInstance, CIMInstance cIMInstance2, CIMInstance cIMInstance3, IndicationHandler indicationHandler, long l) {
            this.mInstSubscription = cIMInstance3;
            this.mFirstDeliveryInstance = cIMInstance;
            this.mInstListener = cIMInstance2;
            this.mIndicationHandlerOMA = indicationHandler;
            this.mRepeatNotificationPolicy = repeatNotificationPolicy;
            UnsignedInteger64 unsignedInteger64 = (UnsignedInteger64)cIMInstance3.getPropertyValue(EventService.CPN_REPEATNOTIFICATIONINTERVAL);
            UnsignedInteger64 unsignedInteger642 = (UnsignedInteger64)cIMInstance3.getPropertyValue(EventService.CPN_REPEATNOTIFICATIONGAP);
            UnsignedInteger16 unsignedInteger16 = (UnsignedInteger16)cIMInstance3.getPropertyValue(EventService.CPN_REPEATNOTIFICATIONCOUNT);
            this.mRepeatNotificationInterval = null != unsignedInteger64 ? unsignedInteger64.longValue() * 1000L : 0L;
            this.mRepeatNotificationGap = null != unsignedInteger642 ? unsignedInteger642.longValue() * 1000L : 0L;
            this.mRepeatNotificationCount = null != unsignedInteger16 ? unsignedInteger16.intValue() : 0;
            this.mIndicationCount = 1;
            this.mIntervalStartTime = l;
            this.mGapStartTime = 0L;
            this.mVerifiedTime = l;
        }

        public void clearFirstInstance() {
            this.mFirstDeliveryInstance = null;
        }

        private void deliverFirstIndication() {
            if (null != this.mFirstDeliveryInstance) {
                this.deliverIndication(this.mFirstDeliveryInstance);
            }
        }

        private void deliverIndication(CIMInstance cIMInstance) {
            EventService.this.deliverEventToIndicationHandler(cIMInstance, this.mInstListener, this.mInstSubscription, this.mIndicationHandlerOMA);
        }

        public int getIndicationCount() {
            return this.mIndicationCount;
        }

        public IndicationDeliveryInfo getIndicationDeliveryInfo() {
            return new IndicationDeliveryInfo(UUID.randomUUID().toString(), this.mFirstDeliveryInstance, this.mInstListener, this.mInstSubscription);
        }

        public CIMInstance getIndicationInstance() {
            return this.mFirstDeliveryInstance;
        }

        public int getRepeatNotificationCount() {
            return this.mRepeatNotificationCount;
        }

        public long getRepeatNotificationGap() {
            return this.mRepeatNotificationGap;
        }

        public long getRepeatNotificationInterval() {
            return this.mRepeatNotificationInterval;
        }

        public RepeatNotificationPolicy getRepeatNotificationPolicy() {
            return this.mRepeatNotificationPolicy;
        }

        public CIMObjectPath getSubscriptionObjectPath() {
            return this.mInstSubscription.getObjectPath();
        }

        public long getVerifiedTime() {
            return this.mVerifiedTime;
        }

        public void indicationTriggered(CIMInstance cIMInstance, long l) {
            if (this.mRepeatNotificationPolicy == RepeatNotificationPolicy.Suppress) {
                long l2 = l - this.mIntervalStartTime;
                if (l2 > this.mRepeatNotificationInterval) {
                    this.mIndicationCount = 1;
                    this.mIntervalStartTime = l;
                    this.deliverIndication(cIMInstance);
                } else if (this.mIndicationCount++ < this.mRepeatNotificationCount) {
                    this.deliverIndication(cIMInstance);
                }
            } else if (this.mRepeatNotificationPolicy == RepeatNotificationPolicy.Delay) {
                long l3;
                boolean bl = false;
                if (0L != this.mGapStartTime) {
                    l3 = l - this.mGapStartTime;
                    if (l3 > this.mRepeatNotificationGap) {
                        this.mGapStartTime = 0L;
                        this.mFirstDeliveryInstance = cIMInstance;
                        this.mIntervalStartTime = l;
                        this.mIndicationCount = 1;
                    } else {
                        bl = true;
                    }
                }
                if (!bl) {
                    l3 = l - this.mIntervalStartTime;
                    if (l3 > this.mRepeatNotificationInterval) {
                        this.mIntervalStartTime = l;
                        this.mFirstDeliveryInstance = cIMInstance;
                        this.mIndicationCount = 1;
                    } else if (this.mIndicationCount++ > this.mRepeatNotificationCount) {
                        this.mGapStartTime = l;
                        this.deliverFirstIndication();
                    }
                }
            } else if (this.mRepeatNotificationPolicy == RepeatNotificationPolicy.None) {
                this.deliverIndication(cIMInstance);
            }
        }

        public void resetVerifiedTime() {
            this.mVerifiedTime = System.currentTimeMillis();
        }
    }

    private class IndicationDeliverer
    implements Runnable {
        final CIMInstance ci;
        final CIMInstance[] indicationSubscriptions;
        final String namespace;

        IndicationDeliverer(CIMInstance cIMInstance, CIMInstance[] cIMInstanceArray) {
            this.ci = cIMInstance;
            this.namespace = cIMInstance.getObjectPath().getNamespace();
            this.indicationSubscriptions = cIMInstanceArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deliverEvent(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
            CIMObjectPath cIMObjectPath = (CIMObjectPath)cIMInstance2.getPropertyValue(EventService.CPN_HANDLER);
            CIMInstance cIMInstance3 = EventService.this.mProviderHandle.getInstance(cIMObjectPath, null);
            UnsignedInteger16 unsignedInteger16 = (UnsignedInteger16)cIMInstance3.getPropertyValue("Protocol");
            if (null != unsignedInteger16) {
                IndicationHandler indicationHandler = ObjectManagerAdapterService.getIHAHandle((int)unsignedInteger16.intValue());
                if (null != indicationHandler) {
                    RepeatNotificationPolicy repeatNotificationPolicy = RepeatNotificationPolicy.None;
                    try {
                        repeatNotificationPolicy = RepeatNotificationPolicy.getRepeatNotificationPolicy(cIMInstance2);
                    }
                    catch (WBEMException wBEMException) {
                        EventService.this.mLogger.log(Level.WARNING, "Caught exception trying to get RepeatNotificationPolicy value.  Will default to 2 (None)", wBEMException);
                    }
                    if (repeatNotificationPolicy == RepeatNotificationPolicy.None) {
                        EventService.this.deliverEventToIndicationHandler(cIMInstance, cIMInstance3, cIMInstance2, indicationHandler);
                    } else {
                        boolean bl = false;
                        long l = System.currentTimeMillis();
                        RepeatNotificationInfo repeatNotificationInfo = null;
                        Map<CIMObjectPath, RepeatNotificationInfo> map = EventService.this.mRepeatNotificationInfoHash;
                        synchronized (map) {
                            repeatNotificationInfo = EventService.this.mRepeatNotificationInfoHash.get(cIMInstance2.getObjectPath());
                            if (null == repeatNotificationInfo) {
                                repeatNotificationInfo = new RepeatNotificationInfo(repeatNotificationPolicy, cIMInstance, cIMInstance3, cIMInstance2, indicationHandler, l);
                                EventService.this.mRepeatNotificationInfoHash.put(cIMInstance2.getObjectPath(), repeatNotificationInfo);
                                bl = true;
                            }
                        }
                        if (bl && repeatNotificationPolicy == RepeatNotificationPolicy.Suppress) {
                            EventService.this.deliverEventToIndicationHandler(cIMInstance, cIMInstance3, cIMInstance2, indicationHandler);
                        } else {
                            repeatNotificationInfo.indicationTriggered(cIMInstance, l);
                        }
                    }
                } else {
                    EventService.this.mLogger.log(Level.SEVERE, "Could not deliver indication because Indication Service could not find IndicationHandler for protocol: " + unsignedInteger16);
                }
            } else {
                EventService.this.mLogger.log(Level.SEVERE, "Could not deliver indication because ListenerDestination instance did not have Protocol property value");
            }
        }

        public void deliverEvent(CIMInstance cIMInstance, List<FilterActivation> list) throws Exception {
            EventService.this.mLogger.info("deliverEvent called");
            for (FilterActivation filterActivation : list) {
                SelectList selectList = filterActivation.getParsedExp().getSelectList();
                CIMInstance cIMInstance2 = selectList == null ? new CIMInstance(new CIMObjectPath(cIMInstance.getClassName()), new CIMProperty[0]) : selectList.apply(cIMInstance);
                if (null == cIMInstance2) {
                    EventService.this.mLogger.log(Level.SEVERE, "Indication delivery failed.  Indication is null");
                    continue;
                }
                CIMObjectPath cIMObjectPath = filterActivation.getFilterOp();
                CloseableIterator closeableIterator = null;
                try {
                    closeableIterator = EventService.this.mProviderHandle.referenceInstances(cIMObjectPath, EventService.CN_INDICATIONSUBSCRIPTION, EventService.CPN_FILTER, null);
                }
                catch (Exception exception) {
                    EventService.this.mLogger.log(Level.SEVERE, "Delivery Indication failed.  Caught exception trying to get IndicationSubscription instances that are associated to filter: {0}\n{1}", new Object[]{cIMObjectPath, exception});
                    continue;
                }
                while (closeableIterator.hasNext()) {
                    this.deliverEvent(cIMInstance2, (CIMInstance)closeableIterator.next());
                }
            }
        }

        @Override
        public void run() {
            if (null != this.indicationSubscriptions && this.indicationSubscriptions.length > 0) {
                for (CIMInstance cIMInstance : this.indicationSubscriptions) {
                    try {
                        this.deliverEvent(this.ci, cIMInstance);
                    }
                    catch (Exception exception) {
                        EventService.this.mLogger.log(Level.SEVERE, "Deliver event failed", exception);
                    }
                }
            } else {
                Object object;
                String string = this.ci.getClassName().toLowerCase();
                IndicationType indicationType = EventService.this.determineIndicationType(this.namespace, string);
                if (indicationType.isInstanceIndication()) {
                    object = (CIMInstance)this.ci.getProperty("SourceInstance").getValue();
                    string = object.getClassName().toLowerCase();
                }
                if ((object = EventService.this.getClassFilters(this.namespace, string, this.ci.getClassName())) == null) {
                    EventService.this.mLogger.log(Level.WARNING, "!!! Could not deliver indication:\n{0}\nbecause indication service could not find filters that match class {1}", new Object[]{this.ci, string});
                    return;
                }
                Iterator iterator = object.iterator();
                ArrayList<FilterActivation> arrayList = new ArrayList<FilterActivation>();
                while (iterator.hasNext()) {
                    SubActivation subActivation = (SubActivation)iterator.next();
                    FilterActivation filterActivation = subActivation.getParentActivation();
                    if (arrayList.contains(filterActivation)) {
                        EventService.this.mLogger.finest("EventService:IndicationDeliverer - Parent filter has already been matched");
                        continue;
                    }
                    try {
                        if (subActivation.getExpression() == null || subActivation.getExpression().apply(this.ci)) {
                            EventService.this.mLogger.finest("EventService:IndicationDeliverer - Matched filter for indication instance:\n" + this.ci);
                            arrayList.add(filterActivation);
                            continue;
                        }
                        EventService.this.mLogger.finest("EventService:IndicationDeliverer - Could NOT matched filter for indication instance:\n" + this.ci + "\nExpression that " + "could not be matched is \"" + subActivation.getExpression() + "\"");
                    }
                    catch (WBEMException wBEMException) {
                        EventService.this.mLogger.log(Level.WARNING, "Expression instance mismatch, check filter", wBEMException);
                    }
                }
                try {
                    this.deliverEvent(this.ci, arrayList);
                }
                catch (Exception exception) {
                    EventService.this.mLogger.log(Level.SEVERE, "Deliver event failed", exception);
                }
            }
        }
    }
}

