/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.data;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.sanproject.rmi.ssl.SanSSLClientSocketFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import sanproject.common.RCobj_interface_CheckRet;
import sanproject.common.RCobj_interface_LogonParam;
import sanproject.common.Robj_interface_DISKgetSubsystemInfo;
import sanproject.common.Robj_interface_DKCgetAllPGNumber;
import sanproject.common.Robj_interface_RJSetGettingParamLDEV;
import sanproject.common.Robj_interface_RJiCLPRName;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLDKCIndex;
import sanproject.common.Robj_interface_RJiPRMName;
import sanproject.common.Robj_interface_RJiPortAttributeInfoDetail;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.common.Robj_interface_RJiPortInfoDetail;
import sanproject.common.Robj_interface_RJiSLPRName;
import sanproject.getmondat.com.RJMdDateFormat;
import sanproject.getmondat.com.RJMdExecParameter;
import sanproject.getmondat.com.RJMdMessage;
import sanproject.getmondat.com.RJMdProgress;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.data.RJMdDataCU;
import sanproject.getmondat.data.RJMdDataCache;
import sanproject.getmondat.data.RJMdDataHostGroup;
import sanproject.getmondat.data.RJMdDataJNL;
import sanproject.getmondat.data.RJMdDataLDEV;
import sanproject.getmondat.data.RJMdDataLU;
import sanproject.getmondat.data.RJMdDataPG;
import sanproject.getmondat.data.RJMdDataPPCGroup;
import sanproject.getmondat.data.RJMdDataPort;
import sanproject.getmondat.data.RJMdDataTracer;
import sanproject.getmondat.data.RJMdDataWWN;
import sanproject.serversx.data.RJiCUIndex;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serversx.data.RJiPGIndex;
import sanproject.serverux.arg.monitor.HIHsmUseRateRangeArgInfo;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.BaseTimeoutValue;
import sanproject.serverux.data.ChangeDataAllString;
import sanproject.serverux.data.CheckRet;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.MonSetMonitoringSwitch;
import sanproject.serverux.data.MonTerm;
import sanproject.serverux.data.MonitorInfo;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.data.PPCAllPPCGroupWWNInfo;
import sanproject.serverux.data.PPCAllPortWWNInfo;
import sanproject.serverux.data.PPCGroupInfo;
import sanproject.serverux.data.PPCGroupWWNInfo;
import sanproject.serverux.data.RmiControlObj;
import sanproject.serverux.data.SANRmiException;
import sanproject.serverux.data.SetRmiException;
import sanproject.serverux.dataimpl.DISKgetSubsystemInfo;
import sanproject.serverux.dataimpl.DKCgetPGLDEVNumber;
import sanproject.serverux.dataimpl.RJSetGettingParamLDEV;
import sanproject.serverux.dataimpl.RJSetGettingParamVol;
import sanproject.serverux.dataimpl.RJiHURget1JNLG;
import sanproject.serverux.dataimpl.RJiHURgetJNLGrps;
import sanproject.serverux.dataimpl.RJiPortIndex;
import sanproject.serverux.sn.RmiObj_Webcon;

public class RJMdDataControl {
    protected RJMdExecParameter parameter;
    protected static final RJMdDateFormat rangeFormat = new RJMdDateFormat("yyyy/MM/dd HH:mm:ss");
    protected static final SimpleDateFormat traceFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    protected static final SimpleDateFormat logid = new SimpleDateFormat("MMddHHmmss");
    protected static PrintStream messageStream = System.out;
    protected static PrintStream infomationStream = System.out;
    protected static PrintStream logStream = null;
    private SanData m_generalParam = null;
    private SanRemote m_RmiObjKV = null;
    private RCobj_interface_CheckRet objname = null;
    private RCobj_interface_LogonParam objparam = null;
    private RmiObj_Webcon rmiobj = null;
    private RmiControlObj rmicontrol = null;
    private String HostPath = null;
    protected boolean connect = false;
    public static final int TRACELEVEL = 1;
    public RJMdDataCache cache = null;
    private Exception FindException = null;
    private int nRetryCounter = 0;
    private ArrayList ApplyDataPool1 = new ArrayList();
    private ArrayList ApplyDataPool2 = new ArrayList();
    private ArrayList ApplyDataPool3 = new ArrayList();
    private String dkcProductName;
    private String dkcMibVersion;
    public static final int PGTYPE_ALLTYPE = 1;
    public static final int PGTYPE_NOEXTERNAL = 2;
    public static final int PGTYPE_EXTERNAL = 3;
    public static final int PGTYPE_ONLY_INTERNAL = 4;
    public static final int LDEVTYPE_NORMAL = 0;
    public static final int LDEVTYPE_NOPOOL = 1;
    public static final int LDEVTYPE_NOVVOL = 2;
    public static final int RETRY_SLEEP_TIMER = 60000;
    public static final int RETRY_LOGIN_STATUS_NOP = 0;
    public static final int RETRY_LOGIN_STATUS_LOOKUP1 = 1;
    public static final int RETRY_LOGIN_STATUS_CHECKLICENCEEX = 2;
    public static final int RETRY_LOGIN_STATUS_LOOKUP2 = 3;
    public static final int RETRY_LOGIN_STATUS_SETTIMEOUT = 4;
    public static final int RETRY_LOGIN_STATUS_MONITORLOGIN = 5;
    public static final int NORMALVOL_BIT = 1;
    public static final int EXTERNALVOL_BIT = 2;
    public static final int QSVOL_BIT = 4;
    public static final int AOUVOL_BIT = 8;
    public static final int POOLVOL_BIT = 16;
    public static final int EXTERNALMFVOL_BIT = 32;
    public static final int ALUVOL_BIT = 64;
    public static final int PERM_BASEMONITOR = 0;
    public static final int PERM_USAGEMONITOR = 1;
    public static final int PERM_HUR = 2;
    private static final int PP_PERFORMANCE = 4;
    private static final int PP_HORC = 5;
    private static final int PP_HRC = 7;
    private static final int PP_HUR = 16;
    private static final int PP_HURMF = 17;
    private static final int FUNC_BASEMONITOR = 1;
    private static final int FUNC_HORC = 1;
    private static final int FUNC_HRC = 1;
    private static final int FUNC_HUR = 1;
    private static final int FUNC_HURMF = 1;
    private static final int PERMISSION_MAX = 128;
    protected static RJMdProgress progress = new RJMdProgress(infomationStream);
    private static final int PORT_TARGET = 1;
    private static final int PORT_INITIATOR = 2;
    private static final int PORT_HTP = 8;
    private static final String HM = "HM";
    private static final int HM_MODEL_INDEX_BEG = 9;
    private static final int HM_MODEL_INDEX_END = 11;
    private static final String HM_MODEL_S = "20";
    private static final String PRODUCTNAME_S0S1 = "VSP G100/G200";
    private static final String PRODUCTNAME_S1 = "VSP G200";
    private SanResponse iScsiSanRes;
    private int iModel = 0;

    public void setExecParameter(RJMdExecParameter rJMdExecParameter) {
        this.parameter = rJMdExecParameter;
    }

    public void setLogPath(String string, String string2) throws IOException {
        File file;
        if (string == null) {
            string = ".";
        }
        if (string2 == null) {
            string2 = "export" + logid.format(new Date()) + ".log";
        }
        if (!(file = new File(string, string2)).getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        logStream = new PrintStream(new FileOutputStream(file), true);
    }

    public RJMdExecParameter getExecParameter() {
        return this.parameter;
    }

    public void putMessage(String string) {
        progress.reset();
        messageStream.println(string);
        RJMdDataControl.trace(string);
    }

    public static void putInfomation(String string) {
        progress.reset();
        infomationStream.println(string);
        RJMdDataControl.trace(string);
    }

    public String serverMessage(int n, int n2) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        String string = RJMdMessage.message("MSG003", objectArray);
        return string;
    }

    public static boolean trace(String string) {
        return RJMdDataControl.trace(string, 1);
    }

    public static boolean trace(String string, int n) {
        boolean bl = false;
        if (n <= 1) {
            String string2 = traceFormat.format(new Date()) + " " + string;
            if (logStream != null) {
                logStream.println(string2);
            }
            bl = true;
        }
        return bl;
    }

    public static PrintStream getMessageStream() {
        return messageStream;
    }

    public static PrintStream getInfomationStream() {
        return infomationStream;
    }

    public static PrintStream getLogStream() {
        return logStream;
    }

    protected String traceException(Exception exception) {
        Exception exception2 = exception;
        String string = null;
        if (exception instanceof GetRmiException) {
            GetRmiException getRmiException = (GetRmiException)exception;
            string = getRmiException.getClass().getName() + " : " + this.serverMessage(getRmiException.nErrCode, getRmiException.nErrData);
        } else if (exception instanceof SANRmiException) {
            SANRmiException sANRmiException = (SANRmiException)((Object)exception);
            string = ((Object)((Object)sANRmiException)).getClass().getName() + " : " + this.serverMessage(sANRmiException.nErrCode, sANRmiException.nErrData);
        } else {
            string = exception.getClass().getName() + " : " + exception.getMessage();
        }
        this.traceDC(string);
        return string;
    }

    protected boolean traceDC(String string) {
        return RJMdDataControl.trace(". " + string, 1);
    }

    public void initProgress(int n) {
        progress.init(n);
    }

    public void addProgress(int n) {
        progress.addProgress(n);
    }

    public void closeProgress() {
        progress.close();
    }

    public void retryProgress() {
        progress.retry();
    }

    private boolean checkRetryErrorCode(int n, int n2, boolean bl) {
        int[][] nArrayArray = new int[][]{{5205, 2003}, {2, 2016}, {5205, 2033}, {5305, 2033}, {1, 5508}, {2, 5510}, {5305, 8002}, {2, 9000}, {2, 6502}, {3, 2033}, {3, 2016}, {3, 3006}, {1, 4001}, {1, 5400}, {405, 8003}, {1, 1001}, {1, 107200}, {405, 6012}};
        boolean bl2 = false;
        this.traceDC("Find ErrorCode = (" + n2 + "," + n + ")");
        for (int i = 0; i < nArrayArray.length; ++i) {
            if (n2 != nArrayArray[i][0] || n != nArrayArray[i][1]) continue;
            --this.nRetryCounter;
            if (this.nRetryCounter <= 0) continue;
            if (bl) {
                this.retryProgress();
            }
            this.doSleep();
            this.traceDC("Retry!!!");
            bl2 = true;
        }
        return bl2;
    }

    private boolean checkRetryErrorCode(Exception exception, boolean bl) {
        boolean bl2 = false;
        this.traceDC("Find Exception = " + exception.toString());
        --this.nRetryCounter;
        if (this.nRetryCounter > 0) {
            if (bl) {
                this.retryProgress();
            }
            this.doSleep();
            this.traceDC("Retry!!!");
            bl2 = true;
        }
        return bl2;
    }

    private boolean checkRetryErrorCodeWithLogin(Exception exception, boolean bl) {
        boolean bl2 = false;
        String string = "";
        boolean bl3 = false;
        if (exception instanceof ConnectIOException) {
            string = "Specified \"ip\" is wrong.";
            bl3 = true;
        } else if (exception instanceof NoSuchObjectException) {
            string = "Specified \"ip\" is wrong.";
            bl3 = true;
        } else if (exception instanceof ConnectException) {
            string = "Specified \"ip\" is wrong.";
            bl3 = true;
        }
        if (bl3) {
            this.traceDC("[login] " + string);
            bl2 = false;
        } else {
            bl2 = this.checkRetryErrorCode(exception, bl);
        }
        return bl2;
    }

    private void doSleep() {
        try {
            Thread.sleep(this.parameter.getRetryTime() * 60000);
        }
        catch (Exception exception) {
            this.traceDC("doSleep() Exception!!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RCobj_interface_CheckRet login(String string, String string2, String string3, String string4, String string5, int n, int n2) throws RJMdRmiException {
        if (string.indexOf(":") >= 0) {
            string = "[" + string + "]";
        }
        String string6 = new String(string);
        string = new String("//" + string + ":" + string2 + "/com.hitachi.sanproject.rmi.supervisor.rmiserver");
        int n3 = 0;
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                SanObject sanObject;
                int n4 = Integer.parseInt(string3);
                SanSSLClientSocketFactory sanSSLClientSocketFactory = new SanSSLClientSocketFactory();
                Registry registry = LocateRegistry.getRegistry(string6, Integer.parseInt(string2), (RMIClientSocketFactory)sanSSLClientSocketFactory);
                SanRemote sanRemote = (SanRemote)registry.lookup("com.hitachi.sanproject.rmi.supervisor.rmiserver");
                this.setRmiObjectKV(sanRemote);
                this.m_generalParam = sanRemote.newData("GeneralParameter");
                this.m_generalParam.newObj("ClientInfo").putString("HostName", "localhost");
                SanRequest sanRequest = sanRemote.newRequest(this.m_generalParam, "SANreadAllStorageManagementServers");
                SanResponse sanResponse = sanRemote.invoke(this.m_generalParam, sanRequest);
                SanList sanList = sanResponse.getList("StorageManagementServers");
                boolean bl = false;
                Iterator iterator = sanList.iterator();
                while (iterator.hasNext()) {
                    sanObject = (SanObject)iterator.next();
                    int n5 = sanObject.getInt("SerialNumber");
                    if (n4 != n5) continue;
                    this.iModel = sanObject.getInt("Model");
                    bl = true;
                }
                if (!bl) {
                    this.traceDC("[login] Specified serial number is not found.");
                    throw new RJMdRmiException();
                }
                iterator = sanRemote.newRequest(this.m_generalParam, "SANreadStorageManagementServer");
                iterator.putInt("Model", this.iModel);
                iterator.putInt("SerialNumber", n4);
                sanObject = sanRemote.invoke(this.m_generalParam, (SanRequest)iterator);
                this.m_generalParam.newObj("StorageInfo").putInt("Model", this.iModel);
                this.m_generalParam.getObj("StorageInfo").putInt("SerialNumber", n4);
                this.m_generalParam.newObj("AccountInfo").putString("UserName", string4);
                this.m_generalParam.getObj("AccountInfo").putString("Password", string5);
                this.HostPath = new String(string);
                this.traceDC("HostPath = " + this.HostPath);
                if (n3 == 0) {
                    this.traceDC("[login] lookup1:start");
                    String string7 = sanObject.getString("RmiControlObjBindName");
                    if (string7 == null || string7.length() == 0) {
                        throw new RJMdRmiException();
                    }
                    this.rmicontrol = (RmiControlObj)registry.lookup(string7);
                    n3 = 1;
                    this.nRetryCounter = this.getRetryCount() + 1;
                    this.traceDC("lookup1 Normal");
                }
                if (n3 == 1) {
                    this.traceDC("[login] checkLicenseEx:start");
                    this.objname = this.rmicontrol.checkLicenseSx(string4, string5, n2, "", "");
                    n3 = 2;
                    this.nRetryCounter = this.getRetryCount() + 1;
                    this.traceDC("checkLicenseEx OK!!");
                }
                if (n3 == 2) {
                    this.traceDC("[login] lookup2:start");
                    if (this.objname.getStrRegBindName() == null) {
                        throw new RJMdRmiException();
                    }
                    this.rmiobj = (RmiObj_Webcon)registry.lookup(this.objname.getStrRegBindName());
                    n3 = 3;
                    this.nRetryCounter = this.getRetryCount() + 1;
                    this.traceDC("lookup2 Normal");
                }
                if (n3 == 3) {
                    String string8;
                    String string9;
                    this.traceDC("[login] setUserTimeoutValue:start");
                    this.rmiobj.setUserTimeoutValue(BaseTimeoutValue.TIMEOUT_LOGOFF, this.getTimeoutValue());
                    n3 = 4;
                    this.nRetryCounter = this.getRetryCount() + 1;
                    this.traceDC("setUserTimeoutValue Normal");
                    this.connect = true;
                    Robj_interface_DISKgetSubsystemInfo robj_interface_DISKgetSubsystemInfo = this.rmiobj.getSubsystemInfo();
                    if (robj_interface_DISKgetSubsystemInfo == null || this.parameter == null) throw new RJMdRmiException();
                    this.dkcProductName = robj_interface_DISKgetSubsystemInfo.getStrDKCProductName();
                    this.dkcMibVersion = string9 = robj_interface_DISKgetSubsystemInfo.getStrDKCMibVersion();
                    RJMdDataControl.putInfomation("[MPC Software Version] " + string9);
                    String string10 = this.parameter.getVersion();
                    RJMdDataControl.putInfomation("[ExportTool version] " + string10);
                    RJMdDataControl.putInfomation("[ExportTool IF version] 83-00-00");
                    if (string9 == null || 4 >= string9.length() || string10 == null || 4 >= string10.length()) throw new RJMdRmiException();
                    String string11 = string9.substring(0, 5);
                    if (!string11.equals(string8 = string10.substring(0, 5))) {
                        this.traceDC("[login] version unmatched");
                        throw new RJMdRmiException();
                    }
                }
                if (n3 == 4) {
                    this.traceDC("[login] useMonitor:start");
                    this.rmiobj.useMonitor(true);
                    n3 = 5;
                    this.nRetryCounter = this.getRetryCount() + 1;
                    this.traceDC("useMonitor Normal");
                }
                this.nRetryCounter = 0;
                this.cache = new RJMdDataCache(this, this.rmiobj);
            }
            catch (GetRmiException getRmiException) {
                if (this.checkRetryErrorCode(getRmiException.nErrData, getRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)getRmiException)));
            }
            catch (NotBoundException notBoundException) {
                if (this.checkRetryErrorCode(notBoundException, false)) continue;
                throw new RJMdRmiException(this.traceException(notBoundException));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCodeWithLogin(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (SanRmiException sanRmiException) {
                if (this.checkRetryErrorCode((Exception)((Object)sanRmiException), false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sanRmiException)));
            }
            catch (SanDataException sanDataException) {
                if (this.checkRetryErrorCode((Exception)((Object)sanDataException), false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sanDataException)));
            }
        }
        return this.objname;
    }

    public void setRmiObjectKV(SanRemote sanRemote) {
        this.m_RmiObjKV = sanRemote;
    }

    public SanRemote getRmiObjectKV() {
        return this.m_RmiObjKV;
    }

    public SanData getSanData() {
        return this.m_generalParam;
    }

    public void logout() throws RJMdRmiException {
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                this.rmiobj.useMonitor(false);
                this.nRetryCounter = 0;
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                this.traceDC("useMonitor(false) failed");
                this.traceException(remoteException);
                this.nRetryCounter = 0;
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode((Exception)((Object)sANRmiException), false)) continue;
                this.traceDC("useMonitor(false) failed");
                this.traceException((Exception)((Object)sANRmiException));
                this.nRetryCounter = 0;
            }
        }
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                this.rmiobj.logOff();
                this.nRetryCounter = 0;
                this.connect = false;
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
    }

    public boolean isConnect() {
        return this.connect;
    }

    protected String toLdevString(int n, int n2) {
        String string = this.toHexString(n, 2) + ":" + this.toHexString(n2, 2);
        return string;
    }

    private String toHexString(int n, int n2) {
        String string = "0000000" + Integer.toHexString(n).toUpperCase();
        return string.substring(string.length() - n2);
    }

    public ArrayList getPort(int n) throws RJMdRmiException {
        return this.getPortData(n);
    }

    public ArrayList getPortToWWN(int n) throws RJMdRmiException {
        return this.getPortToWWNData(n);
    }

    public ArrayList getPG() throws RJMdRmiException {
        return this.getPGListData(1);
    }

    public ArrayList getPG(int n) throws RJMdRmiException {
        return this.getPGListData(n);
    }

    public ArrayList getPGToLDEV(int n, int n2) throws RJMdRmiException {
        return this.getPGtoLDEVData(n, n2, 0);
    }

    public ArrayList getPGToLDEV(int n, int n2, int n3) throws RJMdRmiException {
        return this.getPGtoLDEVData(n, n2, n3);
    }

    public DKCgetPGLDEVNumber getLDEVToPG(int n, int n2, int n3) throws RJMdRmiException {
        return this.getLDEVtoPGData(n, n2, n3);
    }

    public ArrayList getPPCGroup() throws RJMdRmiException {
        return this.getPPCGroupData();
    }

    public ArrayList getPortToHostGroup(int n) throws RJMdRmiException {
        return this.getPortToHostGroupData(n);
    }

    public ArrayList getHostGroupToLU(int n, int n2) throws RJMdRmiException {
        return this.getHostGroupToLUData(n, n2);
    }

    public void clearCacheData() {
        if (this.cache != null) {
            this.cache.clearCache();
        }
    }

    protected ArrayList getPGListData(int n) throws RJMdRmiException {
        ArrayList<RJMdDataPG> arrayList = new ArrayList<RJMdDataPG>();
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            ArrayList arrayList2 = this.makeOriginalPGList();
            this.nRetryCounter = 0;
            block7: for (int i = 0; arrayList2.size() > i; ++i) {
                RJMdDataPG rJMdDataPG = (RJMdDataPG)arrayList2.get(i);
                switch (n) {
                    case 2: {
                        if (rJMdDataPG.isExternal()) continue block7;
                        arrayList.add(rJMdDataPG);
                        continue block7;
                    }
                    case 3: {
                        if (!rJMdDataPG.isExternal()) continue block7;
                        arrayList.add(rJMdDataPG);
                        continue block7;
                    }
                    case 4: {
                        if (rJMdDataPG.isExternal() || rJMdDataPG.isVirtual() || rJMdDataPG.isExternal_MF()) continue block7;
                        arrayList.add(rJMdDataPG);
                        continue block7;
                    }
                    case 1: {
                        arrayList.add(rJMdDataPG);
                        continue block7;
                    }
                }
            }
        }
        return arrayList;
    }

    protected ArrayList makeOriginalPGList() throws RJMdRmiException {
        ArrayList<RJMdDataPG> arrayList = new ArrayList<RJMdDataPG>();
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                Robj_interface_DKCgetAllPGNumber[] robj_interface_DKCgetAllPGNumberArray = this.cache.getAllPGNumber();
                this.nRetryCounter = 0;
                if (robj_interface_DKCgetAllPGNumberArray == null) continue;
                for (int i = 0; i < robj_interface_DKCgetAllPGNumberArray.length; ++i) {
                    arrayList.add(new RJMdDataPG(robj_interface_DKCgetAllPGNumberArray[i].getIFB4(), robj_interface_DKCgetAllPGNumberArray[i].getIPG()));
                }
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        return arrayList;
    }

    public void createLdevCache(ArrayList arrayList) throws RJMdRmiException {
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                RJMdDataPG rJMdDataPG;
                RJiPGIndex[] rJiPGIndexArray = new RJiPGIndex[arrayList.size()];
                Iterator iterator = arrayList.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    rJMdDataPG = (RJMdDataPG)iterator.next();
                    RJiPGIndex rJiPGIndex = new RJiPGIndex();
                    rJiPGIndex.setIFB4(rJMdDataPG.getFB4());
                    rJiPGIndex.setIPG(rJMdDataPG.getPG());
                    rJiPGIndexArray[n] = rJiPGIndex;
                    ++n;
                }
                DKCgetPGLDEVNumber[] dKCgetPGLDEVNumberArray = this.cache.getAllPGLDEVNumber(rJiPGIndexArray);
                rJMdDataPG = new RJSetGettingParamLDEV();
                rJMdDataPG.setBBasic(true);
                rJMdDataPG.setBPool(true);
                this.cache.createPgLdevCache(dKCgetPGLDEVNumberArray, (RJSetGettingParamLDEV)rJMdDataPG);
                this.nRetryCounter = 0;
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
    }

    public void createPgChache(ArrayList arrayList) throws RJMdRmiException {
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                RJMdDataPG rJMdDataPG;
                RJiPGIndex[] rJiPGIndexArray = new RJiPGIndex[arrayList.size()];
                Iterator iterator = arrayList.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    rJMdDataPG = (RJMdDataPG)iterator.next();
                    RJiPGIndex rJiPGIndex = new RJiPGIndex();
                    rJiPGIndex.setIFB4(rJMdDataPG.getFB4());
                    rJiPGIndex.setIPG(rJMdDataPG.getPG());
                    rJiPGIndexArray[n] = rJiPGIndex;
                    ++n;
                }
                DKCgetPGLDEVNumber[] dKCgetPGLDEVNumberArray = this.cache.getAllPGLDEVNumber(rJiPGIndexArray);
                rJMdDataPG = new RJSetGettingParamLDEV();
                rJMdDataPG.setBBasic(true);
                rJMdDataPG.setBPool(true);
                this.cache.createLdevPgCashe(dKCgetPGLDEVNumberArray, (RJSetGettingParamLDEV)rJMdDataPG);
                this.nRetryCounter = 0;
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
    }

    protected ArrayList getPGtoLDEVData(int n, int n2, int n3) throws RJMdRmiException {
        ArrayList<RJMdDataLDEV> arrayList = new ArrayList<RJMdDataLDEV>();
        RJiPGIndex rJiPGIndex = new RJiPGIndex();
        rJiPGIndex.setIFB4(n);
        rJiPGIndex.setIPG(n2);
        RJMdDataLDEV[] rJMdDataLDEVArray = this.cache.getPGtoLDEVData(rJiPGIndex);
        if (rJMdDataLDEVArray != null) {
            for (int i = 0; i < rJMdDataLDEVArray.length; ++i) {
                if ((n3 & 1) != 0 && rJMdDataLDEVArray[i].isPoolVol()) continue;
                arrayList.add(rJMdDataLDEVArray[i]);
            }
        }
        return arrayList;
    }

    protected DKCgetPGLDEVNumber getLDEVtoPGData(int n, int n2, int n3) throws RJMdRmiException {
        RJiLDEVIndex rJiLDEVIndex = new RJiLDEVIndex();
        rJiLDEVIndex.sLDKC = (short)n;
        rJiLDEVIndex.sCU = (short)n2;
        rJiLDEVIndex.sLDEV = (short)n3;
        DKCgetPGLDEVNumber dKCgetPGLDEVNumber = this.cache.getLDEVtoPGData(rJiLDEVIndex);
        return dKCgetPGLDEVNumber;
    }

    protected ArrayList getPPCGroupData() throws RJMdRmiException {
        ArrayList<RJMdDataPPCGroup> arrayList = new ArrayList<RJMdDataPPCGroup>();
        PPCGroupInfo[] pPCGroupInfoArray = null;
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                pPCGroupInfoArray = this.cache.getAllPPCGroupInfo();
                this.nRetryCounter = 0;
                if (pPCGroupInfoArray == null) continue;
                for (int i = 0; i < pPCGroupInfoArray.length; ++i) {
                    arrayList.add(new RJMdDataPPCGroup(pPCGroupInfoArray[i].getGroupName()));
                }
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        return arrayList;
    }

    protected ArrayList getPortData(int n) throws RJMdRmiException {
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 8) != 0;
        ArrayList<RJMdDataPort> arrayList = new ArrayList<RJMdDataPort>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        this.nRetryCounter = this.getRetryCount() + 1;
        Robj_interface_RJiPortInfoDetail[] robj_interface_RJiPortInfoDetailArray = null;
        Robj_interface_RJiPortAttributeInfoDetail[] robj_interface_RJiPortAttributeInfoDetailArray = null;
        while (this.nRetryCounter > 0) {
            try {
                Object object;
                robj_interface_RJiPortInfoDetailArray = this.cache.getAllPortInfo();
                robj_interface_RJiPortAttributeInfoDetailArray = this.cache.getPortAttributeInfo();
                this.nRetryCounter = 0;
                if (robj_interface_RJiPortInfoDetailArray == null || robj_interface_RJiPortAttributeInfoDetailArray == null) continue;
                for (int i = 0; i < robj_interface_RJiPortInfoDetailArray.length; ++i) {
                    object = robj_interface_RJiPortInfoDetailArray[i].getStrPortDisplayName();
                    byte by = this.getPortIDtoAttributeInfo(robj_interface_RJiPortAttributeInfoDetailArray, robj_interface_RJiPortInfoDetailArray[i].getSPort());
                    arrayList.add(new RJMdDataPort(robj_interface_RJiPortInfoDetailArray[i].getSPort(), (String)object, robj_interface_RJiPortInfoDetailArray[i].getByPortKindNo(), by));
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object = (RJMdDataPort)iterator.next();
                    if ((!bl || ((RJMdDataPort)object).getPortKind() != 3 && ((RJMdDataPort)object).getPortKind() != 4 && ((RJMdDataPort)object).getPortKind() != 9) && (!bl2 || ((RJMdDataPort)object).getPortKind() != 5 && ((RJMdDataPort)object).getPortKind() != 6 && ((RJMdDataPort)object).getPortKind() != 9) && (!bl3 || ((RJMdDataPort)object).getPortKind() != 7)) continue;
                    arrayList2.add(object);
                }
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        return arrayList2;
    }

    protected byte getPortIDtoAttributeInfo(Robj_interface_RJiPortAttributeInfoDetail[] robj_interface_RJiPortAttributeInfoDetailArray, short s) {
        byte by = 0;
        for (int i = 0; i < robj_interface_RJiPortAttributeInfoDetailArray.length; ++i) {
            short s2 = robj_interface_RJiPortAttributeInfoDetailArray[i].getSPort();
            if (s2 != s) continue;
            by = robj_interface_RJiPortAttributeInfoDetailArray[i].getByPortKind();
        }
        return by;
    }

    protected ArrayList getPortToWWNData(int n) throws RJMdRmiException {
        ArrayList<RJMdDataWWN> arrayList = new ArrayList<RJMdDataWWN>();
        PPCAllPortWWNInfo[] pPCAllPortWWNInfoArray = null;
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                pPCAllPortWWNInfoArray = this.cache.getAllPortWWNInfo();
                this.nRetryCounter = 0;
                if (pPCAllPortWWNInfoArray == null) continue;
                for (int i = 0; i < pPCAllPortWWNInfoArray.length; ++i) {
                    if (pPCAllPortWWNInfoArray[i].getPortID() != n) continue;
                    PPCAllPortWWNInfo pPCAllPortWWNInfo = pPCAllPortWWNInfoArray[i];
                    for (int j = 0; j < pPCAllPortWWNInfo.getElments().length; ++j) {
                        byte[] byArray = pPCAllPortWWNInfo.getElment(j).getWWNBytes();
                        String string = pPCAllPortWWNInfo.getElment(j).getNickName();
                        arrayList.add(new RJMdDataWWN(byArray, string));
                    }
                }
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        return arrayList;
    }

    protected ArrayList getPortToHostGroupData(int n) throws RJMdRmiException {
        RJMdDataHostGroup[] rJMdDataHostGroupArray;
        SanRemote sanRemote;
        ArrayList<RJMdDataHostGroup> arrayList = new ArrayList<RJMdDataHostGroup>();
        SanData sanData = this.getSanData().clone();
        try {
            SanResponse sanResponse;
            sanRemote = this.getRmiObjectKV();
            rJMdDataHostGroupArray = sanRemote.newRequest(sanData, "LUNMreadAllPortiScsiInfo");
            this.iScsiSanRes = sanResponse = sanRemote.invoke(sanData, (SanRequest)rJMdDataHostGroupArray);
        }
        catch (SanRmiException sanRmiException) {
            throw new RJMdRmiException();
        }
        catch (RemoteException remoteException) {
            throw new RJMdRmiException();
        }
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                sanRemote = new RJiPortIndex();
                sanRemote.setSPort((short)n);
                rJMdDataHostGroupArray = this.cache.getAllHostgroupInfo((Robj_interface_RJiPortIndex)sanRemote, this.iScsiSanRes);
                this.nRetryCounter = 0;
                if (rJMdDataHostGroupArray == null) continue;
                for (int i = 0; i < rJMdDataHostGroupArray.length; ++i) {
                    arrayList.add(rJMdDataHostGroupArray[i]);
                }
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
            catch (SanDataException sanDataException) {
                if (this.checkRetryErrorCode((Exception)((Object)sanDataException), false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sanDataException)));
            }
        }
        return arrayList;
    }

    protected ArrayList getHostGroupToLUData(int n, int n2) throws RJMdRmiException {
        ArrayList<RJMdDataLU> arrayList = new ArrayList<RJMdDataLU>();
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                RJiPortIndex rJiPortIndex = new RJiPortIndex();
                rJiPortIndex.setSPort((short)n);
                RJMdDataLU[] rJMdDataLUArray = this.cache.getALLPathInfo((Robj_interface_RJiPortIndex)rJiPortIndex, n2);
                this.nRetryCounter = 0;
                for (int i = 0; i < rJMdDataLUArray.length; ++i) {
                    arrayList.add(rJMdDataLUArray[i]);
                }
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        return arrayList;
    }

    public DISKgetSubsystemInfo getSubsystemInfo() throws RJMdRmiException {
        DISKgetSubsystemInfo dISKgetSubsystemInfo = null;
        this.traceDC("getSubsystemInfo start");
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                dISKgetSubsystemInfo = (DISKgetSubsystemInfo)this.rmiobj.getSubsystemInfo();
                this.nRetryCounter = 0;
                if (dISKgetSubsystemInfo != null) continue;
                this.traceDC("No Data");
            }
            catch (GetRmiException getRmiException) {
                if (this.checkRetryErrorCode(getRmiException.nErrData, getRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)getRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        this.traceDC("getSubsystemInfo end ");
        return dISKgetSubsystemInfo;
    }

    public String getProductName() throws RJMdRmiException {
        String string;
        block6: {
            string = "";
            this.traceDC("getProductName start");
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("devname");
                ArrayList arrayList2 = this.rmiobj.getDataChangeTable(arrayList);
                int n = Integer.valueOf(Integer.toHexString(this.objname.getNOEMTYPE()));
                ChangeDataAllString[] changeDataAllStringArray = (ChangeDataAllString[])arrayList2.get(0);
                for (int i = 0; i < changeDataAllStringArray.length; ++i) {
                    if (Integer.valueOf(changeDataAllStringArray[i].strMibData) != n) continue;
                    string = changeDataAllStringArray[i].strChangeData1;
                    if (this.isHM_SMODEL() && this.objname.isHitachiVender()) {
                        string = this.objname.isInternal() ? PRODUCTNAME_S0S1 : PRODUCTNAME_S1;
                    }
                    break;
                }
            }
            catch (GetRmiException getRmiException) {
                if (!this.checkRetryErrorCode(getRmiException.nErrData, getRmiException.nErrCode, false)) {
                    throw new RJMdRmiException(this.traceException((Exception)((Object)getRmiException)));
                }
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) break block6;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        this.traceDC("getProductName end ");
        return string;
    }

    public ArrayList getNotGroupedWWN() throws RJMdRmiException {
        ArrayList<RJMdDataWWN> arrayList = new ArrayList<RJMdDataWWN>();
        PPCGroupWWNInfo[] pPCGroupWWNInfoArray = null;
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                pPCGroupWWNInfoArray = this.cache.getNonPPCGroupWWNInfo();
                this.nRetryCounter = 0;
                if (pPCGroupWWNInfoArray == null) continue;
                for (int i = 0; i < pPCGroupWWNInfoArray.length; ++i) {
                    arrayList.add(new RJMdDataWWN(pPCGroupWWNInfoArray[i].getWWNBytes(), pPCGroupWWNInfoArray[i].getNickName()));
                }
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        return arrayList;
    }

    public ArrayList getPPCGroupToWWN(String string) throws RJMdRmiException {
        ArrayList<RJMdDataWWN> arrayList = new ArrayList<RJMdDataWWN>();
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                PPCAllPPCGroupWWNInfo[] pPCAllPPCGroupWWNInfoArray = this.cache.getAllPPCGroupWWNInfo();
                this.nRetryCounter = 0;
                if (pPCAllPPCGroupWWNInfoArray == null) continue;
                for (int i = 0; i < pPCAllPPCGroupWWNInfoArray.length; ++i) {
                    if (pPCAllPPCGroupWWNInfoArray[i].getNickName().compareTo(string) != 0) continue;
                    for (int j = 0; j < pPCAllPPCGroupWWNInfoArray[i].getElements().length; ++j) {
                        arrayList.add(new RJMdDataWWN(pPCAllPPCGroupWWNInfoArray[i].getElement(j).getWWNBytes(), pPCAllPPCGroupWWNInfoArray[i].getElement(j).getNickName()));
                    }
                }
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        return arrayList;
    }

    public ArrayList changeDivideTime(MonArg monArg) {
        int n = this.getDivedeTimeFromMonAgr(monArg);
        ArrayList<Comparable<Date>> arrayList = new ArrayList<Comparable<Date>>();
        MonTerm monTerm = (MonTerm)monArg;
        Date date = monTerm.getStartTime();
        Date date2 = monTerm.getEndTime();
        if (date != null && date2 != null) {
            while (true) {
                Date date3;
                Long l;
                if ((l = new Long(((date3 = new Date(Math.min(date2.getTime(), date.getTime() + (long)(n * 60 * 1000)))).getTime() - date.getTime()) / 1000L / 60L)) != 0L) {
                    arrayList.add(date);
                    arrayList.add(date3);
                    arrayList.add(l);
                }
                if (date3.compareTo(date2) == 0) break;
                date = date3;
            }
        }
        return arrayList;
    }

    public ArrayList changeDivideTimeHIHSM(MonArg monArg) {
        int n = this.getDivedeTimeFromMonAgr(monArg);
        ArrayList<Comparable<Date>> arrayList = new ArrayList<Comparable<Date>>();
        HIHsmUseRateRangeArgInfo hIHsmUseRateRangeArgInfo = (HIHsmUseRateRangeArgInfo)monArg;
        Date date = hIHsmUseRateRangeArgInfo.getStartDate();
        Date date2 = hIHsmUseRateRangeArgInfo.getEndDate();
        if (date != null && date2 != null) {
            while (true) {
                Date date3;
                Long l;
                if ((l = new Long(((date3 = new Date(Math.min(date2.getTime(), date.getTime() + (long)(n * 60 * 1000)))).getTime() - date.getTime()) / 1000L / 60L)) != 0L) {
                    arrayList.add(date);
                    arrayList.add(date3);
                    arrayList.add(l);
                }
                if (date3.compareTo(date2) == 0) break;
                date = date3;
            }
        }
        return arrayList;
    }

    private int getDivedeTimeFromMonAgr(MonArg monArg) {
        int n = 0;
        if (monArg instanceof HIHsmUseRateRangeArgInfo) {
            if (monArg.getClass().getName().indexOf("HIHsmPhysical") != -1) {
                n = this.parameter.getDivideShort() * this.parameter.getBasicShortRange().getIntervalTime();
                this.traceDC("HIHSM divideTime = " + n);
            } else {
                n = this.parameter.getDivideLong() * this.parameter.getBasicLongRange().getIntervalTime();
                this.traceDC("HIHSM LongRange divideTime = " + n);
            }
        } else {
            n = this.parameter.getDivideShort() * this.parameter.getBasicShortRange().getIntervalTime();
            this.traceDC("divideTime = " + n);
        }
        return n;
    }

    private int getTimeoutValue() {
        int n = this.parameter.getTimeoutValue();
        if (this.parameter.getRetryTime() >= this.parameter.getTimeoutValue()) {
            n = this.parameter.getRetryTime() + 1;
        }
        return n;
    }

    private int getRetryCount() {
        int n = this.parameter.getRetryCount();
        if (n == Integer.MAX_VALUE) {
            --n;
        }
        return n;
    }

    public long lock(String string, String string2) throws RJMdRmiException {
        long l;
        block6: {
            l = -1L;
            SanData sanData = this.getSanData().clone();
            try {
                SanRemote sanRemote = this.getRmiObjectKV();
                SanRequest sanRequest = sanRemote.newRequest(sanData, "SANlockSystem");
                sanRequest.putString("UserName", string);
                sanRequest.putString("Password", string2);
                SanResponse sanResponse = sanRemote.invoke(sanData, sanRequest);
                l = sanResponse.getLong("ResourcelockId");
            }
            catch (SanDataException sanDataException) {
                if (!this.checkRetryErrorCode((Exception)((Object)sanDataException), false)) {
                    throw new RJMdRmiException(this.traceException((Exception)((Object)sanDataException)));
                }
            }
            catch (RemoteException remoteException) {
                if (!this.checkRetryErrorCode(remoteException, false)) {
                    throw new RJMdRmiException(this.traceException(remoteException));
                }
            }
            catch (SanRmiException sanRmiException) {
                if (this.checkRetryErrorCode((Exception)((Object)sanRmiException), false)) break block6;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sanRmiException)));
            }
        }
        return l;
    }

    public void unlock(long l) throws RJMdRmiException {
        block6: {
            SanData sanData = this.getSanData().clone();
            try {
                SanRemote sanRemote = this.getRmiObjectKV();
                SanRequest sanRequest = sanRemote.newRequest(sanData, new String("SANunlockSystem"));
                sanRequest.putLong("ResourcelockId", l);
                SanResponse sanResponse = sanRemote.invoke(sanData, sanRequest);
            }
            catch (SanDataException sanDataException) {
                if (!this.checkRetryErrorCode((Exception)((Object)sanDataException), false)) {
                    throw new RJMdRmiException(this.traceException((Exception)((Object)sanDataException)));
                }
            }
            catch (RemoteException remoteException) {
                if (!this.checkRetryErrorCode(remoteException, false)) {
                    throw new RJMdRmiException(this.traceException(remoteException));
                }
            }
            catch (SanRmiException sanRmiException) {
                if (this.checkRetryErrorCode((Exception)((Object)sanRmiException), false)) break block6;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sanRmiException)));
            }
        }
    }

    public void setMonitorSwtch(MonSetMonitoringSwitch monSetMonitoringSwitch) {
        this.ApplyDataPool1.add(monSetMonitoringSwitch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doApply(long l) throws RJMdRmiException {
        try {
            if (this.ApplyDataPool1.size() != 0) {
                this.rmiobj.setTransactionStartEx(l);
                this.rmiobj.setAllMethods((List)this.ApplyDataPool1);
                this.rmiobj.setCommit();
                while (this.rmiobj.getStatusInfo() == 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.ApplyDataPool2.size() != 0) {
                this.rmiobj.setTransactionStartEx(l);
                this.rmiobj.setAllMethods((List)this.ApplyDataPool2);
                this.rmiobj.setCommit();
                while (this.rmiobj.getStatusInfo() == 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.ApplyDataPool3.size() != 0) {
                this.rmiobj.setTransactionStartEx(l);
                this.rmiobj.setAllMethods((List)this.ApplyDataPool3);
                this.rmiobj.setCommit();
                while (this.rmiobj.getStatusInfo() == 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (RemoteException remoteException) {
            if (!this.checkRetryErrorCode(remoteException, false)) {
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        catch (GetRmiException getRmiException) {
            if (!this.checkRetryErrorCode((Exception)((Object)getRmiException), false)) {
                throw new RJMdRmiException(this.traceException((Exception)((Object)getRmiException)));
            }
        }
        catch (SetRmiException setRmiException) {
            if (!this.checkRetryErrorCode((Exception)((Object)setRmiException), false)) {
                throw new RJMdRmiException(this.traceException((Exception)((Object)setRmiException)));
            }
        }
        finally {
            this.clearApplyData();
        }
    }

    public void clearApplyData() {
        this.ApplyDataPool1.clear();
        this.ApplyDataPool2.clear();
        this.ApplyDataPool3.clear();
    }

    private String getPermission() throws RJMdRmiException {
        String string = new String();
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            if (this.objparam == null) {
                this.objparam = (RCobj_interface_LogonParam)this.objname.getObjLogonParamObject();
            }
            string = this.objparam.getStrWritePermission();
            this.nRetryCounter = 0;
        }
        this.traceDC("Write Permission is " + string);
        return string;
    }

    public boolean hasPermission(int n) throws RJMdRmiException {
        boolean bl = false;
        int n2 = 0;
        String string = this.getPermission();
        byte[] byArray = this.getBitInfo(string);
        switch (n) {
            case 0: {
                this.traceDC("[BaseMonitor]");
                n2 = byArray[4] & 1;
                if (n2 != 1) break;
                bl = true;
                break;
            }
            case 1: {
                this.traceDC("[UsageMonitor]");
                n2 = byArray[5] & 1;
                if (n2 == 1) {
                    bl = true;
                }
                if ((n2 = byArray[7] & 1) != 1) break;
                bl = true;
                break;
            }
            case 2: {
                this.traceDC("[HUR]");
                n2 = byArray[16] & 1;
                if (n2 == 1) {
                    bl = true;
                }
                if ((n2 = byArray[17] & 1) != 1) break;
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.traceDC(" -> Permission denied!!");
        }
        return bl;
    }

    private byte[] getBitInfo(String string) {
        int n;
        byte[] byArray = new byte[64];
        String string2 = new String();
        int n2 = 0;
        int n3 = string.length();
        if (n3 < 128) {
            n = 0;
            while (128 > n3 + n2) {
                string2 = string2 + "0";
                ++n2;
            }
        }
        if ((n = (string2 = string2 + string).length()) >= 128) {
            n = 127;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n > 0) {
            n4 = Integer.parseInt(string2.substring(n, n + 1), 16);
            n5 = Integer.parseInt(string2.substring(--n, n + 1), 16);
            --n;
            byArray[n6] = (byte)(n5 * 16 + n4);
            ++n6;
        }
        return byArray;
    }

    public MonitorInfo getMonitorInfo(MonArg monArg) throws RJMdRmiException {
        this.traceDC("getMonitorInfo start [" + monArg.toString() + "]");
        MonitorInfo monitorInfo = null;
        monitorInfo = monArg instanceof MonTerm ? this.getDivideInfo(monArg) : (monArg instanceof HIHsmUseRateRangeArgInfo ? this.getDivideInfoHIHSM(monArg) : this.getSimpleInfo(monArg));
        this.traceDC("getMonitorInfo end");
        return monitorInfo;
    }

    private MonitorInfo getSimpleInfo(MonArg monArg) throws RJMdRmiException {
        MonitorInfo monitorInfo = null;
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                monitorInfo = this.rmiobj.getMonitorInfo(monArg);
                this.nRetryCounter = 0;
                if (monitorInfo != null) continue;
                this.traceDC("No Data");
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        return monitorInfo;
    }

    private MonitorInfo getDivideInfo(MonArg monArg) throws RJMdRmiException {
        this.traceDC("getDivideInfo start");
        MonitorInfo monitorInfo = null;
        ArrayList arrayList = this.changeDivideTime(monArg);
        RJMdDataTracer rJMdDataTracer = new RJMdDataTracer(this);
        int n = this.parameter.getDebug();
        for (int i = 0; i < arrayList.size(); i += 3) {
            MonitorInfo monitorInfo2 = null;
            this.nRetryCounter = this.getRetryCount() + 1;
            while (this.nRetryCounter > 0) {
                try {
                    this.traceDC("[" + (Date)arrayList.get(i) + " -> " + (Date)arrayList.get(i + 1) + "]");
                    MonTerm monTerm = (MonTerm)monArg;
                    monTerm.setMonitorTime((Date)arrayList.get(i), (Date)arrayList.get(i + 1));
                    monitorInfo2 = this.rmiobj.getMonitorInfo(monArg);
                    this.nRetryCounter = 0;
                    if (n == 1) {
                        rJMdDataTracer.printLog(monArg);
                        rJMdDataTracer.printLog(monitorInfo2);
                    }
                    if (i == 0) {
                        monitorInfo = monitorInfo2;
                        continue;
                    }
                    MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)monitorInfo;
                    while (monitorInfoCollection.getNextCollection() != null) {
                        monitorInfoCollection = monitorInfoCollection.getNextCollection();
                    }
                    monitorInfoCollection.setNextCollection((MonitorInfoCollection)monitorInfo2);
                }
                catch (SANRmiException sANRmiException) {
                    if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, true)) continue;
                    throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
                }
                catch (RemoteException remoteException) {
                    if (this.checkRetryErrorCode(remoteException, true)) continue;
                    throw new RJMdRmiException(this.traceException(remoteException));
                }
            }
        }
        this.traceDC("getDivideInfo end");
        return monitorInfo;
    }

    private MonitorInfo getDivideInfoHIHSM(MonArg monArg) throws RJMdRmiException {
        this.traceDC("getDivideInfo start");
        MonitorInfo monitorInfo = null;
        ArrayList arrayList = this.changeDivideTimeHIHSM(monArg);
        RJMdDataTracer rJMdDataTracer = new RJMdDataTracer(this);
        int n = this.parameter.getDebug();
        for (int i = 0; i < arrayList.size(); i += 3) {
            MonitorInfo monitorInfo2 = null;
            this.nRetryCounter = this.getRetryCount() + 1;
            while (this.nRetryCounter > 0) {
                try {
                    this.traceDC("[" + (Date)arrayList.get(i) + " -> " + (Date)arrayList.get(i + 1) + "]");
                    HIHsmUseRateRangeArgInfo hIHsmUseRateRangeArgInfo = (HIHsmUseRateRangeArgInfo)monArg;
                    hIHsmUseRateRangeArgInfo.setStartDate((Date)arrayList.get(i));
                    hIHsmUseRateRangeArgInfo.setEndDate((Date)arrayList.get(i + 1));
                    monitorInfo2 = this.rmiobj.getMonitorInfo(monArg);
                    this.nRetryCounter = 0;
                    if (n == 1) {
                        rJMdDataTracer.printLog(monArg);
                        rJMdDataTracer.printLog(monitorInfo2);
                    }
                    if (i == 0) {
                        monitorInfo = monitorInfo2;
                        continue;
                    }
                    MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)monitorInfo;
                    while (monitorInfoCollection.getNextCollection() != null) {
                        monitorInfoCollection = monitorInfoCollection.getNextCollection();
                    }
                    monitorInfoCollection.setNextCollection((MonitorInfoCollection)monitorInfo2);
                }
                catch (SANRmiException sANRmiException) {
                    if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, true)) continue;
                    throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
                }
                catch (RemoteException remoteException) {
                    if (this.checkRetryErrorCode(remoteException, true)) continue;
                    throw new RJMdRmiException(this.traceException(remoteException));
                }
            }
        }
        this.traceDC("getDivideInfo end");
        return monitorInfo;
    }

    public Robj_interface_RJiPRMName getCLPR() throws RJMdRmiException {
        Robj_interface_RJiPRMName robj_interface_RJiPRMName = null;
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                robj_interface_RJiPRMName = this.rmiobj.getPRMName();
                this.nRetryCounter = 0;
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode((Exception)((Object)sANRmiException), false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        return robj_interface_RJiPRMName;
    }

    public ArrayList getCLPRList() throws RJMdRmiException {
        ArrayList<Robj_interface_RJiCLPRName> arrayList = new ArrayList<Robj_interface_RJiCLPRName>();
        Robj_interface_RJiPRMName robj_interface_RJiPRMName = this.getCLPR();
        Robj_interface_RJiSLPRName[] robj_interface_RJiSLPRNameArray = robj_interface_RJiPRMName.getObjSLPRName();
        for (int i = 0; i < robj_interface_RJiSLPRNameArray.length; ++i) {
            Robj_interface_RJiCLPRName[] robj_interface_RJiCLPRNameArray = robj_interface_RJiSLPRNameArray[i].getObjCLPRName();
            for (int j = 0; j < robj_interface_RJiCLPRNameArray.length; ++j) {
                arrayList.add(robj_interface_RJiCLPRNameArray[j]);
            }
        }
        return arrayList;
    }

    public ArrayList getCU() throws RJMdRmiException {
        ArrayList<RJMdDataCU> arrayList = new ArrayList<RJMdDataCU>();
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                Robj_interface_RJiLDKCIndex[] robj_interface_RJiLDKCIndexArray = this.cache.getLDKCIndex();
                RJSetGettingParamVol rJSetGettingParamVol = new RJSetGettingParamVol();
                rJSetGettingParamVol.setBAllVolume(true);
                RJMdDataCU[] rJMdDataCUArray = this.cache.getCUIndex(robj_interface_RJiLDKCIndexArray, rJSetGettingParamVol);
                this.nRetryCounter = 0;
                if (rJMdDataCUArray.length == 0) continue;
                for (int i = 0; i < rJMdDataCUArray.length; ++i) {
                    if (arrayList.indexOf(rJMdDataCUArray[i]) != -1) continue;
                    arrayList.add(rJMdDataCUArray[i]);
                }
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        return arrayList;
    }

    public ArrayList getCUToLDEV(int n, int n2) throws RJMdRmiException {
        return this.getCUToLDEV(n, n2, 11);
    }

    public ArrayList getCUToLDEVbyEachOfCU(int n, int n2) throws RJMdRmiException {
        return this.getCUToLDEV(n, n2, 79);
    }

    public ArrayList getCUToLDEV(int n, int n2, int n3) throws RJMdRmiException {
        boolean bl = (n3 & 1) != 0;
        boolean bl2 = (n3 & 2) != 0;
        boolean bl3 = (n3 & 8) != 0;
        boolean bl4 = (n3 & 0x40) != 0;
        boolean bl5 = (n3 & 4) != 0;
        ArrayList<RJMdDataLDEV> arrayList = new ArrayList<RJMdDataLDEV>();
        this.nRetryCounter = this.getRetryCount() + 1;
        RJSetGettingParamLDEV rJSetGettingParamLDEV = new RJSetGettingParamLDEV();
        rJSetGettingParamLDEV.setBBasic(true);
        rJSetGettingParamLDEV.setBPool(true);
        RJiCUIndex rJiCUIndex = new RJiCUIndex();
        rJiCUIndex.setSLDKC((short)n);
        rJiCUIndex.setSCU((short)n2);
        while (this.nRetryCounter > 0) {
            try {
                Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = this.cache.getLDEVIndex((Robj_interface_RJiCUIndex)rJiCUIndex);
                if (robj_interface_RJiLDEVIndexArray == null) continue;
                RJMdDataLDEV[] rJMdDataLDEVArray = this.cache.getLDEVInfoDetail(robj_interface_RJiLDEVIndexArray, (Robj_interface_RJSetGettingParamLDEV)rJSetGettingParamLDEV);
                this.nRetryCounter = 0;
                for (int i = 0; i < rJMdDataLDEVArray.length; ++i) {
                    if (!(bl && rJMdDataLDEVArray[i].isNormal() || bl2 && rJMdDataLDEVArray[i].isExternal() || bl3 && rJMdDataLDEVArray[i].isAouVol() || bl4 && rJMdDataLDEVArray[i].isAluVol()) && (!bl5 || !rJMdDataLDEVArray[i].isVirtualVol()) || rJMdDataLDEVArray[i].isPoolVol() || rJMdDataLDEVArray[i].isFptVol()) continue;
                    arrayList.add(rJMdDataLDEVArray[i]);
                }
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        return arrayList;
    }

    public ArrayList getJNLGrps() throws RJMdRmiException {
        this.traceDC("getJNLGrps start");
        ArrayList<RJMdDataJNL> arrayList = new ArrayList<RJMdDataJNL>();
        this.nRetryCounter = this.getRetryCount() + 1;
        while (this.nRetryCounter > 0) {
            try {
                RJiHURgetJNLGrps rJiHURgetJNLGrps = (RJiHURgetJNLGrps)this.cache.getHurAllJNLGrps();
                this.nRetryCounter = 0;
                for (int i = 0; i < rJiHURgetJNLGrps.jnlGroups.size(); ++i) {
                    RJiHURget1JNLG rJiHURget1JNLG = (RJiHURget1JNLG)rJiHURgetJNLGrps.jnlGroups.get(i);
                    this.traceDC("RJiHURget1JNLG attribute:jnlGrpNumber = " + rJiHURget1JNLG.attribute + ":" + rJiHURget1JNLG.jnlGrpNumber);
                    if (rJiHURget1JNLG.attribute == 0) continue;
                    arrayList.add(new RJMdDataJNL(rJiHURget1JNLG.jnlGrpNumber));
                }
            }
            catch (SANRmiException sANRmiException) {
                if (this.checkRetryErrorCode(sANRmiException.nErrData, sANRmiException.nErrCode, false)) continue;
                throw new RJMdRmiException(this.traceException((Exception)((Object)sANRmiException)));
            }
            catch (RemoteException remoteException) {
                if (this.checkRetryErrorCode(remoteException, false)) continue;
                throw new RJMdRmiException(this.traceException(remoteException));
            }
        }
        this.traceDC("getJNLGrps End");
        return arrayList;
    }

    public boolean isHM() {
        boolean bl = false;
        if (this.dkcProductName != null && this.dkcProductName.indexOf(HM) != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean isHM_SMODEL() {
        String string;
        boolean bl = false;
        if (this.isHM() && (string = this.dkcMibVersion.substring(9, 11)).equals(HM_MODEL_S)) {
            bl = true;
        }
        return bl;
    }

    public boolean isAdministrator() {
        CheckRet checkRet;
        boolean bl = false;
        if (this.objname != null && this.objname instanceof CheckRet && (checkRet = (CheckRet)this.objname).getNManager() == 1) {
            bl = true;
        }
        return bl;
    }
}

