/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.HashMap;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdContainer;
import sanproject.getmondat.com.RJMdExecParameter;
import sanproject.getmondat.com.RJMdMessage;
import sanproject.getmondat.com.RJMdMsgID;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataCU;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataHostGroup;
import sanproject.getmondat.data.RJMdDataJNL;
import sanproject.getmondat.data.RJMdDataPG;
import sanproject.getmondat.data.RJMdDataPPCGroup;
import sanproject.getmondat.data.RJMdDataPort;

public abstract class RJMdGroupData
implements RJMdMsgID {
    protected RJMdDataControl controller;
    protected RJMdExecParameter parameter;
    public static final int LIMIT_PARAMS = 16;
    private HashMap nameMap = new HashMap();
    public static final int PLOT_DATA = 1;
    private boolean opeLong = false;
    private boolean opeShort = false;
    protected boolean allowPSA = true;
    public static final int PARSE_PG = 1;
    public static final int PARSE_ExG = 2;
    public static final int PARSE_QS_VVol = 4;
    public static final int PARSE_AOU_VVol = 8;
    public static final int PARSE_EXTERNAL_MFG = 16;

    public RJMdGroupData(RJMdDataControl rJMdDataControl) {
        this.controller = rJMdDataControl;
        this.parameter = rJMdDataControl.getExecParameter();
    }

    public abstract void init() throws IOException;

    public void createGroup() throws RJMdRmiException, IOException {
        this.nameMap.clear();
    }

    public void putInfomation(String string, String string2) {
        RJMdDataControl.putInfomation(RJMdMessage.message(string, string2));
    }

    protected void initProgress(int n, int n2) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        RJMdDataControl.putInfomation(RJMdMessage.message("INF005", objectArray));
        this.controller.initProgress(n);
    }

    public void addProgress(int n) {
        this.controller.addProgress(n);
    }

    public void closeProgress() {
        this.controller.closeProgress();
    }

    public int checkClear(int n) throws IOException {
        if (n == 0 && this.isGroupExists()) {
            File file = new File(this.parameter.getDirectory());
            RJMdDataControl.putInfomation(RJMdMessage.message("INF001", file.getAbsolutePath()));
            RJMdDataControl.putInfomation(RJMdMessage.message("INF002"));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string = bufferedReader.readLine();
            RJMdDataControl.trace(string);
            String string2 = "stop";
            n = 3;
            if (string.equals("c")) {
                string2 = "clear";
                n = 1;
            } else if (string.equals("u")) {
                string2 = "update";
                n = 2;
            }
            if (n != 3) {
                RJMdDataControl.putInfomation(RJMdMessage.message("INF003", string2));
                string = bufferedReader.readLine();
                RJMdDataControl.trace(string);
                if (!string.equals("y")) {
                    n = 3;
                    RJMdDataControl.putInfomation(RJMdMessage.message("INF004"));
                }
            } else {
                RJMdDataControl.putInfomation(RJMdMessage.message("INF004"));
            }
        }
        return n;
    }

    protected boolean isGroupExists() {
        return false;
    }

    public void deleteGroup() {
    }

    public abstract String getGroupID();

    public abstract String[] getGroupAlias();

    public abstract String getGroupName();

    public abstract String getGroupInfo();

    public abstract RJMdTimeRange getTimeRange();

    public boolean isAllowCreate() {
        boolean bl = false;
        RJMdTimeRange rJMdTimeRange = this.getTimeRange();
        if (rJMdTimeRange != null && this.isActive()) {
            bl = true;
        }
        return bl;
    }

    public void setActive(boolean bl) {
        this.parameter.setGroupActive(this.getGroupID(), bl);
    }

    public boolean isActive() {
        boolean bl = this.parameter.isGroupActive(this.getGroupID());
        return bl;
    }

    public boolean isShort() {
        return this.opeShort;
    }

    public boolean isLong() {
        return this.opeLong;
    }

    protected String getFileNo(String string) {
        String string2 = "";
        File file = new File(string);
        int n = 2;
        while (this.nameMap.get(file) != null) {
            string2 = "_" + n;
            file = new File(string + string2);
            ++n;
        }
        this.nameMap.put(file, string);
        return string2;
    }

    public String toWWNString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            string = string + this.toHexString(byArray[i], 2);
        }
        return string;
    }

    public String toLdevString(int n, int n2, int n3) {
        String string = this.toHexString(n, 2) + ":" + this.toHexString(n2, 2) + ":" + this.toHexString(n3, 2);
        return string;
    }

    public String toHexString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        return string;
    }

    public String toHexString(int n, int n2) {
        String string = "0000000" + Integer.toHexString(n).toUpperCase();
        return string.substring(string.length() - n2);
    }

    public String toPortHgString(RJMdDataPort rJMdDataPort, RJMdDataHostGroup rJMdDataHostGroup) {
        String string = rJMdDataPort.getPortName() + "." + this.toHexString(rJMdDataHostGroup.getHostGroupID(), 2) + "(" + rJMdDataHostGroup.getNickname() + ")";
        return string;
    }

    public String toPortLunString(String string, int n) {
        String string2 = string + "." + Integer.toString(n, 10);
        return string2;
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
    }

    protected RJMdRange analyzePortRange(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        RJMdDataPort rJMdDataPort = this.analyzePort(rJMdCmdParser);
        RJMdDataPort rJMdDataPort2 = null;
        char c = rJMdCmdParser.getKind();
        if (c == ':') {
            rJMdCmdParser.nextTokenS();
            rJMdDataPort2 = this.analyzePort(rJMdCmdParser);
            rJMdRange = new RJMdRange(rJMdDataPort, rJMdDataPort2);
        } else if (rJMdDataPort != null) {
            throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
        }
        return rJMdRange;
    }

    protected RJMdDataPort analyzePort(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdDataPort rJMdDataPort = null;
        String string = null;
        char c = rJMdCmdParser.getKind();
        if (c == 'I') {
            string = rJMdCmdParser.getToken();
            if (!string.startsWith("CL")) {
                throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
            }
            c = rJMdCmdParser.nextTokenS();
            if (c != '-') {
                throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
            }
            string = string + rJMdCmdParser.getKind();
            c = rJMdCmdParser.nextTokenS();
            if (c != 'I') {
                throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
            }
            string = string + rJMdCmdParser.getToken();
            c = rJMdCmdParser.nextTokenS();
            rJMdDataPort = new RJMdDataPort(0, string);
        }
        return rJMdDataPort;
    }

    protected RJMdRange analyzePGrpRange(RJMdCmdParser rJMdCmdParser) throws ParseException {
        return this.analyzePGrpRange(rJMdCmdParser, true, false);
    }

    protected RJMdRange analyzePGrpRange(RJMdCmdParser rJMdCmdParser, boolean bl) throws ParseException {
        return this.analyzePGrpRange(rJMdCmdParser, true, bl);
    }

    protected RJMdRange analyzePGrpRange(RJMdCmdParser rJMdCmdParser, boolean bl, boolean bl2) throws ParseException {
        int n = 0;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        return this.analyzePGrpRange(rJMdCmdParser, n);
    }

    protected RJMdRange analyzePGrpRange(RJMdCmdParser rJMdCmdParser, int n) throws ParseException {
        RJMdRange rJMdRange = null;
        RJMdDataPG rJMdDataPG = this.analyzePGrp(rJMdCmdParser, n);
        RJMdDataPG rJMdDataPG2 = null;
        char c = rJMdCmdParser.getKind();
        if (c == ':') {
            rJMdCmdParser.nextTokenS();
            rJMdDataPG2 = this.analyzePGrp(rJMdCmdParser, n);
            rJMdRange = new RJMdRange(rJMdDataPG, rJMdDataPG2);
        } else if (rJMdDataPG != null) {
            throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
        }
        return rJMdRange;
    }

    protected RJMdDataPG analyzePGrp(RJMdCmdParser rJMdCmdParser, int n) throws ParseException {
        RJMdDataPG rJMdDataPG = null;
        int n2 = -1;
        int n3 = -1;
        char c = rJMdCmdParser.getKind();
        if (c == 'I') {
            block15: {
                int n4;
                int n5 = 1;
                int n6 = 32;
                int n7 = 1;
                try {
                    n4 = (n & 1) != 0 ? 1 : 0;
                    boolean bl = (n & 2) != 0;
                    boolean bl2 = (n & 4) != 0;
                    boolean bl3 = (n & 8) != 0;
                    boolean bl4 = (n & 0x10) != 0;
                    String string = rJMdCmdParser.getToken();
                    int n8 = 1;
                    int n9 = 16;
                    if (n4 == 0 && Character.isDigit(string.charAt(0))) {
                        string = "*";
                    }
                    if (bl && string.length() > 1 && string.charAt(0) == 'E') {
                        n8 = 101;
                        n9 = 16484;
                        n5 = 1;
                        n6 = 4096;
                        string = string.substring(1);
                    }
                    if (bl2 && string.length() > 1 && string.charAt(0) == 'V') {
                        n8 = 65;
                        n9 = 96;
                        n5 = 1;
                        n6 = 1;
                        n7 = 2048;
                        string = string.substring(1);
                    }
                    if (bl3 && string.length() > 1 && string.charAt(0) == 'X') {
                        n8 = 16485;
                        n9 = 16516;
                        n5 = 1;
                        n6 = 1;
                        n7 = 2048;
                        string = string.substring(1);
                    }
                    if (bl4 && string.length() > 1 && string.charAt(0) == 'M') {
                        n8 = 16641;
                        n9 = 17152;
                        n5 = 1;
                        n6 = 4096;
                        string = string.substring(1);
                    }
                    n2 = Integer.parseInt(string);
                    n3 = (n2 - 1) % n7 + 1;
                    int n10 = n2 - 1;
                    n2 = n10 / n7 + n8;
                    if (n10 < 0 || n2 < n8 || n2 > n9) {
                        throw RJMdMessage.parseException("MSG013", rJMdCmdParser.getToken());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw RJMdMessage.parseException("MSG019", rJMdCmdParser.getToken());
                }
                c = rJMdCmdParser.nextTokenS();
                if (c != '-') {
                    throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
                }
                c = rJMdCmdParser.nextTokenS();
                if (c == 'I') {
                    try {
                        n4 = Integer.parseInt(rJMdCmdParser.getToken());
                        if (n7 == 1) {
                            n3 = n4;
                        }
                        if (n4 < n5 || n4 > n6) {
                            throw RJMdMessage.parseException("MSG013", rJMdCmdParser.getToken());
                        }
                        break block15;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw RJMdMessage.parseException("MSG019", rJMdCmdParser.getToken());
                    }
                }
                throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
            }
            c = rJMdCmdParser.nextTokenS();
            rJMdDataPG = new RJMdDataPG(n2, n3);
            RJMdDataControl.trace("\t " + n2 + "-" + n3);
        }
        return rJMdDataPG;
    }

    protected RJMdRange analyzePPCGRange(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        RJMdDataPPCGroup rJMdDataPPCGroup = this.analyzePPCG(rJMdCmdParser);
        RJMdDataPPCGroup rJMdDataPPCGroup2 = null;
        char c = rJMdCmdParser.getKind();
        if (c == ':') {
            rJMdCmdParser.nextTokenS();
            rJMdDataPPCGroup2 = this.analyzePPCG(rJMdCmdParser);
            rJMdRange = new RJMdRange(rJMdDataPPCGroup, rJMdDataPPCGroup2);
        } else if (rJMdDataPPCGroup != null) {
            throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
        }
        return rJMdRange;
    }

    protected RJMdDataPPCGroup analyzePPCG(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdDataPPCGroup rJMdDataPPCGroup;
        block3: {
            char c;
            block2: {
                rJMdDataPPCGroup = null;
                c = rJMdCmdParser.getKind();
                if (c == 'I') break block2;
                if (c != 'L') break block3;
            }
            String string = rJMdCmdParser.getToken();
            c = rJMdCmdParser.nextTokenS();
            rJMdDataPPCGroup = new RJMdDataPPCGroup(string);
        }
        return rJMdDataPPCGroup;
    }

    protected RJMdRange analyzePortHgRange(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        RJMdContainer rJMdContainer = this.analyzePortHg(rJMdCmdParser);
        RJMdContainer rJMdContainer2 = null;
        char c = rJMdCmdParser.getKind();
        if (c == ':') {
            rJMdCmdParser.nextTokenS();
            rJMdContainer2 = this.analyzePortHg(rJMdCmdParser);
            rJMdRange = new RJMdRange(rJMdContainer, rJMdContainer2);
        } else if (rJMdContainer != null) {
            throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
        }
        return rJMdRange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected RJMdContainer analyzePortHg(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdContainer rJMdContainer = null;
        RJMdDataPort rJMdDataPort = this.analyzePort(rJMdCmdParser);
        if (rJMdDataPort == null) return rJMdContainer;
        RJMdDataHostGroup rJMdDataHostGroup = null;
        char c = rJMdCmdParser.getKind();
        if (c != '.') throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
        c = rJMdCmdParser.nextTokenS();
        if (c != 'I') throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
        int n = -1;
        try {
            n = Integer.parseInt(rJMdCmdParser.getToken(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw RJMdMessage.parseException("MSG019", rJMdCmdParser.getToken());
        }
        c = rJMdCmdParser.nextTokenS();
        rJMdDataHostGroup = new RJMdDataHostGroup(n);
        return new RJMdContainer(rJMdDataPort, rJMdDataHostGroup);
    }

    protected RJMdRange analyzeCURange(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        RJMdDataCU rJMdDataCU = this.analyzeCU(rJMdCmdParser);
        RJMdDataCU rJMdDataCU2 = null;
        char c = rJMdCmdParser.getKind();
        if (c == ':') {
            rJMdCmdParser.nextTokenS();
            rJMdDataCU2 = this.analyzeCU(rJMdCmdParser);
            rJMdRange = new RJMdRange(rJMdDataCU, rJMdDataCU2);
        } else if (rJMdDataCU != null) {
            throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
        }
        return rJMdRange;
    }

    protected RJMdRange analyzeVolumeTypeRange(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        int n = 1;
        int n2 = 32;
        int n3 = 1;
        int n4 = 16;
        if (rJMdCmdParser.getToken().equals("virtual")) {
            n = 1;
            n2 = 4096;
            n3 = 65;
            n4 = 17152;
        } else if (!rJMdCmdParser.getToken().equals("internal")) {
            throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
        }
        RJMdDataPG rJMdDataPG = new RJMdDataPG(n3, n);
        RJMdDataPG rJMdDataPG2 = new RJMdDataPG(n4, n2);
        rJMdRange = new RJMdRange(rJMdDataPG, rJMdDataPG2);
        char c = rJMdCmdParser.nextTokenS();
        return rJMdRange;
    }

    protected RJMdDataCU analyzeCU(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdDataCU rJMdDataCU = null;
        int n = 0;
        char c = rJMdCmdParser.getKind();
        if (c == 'I') {
            int n2 = -1;
            try {
                n2 = Integer.parseInt(rJMdCmdParser.getToken(), 16);
                n = n2 / 256;
                n2 %= 256;
                if (n < 0 || n > 1) {
                    throw RJMdMessage.parseException("MSG013", rJMdCmdParser.getToken());
                }
                if (n2 < 0 || n2 > 63) {
                    throw RJMdMessage.parseException("MSG013", rJMdCmdParser.getToken());
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw RJMdMessage.parseException("MSG019", rJMdCmdParser.getToken());
            }
            c = rJMdCmdParser.nextTokenS();
            rJMdDataCU = new RJMdDataCU(n, n2);
        }
        return rJMdDataCU;
    }

    protected RJMdRange analyzeJNLRange(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        RJMdDataJNL rJMdDataJNL = this.analyzeJNL(rJMdCmdParser);
        RJMdDataJNL rJMdDataJNL2 = null;
        char c = rJMdCmdParser.getKind();
        if (c == ':') {
            rJMdCmdParser.nextTokenS();
            rJMdDataJNL2 = this.analyzeJNL(rJMdCmdParser);
            rJMdRange = new RJMdRange(rJMdDataJNL, rJMdDataJNL2);
        } else if (rJMdDataJNL != null) {
            throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
        }
        return rJMdRange;
    }

    protected RJMdDataJNL analyzeJNL(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdDataJNL rJMdDataJNL = null;
        char c = rJMdCmdParser.getKind();
        if (c == 'I') {
            int n = -1;
            try {
                n = Integer.parseInt(rJMdCmdParser.getToken(), 16);
                if (n < 0 || n > 255) {
                    throw RJMdMessage.parseException("MSG013", rJMdCmdParser.getToken());
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw RJMdMessage.parseException("MSG019", rJMdCmdParser.getToken());
            }
            c = rJMdCmdParser.nextTokenS();
            rJMdDataJNL = new RJMdDataJNL(n);
        }
        return rJMdDataJNL;
    }

    protected void analyzeTimeRange(RJMdCmdParser rJMdCmdParser) throws ParseException {
        this.opeLong = true;
        this.opeShort = true;
        char c = rJMdCmdParser.getKind();
        if (c == 'I') {
            String string = rJMdCmdParser.getToken().toLowerCase();
            if (string.equals("short")) {
                this.opeLong = false;
                rJMdCmdParser.nextToken();
            } else if (string.equals("long")) {
                this.opeShort = false;
                rJMdCmdParser.nextToken();
            }
        }
    }

    public boolean isAllowPSA() {
        return this.allowPSA;
    }
}

