/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdContainer;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataHostGroup;
import sanproject.getmondat.data.RJMdDataLU;
import sanproject.getmondat.data.RJMdDataPort;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitParallelStream;
import sanproject.serverux.arg.monitor.ArgLUAbility;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.LDEVMonitorLUAbility;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJMdGroupLU
extends RJMdGroupData {
    private static final String groupID = "LU";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "LU_dat";
    private static final String groupInfo = "LU data";
    private RJMdUnitParallelStream stream = null;
    public static final int LIMIT_PARAMS_LU = 512;
    public static final int KIND_TARGET = 1;
    private static final String EN_LU_IOPS = "LU_IOPS";
    private static final String EN_LU_TransRate = "LU_TransRate";
    private static final String EN_LU_Read_TransRate = "LU_Read_TransRate";
    private static final String EN_LU_Write_TransRate = "LU_Write_TransRate";
    private static final String EN_LU_Seq_Read_IOPS = "LU_Seq_Read_IOPS";
    private static final String EN_LU_Rnd_Read_IOPS = "LU_Rnd_Read_IOPS";
    private static final String EN_LU_Seq_Write_IOPS = "LU_Seq_Write_IOPS";
    private static final String EN_LU_Rnd_Write_IOPS = "LU_Rnd_Write_IOPS";
    private static final String EN_LU_Seq_Read_Hit = "LU_Seq_Read_Hit";
    private static final String EN_LU_Rnd_Read_Hit = "LU_Rnd_Read_Hit";
    private static final String EN_LU_Seq_Write_Hit = "LU_Seq_Write_Hit";
    private static final String EN_LU_Rnd_Write_Hit = "LU_Rnd_Write_Hit";
    private static final String EN_LU_C2D_Trans = "LU_C2D_Trans";
    private static final String EN_LU_D2CS_Trans = "LU_D2CS_Trans";
    private static final String EN_LU_D2CR_Trans = "LU_D2CR_Trans";
    private static final String EN_LU_Response = "LU_Response";
    private static final String EN_LU_Read_Response = "LU_Read_Response";
    private static final String EN_LU_Write_Response = "LU_Write_Response";
    private static final String[] entryNames = new String[]{"LU_IOPS", "LU_TransRate", "LU_Read_TransRate", "LU_Write_TransRate", "LU_Seq_Read_IOPS", "LU_Rnd_Read_IOPS", "LU_Seq_Write_IOPS", "LU_Rnd_Write_IOPS", "LU_Seq_Read_Hit", "LU_Rnd_Read_Hit", "LU_Seq_Write_Hit", "LU_Rnd_Write_Hit", "LU_C2D_Trans", "LU_D2CS_Trans", "LU_D2CR_Trans", "LU_Response", "LU_Read_Response", "LU_Write_Response"};

    public RJMdGroupLU(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        this.stream = new RJMdUnitParallelStream(groupName, file);
        this.stream.setCompress(this.parameter.isCompless());
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupLU();
        }
        finally {
            this.stream.close();
        }
    }

    private void createGroupLU() throws RJMdRmiException, IOException {
        Object object;
        this.putInfomation("INF006", this.getGroupInfo());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < entryNames.length; ++i) {
            object = this.stream.createEntry(entryNames[i], this.getTimeRange());
            hashMap.put(entryNames[i], object);
        }
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        object = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        ArrayList arrayList = this.controller.getPort(1);
        this.initProgress(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPort rJMdDataPort = (RJMdDataPort)iterator.next();
            int n = rJMdDataPort.getPortID();
            ArrayList arrayList2 = this.controller.getPortToHostGroup(n);
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                RJMdDataHostGroup rJMdDataHostGroup = (RJMdDataHostGroup)iterator2.next();
                RJMdContainer rJMdContainer = new RJMdContainer(rJMdDataPort, rJMdDataHostGroup);
                if (!this.parameter.containsRange(this.getGroupID(), rJMdContainer)) continue;
                int n2 = rJMdDataHostGroup.getHostGroupID();
                ArrayList arrayList3 = this.controller.getHostGroupToLU(n, n2);
                Iterator iterator3 = arrayList3.iterator();
                while (iterator3.hasNext()) {
                    RJMdDataLU rJMdDataLU = (RJMdDataLU)iterator3.next();
                    if (((CollectParam)object).size() >= 512) {
                        this.collect(hashMap, (CollectParam)object);
                        this.addProgress(((CollectParam)object).size());
                        object = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
                    }
                    ((CollectParam)object).add(rJMdDataPort, rJMdDataHostGroup, rJMdDataLU);
                }
            }
        }
        this.collect(hashMap, (CollectParam)object);
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    private void initProgress(ArrayList arrayList) throws RJMdRmiException {
        int n = 0;
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPort rJMdDataPort = (RJMdDataPort)iterator.next();
            int n3 = rJMdDataPort.getPortID();
            ArrayList arrayList2 = this.controller.getPortToHostGroup(n3);
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                RJMdDataHostGroup rJMdDataHostGroup = (RJMdDataHostGroup)iterator2.next();
                int n4 = rJMdDataHostGroup.getHostGroupID();
                ArrayList arrayList3 = this.controller.getHostGroupToLU(n3, n4);
                n2 += arrayList3.size();
                RJMdContainer rJMdContainer = new RJMdContainer(rJMdDataPort, rJMdDataHostGroup);
                if (!this.parameter.containsRange(this.getGroupID(), rJMdContainer)) continue;
                n += arrayList3.size();
            }
        }
        super.initProgress(n, n2);
    }

    public void collect(HashMap hashMap, CollectParam collectParam) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                LDEVMonitorLUAbility lDEVMonitorLUAbility = (LDEVMonitorLUAbility)monitorInfoCollection.get(i);
                String string = collectParam.toColumnName(lDEVMonitorLUAbility.getPortID(), lDEVMonitorLUAbility.getHostgroupID(), lDEVMonitorLUAbility.getLUN());
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_IOPS), new RJMdColumn(string, lDEVMonitorLUAbility.getIOPerSec()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_TransRate), new RJMdColumn(string, lDEVMonitorLUAbility.getTransRate()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_Read_TransRate), new RJMdColumn(string, lDEVMonitorLUAbility.getReadTransRate()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_Write_TransRate), new RJMdColumn(string, lDEVMonitorLUAbility.getWriteTransRate()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_Seq_Read_IOPS), new RJMdColumn(string, lDEVMonitorLUAbility.getReadSeq()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_Rnd_Read_IOPS), new RJMdColumn(string, lDEVMonitorLUAbility.getReadRnd()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_Seq_Write_IOPS), new RJMdColumn(string, lDEVMonitorLUAbility.getWriteSeq()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_Rnd_Write_IOPS), new RJMdColumn(string, lDEVMonitorLUAbility.getWriteRnd()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_Seq_Read_Hit), new RJMdColumn(string, lDEVMonitorLUAbility.getReadHitSeq()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_Rnd_Read_Hit), new RJMdColumn(string, lDEVMonitorLUAbility.getReadHitRnd()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_Seq_Write_Hit), new RJMdColumn(string, lDEVMonitorLUAbility.getWriteHitSeq()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_Rnd_Write_Hit), new RJMdColumn(string, lDEVMonitorLUAbility.getWriteHitRnd()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_C2D_Trans), new RJMdColumn(string, lDEVMonitorLUAbility.getBackTransCtoD()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_D2CS_Trans), new RJMdColumn(string, lDEVMonitorLUAbility.getBackTransDtoCSeq()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_D2CR_Trans), new RJMdColumn(string, lDEVMonitorLUAbility.getBackTransDtoCRnd()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_Response), new RJMdColumn(string, lDEVMonitorLUAbility.getResponseTime()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_Read_Response), new RJMdColumn(string, lDEVMonitorLUAbility.getReadResponseTime()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_LU_Write_Response), new RJMdColumn(string, lDEVMonitorLUAbility.getWriteResponseTime()));
            }
        }
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzePortHgRange(rJMdCmdParser)) != null) {
            RJMdDataControl.trace("\tPort.HostGroup =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }

    class CollectParam {
        private ArgLUAbility luArgument = null;
        private HashMap columnNames = new HashMap();

        CollectParam(Date date, Date date2) {
            this.luArgument = new ArgLUAbility(1, date, date2);
        }

        public void add(RJMdDataPort rJMdDataPort, RJMdDataHostGroup rJMdDataHostGroup, RJMdDataLU rJMdDataLU) {
            String string = this.toKeyString(rJMdDataPort.getPortID(), rJMdDataHostGroup.getHostGroupID());
            this.columnNames.put(string, RJMdGroupLU.this.toPortHgString(rJMdDataPort, rJMdDataHostGroup));
            this.luArgument.addLU(rJMdDataPort.getPortID(), rJMdDataHostGroup.getHostGroupID(), rJMdDataLU.getLU());
        }

        public int size() {
            return this.luArgument.size();
        }

        private String toColumnName(int n, int n2, int n3) {
            String string = (String)this.columnNames.get(this.toKeyString(n, n2));
            String string2 = RJMdGroupLU.this.toPortLunString(string, n3);
            return string2;
        }

        private String toKeyString(int n, int n2) {
            String string = String.valueOf(n) + "." + String.valueOf(n2);
            return string;
        }

        public ArgLUAbility getArgument() {
            return this.luArgument;
        }
    }
}

