/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataPG;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitParallelStream;
import sanproject.serverux.arg.monitor.ArgPGAbility;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.LDEVMonitorPGAbility;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJMdGroupPG
extends RJMdGroupData {
    private static final String groupID = "PG";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "PG_dat";
    private static final String groupInfo = "parity group data";
    private RJMdUnitParallelStream stream = null;
    public static final int LIMIT_PARAMS_AG = 128;
    private static final String EN_AG_IOPS = "PG_IOPS";
    private static final String EN_AG_TransRate = "PG_TransRate";
    private static final String EN_AG_Read_TransRate = "PG_Read_TransRate";
    private static final String EN_AG_Write_TransRate = "PG_Write_TransRate";
    private static final String EN_AG_Read_IOPS = "PG_Read_IOPS";
    private static final String EN_AG_Write_IOPS = "PG_Write_IOPS";
    private static final String EN_AG_Read_Hit = "PG_Read_Hit";
    private static final String EN_AG_Write_Hit = "PG_Write_Hit";
    private static final String EN_AG_BackTrans = "PG_BackTrans";
    private static final String EN_AG_Seq_Read_IOPS = "PG_Seq_Read_IOPS";
    private static final String EN_AG_Rnd_Read_IOPS = "PG_Rnd_Read_IOPS";
    private static final String EN_AG_Seq_Write_IOPS = "PG_Seq_Write_IOPS";
    private static final String EN_AG_Rnd_Write_IOPS = "PG_Rnd_Write_IOPS";
    private static final String EN_AG_Seq_Read_Hit = "PG_Seq_Read_Hit";
    private static final String EN_AG_Rnd_Read_Hit = "PG_Rnd_Read_Hit";
    private static final String EN_AG_Seq_Write_Hit = "PG_Seq_Write_Hit";
    private static final String EN_AG_Rnd_Write_Hit = "PG_Rnd_Write_Hit";
    private static final String EN_AG_C2D_Trans = "PG_C2D_Trans";
    private static final String EN_AG_D2CS_Trans = "PG_D2CS_Trans";
    private static final String EN_AG_D2CR_Trans = "PG_D2CR_Trans";
    private static final String EN_AG_Response = "PG_Response";
    private static final String EN_AG_Read_Response = "PG_Read_Response";
    private static final String EN_AG_Write_Response = "PG_Write_Response";
    private String[] entryNames = entryNames_raid;
    private static final String[] entryNames_raid = new String[]{"PG_IOPS", "PG_TransRate", "PG_Read_TransRate", "PG_Write_TransRate", "PG_Read_IOPS", "PG_Write_IOPS", "PG_Read_Hit", "PG_Write_Hit", "PG_BackTrans", "PG_Seq_Read_IOPS", "PG_Rnd_Read_IOPS", "PG_Seq_Write_IOPS", "PG_Rnd_Write_IOPS", "PG_Seq_Read_Hit", "PG_Rnd_Read_Hit", "PG_Seq_Write_Hit", "PG_Rnd_Write_Hit", "PG_C2D_Trans", "PG_D2CS_Trans", "PG_D2CR_Trans", "PG_Response", "PG_Read_Response", "PG_Write_Response"};
    private static final String[] entryNames_hm = new String[]{"PG_IOPS", "PG_TransRate", "PG_Read_TransRate", "PG_Write_TransRate", "PG_Read_IOPS", "PG_Write_IOPS", "PG_Read_Hit", "PG_Write_Hit", "PG_BackTrans", "PG_Seq_Read_IOPS", "PG_Rnd_Read_IOPS", "PG_Seq_Write_IOPS", "PG_Rnd_Write_IOPS", "PG_Seq_Read_Hit", "PG_Rnd_Read_Hit", "PG_Seq_Write_Hit", "PG_Rnd_Write_Hit", "PG_C2D_Trans", "PG_D2CS_Trans", "PG_D2CR_Trans", "PG_Response", "PG_Read_Response", "PG_Write_Response"};

    public RJMdGroupPG(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
    }

    public void init() throws IOException {
        this.entryNames = this.controller.isHM() ? entryNames_hm : entryNames_raid;
        String string = this.parameter.getDirectory();
        File file = new File(string);
        this.stream = new RJMdUnitParallelStream(groupName, file);
        this.stream.setCompress(this.parameter.isCompless());
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupPG();
        }
        finally {
            this.stream.close();
        }
    }

    private void createGroupPG() throws RJMdRmiException, IOException {
        RJMdUnitEntry rJMdUnitEntry;
        this.putInfomation("INF006", this.getGroupInfo());
        HashMap<String, RJMdUnitEntry> hashMap = new HashMap<String, RJMdUnitEntry>();
        for (int i = 0; i < this.entryNames.length; ++i) {
            rJMdUnitEntry = this.stream.createEntry(this.entryNames[i], this.getTimeRange());
            hashMap.put(this.entryNames[i], rJMdUnitEntry);
        }
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        rJMdUnitEntry = new ArgPGAbility(1, rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        ArrayList arrayList = this.controller.getPG();
        this.initProgress(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPG rJMdDataPG = (RJMdDataPG)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPG)) continue;
            if (rJMdUnitEntry.size() >= 128) {
                this.collect(hashMap, (ArgPGAbility)rJMdUnitEntry);
                this.addProgress(rJMdUnitEntry.size());
                rJMdUnitEntry = new ArgPGAbility(1, rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
            }
            rJMdUnitEntry.addPG(rJMdDataPG.getFB4(), rJMdDataPG.getPG());
        }
        this.collect(hashMap, (ArgPGAbility)rJMdUnitEntry);
        this.addProgress(rJMdUnitEntry.size());
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    private void initProgress(ArrayList arrayList) {
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPG rJMdDataPG = (RJMdDataPG)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPG)) continue;
            ++n;
        }
        super.initProgress(n, arrayList.size());
    }

    public void collect(HashMap hashMap, ArgPGAbility argPGAbility) throws RJMdRmiException, IOException {
        if (argPGAbility.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)argPGAbility);
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                LDEVMonitorPGAbility lDEVMonitorPGAbility = (LDEVMonitorPGAbility)monitorInfoCollection.get(i);
                String string = null;
                RJMdDataPG rJMdDataPG = new RJMdDataPG(lDEVMonitorPGAbility.getDG(), lDEVMonitorPGAbility.getPG());
                if (rJMdDataPG.isAOUVVol() || rJMdDataPG.isQSVVol() || rJMdDataPG.isALUVVol()) continue;
                string = rJMdDataPG.toString();
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_IOPS), new RJMdColumn(string, lDEVMonitorPGAbility.getIOPerSec()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_TransRate), new RJMdColumn(string, lDEVMonitorPGAbility.getTransRate()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Read_TransRate), new RJMdColumn(string, lDEVMonitorPGAbility.getReadTransRate()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Write_TransRate), new RJMdColumn(string, lDEVMonitorPGAbility.getWriteTransRate()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Read_IOPS), new RJMdColumn(string, lDEVMonitorPGAbility.getReadIOPerSec()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Write_IOPS), new RJMdColumn(string, lDEVMonitorPGAbility.getWriteIOPerSec()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Read_Hit), new RJMdColumn(string, lDEVMonitorPGAbility.getReadHit()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Write_Hit), new RJMdColumn(string, lDEVMonitorPGAbility.getWriteHit()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_BackTrans), new RJMdColumn(string, lDEVMonitorPGAbility.getDataTransCtoD()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Seq_Read_IOPS), new RJMdColumn(string, lDEVMonitorPGAbility.getReadSeq()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Rnd_Read_IOPS), new RJMdColumn(string, lDEVMonitorPGAbility.getReadRnd()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Seq_Write_IOPS), new RJMdColumn(string, lDEVMonitorPGAbility.getWriteSeq()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Rnd_Write_IOPS), new RJMdColumn(string, lDEVMonitorPGAbility.getWriteRnd()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Seq_Read_Hit), new RJMdColumn(string, lDEVMonitorPGAbility.getReadHitSeq()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Rnd_Read_Hit), new RJMdColumn(string, lDEVMonitorPGAbility.getReadHitRnd()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Seq_Write_Hit), new RJMdColumn(string, lDEVMonitorPGAbility.getWriteHitSeq()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Rnd_Write_Hit), new RJMdColumn(string, lDEVMonitorPGAbility.getWriteHitRnd()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_C2D_Trans), new RJMdColumn(string, lDEVMonitorPGAbility.getBackTransCtoD()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_D2CS_Trans), new RJMdColumn(string, lDEVMonitorPGAbility.getBackTransDtoCSeq()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_D2CR_Trans), new RJMdColumn(string, lDEVMonitorPGAbility.getBackTransDtoCRnd()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Response), new RJMdColumn(string, lDEVMonitorPGAbility.getResponseTime()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Read_Response), new RJMdColumn(string, lDEVMonitorPGAbility.getReadResponseTime()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_AG_Write_Response), new RJMdColumn(string, lDEVMonitorPGAbility.getWriteResponseTime()));
            }
        }
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzePGrpRange(rJMdCmdParser, 19)) != null) {
            RJMdDataControl.trace("\tPG =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }
}

