/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataLDEV;
import sanproject.getmondat.data.RJMdDataPG;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitSerialStream;
import sanproject.serverux.arg.monitor.HIHsmPhysicalExdLDEVUseRateArgInfo;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.HIHsmPhysicalExdLDEVUseRate;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJMdGroupPhyExLDEV
extends RJMdGroupData {
    private static final String groupID = "PhyExLDEV";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "PhyExLDEV_dat";
    private static final String groupInfo = " data of physical";
    private RJMdUnitSerialStream stream = null;
    public static final int LIMIT_PARAMS_PhyExLDEV = 128;
    public HashMap unitStreams = null;
    private static final String UN_PHY_ExLDEV_Response = "PHY_ExLDEV_Response";
    private static final String UN_PHY_ExLDEV_Read_Response = "PHY_ExLDEV_Read_Response";
    private static final String UN_PHY_ExLDEV_Write_Response = "PHY_ExLDEV_Write_Response";
    private static final String UN_PHY_ExLDEV_Trans = "PHY_ExLDEV_Trans";
    private static final String UN_PHY_ExLDEV_Read_Trans = "PHY_ExLDEV_Read_Trans";
    private static final String UN_PHY_ExLDEV_Write_Trans = "PHY_ExLDEV_Write_Trans";
    private static final String[] unitNames = new String[]{"PHY_ExLDEV_Response", "PHY_ExLDEV_Read_Response", "PHY_ExLDEV_Write_Response", "PHY_ExLDEV_Trans", "PHY_ExLDEV_Read_Trans", "PHY_ExLDEV_Write_Trans"};

    public RJMdGroupPhyExLDEV(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        File file2 = new File(file.getAbsolutePath(), groupName);
        this.unitStreams = new HashMap();
        for (int i = 0; i < unitNames.length; ++i) {
            this.stream = new RJMdUnitSerialStream(unitNames[i], file2);
            this.stream.setCompress(this.parameter.isCompless());
            this.unitStreams.put(unitNames[i], this.stream);
        }
    }

    protected boolean isGroupExists() {
        String string = this.parameter.getDirectory();
        File file = new File(string, groupName);
        boolean bl = file.exists() && file.isDirectory();
        return bl;
    }

    public void deleteGroup() {
        for (int i = 0; i < unitNames.length; ++i) {
            this.streams(unitNames[i]).deleteAll();
        }
        String string = this.parameter.getDirectory();
        File file = new File(string, groupName);
        this.streams(unitNames[0]).deletePath(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupPhyExLDEV();
        }
        finally {
            for (int i = 0; i < unitNames.length; ++i) {
                this.streams(unitNames[i]).closeEntry();
                this.streams(unitNames[i]).close();
            }
        }
    }

    private void createGroupPhyExLDEV() throws RJMdRmiException, IOException {
        this.putInfomation("INF006", "external group LDEV" + this.getGroupInfo());
        String string = this.parameter.getDirectory();
        File file = new File(string, groupName);
        if (!file.exists()) {
            file.mkdirs();
        }
        ArrayList arrayList = this.controller.getPG(3);
        this.controller.createLdevCache(arrayList);
        int n = this.initProgressExLDEV(arrayList);
        int n2 = 0;
        CollectParam collectParam = new CollectParam(n);
        n -= collectParam.getCount();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPG rJMdDataPG = (RJMdDataPG)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPG)) continue;
            ArrayList arrayList2 = this.controller.getPGToLDEV(rJMdDataPG.getFB4(), rJMdDataPG.getPG());
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                RJMdDataLDEV rJMdDataLDEV = (RJMdDataLDEV)iterator2.next();
                if (n2 >= 128) {
                    this.collect(collectParam, this.unitStreams);
                    this.addProgress(n2);
                    n2 = 0;
                    collectParam = new CollectParam(n);
                    n -= collectParam.getCount();
                }
                collectParam.add(n2, rJMdDataPG, rJMdDataLDEV);
                ++n2;
            }
        }
        this.collect(collectParam, this.unitStreams);
        this.addProgress(n2);
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    public HIHsmPhysicalExdLDEVUseRateArgInfo createArgument(int n) {
        HIHsmPhysicalExdLDEVUseRateArgInfo hIHsmPhysicalExdLDEVUseRateArgInfo = null;
        int n2 = n;
        if (n >= 128) {
            n2 = 128;
        }
        hIHsmPhysicalExdLDEVUseRateArgInfo = new HIHsmPhysicalExdLDEVUseRateArgInfo(1, this.parameter.getShortRange().getFromTime(), this.parameter.getShortRange().getToTime(), n2);
        return hIHsmPhysicalExdLDEVUseRateArgInfo;
    }

    public void collect(CollectParam collectParam, HashMap hashMap) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                HIHsmPhysicalExdLDEVUseRate hIHsmPhysicalExdLDEVUseRate = (HIHsmPhysicalExdLDEVUseRate)monitorInfoCollection.get(i);
                String string = this.toHexString(hIHsmPhysicalExdLDEVUseRate.getLdkc(), 2) + ":" + this.toHexString(hIHsmPhysicalExdLDEVUseRate.getCu(), 2) + ":" + this.toHexString(hIHsmPhysicalExdLDEVUseRate.getLdev(), 2);
                string = string + " " + '#';
                RJMdDataPG rJMdDataPG = collectParam.getPG(hIHsmPhysicalExdLDEVUseRate.getLdkc(), hIHsmPhysicalExdLDEVUseRate.getCu(), hIHsmPhysicalExdLDEVUseRate.getLdev());
                String string2 = rJMdDataPG.toString();
                for (int j = 0; j < unitNames.length; ++j) {
                    String string3 = this.streams(unitNames[j]).getName() + "_" + string2;
                    RJMdUnitEntry rJMdUnitEntry = this.streams(unitNames[j]).getCurrentEntry();
                    if (rJMdUnitEntry != null && rJMdUnitEntry.getName().equals(string3)) continue;
                    if (rJMdUnitEntry != null) {
                        this.streams(unitNames[j]).closeEntry();
                    }
                    this.streams(unitNames[j]).createEntry(string3, this.getTimeRange());
                }
                this.streams(UN_PHY_ExLDEV_Response).write(new RJMdColumn(string, hIHsmPhysicalExdLDEVUseRate.getResponseTime()));
                this.streams(UN_PHY_ExLDEV_Read_Response).write(new RJMdColumn(string, hIHsmPhysicalExdLDEVUseRate.getReadResponseTime()));
                this.streams(UN_PHY_ExLDEV_Write_Response).write(new RJMdColumn(string, hIHsmPhysicalExdLDEVUseRate.getWriteResponseTime()));
                this.streams(UN_PHY_ExLDEV_Trans).write(new RJMdColumn(string, hIHsmPhysicalExdLDEVUseRate.getTransmit()));
                this.streams(UN_PHY_ExLDEV_Read_Trans).write(new RJMdColumn(string, hIHsmPhysicalExdLDEVUseRate.getReadTransRate()));
                this.streams(UN_PHY_ExLDEV_Write_Trans).write(new RJMdColumn(string, hIHsmPhysicalExdLDEVUseRate.getWriteTransRate()));
            }
        }
    }

    private RJMdUnitSerialStream streams(String string) {
        return (RJMdUnitSerialStream)this.unitStreams.get(string);
    }

    private int initProgressExLDEV(ArrayList arrayList) throws RJMdRmiException {
        int n = 0;
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPG rJMdDataPG = (RJMdDataPG)iterator.next();
            ArrayList arrayList2 = this.controller.getPGToLDEV(rJMdDataPG.getFB4(), rJMdDataPG.getPG());
            n2 += arrayList2.size();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPG)) continue;
            n += arrayList2.size();
        }
        super.initProgress(n, n2);
        return n;
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzePGrpRange(rJMdCmdParser, false, true)) != null) {
            RJMdDataControl.trace("\tPG =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }

    class CollectParam {
        private ArrayList pglist = new ArrayList();
        private ArrayList ldevlist = new ArrayList();
        private HIHsmPhysicalExdLDEVUseRateArgInfo argInfo = null;

        CollectParam(int n) {
            this.argInfo = RJMdGroupPhyExLDEV.this.createArgument(n);
        }

        public int getCount() {
            return this.argInfo.getCount();
        }

        public void add(int n, RJMdDataPG rJMdDataPG, RJMdDataLDEV rJMdDataLDEV) {
            this.pglist.add(rJMdDataPG);
            this.ldevlist.add(rJMdDataLDEV);
            this.argInfo.setAllParam(n, rJMdDataLDEV.getLDKC(), rJMdDataLDEV.getCU(), rJMdDataLDEV.getLDEV());
        }

        public int size() {
            return this.argInfo.getCount();
        }

        public RJMdDataPG getPG(int n) {
            return (RJMdDataPG)this.pglist.get(n);
        }

        public RJMdDataPG getPG(int n, int n2, int n3) {
            RJMdDataPG rJMdDataPG = null;
            Iterator iterator = this.ldevlist.iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                RJMdDataLDEV rJMdDataLDEV = (RJMdDataLDEV)iterator.next();
                if (rJMdDataLDEV.getLDKC() == n && rJMdDataLDEV.getCU() == n2 && rJMdDataLDEV.getLDEV() == n3) {
                    rJMdDataPG = this.getPG(n4);
                    break;
                }
                ++n4;
            }
            return rJMdDataPG;
        }

        public HIHsmPhysicalExdLDEVUseRateArgInfo getArgument() {
            return this.argInfo;
        }
    }
}

