/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.codec.binary.Base64;
import sanproject.sn2.base.authentication.def.SJbaseHcsConMapKey;
import sanproject.sn2.base.authentication.plugin.SJbaseHCSAuthentication;
import sanproject.sn2.base.authentication.plugin.SJbaseHCSXMLUtility;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.generated.hcs.APIInfo;
import sanproject.sn2.generated.hcs.AclResourceGroup;
import sanproject.sn2.generated.hcs.AclUser;
import sanproject.sn2.generated.hcs.Get;
import sanproject.sn2.generated.hcs.HiCommandServerMessage;
import sanproject.sn2.generated.hcs.ObjectFactory;
import sanproject.sn2.generated.hcs.Request;
import sanproject.sn2.generated.hcs.SecurityAdmin;

public class SJbaseHCSAuthUtility {
    private static final String LOG_FUNCTION = "HCS";
    private static final String LOG_TITLE = SJbaseHCSAuthentication.class.getSimpleName();
    private static final SJcLoggerInterface LOGGER = SJcLogUty.getLogger("SN_HCS.log");
    private static final String ENCODE = "UTF-8";

    public static String createRequestContents(String user) throws Exception {
        String LOG_SUBTITLE = "createRequestContents";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "createRequestContents", "Start.");
        String requestStr = null;
        try {
            ObjectFactory factory = new ObjectFactory();
            HiCommandServerMessage serverMessage = factory.createHiCommandServerMessage();
            APIInfo apiinfo = factory.createAPIInfo();
            apiinfo.setVersion("8.0");
            Request request = factory.createRequest();
            SecurityAdmin secAdmin = factory.createSecurityAdmin();
            Get get = factory.createGet();
            get.setTarget("AclUser");
            get.setOption("nologout");
            AclUser aclUser = factory.createAclUser();
            aclUser.setLoginID(user);
            List<AclResourceGroup> aclResourceGroupList = aclUser.getAclResourceGroup();
            AclResourceGroup aclResourceGroup = factory.createAclResourceGroup();
            aclResourceGroupList.add(aclResourceGroup);
            get.setAclUser(aclUser);
            secAdmin.setGet(get);
            request.setSecurityAdmin(secAdmin);
            serverMessage.setAPIInfo(apiinfo);
            serverMessage.setRequest(request);
            HiCommandServerMessage classObject = serverMessage;
            ByteArrayOutputStream outputStream = null;
            outputStream = new ByteArrayOutputStream();
            SJbaseHCSXMLUtility.java2Xml(classObject, outputStream);
            requestStr = ((Object)outputStream).toString();
        }
        catch (Exception ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "createRequestContents", "Exception occured.", ex);
            throw ex;
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "createRequestContents", "requestStr:" + requestStr);
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "createRequestContents", "End.");
        return requestStr;
    }

    public static HttpURLConnection connect(String urlStr, String requestContents, String user, String password, String argReadTimeout) throws Exception {
        String LOG_SUBTITLE = "connect";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "connect", "Start. - user:" + user);
        HttpsURLConnection urlconn = null;
        try {
            int connectTimeout = SJbaseHCSAuthUtility.getConnectTimeout();
            int readTimeout = SJbaseHCSAuthUtility.getReadTimeout_arg(argReadTimeout);
            URL url = new URL(urlStr);
            urlconn = (HttpsURLConnection)url.openConnection();
            urlconn.setRequestMethod("POST");
            urlconn.setInstanceFollowRedirects(false);
            urlconn.setDoOutput(true);
            urlconn.setRequestProperty("Accept-Language", "ja;q=0.7,en;q=0.3");
            urlconn.setRequestProperty("User-Agent", "Hitachi:StorageNavigator2:0");
            String sInTestStr = URLEncoder.encode(user, ENCODE) + ":" + URLEncoder.encode(password, ENCODE);
            byte[] inTestStrByte = sInTestStr.getBytes(ENCODE);
            byte[] outTestStrBtye = Base64.encodeBase64((byte[])inTestStrByte);
            String sOutTestStr = new String(outTestStrBtye, ENCODE);
            String authorization = "PNMSN " + sOutTestStr;
            urlconn.setRequestProperty("Authorization", authorization);
            urlconn.setRequestProperty("Content-Type", "text/xml");
            urlconn.setRequestProperty("Content-Length", "" + requestContents.length());
            urlconn.setConnectTimeout(connectTimeout);
            urlconn.setReadTimeout(readTimeout);
            SJbaseHCSAuthUtility.connect(urlconn);
        }
        catch (Exception ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "connect", "Exception occured. ", ex);
            throw ex;
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "connect", "End.");
        return urlconn;
    }

    private static int getConnectTimeout() {
        String LOG_SUBTITLE = "getConnectTimeout";
        int returnValue = 60000;
        try {
            int connectTimeout = SJcEnvUty.getProperty2int("SN_HCS_CONNECT_TIMEOUT", 60000);
            if (connectTimeout > 0) {
                returnValue = connectTimeout;
            }
        }
        catch (Exception ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getConnectTimeout", "Exception occured. ", ex);
        }
        return returnValue;
    }

    private static int getReadTimeout() {
        String LOG_SUBTITLE = "getReadTimeout";
        int returnValue = 60000;
        try {
            int readTimeout = SJcEnvUty.getProperty2int("SN_HCS_READ_TIMEOUT", 60000);
            if (readTimeout > 0) {
                returnValue = readTimeout;
            }
        }
        catch (Exception ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getReadTimeout", "Exception occured. ", ex);
        }
        return returnValue;
    }

    private static int getReadTimeout_arg(String argReadTimeout) {
        String LOG_SUBTITLE = "getReadTimeout_arg";
        int returnValue = 60000;
        try {
            returnValue = argReadTimeout != null && argReadTimeout.length() > 0 ? Integer.valueOf(argReadTimeout) : SJbaseHCSAuthUtility.getReadTimeout();
        }
        catch (Exception ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getReadTimeout_arg", "Exception occured. ", ex);
        }
        return returnValue;
    }

    private static int getConnectRetryTime() {
        String LOG_SUBTITLE = "getConnectRetryTime";
        int returnValue = 2;
        try {
            int retryTime = SJcEnvUty.getProperty2int("SN_HCS_CONNECT_RETRY", 2);
            if (retryTime >= 0) {
                returnValue = retryTime;
            }
        }
        catch (Exception ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getConnectRetryTime", "Exception occured. ", ex);
        }
        return returnValue;
    }

    private static int getReadRetryTime() {
        String LOG_SUBTITLE = "getReadRetryTime";
        int returnValue = 2;
        try {
            int retryTime = SJcEnvUty.getProperty2int("SN_HCS_READ_RETRY", 2);
            if (retryTime >= 0) {
                returnValue = retryTime;
            }
        }
        catch (Exception ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getReadRetryTime", "Exception occured. ", ex);
        }
        return returnValue;
    }

    private static void connect(HttpsURLConnection urlconn) throws Exception {
        Certificate[] certs;
        String LOG_SUBTITLE = "connect(urlconn)";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "connect(urlconn)", "Start.");
        int retryTime = SJbaseHCSAuthUtility.getConnectRetryTime();
        for (int cnt = 0; cnt <= retryTime; ++cnt) {
            try {
                urlconn.connect();
                break;
            }
            catch (SocketTimeoutException sockTex) {
                LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "connect(urlconn)", "SocketTimeoutException occured. retryTime:" + retryTime + " cnt:" + cnt);
                if (cnt < retryTime) continue;
                throw sockTex;
            }
            catch (Exception ex) {
                LOGGER.error(LOG_FUNCTION, LOG_TITLE, "connect(urlconn)", "Exception occured. ");
                throw ex;
            }
        }
        for (Certificate cert : certs = urlconn.getServerCertificates()) {
            LOGGER.info(LOG_FUNCTION, LOG_TITLE, "connect(urlconn)", "Cert Type :" + cert.getType());
            LOGGER.info(LOG_FUNCTION, LOG_TITLE, "connect(urlconn)", "Cert Hash Code :" + cert.hashCode());
            LOGGER.info(LOG_FUNCTION, LOG_TITLE, "connect(urlconn)", "Cert Public Key Algorithm :" + cert.getPublicKey().getAlgorithm());
            LOGGER.info(LOG_FUNCTION, LOG_TITLE, "connect(urlconn)", "Cert Public Key Format :" + cert.getPublicKey().getFormat());
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "connect(urlconn)", "End.");
    }

    public static void disconnect(HttpURLConnection urlconn) {
        String LOG_SUBTITLE = "disconnect";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "disconnect", "Start.");
        urlconn.disconnect();
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "disconnect", "End.");
    }

    public static String getHcsUrl(String hcsIp, String hcsPort) {
        String LOG_SUBTITLE = "getHcsUrl(ip,port)";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getHcsUrl(ip,port)", "Start. - hcsIp:" + hcsIp + ", hcsPort:" + hcsPort);
        String resultUrl = null;
        if (SJbaseHCSAuthUtility.isNullOrEmpty(hcsIp)) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getHcsUrl(ip,port)", "ip address is null.");
            return resultUrl;
        }
        if (SJbaseHCSAuthUtility.isNullOrEmpty(hcsPort)) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getHcsUrl(ip,port)", "port is null.");
            return resultUrl;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("https");
        buff.append("://");
        buff.append(hcsIp);
        buff.append(":");
        buff.append(hcsPort);
        buff.append("/");
        buff.append("service");
        buff.append("/");
        buff.append("ServerAdmin");
        resultUrl = buff.toString();
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getHcsUrl(ip,port)", "End.");
        return resultUrl;
    }

    public static String getHcsUrl(Map<String, Object> map) {
        String LOG_SUBTITLE = "getHcsUrl";
        if (null == map) {
            LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "getHcsUrl", "map is null.");
            return null;
        }
        return SJbaseHCSAuthUtility.getHcsUrl(SJbaseHCSAuthUtility.getHcsIp(map), SJbaseHCSAuthUtility.getHcsPort(map));
    }

    public static void send(HttpURLConnection urlconn, String requestContents) throws Exception {
        String LOG_SUBTITLE = "send";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "send", "Start.");
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(urlconn.getOutputStream(), "utf-8")));
            pw.print(requestContents);
            pw.flush();
            pw.close();
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "send", "UnsupportedEncodingException occured.", ex);
            throw ex;
        }
        catch (IOException ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "send", "IOException occured.", ex);
            throw ex;
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "send", "End.");
    }

    private static HiCommandServerMessage receiveData(HttpURLConnection urlconn) throws Exception {
        String LOG_SUBTITLE = "receiveData";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "receiveData", "Start.");
        HiCommandServerMessage serverMessage = null;
        try {
            int resCode = SJbaseHCSAuthUtility.getResponseCode(urlconn);
            if (resCode != 200) {
                LOGGER.error(LOG_FUNCTION, LOG_TITLE, "receiveData", "ResponseCode: " + urlconn.getResponseCode() + "  " + "ResponseMSG: " + urlconn.getResponseMessage());
                return serverMessage;
            }
            serverMessage = SJbaseHCSAuthUtility.getResponseBody(urlconn, SJbaseHCSAuthUtility.getCharSet(urlconn));
        }
        catch (SocketTimeoutException sockTex) {
            throw sockTex;
        }
        catch (IOException ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "receiveData", "IOException occured.", ex);
            throw ex;
        }
        if (null != serverMessage) {
            LOGGER.info(LOG_FUNCTION, LOG_TITLE, "receiveData", "ResponseBody\n" + serverMessage.toString());
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "receiveData", "End.");
        return serverMessage;
    }

    public static HiCommandServerMessage receive(HttpURLConnection urlconn) throws Exception {
        String LOG_SUBTITLE = "receive";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "receive", "Start.");
        HiCommandServerMessage msg = null;
        int retryTime = SJbaseHCSAuthUtility.getReadRetryTime();
        for (int cnt = 0; cnt <= retryTime; ++cnt) {
            try {
                msg = SJbaseHCSAuthUtility.receiveData(urlconn);
                break;
            }
            catch (SocketTimeoutException sockTex) {
                LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "receive", "SocketTimeoutException occured. retryTime:" + retryTime + " cnt:" + cnt);
                if (cnt < retryTime) continue;
                throw sockTex;
            }
            catch (Exception ex) {
                LOGGER.error(LOG_FUNCTION, LOG_TITLE, "receive", "Exception occured. ");
                throw ex;
            }
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "receive", "End.");
        return msg;
    }

    public static int getResponseCode(HttpURLConnection urlconn) throws Exception {
        String LOG_SUBTITLE = "getResponseCode";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getResponseCode", "Start.");
        SJbaseHCSAuthUtility.getHeaderFields(urlconn);
        int resCode = urlconn.getResponseCode();
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getResponseCode", "ResponseCode: " + urlconn.getResponseCode() + "  " + "ResponseMSG: " + urlconn.getResponseMessage());
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getResponseCode", "End. - resCode:" + resCode);
        return resCode;
    }

    public static String getHcsIp(Map<String, Object> map) {
        String LOG_SUBTITLE = "getHcsIp";
        if (null == map) {
            LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "getHcsIp", "map is null.");
            return null;
        }
        return (String)map.get(SJbaseHcsConMapKey.IP.getKey());
    }

    public static String getHcsPort(Map<String, Object> map) {
        String LOG_SUBTITLE = "getHcsPort";
        if (null == map) {
            LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "getHcsPort", "map is null.");
            return null;
        }
        return (String)map.get(SJbaseHcsConMapKey.PORT.getKey());
    }

    public static String getHcsReadTimeout(Map<String, Object> map) {
        String LOG_SUBTITLE = "getHcsReadTimeout";
        String rtnValue = "";
        if (null == map) {
            LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "getHcsReadTimeout", "map is null.");
            return null;
        }
        try {
            String getValue = (String)map.get(SJbaseHcsConMapKey.READ_TIMEOUT.getKey());
            if (null != getValue) {
                rtnValue = getValue;
                LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getHcsReadTimeout", "Readtimeout=[" + rtnValue + "].");
            } else {
                LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getHcsReadTimeout", "Readtimeout is null.");
            }
        }
        catch (NullPointerException ex) {
            LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getHcsReadTimeout", "Readtimeout is not set.");
        }
        return rtnValue;
    }

    private static String getCharSet(HttpURLConnection urlconn) {
        String LOG_SUBTITLE = "getCharSet";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getCharSet", "Start.");
        String charSet = null;
        String contentType = urlconn.getHeaderField("Content-Type");
        charSet = "utf-8";
        for (String elm : contentType.replace(" ", "").split(";")) {
            if (!elm.startsWith("charset=")) continue;
            charSet = elm.substring(8);
            break;
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getCharSet", "End.");
        return charSet;
    }

    private static HiCommandServerMessage getResponseBody(HttpURLConnection urlconn, String charSet) throws Exception {
        String LOG_SUBTITLE = "getResponseBody";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getResponseBody", "Start.");
        HiCommandServerMessage result = null;
        try {
            ByteArrayInputStream bais;
            StringBuffer buf = SJbaseHCSAuthUtility.getResponseBodyString(urlconn, charSet);
            ByteArrayInputStream inputStream = null;
            Class<HiCommandServerMessage> classObject = HiCommandServerMessage.class;
            inputStream = bais = new ByteArrayInputStream(buf.toString().getBytes(charSet));
            Object obj = SJbaseHCSXMLUtility.xml2Java(inputStream, classObject);
            if (null != obj) {
                result = (HiCommandServerMessage)obj;
            } else {
                LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getResponseBody", "Converted object is null.");
            }
        }
        catch (SocketTimeoutException sockTex) {
            throw sockTex;
        }
        catch (IOException ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getResponseBody", "IO error.", ex);
            throw ex;
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getResponseBody", "End.");
        return result;
    }

    private static StringBuffer getResponseBodyString(HttpURLConnection urlconn, String charSet) throws Exception {
        String LOG_SUBTITLE = "getResponseBodyString";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getResponseBodyString", "Start.");
        StringBuffer buf = new StringBuffer();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(urlconn.getInputStream(), charSet));
            while ((line = br.readLine()) != null) {
                buf.append(line + "\n");
            }
        }
        catch (SocketTimeoutException sockTex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getResponseBodyString", "SocketTimeoutException occured.", sockTex);
            throw sockTex;
        }
        catch (Exception ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getResponseBodyString", "ResponseCode: " + urlconn.getResponseCode() + "  " + "ResponseMSG: " + urlconn.getResponseMessage(), ex);
            if (urlconn.getErrorStream() != null) {
                String line;
                br = new BufferedReader(new InputStreamReader(urlconn.getErrorStream(), charSet));
                while ((line = br.readLine()) != null) {
                    buf.append(line + "\n");
                }
            }
            throw ex;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getResponseBodyString", "buf:" + buf.toString());
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getResponseBodyString", "End.");
        return buf;
    }

    private static Map<String, List<String>> getHeaderFields(HttpURLConnection urlconn) throws Exception {
        String LOG_SUBTITLE = "getHeaderFields";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getHeaderFields", "Start.");
        Map<String, List<String>> headers = null;
        try {
            if (null == urlconn) {
                LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getHeaderFields", "urlconn is null.");
                return null;
            }
            headers = urlconn.getHeaderFields();
            for (Map.Entry<String, List<String>> keyValue : headers.entrySet()) {
                String key = keyValue.getKey();
                List<String> list = keyValue.getValue();
                LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getHeaderFields", "ResponseHeader  " + key + " : " + list.toString());
            }
        }
        catch (Exception ex) {
            LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getHeaderFields", "End.", ex);
            throw ex;
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getHeaderFields", "End.");
        return headers;
    }

    public static boolean isNullOrEmpty(String target) {
        boolean result = true;
        if (target == null) {
            return result;
        }
        if (target.equals("")) {
            return result;
        }
        result = false;
        return result;
    }
}

