/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.fileuty;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.utility.fileuty.SJcByteArrayInputStream;
import sanproject.sn2.com.utility.fileuty.SJcByteArrayOutputStream;

public class SJcFileUtyMemFile
implements Serializable,
SJcByteArrayOutputStream.SJcByteArrayOutputStreamListener {
    static final long serialVersionUID = 0L;
    private String filepath;
    private long lastModified;
    private boolean directory;
    private SJcFileUtyMemFile parent;
    private List<SJcFileUtyMemFile> children;
    private byte[] data;

    public SJcFileUtyMemFile(String filepath, SJcFileUtyMemFile parent, boolean directory) {
        this.filepath = filepath;
        this.parent = parent;
        this.directory = directory;
        this.children = new ArrayList<SJcFileUtyMemFile>();
        this.data = new byte[0];
        this.setLastModifiedNow();
    }

    public String getOriginalFilePath() {
        return this.filepath;
    }

    public void setOriginalFilePath(String filepath) {
        this.filepath = filepath;
    }

    public byte[] getData() {
        byte[] ret = new byte[this.data.length];
        System.arraycopy(this.data, 0, ret, 0, this.data.length);
        return ret;
    }

    public void setData(byte[] b) throws IOException {
        this.data = new byte[b.length];
        System.arraycopy(b, 0, this.data, 0, b.length);
        this.setLastModifiedNow();
        SJcFileUtyMemFile parentMemFile = this.getParent();
        if (parentMemFile != null) {
            parentMemFile.setLastModifiedNow();
        }
    }

    public int getDataLength() {
        int ret = this.data.length;
        return ret;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long timeInMillis) {
        this.lastModified = timeInMillis;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public SJcFileUtyMemFile getParent() {
        return this.parent;
    }

    public List<SJcFileUtyMemFile> getChildren() {
        return this.children;
    }

    public void addChild(SJcFileUtyMemFile child) {
        this.children.add(child);
    }

    public void removeChild(SJcFileUtyMemFile child) {
        this.children.remove(child);
    }

    public InputStream getInputStream() {
        SJcByteArrayInputStream ret = new SJcByteArrayInputStream(this.data);
        return ret;
    }

    public OutputStream getOutputStream() {
        SJcByteArrayOutputStream ret = new SJcByteArrayOutputStream();
        ret.setListener(this);
        return ret;
    }

    @Override
    public void dataChanged(byte[] data) {
        this.data = data;
        this.setLastModifiedNow();
        SJcFileUtyMemFile parentMemFile = this.getParent();
        if (parentMemFile != null) {
            parentMemFile.setLastModifiedNow();
        }
    }

    public void setLastModifiedNow() {
        this.setLastModified(System.currentTimeMillis());
    }
}

