/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.tomcat;

import flex.messaging.FlexContext;
import java.io.File;
import javax.servlet.ServletContext;
import sanproject.sn2.base.system.inf.SJbasePluginInterface;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJcJSPCacheCleaner
implements SJbasePluginInterface {
    private final String LOG_FUNCTION = "JSPCacheCleaner";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private SJcLoggerInterface stdLogger = SJcLogUty.getLogger();

    @Override
    public void initialize(int status) {
        String LOG_SUBTITLE = "initialize";
        this.stdLogger.info("JSPCacheCleaner", this.LOG_TITLE, "initialize", "Start. - status:" + status);
        ServletContext context = FlexContext.getServletContext();
        if (null == context) {
            this.stdLogger.info("JSPCacheCleaner", this.LOG_TITLE, "initialize", "context is null");
            return;
        }
        File tempdir = (File)context.getAttribute("javax.servlet.context.tempdir");
        if (null == tempdir) {
            this.stdLogger.info("JSPCacheCleaner", this.LOG_TITLE, "initialize", "tempdir is null");
            return;
        }
        String path = tempdir.getPath();
        String allpath = path + SJcConst.sjc_PathSeparator + "org" + SJcConst.sjc_PathSeparator + "apache" + SJcConst.sjc_PathSeparator + "jsp";
        this.stdLogger.info("JSPCacheCleaner", this.LOG_TITLE, "initialize", "DeleteDir:" + allpath);
        File targetDir = new File(allpath);
        if (null == targetDir) {
            this.stdLogger.info("JSPCacheCleaner", this.LOG_TITLE, "initialize", "targetDir is null");
            return;
        }
        this.deleteDir(targetDir);
        this.stdLogger.info("JSPCacheCleaner", this.LOG_TITLE, "initialize", "End.");
    }

    @Override
    public void finish() {
        String LOG_SUBTITLE = "finish";
        this.stdLogger.info("JSPCacheCleaner", this.LOG_TITLE, "finish", "Start.");
        this.stdLogger.info("JSPCacheCleaner", this.LOG_TITLE, "finish", "End.");
    }

    private void deleteDir(File file) {
        if (null == file) {
            this.stdLogger.info("JSPCacheCleaner", this.LOG_TITLE, "deleteDir", "File Obj is null");
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isFile() && !file.delete()) {
            this.stdLogger.info("JSPCacheCleaner", this.LOG_TITLE, "deleteDir", "DeleteError_File:" + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.deleteDir(files[i]);
            }
            if (!file.delete()) {
                this.stdLogger.info("JSPCacheCleaner", this.LOG_TITLE, "deleteDir", "DeleteError_Dir:" + file.getAbsolutePath());
            }
        }
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isEnable() {
        return true;
    }
}

