/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.controller.com.SJctrAsyncGetInterface;
import sanproject.sn2.controller.com.SJctrAsyncGetThread;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.data.SJctrRequestDataObject;

public class SJctrAsyncGetDataController
extends SJctrDataController {
    private static final int DISP_ID = 0x30FFFFF;
    public static final int FUNC_BASE = 0;
    public static int ASYNCGET_ERR1 = 108033;
    private SJctrAsyncGetInterface mClient = null;
    private SJctrAsyncGetThread asyncThread = null;
    private static final long WAIT_TIME_DEFAULT = 150000L;
    private long waitTime = 150000L;
    private long timeOut = (long)SJcEnvUty.getProperty2int("ASYNC_TIME_OUT", 1800000) + System.currentTimeMillis();
    public static final String KEY_TARGET = "COM_TARGET";
    public static final String KEY_UPDATE = "COM_UPDATE";
    private static final String ASYNC_TIME_OUT = "ASYNC_TIME_OUT";
    private static final int TIME_OUT_DEF = 1800000;
    private boolean asyncType = false;
    private boolean finishFlg = false;
    private static final int ASYNC_GET_WAIT_TIME = 1000;
    private SJcException exception = null;

    public SJctrAsyncGetDataController() throws SJcException {
        super(0x30FFFFF);
    }

    @Override
    protected SJctrRequestDataObject requestGet(SJctrRequestDataObject req) {
        SJctrRequestDataObject ret = req.createDefualtResponse();
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject asyncRelated = this.getAsyncData();
        if (!this.asyncType && this.finishFlg) {
            int uId = this.mClient.getuId();
            SJctrRelatedDispDataObject relatedDisp = uc.getRelatedDispData(uId);
            SJctrDataController dc = uc.getDataController(relatedDisp);
            List<SJctrRelatedDispDataObject> updateDispList = dc.getUpdataDispList();
            ret.setData(KEY_UPDATE, updateDispList);
        } else {
            ArrayList<SJctrRelatedDispDataObject> relatedDisp = new ArrayList<SJctrRelatedDispDataObject>();
            relatedDisp.add(asyncRelated);
            SJctrDataObject target = new SJctrDataObject();
            target.setData("COM_CHILD", relatedDisp);
            ret.setData(KEY_TARGET, target);
        }
        return ret;
    }

    public void setAsyncGet(SJctrAsyncGetInterface client) {
        this.getLogUty().putlog("setAsyncGet", "Create Async Get Thraed Start.");
        this.mClient = client;
        Set<SJctrGetDirectWrapper> modelData = this.mClient.getModelRequest();
        this.asyncThread = new SJctrAsyncGetThread(modelData, this);
        this.asyncThread.start();
    }

    private SJctrRelatedDispDataObject getAsyncData() {
        try {
            this.getLogUty().putlog("getAsyncData", "Thread watch Start.");
            long endTime = this.waitTime + System.currentTimeMillis();
            boolean aliveThreadFlg = true;
            while (aliveThreadFlg) {
                long now = System.currentTimeMillis();
                if (now > this.timeOut) {
                    SJctrError err = new SJctrError(201, 22, ASYNCGET_ERR1);
                    SJcException exp = err.createException();
                    throw exp;
                }
                aliveThreadFlg = this.asyncThread.isAlive();
                if (now > endTime) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.getLogUty().putlog("getAsyncData", "Wait interrupted.", 40000);
                }
            }
            SJctrRelatedDispDataObject related = null;
            SJctrUserController uc = this.getOwner();
            int asyncUid = this.getuId();
            if (aliveThreadFlg) {
                related = uc.getRelatedDispData(asyncUid);
                this.getLogUty().putlog("getAsyncData", "Thread watch Continue.");
            } else {
                int uId = this.mClient.getuId();
                related = uc.getRelatedDispData(uId);
                SJcException e = this.asyncThread.getException();
                this.mClient.setAsyncException(e);
                Map<SJctrGetDirectWrapper, List<?>> map = this.asyncThread.getModelData();
                this.mClient.setModelData(map);
                this.finishFlg = true;
                SJctrDataController dc = uc.getDataController(uId);
                if (dc != null && this.mClient.isDialogAsyncGet()) {
                    SJctrRelatedDispDataObject relatedDispData = new SJctrRelatedDispDataObject();
                    relatedDispData.dispId(dc.getDisplayId());
                    relatedDispData.uId(uId);
                    relatedDispData.status(0);
                    dc.addUpdateDisp(relatedDispData);
                }
                uc.removeRelatedDispData(asyncUid);
                this.getLogUty().putlog("getAsyncData", "Thread watch End.");
            }
            return related;
        }
        catch (SJcException ex) {
            SJctrUserController uc;
            this.getLogUty().putlog("getAsyncData", "The thread watch is stopped for the exception generation.");
            if (this.mClient.isDialogAsyncGet()) {
                this.removeClientDisp();
            }
            if ((uc = this.getOwner()) != null) {
                int asyncUid = this.getuId();
                uc.removeRelatedDispData(asyncUid);
            }
            throw ex;
        }
    }

    public void setThreadWaitTime(long time) {
        this.waitTime = time;
    }

    public void setAsyncType(boolean type) {
        this.asyncType = type;
    }

    public SJcException getException() {
        return this.exception;
    }

    public void removeClientDisp() {
        SJctrUserController uc = this.getOwner();
        if (uc != null && this.mClient != null) {
            int uid = this.mClient.getuId();
            uc.removeRelatedDispData(uid);
        }
    }
}

