/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.StringTokenizer;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.controller.com.SJctrLogUty;

public class SJctrEnvParamUtility {
    public static final String DEFAULT_ENV_DIRECTORY = "base\\init";
    public static final String DEFAULT_ENV_FILENAME = "ENV.CSV";
    private static String DELIMITER = ",\r\n";
    public static final String NA = "";
    static SJctrLogUty mLogger;
    private String[] mParamList = new String[0];
    private static String HIDE_STATUS_WINDOW_ENABLE;

    public SJctrEnvParamUtility(SJctrLogUty logger) {
        mLogger = logger;
        this.update();
    }

    public void update() {
        this.update(DEFAULT_ENV_DIRECTORY, DEFAULT_ENV_FILENAME);
    }

    public void update(String directory, String filename) {
        String record = NA;
        try {
            record = SJcFileUty.loadText(directory, filename);
        }
        catch (SJcException e) {
            mLogger.putlog("update", "File accece error occurred. FileName:" + directory + "\\" + filename);
            String idFunction = e.getMsg().getFunctionID();
            String idModule = e.getMsg().getModuleID();
            String idMsg = e.getMsg().getMsgID();
            mLogger.putlog("update", "An error occurred(" + idFunction + "-" + idModule + "-" + idMsg + ")");
        }
        StringTokenizer tokenizer = new StringTokenizer(record, DELIMITER);
        int paramSize = tokenizer.countTokens();
        ArrayList<String> paramList = new ArrayList<String>(paramSize);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            paramList.add(token);
        }
        this.mParamList = paramList.toArray(this.mParamList);
    }

    public String getParam(Param param) {
        int ordinal = param.ordinal();
        if (this.mParamList.length <= ordinal) {
            return NA;
        }
        return this.mParamList[ordinal];
    }

    public boolean isHideStatusWindow() {
        boolean ret = false;
        String param = this.getParam(Param.HIDE_ST_WINDOW);
        ret = param.equals(HIDE_STATUS_WINDOW_ENABLE);
        return ret;
    }

    static {
        HIDE_STATUS_WINDOW_ENABLE = "1";
    }

    public static enum Param {
        RESERVE1,
        RESERVE2,
        RMI_TIMEOUT,
        POLLING_CHK_LOCK,
        POLLING_CHK_OBSTACLES,
        RESERVE3,
        RESERVE4,
        RESERVE5,
        RESERVE6,
        RMI_TIMEOUT_MODIFY,
        JRE_VERSION,
        HIDE_ST_WINDOW,
        PASSWD_LENGTH,
        LOGIN_ENTRY_COUNT,
        LOGIN_ENTRY_WAIT;

    }
}

